/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import de.superx.bin.SxConnection;
import de.superx.bin.SxTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebserviceClientSummendaten
extends AbstractWebserviceClient {
    private Collection<String> finanzstellen = new LinkedList<String>();
    private Document configDocument;
    private String hsnr;
    private String xmlConfig;
    private String datentyp;
    private String url;
    private StringBuffer data = new StringBuffer();
    private String soap;
    private String replaceNodeName;
    private String xslpfad;
    private String outfile;
    private boolean isDeleteTmpXmlFileWanted = true;
    private String jahr;
    private boolean isDBConnectionPossible = true;
    private String dbpropfile;

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClientSummendaten Version 1.3");
        WebserviceClientSummendaten tc = new WebserviceClientSummendaten();
        tc.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            this.initLogging();
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_xmlconfig, GetOpts.Options.opt_xslPfad, GetOpts.Options.opt_hsnr, GetOpts.Options.opt_jahr, GetOpts.Options.opt_out, GetOpts.Options.opt_datentyp});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.readFinanzstellen();
            this.perform();
            String msg = "    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            logger.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void readFinanzstellen() throws Exception {
        if (this.isDBConnectionPossible) {
            SxConnection myConnection = new SxConnection();
            myConnection.setPropfile(this.dbpropfile);
            Connection con = myConnection.getConnection();
            Statement stm = con.createStatement();
            ResultSet rs = stm.executeQuery("select distinct fmfctr_fictr from gxstage_sap_sc11 ; ");
            while (rs.next()) {
                String instnr = rs.getString(1);
                this.finanzstellen.add(instnr);
            }
            rs.close();
            stm.close();
            con.close();
        }
        String msg = this.finanzstellen.size() + " Finanzstellen gefunden";
        logger.log(Level.INFO, msg);
        System.out.println(msg);
    }

    private void perform() throws Exception {
        Node n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "sumurl");
        this.url = XMLUtils.getTheValue(n);
        this.url = this.adaptURL(this.url);
        logger.fine("URL:" + this.url);
        System.out.println("URL:" + this.url);
        n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "sumsoap");
        this.soap = XMLUtils.getTheValue(n);
        this.soap = this.soap.replace("XXHSNRXX", this.hsnr);
        this.soap = this.soap.replace("XXJAHRXX", this.jahr);
        System.out.println(this.datentyp + "\n" + this.soap);
        n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "sumreplacenode");
        this.replaceNodeName = XMLUtils.getAttribValue(n, "from");
        logger.fine(this.datentyp + "\nSOAP Aufruf:\n" + this.soap);
        Iterator<String> it = this.finanzstellen.iterator();
        int i = 0;
        while (it.hasNext()) {
            String tmpsoap;
            StringBuffer result;
            String fistl = it.next();
            if (++i % 10 == 0) {
                System.out.print(i + " ");
            }
            if (!this.isReplyOk(result = this.readSOAP(tmpsoap = this.soap.replace("XXFISTLXX", fistl), this.url))) {
                String msg = "Error: Aufruf von Webservice fuer Summendaten " + this.datentyp + " (" + this.xmlConfig + ") FISTL:" + fistl + " fehlgeschlagen\n" + String.valueOf(result);
                System.out.println(msg);
                logger.severe(msg);
                LogUtils.close("wc");
                System.exit(-1);
            }
            if (result.indexOf("Es wurden 0000") > -1 || result.indexOf("<EX_FMBDT/>") > -1) continue;
            String resultAdapted = this.removeXmlHeader(result.toString());
            resultAdapted = WebserviceClientSummendaten.purge(resultAdapted, true);
            resultAdapted = StringUtils.replace(resultAdapted, this.replaceNodeName, "response");
            this.data.append(this.format(resultAdapted));
        }
        System.out.println("");
        this.writeChangeXml();
    }

    private void readConfig() throws IOException, SAXException {
        this.xmlConfig = GetOpts.getValue(GetOpts.Options.opt_xmlconfig);
        this.outfile = GetOpts.getValue(GetOpts.Options.opt_out);
        this.xslpfad = GetOpts.getValue(GetOpts.Options.opt_xslPfad);
        this.hsnr = GetOpts.getValue(GetOpts.Options.opt_hsnr);
        this.jahr = GetOpts.getValue(GetOpts.Options.opt_jahr);
        this.datentyp = GetOpts.getValue(GetOpts.Options.opt_datentyp);
        if (!this.datentyp.contentEquals("fmbdt") && !this.datentyp.contentEquals("fmit")) {
            System.out.println("Fehler: Unbekannter Datentyp " + this.datentyp + " als Parameter");
            System.exit(-1);
        }
        this.dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + "\nHochschulnummer " + this.hsnr);
        logger.info("\nHochschulnummer " + this.hsnr);
        if (GetOpts.isPresent(GetOpts.Options.opt_noDelete)) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        logger.log(Level.INFO, "Geschaeftsjahr " + this.jahr);
        System.out.println("Geschaeftsjahr " + this.jahr);
        logger.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        this.configDocument = XMLUtils.buildDocument(new File(this.xmlConfig));
    }

    private void writeChangeXml() throws Exception {
        File f = File.createTempFile("webservicedata", ".xml");
        if (!this.isDeleteTmpXmlFileWanted) {
            System.out.println("Temp Datei: " + f.getAbsolutePath());
            logger.info("Temp Datei: " + f.getAbsolutePath());
        }
        if (f.exists()) {
            f.delete();
        }
        Files.writeString(f.toPath(), (CharSequence)"<newdata>\n", StandardOpenOption.CREATE);
        Files.writeString(f.toPath(), (CharSequence)this.data, StandardOpenOption.APPEND);
        Files.writeString(f.toPath(), (CharSequence)"\n</newdata>\n", StandardOpenOption.APPEND);
        SxTransformer sxTrans = new SxTransformer(logger, this.outfile);
        sxTrans.quellstring = f.getAbsolutePath();
        sxTrans.stylesheet = this.xslpfad + File.separator + "sum_soap_to_csv_" + this.datentyp + ".xsl";
        sxTrans.params = "ignoreElements=EX_JEST";
        sxTrans.transformFile("text");
        if (this.isDeleteTmpXmlFileWanted) {
            f.delete();
        }
    }
}

