/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.CryptUtils;
import de.memtext.util.GetOpts;
import de.memtext.widgets.LabeledComboBox;
import de.memtext.widgets.LabeledTextField;
import de.memtext.widgets.RadioButtonGroup;
import de.memtext.widgets.VerticalBox;
import de.memtext.widgets.WarningMessage;
import de.superx.util.ConnectionDialogCommon;
import de.superx.util.SqlStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PropAdminOld
extends JFrame
implements ActionListener,
ItemListener {
    static Container cp;
    static LinkedList logLevels;
    static JTextField tAdminPasswd;
    static JTextField tdriver;
    static JTextField turl;
    static JTextField tadminUser;
    static JTextField tRestrictedUser;
    static JTextField tRestrictedPassword;
    static LabeledTextField ltfMaskCache;
    static LabeledTextField ltfUserCache;
    static JComboBox tname;
    static LabeledComboBox sqlLogLevel;
    static LabeledComboBox xmlLogLevel;
    static LabeledTextField maxActive;
    static LabeledTextField minIdle;
    static LabeledTextField maxIdle;
    static RadioButtonGroup rbEntwicklungsmodus;
    private static String defaultDBDriver;
    private static String defaultConnection;
    private static String defaultUser;
    private static String dbpropfile;
    private static String[][] connTypes;
    private static boolean isGuiWanted;
    static Properties props;
    static byte[] key;
    static int keyLength;
    private static String usage;

    public PropAdminOld() {
        super("DB-Properties Admin @version@");
        ltfMaskCache = new LabeledTextField("Masken, die im Cache sein sollen", "select tid from maskeninfo where 1=0", 50);
        ltfUserCache = new LabeledTextField("User, die im Cache sein sollen", "select tid from userinfo where 1=0", 50);
        maxActive = new LabeledTextField("maxActive", 3);
        minIdle = new LabeledTextField("minIdle", 3);
        maxIdle = new LabeledTextField("maxIdle", 3);
        sqlLogLevel = new LabeledComboBox("Log Level SQL", logLevels);
        xmlLogLevel = new LabeledComboBox("Log Level XML", logLevels);
        sqlLogLevel.setSelectedIndex(1);
        xmlLogLevel.setSelectedIndex(1);
        rbEntwicklungsmodus.add(new JLabel("Entwicklungsmodus "));
        rbEntwicklungsmodus.add("an");
        rbEntwicklungsmodus.add("aus");
        rbEntwicklungsmodus.setSelection("an");
        JButton btnTestAdmin = new JButton("Verbindung testen");
        btnTestAdmin.addActionListener(this);
        cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel titel = new JPanel();
        JLabel ltitel = new JLabel("DB-Properties Admin f\u00fcr " + dbpropfile);
        ltitel.setFont(new Font("Courier", 1, 14));
        titel.add(ltitel);
        cp.add((Component)titel, "North");
        VerticalBox center = new VerticalBox();
        JPanel p0 = new JPanel(new FlowLayout(0));
        tname = new JComboBox();
        connTypes = ConnectionDialogCommon.getTypes();
        for (int i = 0; i < connTypes.length; ++i) {
            tname.addItem(connTypes[i][0]);
        }
        JLabel lname = new JLabel("            Driver :");
        lname.setFont(new Font("Courier", 1, 12));
        JLabel c_name = new JLabel("(m\u00f6gliche Datenbanksysteme f\u00fcr SuperX)");
        p0.add(lname);
        p0.add(tname);
        p0.add(c_name);
        center.add(p0);
        JPanel p1 = new JPanel(new FlowLayout(0));
        JLabel ldriver = new JLabel("       Driver Class:");
        ldriver.setFont(new Font("Courier", 1, 12));
        tdriver = new JTextField(30);
        JLabel c_driver = new JLabel("(muss im CLASSPATH stehen!)");
        p1.add(ldriver);
        p1.add(tdriver);
        p1.add(c_driver);
        center.add(p1);
        JPanel p1b = new JPanel(new FlowLayout(0));
        JLabel lurl = new JLabel("     Connection URL:");
        lurl.setFont(new Font("Courier", 1, 12));
        turl = new JTextField(50);
        p1b.add(lurl);
        p1b.add(turl);
        center.add(p1b);
        JPanel p3 = new JPanel(new FlowLayout(0));
        JLabel luser = new JLabel("           Username:");
        luser.setFont(new Font("Courier", 1, 12));
        tadminUser = new JTextField(10);
        JLabel lpasswd = new JLabel(" Password:");
        lpasswd.setFont(new Font("Courier", 1, 12));
        tAdminPasswd = new JPasswordField(10);
        p3.add(luser);
        p3.add(tadminUser);
        p3.add(lpasswd);
        p3.add(tAdminPasswd);
        p3.add(btnTestAdmin);
        center.add(p3);
        JPanel p3b = new JPanel(new FlowLayout(0));
        JLabel lbl33 = new JLabel("  Eingeschr\u00e4nkter User:");
        lbl33.setFont(new Font("Courier", 1, 12));
        p3b.add(lbl33);
        tRestrictedUser = new JTextField(10);
        p3b.add(tRestrictedUser);
        tRestrictedPassword = new JPasswordField(10);
        p3b.add(new JLabel("Passwort"));
        p3b.add(tRestrictedPassword);
        JButton btnTest2 = new JButton("Verb.testen");
        btnTest2.addActionListener(this);
        JButton btnSelectRights = new JButton("select-Rechte auf alle Tabellen");
        btnSelectRights.addActionListener(this);
        p3b.add(btnTest2);
        p3b.add(btnSelectRights);
        center.add(p3b);
        center.add(sqlLogLevel);
        center.add(xmlLogLevel);
        center.addWithLeftAlignment(rbEntwicklungsmodus);
        center.addWithLeftAlignment(new JLabel("<html>(Im Entwicklungsmodus werden alle SQL-Befehle von Abfragen einzeln an die Datenbank geschickt.<br>Das dauert etwas l&auml;nger, erm&ouml;glicht aber bessere Fehlermeldungen.)<br>"));
        center.add(ltfMaskCache);
        center.add(ltfUserCache);
        JPanel p4 = new JPanel();
        p4.add(new JLabel("<html>Der Apache ConnectionPool verwaltet die Anzahl ben\u00f6tigter Verbindungen dynamisch.<br>min/max idle gibt an wieviele Connections st\u00e4ndig bereit gehalten werden sollen.<br>maxActive gibt an wieviele Connections maximal gleichzeitig aktiv sein sollen."));
        center.add(p4);
        JPanel p5 = new JPanel();
        p5.add(minIdle);
        p5.add(maxIdle);
        p5.add(maxActive);
        center.add(p5);
        cp.add((Component)center, "Center");
        JButton OK = new JButton("Speichern");
        OK.addActionListener(this);
        JPanel unten = new JPanel();
        unten.add(OK);
        cp.add((Component)unten, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        tname.addItemListener(this);
        this.pack();
    }

    private static void properties_einlesen() throws IOException {
        if (!isGuiWanted) {
            System.out.println("Lese ein: " + dbpropfile);
        }
        props = new Properties();
        FileInputStream is = new FileInputStream(dbpropfile);
        if (is != null) {
            props.load(is);
            is.close();
        } else {
            if (isGuiWanted) {
                JOptionPane.showMessageDialog(null, "Kann Properties nicht einlesen.", "DB-Prop Admin", 1);
            }
            System.out.println("kann properties nicht einlesen");
        }
    }

    private static void initFormFromProps() {
        String tdriverclass = props.getProperty("driverName");
        tdriver.setText(tdriverclass);
        for (int i = 0; i < connTypes.length; ++i) {
            if (!tdriverclass.equals(connTypes[i][1])) continue;
            tname.setSelectedIndex(i);
        }
        if (props.getProperty("connectionURL") != null) {
            turl.setText(props.getProperty("connectionURL"));
        }
        tadminUser.setText(props.getProperty("connectionName"));
        tRestrictedUser.setText(props.getProperty("restrictedConnectionName"));
        if (props.getProperty("logLevelSQL") != null) {
            sqlLogLevel.setSelectedItem(props.getProperty("logLevelSQL"));
        }
        if (props.getProperty("logLevelXML") != null) {
            xmlLogLevel.setSelectedItem(props.getProperty("logLevelXML"));
        }
        if (props.getProperty("maskCache") != null) {
            ltfMaskCache.setValue(props.getProperty("maskCache"));
        }
        if (props.getProperty("userCache") != null) {
            ltfUserCache.setValue(props.getProperty("userCache"));
        }
        if (props.getProperty("minIdle") != null) {
            minIdle.setValue(props.getProperty("minIdle"));
        } else {
            minIdle.setValue("5");
        }
        if (props.getProperty("maxIdle") != null) {
            maxIdle.setValue(props.getProperty("maxIdle"));
        }
        if (props.getProperty("maxActive") != null) {
            maxActive.setValue(props.getProperty("maxActive"));
        }
        if (props.getProperty("developmentMode") == null || props.getProperty("developmentMode").equals("true")) {
            rbEntwicklungsmodus.setSelection("an");
        } else {
            rbEntwicklungsmodus.setSelection("aus");
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("Speichern")) {
            try {
                PropAdminOld.formValuesToProps();
                PropAdminOld.saveProps();
                System.exit(0);
            }
            catch (Exception e) {
                System.out.println("Es ist ein Fehler aufgetreten.");
                e.printStackTrace();
                WarningMessage.show(null, "Fehler: " + String.valueOf(e), "SuperX");
            }
        }
        if (cmd.equals("Verbindung testen")) {
            try {
                PropAdminOld.formValuesToProps();
                boolean e = PropAdminOld.testConnection(props.getProperty("connectionName"), tAdminPasswd.getText());
            }
            catch (Exception e) {
                WarningMessage.show(null, "Fehler:" + String.valueOf(e), "PropAdmin");
            }
        }
        if (cmd.equals("Verb.testen")) {
            try {
                PropAdminOld.formValuesToProps();
                PropAdminOld.testConnection(props.getProperty("restrictedConnectionName"), tRestrictedPassword.getText());
            }
            catch (Exception e) {
                WarningMessage.show(null, "Fehler:" + String.valueOf(e), "PropAdmin");
            }
        }
        if (cmd.equals("select-Rechte auf alle Tabellen")) {
            try {
                if (tRestrictedUser.getText() == null || tRestrictedUser.getText().trim().equals("")) {
                    throw new IllegalArgumentException("Eingeschr\u00e4nkter user muss angegeben sein");
                }
                if (tadminUser.getText() == null || tadminUser.getText().trim().equals("")) {
                    throw new IllegalArgumentException("User muss angegeben sein");
                }
                if (tAdminPasswd.getText() == null || tAdminPasswd.getText().trim().equals("")) {
                    throw new IllegalArgumentException("Userpassword muss angegeben sein");
                }
                this.grantSelectToRestrictedUser();
            }
            catch (Exception e) {
                WarningMessage.show(null, "Fehler:" + String.valueOf(e), "PropAdmin");
            }
        }
    }

    private void grantSelectToRestrictedUser() throws Exception {
        Class.forName(props.getProperty("driverName"));
        Connection conn = DriverManager.getConnection(props.getProperty("connectionURL"), tadminUser.getText(), tAdminPasswd.getText());
        Statement stm = conn.createStatement();
        ResultSet rs = null;
        rs = props.getProperty("driverName").indexOf("postgres") > -1 ? conn.getMetaData().getTables(null, null, null, null) : conn.getMetaData().getTables("superx", "superx", null, null);
        while (rs.next()) {
            System.out.println(rs.getObject(3).toString());
            if (rs.getString(4) == null || !rs.getString(4).equals("TABLE") && !rs.getString(4).equals("VIEW")) continue;
            stm.execute("grant select on " + rs.getObject(3).toString() + " to " + tRestrictedUser.getText() + ";");
        }
        rs.close();
        stm.close();
        conn.close();
    }

    private static boolean testConnection(String username, String password) {
        boolean result = false;
        try {
            Class.forName(props.getProperty("driverName"));
            if (props.getProperty("driverName").indexOf("postgres") > -1) {
                props.put("charSet", SqlStringUtils.getEncoding().equals("xUTF-8") ? "UTF-8" : "Latin-1");
                props.put("DateStyle", "German, DMY");
            } else {
                props.put("GL_DATETIME", "%d.%m.%Y %T");
                props.put("CLIENT_LOCALE", SqlStringUtils.getEncoding().equals("xUTF-8") ? "UTF-8" : "de_de.8859-1");
            }
            Connection conn = DriverManager.getConnection(props.getProperty("connectionURL"), username, password);
            DatabaseMetaData dbmd = conn.getMetaData();
            String msg = "Verbindung mit Datenbank " + conn.getCatalog() + " (" + dbmd.getDatabaseProductName() + " " + dbmd.getDatabaseProductVersion() + ") als " + username + " erfolgreich aufgebaut";
            if (isGuiWanted) {
                JOptionPane.showMessageDialog(null, msg, "DB-Prop Admin", 1);
            } else {
                System.out.println(msg);
            }
            conn.close();
            result = true;
        }
        catch (Exception e) {
            String msg = "Ein Fehler ist aufgetreten.\n" + e.toString();
            if (props.getProperty("driverName").indexOf("postgres") > -1 && e.toString().indexOf("Date Style") > -1) {
                msg = msg + "\nPr\u00fcfen Sie,ob Date Style auf dem Server auf German, DMY steht.";
            }
            if (isGuiWanted) {
                JOptionPane.showMessageDialog(null, msg, "DB-Prop Admin", 2);
            }
            System.out.println("Fehler: " + e.toString());
        }
        return result;
    }

    private static void formValuesToProps() throws Exception {
        String driver = tdriver.getText();
        String name = tadminUser.getText();
        String passwd = tAdminPasswd.getText();
        String url = turl.getText();
        if (driver == null || name == null || passwd == null || url == null || driver.equals("") || name.equals("") || url.equals("")) {
            if (isGuiWanted) {
                JOptionPane.showMessageDialog(null, "Bitte alle Felder ausf\u00fcllen!", "DB-Prop Admin", 1);
            }
            return;
        }
        props.setProperty("connectionPassword", "sx_des" + CryptUtils.encryptStringDES(tAdminPasswd.getText()));
        props.setProperty("connectionName", name);
        props.setProperty("restrictedConnectionName", tRestrictedUser.getText());
        if (tRestrictedPassword.getText() != null && tRestrictedPassword.getText().length() > 1) {
            props.setProperty("restrictedConnectionPassword", "sx_des" + CryptUtils.encryptStringDES(tRestrictedPassword.getText()));
        }
        props.setProperty("connectionURL", url);
        props.setProperty("driverName", driver);
        props.setProperty("minIdle", (String)minIdle.getValue());
        props.setProperty("maxIdle", (String)maxIdle.getValue());
        props.setProperty("maxActive", (String)maxActive.getValue());
        props.setProperty("maskCache", (String)ltfMaskCache.getValue());
        props.setProperty("userCache", (String)ltfUserCache.getValue());
        props.setProperty("logLevelSQL", sqlLogLevel.getSelectedItem().toString());
        props.setProperty("logLevelXML", xmlLogLevel.getSelectedItem().toString());
        props.setProperty("developmentMode", rbEntwicklungsmodus.getSelectedName().equals("an") ? "true" : "false");
    }

    private static void saveProps() {
        try {
            props.remove("charSet");
            props.remove("DateStyle");
            props.remove("GL_DATETIME");
            props.remove("CLIENT_LOCALE");
            FileOutputStream os = new FileOutputStream(dbpropfile);
            props.store(os, "SuperX DB.properties");
            ((OutputStream)os).close();
            System.out.println("\u00c4nderung gespeichert in " + dbpropfile);
        }
        catch (IOException e) {
            String fehler = "Konnte db.properties-Datei nicht speichern:" + e.toString();
            if (isGuiWanted) {
                JOptionPane.showMessageDialog(null, fehler, "DB-Prop Admin", 2);
            }
            System.out.println(e.toString());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        logLevels.add("SEVERE");
        logLevels.add("WARNING");
        logLevels.add("INFO");
        logLevels.add("FINE");
        logLevels.add("FINER");
        logLevels.add("FINEST");
        System.out.println("Umgebungsvariable LANG: " + System.getProperty("file.encoding"));
        GetOpts.setOpts(args);
        Window propAdmin = null;
        if (GetOpts.isPresent(GetOpts.Options.opt_dbprops)) {
            dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_noguiVar0) || GetOpts.isPresent(GetOpts.Options.opt_noguiVar1) || GetOpts.isPresent(GetOpts.Options.opt_noguiVar2)) {
            isGuiWanted = false;
        } else {
            try {
                JFrame jFrame = new JFrame();
            }
            catch (Throwable e) {
                System.out.println("Keine graphische Umgebung verfuegbar - starte Shell-Modus");
                isGuiWanted = false;
            }
            if (isGuiWanted) {
                propAdmin = new PropAdminOld();
            }
        }
        try {
            PropAdminOld.properties_einlesen();
            if (isGuiWanted) {
                PropAdminOld.initFormFromProps();
            }
        }
        catch (IOException e) {
            String fehler = "Konnte db.properties-Datei nicht finden.\nEs wird eine neue in \n" + dbpropfile + " \nangelegt.";
            if (isGuiWanted) {
                JOptionPane.showMessageDialog(null, fehler, "DB-Prop Admin", 1);
                System.out.println(fehler);
                tdriver.setText(defaultDBDriver);
                tadminUser.setText(defaultUser);
                turl.setText(defaultConnection);
            }
            System.out.println("Sie koennen nur bestehende db.properties Dateien bearbeiten.");
            System.out.println("Geben Sie den Parameter -dbproperties:/home/superx/../db.properties an");
            System.out.println(e);
            System.exit(1);
        }
        if (isGuiWanted) {
            propAdmin.show();
        } else {
            PropAdminOld.noGuiEdit();
        }
    }

    private static void noGuiEdit() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Die meisten Paramter koennen Sie mit dem vi bearbeiten.");
            System.out.print("Passwort f\u00fcr uneingeschr\u00e4nkten User (erscheint auf Bildschirm!): ");
            String newAdminPassword = br.readLine();
            System.out.println();
            if (PropAdminOld.testConnection(props.getProperty("connectionName"), newAdminPassword)) {
                System.out.print("Einen Moment - Verschl\u00fcsselung l\u00e4uft ...");
                props.setProperty("connectionPassword", "sx_des" + CryptUtils.encryptStringDES(newAdminPassword));
                System.out.println(" OK");
                PropAdminOld.saveProps();
            }
            if (props.getProperty("restrictedConnectionName") != null) {
                System.out.print("Passwort f\u00fcr eingeschraenkten User (erscheint auf Bildschirm!): ");
                String newPassword = br.readLine();
                System.out.println();
                if (PropAdminOld.testConnection(props.getProperty("restrictedConnectionName"), newPassword)) {
                    System.out.print("Einen Moment - Verschl\u00fcsselung l\u00e4uft ...");
                    props.setProperty("restrictedConnectionPassword", "sx_des" + CryptUtils.encryptStringDES(newPassword));
                    System.out.println(" OK");
                    PropAdminOld.saveProps();
                }
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String s = (String)e.getItem();
        for (int i = 0; i < connTypes.length; ++i) {
            if (!s.equals(connTypes[i][0])) continue;
            tdriver.setText(connTypes[i][1]);
            turl.setText(connTypes[i][2]);
        }
    }

    static {
        logLevels = new LinkedList();
        rbEntwicklungsmodus = new RadioButtonGroup();
        defaultDBDriver = "com.informix.jdbc.IfxDriver";
        defaultConnection = "jdbc:informix-sqli://<<hostname>>:<<Portnr>>:informixserver=<<informixserver>>;database=superx";
        defaultUser = "superx";
        dbpropfile = "db.properties";
        isGuiWanted = true;
        props = new Properties();
        key = new byte[]{-1, -35, 127, 109, -127};
        keyLength = key.length;
        usage = "-------------------------------------\nGebrauch: java de.superx.bin.PropAdmin -dbproperties:<<Pfad zu den db-Properties>>(optional) \n---------------------------------------------------";
    }
}

