/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.GetOpts;
import de.superx.bin.Doschema;
import de.superx.bin.FMParser;
import de.superx.bin.SxConnection;
import de.superx.bin.SxDBUtils;
import de.superx.bin.SxJdbcClient;
import de.superx.bin.SxTransformer;
import de.superx.bin.XUpdater;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Dosql {
    private static Connection myDb;
    private static Statement st;
    private static boolean done;
    private static String delim;
    private static String header;
    private static String logfile;
    private static String tabelle;
    private static String dbpropfile;
    private static String outfile;
    private static Doschema.Format outFormat;
    private static String _dateiPfad;
    private static Logger logger;
    private static String usage;

    public static void instructions() {
        System.out.println("SuperX @version@\n");
        System.out.println("\nDieses Javaprogramm f\u00fchrt ein beliebiges sql-Script mit einer oder mehr sql-Anweisungen aus");
        System.out.println("Im Classpath muss superx@version@.jar sowie der zugeh\u00f6rige jdbc-Treiber sein.");
        System.out.println("Befehl:\n java dosql <Dateipfad sql-Script> <delimiter>(optional) <Ausgabe der Feld\u00fcberschriften (optional, true oder false).");
        System.out.println("Default:\n java dosql <Dateipfad sql-Script> <TAB> true");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            Dosql.execute(args);
        }
        catch (Exception e) {
            logger.severe("Fehler beim sql-Script: " + _dateiPfad + " " + e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void execute(String[] args) throws Exception {
        File f;
        Object params = "";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_logger, GetOpts.Options.opt_dbprops, GetOpts.Options.opt_sql});
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_logger)) {
            logfile = GetOpts.getValue(GetOpts.Options.opt_logger);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_dbprops)) {
            dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_sql)) {
            _dateiPfad = GetOpts.getValue(GetOpts.Options.opt_sql);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_delim)) {
            delim = GetOpts.getValue(GetOpts.Options.opt_delim);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_header)) {
            header = GetOpts.getValue(GetOpts.Options.opt_header);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_outFile)) {
            outfile = GetOpts.getValue(GetOpts.Options.opt_outFile);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_params)) {
            params = GetOpts.getValue(GetOpts.Options.opt_params);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_outFormat)) {
            outFormat = Doschema.Format.valueOf(GetOpts.getValue(GetOpts.Options.opt_outFormat).toLowerCase());
        }
        if (delim.equals("")) {
            delim = "^";
        }
        if (!(f = new File(logfile)).exists()) {
            throw new IOException("Datei nicht gefunden: " + logfile);
        }
        FileInputStream ins = new FileInputStream(logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        logfile = MyLogManager.getProperty(".level");
        logger.info("Using Loggging-Level " + logfile);
        f = new File(_dateiPfad);
        if (!f.exists()) {
            throw new IOException("Datei nicht gefunden: " + _dateiPfad);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        Object sql = "";
        String text = "";
        while ((text = in.readLine()) != null) {
            sql = (String)sql + System.getProperty("line.separator") + text.trim();
        }
        in.close();
        if (((String)sql).toLowerCase().indexOf("<xupdate>") > -1) {
            SxConnection myConnection = new SxConnection();
            myConnection.setPropfile(dbpropfile);
            Connection con = myConnection.getConnection();
            new XUpdater().execute(con, myConnection.getDatabaseAbbr(), (String)sql, logger);
        } else {
            if (((String)sql).toLowerCase().indexOf("--freemarker template") > -1) {
                try {
                    sql = FMParser.simpleParser(dbpropfile, (String)sql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (((String)(sql = ((String)sql).trim())).startsWith("\"")) {
                sql = ((String)sql).substring(1, ((String)sql).length());
            }
            if (((String)sql).endsWith("\"")) {
                sql = ((String)sql).substring(0, ((String)sql).length() - 1);
            }
            logger.config("Inhalt der sql-Datei: \n--" + (String)sql + "--");
            if (!((String)params).equals("")) {
                if (!((String)params).endsWith("|")) {
                    params = (String)params + "|";
                }
                StringTokenizer st = new StringTokenizer((String)params, "|");
                while (st.hasMoreTokens()) {
                    String param = st.nextToken();
                    if (param.equals("")) continue;
                    String paramname = param.substring(0, param.indexOf("="));
                    String paramvalue = param.substring(param.indexOf("=") + 1, param.length());
                    sql = SxDBUtils.replaceString((String)sql, paramname, paramvalue);
                }
            }
            SxJdbcClient myClient = new SxJdbcClient(logger, dbpropfile, (String)sql);
            if (outfile.equals("") && outFormat == Doschema.Format.txt) {
                myClient.setLogAllResultSetsToConsole(true);
            }
            SxTransformer myTransformer = null;
            myClient.Rs_executeALL();
            ResultSet myrs = myClient.getRs();
            if (myrs != null) {
                myTransformer = outfile.equals("") ? new SxTransformer(logger, System.out) : new SxTransformer(logger, new FileWriter(outfile));
                if (!outfile.equals("") || outFormat != Doschema.Format.txt) {
                    myTransformer.setDelim(delim);
                    myTransformer.setHeader(header);
                    myTransformer.setOutrs(myrs);
                    myTransformer.setOutrsmd(myClient.getRsmd());
                    myTransformer.printResult(outFormat.name());
                }
            } else {
                logger.info("Keine R\u00fcckgabewerte aus SQL-Script");
            }
            myClient.close();
        }
        System.out.println("Dosql hat das Script " + _dateiPfad + " erfolgreich durchgef\u00fchrt");
        logger.info("dosql erfolgreich beendet");
    }

    static {
        done = false;
        delim = "^";
        header = "false";
        logfile = "../conf/logging.properties";
        tabelle = "";
        dbpropfile = "../conf/db.properties";
        outfile = "";
        outFormat = Doschema.Format.txt;
        _dateiPfad = "";
        logger = Logger.getLogger(Dosql.class.toString());
        usage = "-------------------------------------\nGebrauch: java de.superx.bin.Dosql -logger=<<Pfad zu logging.properties>> -dbproperties=<<Pfad zu db.properties>> -sqlfile:<Datei mit sql-Ausdr\u00fccken> -params:<Parameter, die in sql- oder Script-Dateien ersetzt werden; Syntax:param1=wert1,param2=wert2 etc> -outFormat:<Ausgabeformat (txt | html | xml)>(optional) -delim:<delimiter> -header:<mit Spalten\u00fcberschriften (true | false)>(optional) -outfile:<Ausgabedatei>(optional) \n---------------------------------------------------";
    }
}

