/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.rest;

import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.Dimension;
import de.superx.bianalysis.models.FactTable;
import de.superx.bianalysis.models.Measure;
import de.superx.bianalysis.repository.dto.AttributeDto;
import de.superx.bianalysis.service.BiAnalysisRightService;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.common.NotYetImplementedException;
import de.superx.rest.RestControllerBase;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bianalysis/admin"})
@PreAuthorize(value="hasAuthority('RIGHT_CS_BIA_ANALYSIS_MANAGE_METADATA')")
public class BiAnalysisAdminApi
extends RestControllerBase {
    static Logger logger = Logger.getLogger(BiAnalysisAdminApi.class);
    @Autowired
    DbMetaAdapter dbAdapter;
    @Autowired
    BiAnalysisRightService userService;

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/facttables"})
    public List<FactTable> listFactTables() throws NotYetImplementedException {
        return this.dbAdapter.getFactTables();
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/dimensions"})
    public List<Dimension> listDimensions(@RequestParam(value="facttable_id") String factId) {
        return this.dbAdapter.getDimensions(new Identifier(factId));
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/measures"})
    public List<Measure> listMeasures(@RequestParam(value="facttable_id") String factId) {
        return this.dbAdapter.getMeasures(new Identifier(factId));
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/attribute-group"})
    public Identifier saveAttributeGroup(@RequestBody AttributeDto attributeGroup, @RequestParam(value="dimension_id") Identifier dimensionId) {
        AttributeDto savedAttribute;
        if (attributeGroup.id != null && attributeGroup.id.composedId != null && !attributeGroup.id.composedId.isBlank()) {
            this.dbAdapter.deleteColumnForAttributeGroup(attributeGroup.id, dimensionId);
        }
        if ((savedAttribute = this.dbAdapter.saveAttributeGroup(attributeGroup, dimensionId)) != null && savedAttribute.id != null) {
            try {
                this.dbAdapter.saveAttributeGroupColumn(savedAttribute, false);
                this.dbAdapter.saveAttributeGroupColumn(savedAttribute, true);
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.dbAdapter.deleteAttributeGroupById(savedAttribute.id);
            }
        } else {
            logger.error((Object)attributeGroup);
            throw new RuntimeException("ERROR saving Attribute Group.");
        }
        return savedAttribute.id;
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/attribute-group/validate"})
    public List<String> validateAttributeGroup(@RequestBody AttributeDto attributeGroup, @RequestParam(value="dimension_id") Identifier dimensionId) {
        return this.dbAdapter.validateAttibuteGroup(attributeGroup, dimensionId);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/attribute-group"})
    public void deleteAttributeGroup(@RequestParam(value="attribute_group_id") Identifier attributeGroupId) {
        this.dbAdapter.deleteAttributeGroupById(attributeGroupId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/all-attribute-groups"})
    public List<AttributeDto> listAllAttributeGroups() {
        List<AttributeDto> groups = this.dbAdapter.getAttributeGroups();
        return groups;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/dimensionAttributeValues"})
    public List<String> listAttributeValues(@RequestParam(value="attribute_id") List<Identifier> ids) {
        return this.dbAdapter.getValuesForAttributes(ids);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/hideAttribute"})
    public void hideAttribute(@RequestBody Boolean hide, @RequestParam(value="attribute_id") Identifier id) {
        this.dbAdapter.hideAttributeById(id, hide);
    }
}

