/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.Dimension;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.repository.dto.MeasureDto;
import de.superx.bianalysis.repository.dto.MeasureFilterDto;
import de.superx.rest.model.ColumnType;

public class Measure {
    private MeasureDto measureDto;
    @JsonIgnore
    public String filterTablename;
    @JsonIgnore
    public String filterJoincolumn;
    @JsonIgnore
    public String filterColumnname;
    @JsonIgnore
    public String filterInclude;
    @JsonIgnore
    public String filterExclude;
    @JsonIgnore
    public String filterDimensionTableAlias;
    @JsonIgnore
    public String filterCondition;
    @JsonIgnore
    public String factColumnFilter;
    @JsonIgnore
    public Identifier filterAttributeId;

    public Measure() {
    }

    public Measure(MeasureDto measureDTO) {
        this.measureDto = measureDTO;
    }

    public void setMeasureFilterAttributes(MeasureFilterDto filter, DimensionAttribute attribute, Dimension dimension) {
        this.filterInclude = filter.includedValues;
        this.filterExclude = filter.excludedValues;
        this.filterTablename = dimension.getTablename();
        this.filterJoincolumn = dimension.getJoincolumn();
        this.filterColumnname = attribute.getColumnname();
        this.filterAttributeId = attribute.getId();
        this.filterDimensionTableAlias = dimension.getAlias() != null ? dimension.getAlias() : Measure.generatefilterDimensionTableAlias(this.filterJoincolumn);
        this.filterCondition = this.generateFilterCondition();
    }

    public void setFactColumnFilter(MeasureFilterDto filter) {
        this.factColumnFilter = filter.factColumnFilter;
        this.filterInclude = filter.includedValues;
        this.filterExclude = filter.excludedValues;
        this.filterCondition = this.generateFilterCondition();
    }

    private static String generatefilterDimensionTableAlias(String filterJoincolumn) {
        if (filterJoincolumn != null) {
            return filterJoincolumn.replaceFirst("_(id|lid)$", "");
        }
        return null;
    }

    private String generateFilterCondition() {
        if (this.measureDto.measureFilterId.value != null) {
            StringBuilder filterConditionStatement = new StringBuilder();
            Object tableDotColumn = this.filterDimensionTableAlias + "." + this.filterColumnname;
            if (this.factColumnFilter != null && !this.factColumnFilter.isBlank()) {
                tableDotColumn = this.factColumnFilter;
            }
            if (this.filterInclude != null) {
                filterConditionStatement.append((String)tableDotColumn + " IN (" + this.filterInclude + ")");
            }
            if (this.filterInclude != null && this.filterExclude != null) {
                filterConditionStatement.append(" AND ");
            }
            if (this.filterExclude != null) {
                filterConditionStatement.append((String)tableDotColumn + " NOT IN (" + this.filterExclude + ")");
            }
            return filterConditionStatement.toString();
        }
        return null;
    }

    public Identifier getId() {
        return this.measureDto.id;
    }

    public String getCaption() {
        return this.measureDto.caption;
    }

    public String getColumnname() {
        return this.measureDto.columnname;
    }

    public String getDescription() {
        return this.measureDto.description;
    }

    public String getAggregationType() {
        return this.measureDto.aggregationType;
    }

    public ColumnType getMeasureType() {
        return ColumnType.valueOf(this.measureDto.measureType);
    }

    public Identifier getMeasureFilterId() {
        return this.measureDto.measureFilterId;
    }
}

