/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.ImageTransferable;
import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;

class ImageAndRtfTransferable
extends ImageTransferable {
    private ByteArrayInputStream stream;
    public DataFlavor rtfDataFlavor;

    ImageAndRtfTransferable(Component comp, ByteArrayInputStream stream) {
        super(comp);
        this.initRTF(stream);
    }

    ImageAndRtfTransferable(Image image, ByteArrayInputStream stream) {
        super(image);
        this.initRTF(stream);
    }

    private void initRTF(ByteArrayInputStream stream) {
        try {
            this.rtfDataFlavor = new DataFlavor("text/rtf; class=java.io.InputStream");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.stream = stream;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor, this.rtfDataFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.rtfDataFlavor) || flavor.equals(DataFlavor.imageFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        Object res = null;
        if (flavor.equals(this.rtfDataFlavor)) {
            res = this.stream;
        }
        if (flavor.equals(DataFlavor.imageFlavor)) {
            res = this.image;
        }
        return res;
    }
}

