/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.db.ConnectionCreator;
import de.memtext.db.DBAccess;
import de.memtext.tree.MBTreeSelectionListener;
import de.memtext.tree.admin.RecursiveTableAdminPanel;
import de.memtext.tree.admin.Status;
import de.memtext.util.PlafUtils;
import de.memtext.util.WindowUtils;
import de.memtext.widgets.InfoMessage;
import de.memtext.widgets.MBFrame;
import de.memtext.widgets.WarningMessage;
import java.awt.Component;
import java.awt.Container;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class RecursiveTableAdmin
extends MBFrame {
    private Connection con;
    private Statement stmt;
    private JTree selectionTree;
    private RecursiveTableAdminPanel adm;
    private static String table;
    private static String keycolname;
    private static String parentcolname;

    public static void main(String[] arg) {
        if (arg.length < 1 || arg.length > 4) {
            System.out.println("RecursiveTableAdmin propfilename [table] [keycolumn name] [parent column name]");
            System.exit(0);
        }
        try {
            Connection con = ConnectionCreator.getConnectionCryptPassword(arg[0], "driverName", "connectionURL", "connectionName", "connectionPassword");
            DBAccess.addConnection("RecursiveTableAdmin", con);
        }
        catch (Exception e) {
            WarningMessage.show(null, "Verbindung konnte nicht aufgebaut werden.\n" + String.valueOf(e), "Achtung");
            e.printStackTrace();
            System.exit(-1);
        }
        if (arg.length > 1) {
            table = arg[1];
            keycolname = arg[2];
            parentcolname = arg[3];
        }
        InfoMessage.show(null, "\u00c4nderungen werden erst in die Datenbank gespielt, wenn man Save aufruft.\nBisher k\u00f6nnen keine null-Werte eingef\u00fcgt werden - immer Leerstring!", "Hinweis");
        try {
            RecursiveTableAdmin admin = new RecursiveTableAdmin();
            admin.setSize(900, 500);
            WindowUtils.center(admin);
            admin.show();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public RecursiveTableAdmin() throws SQLException {
        super("RecursiveTableAdmin");
        PlafUtils.setWindowsLook(this);
        Status.getInstance().setFrame(this);
        Container cp = this.getContentPane();
        LinkedList<String> tables = null;
        if (table == null) {
            tables = this.getRecursiveTables();
        } else {
            tables = new LinkedList<String>();
            tables.add(table);
        }
        this.selectionTree = this.getSelectionTree(tables);
        this.selectionTree.setSelectionRow(1);
        this.adm = new RecursiveTableAdminPanel(tables.toArray()[0].toString());
        this.selectionTree.addTreeSelectionListener(new RecursiveTableTreeSelectionListener());
        JSplitPane splitp = new JSplitPane(1, new JScrollPane(this.selectionTree), this.adm);
        cp.add((Component)splitp, "Center");
        this.setJMenuBar(this.adm.getAMenuBar());
    }

    private JTree getSelectionTree(Collection tableList) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("rekursive Tables");
        for (String tableName : tableList) {
            root.add(new DefaultMutableTreeNode(tableName));
        }
        return new JTree(root);
    }

    private Collection getRecursiveTables() throws SQLException {
        TreeSet result = new TreeSet();
        result.addAll(DBAccess.get("RecursiveTableAdmin").getTableList());
        LinkedList<String> removeList = new LinkedList<String>();
        for (String aTablename : result) {
            if (DBAccess.get("RecursiveTableAdmin").hasColumn(aTablename, "key") && DBAccess.get("RecursiveTableAdmin").hasColumn(aTablename, "parent") && DBAccess.get("RecursiveTableAdmin").hasColumn(aTablename, "name")) continue;
            removeList.add(aTablename);
        }
        result.removeAll(removeList);
        return result;
    }

    @Override
    protected void doBeforeExit() throws SQLException {
        DBAccess.get("RecursiveTableAdmin").closeConnection();
    }

    class RecursiveTableTreeSelectionListener
    extends MBTreeSelectionListener {
        RecursiveTableTreeSelectionListener() {
        }

        @Override
        public void selectionChanged() {
            String tablename = null;
            if (this.getSelectedNode() != null) {
                tablename = this.getSelectedNode().toString();
            }
            RecursiveTableAdmin.this.adm.setTable(tablename);
        }
    }
}

