/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class SelectedNodeAction
extends AbstractAction
implements TreeSelectionListener {
    private TreeNode selectedNode;
    private Set acceptableTreeNodeClasses = null;
    private boolean isStrictAcceptabilityWanted = false;

    public SelectedNodeAction() {
        this.setEnabled(false);
    }

    public SelectedNodeAction(String name) {
        super(name);
        this.setEnabled(false);
    }

    public SelectedNodeAction(String name, Icon icon) {
        super(name, icon);
        this.setEnabled(false);
    }

    public SelectedNodeAction(Icon icon) {
        super(null, icon);
        this.setEnabled(false);
    }

    public void addAcceptableTreeNodeClass(Class nodeClass) {
        if (nodeClass == null) {
            throw new NullPointerException("Acceptable node class must not be null");
        }
        if (this.acceptableTreeNodeClasses == null) {
            this.acceptableTreeNodeClasses = new HashSet();
        }
        this.acceptableTreeNodeClasses.add(nodeClass);
    }

    public void removeAcceptableTreeNodeClass(Class nodeClass) {
        if (this.acceptableTreeNodeClasses != null) {
            this.acceptableTreeNodeClasses.remove(nodeClass);
        }
    }

    public void setStrictAcceptability(boolean isStrictAcceptabilityWanted) {
        this.isStrictAcceptabilityWanted = isStrictAcceptabilityWanted;
    }

    public boolean isStrictAcceptability() {
        return this.isStrictAcceptabilityWanted;
    }

    @Override
    public final void valueChanged(TreeSelectionEvent e) {
        TreePath selectionPath = e.getNewLeadSelectionPath();
        if (selectionPath != null) {
            this.selectedNode = (TreeNode)selectionPath.getLastPathComponent();
            this.setEnabled(this.isClassOK(this.selectedNode));
            if (this.isEnabled()) {
                this.checkAcceptable();
            }
        } else {
            this.setEnabled(false);
            this.selectedNode = null;
        }
    }

    protected void checkAcceptable() {
    }

    private boolean isClassOK(TreeNode selection) {
        if (this.acceptableTreeNodeClasses == null || this.acceptableTreeNodeClasses.isEmpty()) {
            return true;
        }
        boolean result = false;
        for (Class anAcceptableClass : this.acceptableTreeNodeClasses) {
            if (this.isStrictAcceptabilityWanted) {
                if (!anAcceptableClass.getName().equals(selection.getClass().getName())) continue;
                result = true;
                break;
            }
            if (!anAcceptableClass.isInstance(selection)) continue;
            result = true;
            break;
        }
        return result;
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);
}

