/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.rights;

import de.memtext.rights.Allowable;
import de.memtext.rights.AllowableHierarchy;
import de.memtext.tree.TreeEntryI;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class AllowableHierarchyUtil {
    public static void removeUnallowedNodes(AllowableHierarchy root) {
        if (!(root instanceof DefaultMutableTreeNode)) {
            throw new IllegalArgumentException(" must be a node!");
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)((Object)root);
        boolean needAnotherRound = true;
        boolean killedOne = false;
        while (needAnotherRound) {
            killedOne = false;
            Enumeration<TreeNode> en = rootNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                AllowableHierarchy ah;
                TreeNode o = en.nextElement();
                if (o == root || (ah = (AllowableHierarchy)((Object)o)).isAnyDescendantAllowed()) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)((Object)ah);
                AllowableHierarchyUtil.markParentsAsNotAllowed(node);
                node.removeFromParent();
                killedOne = true;
                break;
            }
            if (killedOne) continue;
            needAnotherRound = false;
        }
    }

    private static void markParentsAsNotAllowed(DefaultMutableTreeNode node) {
        if (!node.isRoot() && node instanceof Allowable) {
            Allowable al = null;
            if (node.getParent() instanceof Allowable) {
                al = (Allowable)((Object)node.getParent());
            }
            al.setAllowed(false);
            AllowableHierarchyUtil.markParentsAsNotAllowed((DefaultMutableTreeNode)node.getParent());
        }
    }

    public static void reorg(AllowableHierarchy root) {
        if (!(root instanceof DefaultMutableTreeNode)) {
            throw new IllegalArgumentException(" must be a node!");
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)((Object)root);
        boolean needAnotherRound = true;
        LinkedList<TreeNode> nodeList = new LinkedList<TreeNode>();
        while (needAnotherRound) {
            nodeList.clear();
            needAnotherRound = false;
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                AllowableHierarchy ah = (AllowableHierarchy)((Object)rootNode.getChildAt(i));
                if (ah.isAllowed()) continue;
                needAnotherRound = true;
                ((DefaultMutableTreeNode)((Object)ah)).removeFromParent();
                for (int i2 = 0; i2 < ((DefaultMutableTreeNode)((Object)ah)).getChildCount(); ++i2) {
                    nodeList.add(((DefaultMutableTreeNode)((Object)ah)).getChildAt(i2));
                }
            }
            Iterator it = nodeList.iterator();
            while (it.hasNext()) {
                rootNode.add((DefaultMutableTreeNode)it.next());
            }
        }
    }

    public static void markNotAllowedNodes(AllowableHierarchy root, String mark) {
        if (!(root instanceof DefaultMutableTreeNode)) {
            throw new IllegalArgumentException(" must be a node!");
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)((Object)root);
        boolean i = false;
        Enumeration<TreeNode> en = rootNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            TreeEntryI te;
            AllowableHierarchy ah = (AllowableHierarchy)((Object)en.nextElement());
            if (ah.isAllowed() || (te = (TreeEntryI)((Object)ah)).getName().endsWith(mark)) continue;
            te.setName(te.getName() + mark);
        }
    }
}

