/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.repository;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.server.io.DefaultHandler;
import org.apache.jackrabbit.server.io.IOManager;
import org.apache.jackrabbit.server.io.ImportContext;

public class SaikuDavResourceImpl
extends DefaultHandler {
    public SaikuDavResourceImpl() {
    }

    public SaikuDavResourceImpl(IOManager ioManager) {
        super(ioManager);
    }

    public SaikuDavResourceImpl(IOManager ioManager, String collectionNodetype, String defaultNodetype, String contentNodetype) {
        super(ioManager, collectionNodetype, defaultNodetype, contentNodetype);
    }

    public boolean importContent(ImportContext context, boolean isCollection) throws IOException {
        if (!this.canImport(context, isCollection)) {
            throw new IOException(this.getName() + ": Cannot import " + context.getSystemId());
        }
        boolean success = false;
        try {
            Node contentNode = this.getContentNode(context, isCollection);
            String ext = FilenameUtils.getExtension((String)context.getSystemId());
            if (ext.equals("saiku")) {
                contentNode.getParent().addMixin("nt:saikufiles");
            } else if (ext.equals("xml")) {
                contentNode.getParent().addMixin("nt:mondrianschema");
            } else if (ext.equals("sds")) {
                contentNode.getParent().addMixin("nt:olapdatasource");
            } else if (isCollection) {
                contentNode.getParent().addMixin("nt:saikufolders");
            }
            success = this.importData(context, isCollection, contentNode);
            if (success) {
                success = this.importProperties(context, isCollection, contentNode);
            }
        }
        catch (RepositoryException e) {
            success = false;
            throw new IOException(e.getMessage());
        }
        finally {
            if (!success) {
                try {
                    context.getImportRoot().refresh(false);
                }
                catch (RepositoryException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
        return success;
    }
}

