/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.util.formatter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.impl.CoordinateIterator;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.Property;
import org.saiku.olap.dto.resultset.DataCell;
import org.saiku.olap.dto.resultset.Matrix;
import org.saiku.olap.dto.resultset.MemberCell;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.olap.util.formatter.ICellSetFormatter;

public class CellSetFormatter
implements ICellSetFormatter {
    private Matrix matrix;

    private static Iterable<Cell> cellIter(final int[] pageCoords, final CellSet cellSet) {
        return new Iterable<Cell>(){

            @Override
            public Iterator<Cell> iterator() {
                int[] axisDimensions = new int[cellSet.getAxes().size() - pageCoords.length];
                assert (pageCoords.length <= axisDimensions.length);
                for (int i = 0; i < axisDimensions.length; ++i) {
                    CellSetAxis axis = (CellSetAxis)cellSet.getAxes().get(i);
                    axisDimensions[i] = axis.getPositions().size();
                }
                final CoordinateIterator coordIter = new CoordinateIterator(axisDimensions, true);
                return new Iterator<Cell>(){

                    @Override
                    public boolean hasNext() {
                        return coordIter.hasNext();
                    }

                    @Override
                    public Cell next() {
                        final int[] ints = coordIter.next();
                        AbstractList<Integer> intList = new AbstractList<Integer>(){

                            @Override
                            public Integer get(int index) {
                                return index < ints.length ? ints[index] : pageCoords[index - ints.length];
                            }

                            @Override
                            public int size() {
                                return pageCoords.length + ints.length;
                            }
                        };
                        return cellSet.getCell((List)intList);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Matrix format(CellSet cellSet) {
        CellSetAxis columnsAxis = cellSet.getAxes().size() > 0 ? (CellSetAxis)cellSet.getAxes().get(0) : null;
        AxisInfo columnsAxisInfo = this.computeAxisInfo(columnsAxis);
        CellSetAxis rowsAxis = cellSet.getAxes().size() > 1 ? (CellSetAxis)cellSet.getAxes().get(1) : null;
        AxisInfo rowsAxisInfo = this.computeAxisInfo(rowsAxis);
        if (cellSet.getAxes().size() > 2) {
            int[] dimensions = new int[cellSet.getAxes().size() - 2];
            for (int i = 2; i < cellSet.getAxes().size(); ++i) {
                CellSetAxis cellSetAxis = (CellSetAxis)cellSet.getAxes().get(i);
                dimensions[i - 2] = cellSetAxis.getPositions().size();
            }
            for (int[] pageCoords : CoordinateIterator.iterate((int[])dimensions)) {
                this.matrix = this.formatPage(cellSet, pageCoords, columnsAxis, columnsAxisInfo, rowsAxis, rowsAxisInfo);
            }
        } else {
            this.matrix = this.formatPage(cellSet, new int[0], columnsAxis, columnsAxisInfo, rowsAxis, rowsAxisInfo);
        }
        return this.matrix;
    }

    private AxisInfo computeAxisInfo(CellSetAxis axis) {
        if (axis == null) {
            return new AxisInfo(0);
        }
        AxisInfo axisInfo = new AxisInfo(axis.getAxisMetaData().getHierarchies().size());
        int p = -1;
        for (Position position : axis.getPositions()) {
            ++p;
            int k = -1;
            for (Member member : position.getMembers()) {
                AxisOrdinalInfo axisOrdinalInfo;
                if ((axisOrdinalInfo = axisInfo.ordinalInfos.get(++k)).getDepths().contains(member.getDepth())) continue;
                axisOrdinalInfo.getDepths().add(member.getDepth());
                axisOrdinalInfo.addLevel(member.getDepth(), member.getLevel());
                Collections.sort(axisOrdinalInfo.depths);
            }
        }
        return axisInfo;
    }

    private Matrix formatPage(CellSet cellSet, int[] pageCoords, CellSetAxis columnsAxis, AxisInfo columnsAxisInfo, CellSetAxis rowsAxis, AxisInfo rowsAxisInfo) {
        int yOffset = columnsAxisInfo.getWidth();
        int xOffsset = rowsAxisInfo.getWidth();
        Matrix matrix = new Matrix(xOffsset + (columnsAxis == null ? 1 : columnsAxis.getPositions().size()), yOffset + (rowsAxis == null ? 1 : rowsAxis.getPositions().size()));
        ArrayList<Level> levels = new ArrayList<Level>();
        if (rowsAxis != null && rowsAxis.getPositions().size() > 0) {
            Position p = (Position)rowsAxis.getPositions().get(0);
            for (int m = 0; m < p.getMembers().size(); ++m) {
                AxisOrdinalInfo a = rowsAxisInfo.ordinalInfos.get(m);
                for (Integer depth : a.getDepths()) {
                    levels.add(a.getLevel(depth));
                }
            }
            for (int x = 0; x < xOffsset; ++x) {
                Level xLevel = (Level)levels.get(x);
                String s = xLevel.getCaption();
                for (int y = 0; y < yOffset; ++y) {
                    MemberCell memberInfo = new MemberCell(false, x > 0);
                    if (y == yOffset - 1) {
                        memberInfo.setRawValue(s);
                        memberInfo.setFormattedValue(s);
                        memberInfo.setProperty("__headertype", "row_header_header");
                        memberInfo.setProperty("levelindex", "" + levels.indexOf(xLevel));
                        memberInfo.setHierarchy(xLevel.getHierarchy().getUniqueName());
                        memberInfo.setParentDimension(xLevel.getDimension().getName());
                        memberInfo.setLevel(xLevel.getUniqueName());
                    }
                    matrix.set(x, y, memberInfo);
                }
            }
        }
        this.populateAxis(matrix, columnsAxis, columnsAxisInfo, true, xOffsset);
        this.populateAxis(matrix, rowsAxis, rowsAxisInfo, false, yOffset);
        for (Cell cell : CellSetFormatter.cellIter(pageCoords, cellSet)) {
            String cellValue;
            List coordList = cell.getCoordinateList();
            int x = xOffsset;
            if (coordList.size() > 0) {
                x += ((Integer)coordList.get(0)).intValue();
            }
            int y = yOffset;
            if (coordList.size() > 1) {
                y += ((Integer)coordList.get(1)).intValue();
            }
            DataCell cellInfo = new DataCell(true, false, coordList);
            cellInfo.setCoordinates(cell.getCoordinateList());
            if (cell.getValue() != null) {
                try {
                    cellInfo.setRawNumber(cell.getDoubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((cellValue = cell.getFormattedValue()) == null || cellValue.equals("null")) {
                cellValue = "";
            }
            if (cellValue.length() < 1) {
                Object value = cell.getValue();
                if (value == null || value.equals("null")) {
                    cellValue = "";
                } else {
                    try {
                        DecimalFormat myFormatter = new DecimalFormat(SaikuProperties.formatDefautNumberFormat);
                        DecimalFormatSymbols dfs = new DecimalFormatSymbols(SaikuProperties.locale);
                        myFormatter.setDecimalFormatSymbols(dfs);
                        cellValue = myFormatter.format(cell.getValue());
                    }
                    catch (Exception myFormatter) {
                        // empty catch block
                    }
                }
            }
            try {
                String formatString = (String)cell.getPropertyValue((Property)Property.StandardCellProperty.FORMAT_STRING);
                if (formatString != null && !formatString.startsWith("|")) {
                    cellInfo.setFormatString(formatString);
                } else {
                    formatString = formatString.substring(1, formatString.length());
                    cellInfo.setFormatString(formatString.substring(0, formatString.indexOf("|")));
                }
            }
            catch (Exception formatString) {
                // empty catch block
            }
            HashMap<String, String> cellProperties = new HashMap<String, String>();
            String val = Olap4jUtil.parseFormattedCellValue((String)cellValue, cellProperties);
            if (!cellProperties.isEmpty()) {
                cellInfo.setProperties(cellProperties);
            }
            cellInfo.setFormattedValue(val);
            matrix.set(x, y, cellInfo);
        }
        return matrix;
    }

    private void populateAxis(Matrix matrix, CellSetAxis axis, AxisInfo axisInfo, boolean isColumns, int offset) {
        if (axis == null) {
            return;
        }
        Member[] prevMembers = new Member[axisInfo.getWidth()];
        MemberCell[] prevMemberInfo = new MemberCell[axisInfo.getWidth()];
        Member[] members = new Member[axisInfo.getWidth()];
        for (int i = 0; i < axis.getPositions().size(); ++i) {
            int x = offset + i;
            Position position = (Position)axis.getPositions().get(i);
            int yOffset = 0;
            List memberList = position.getMembers();
            HashMap<Hierarchy, List> lvls = new HashMap<Hierarchy, List>();
            for (int j = 0; j < memberList.size(); ++j) {
                Member member = (Member)memberList.get(j);
                AxisOrdinalInfo ordinalInfo = axisInfo.ordinalInfos.get(j);
                List depths = ordinalInfo.depths;
                Collections.sort(depths);
                lvls.put(member.getHierarchy(), depths);
                if (ordinalInfo.getDepths().size() > 0 && member.getDepth() < ordinalInfo.getDepths().get(0)) break;
                int y = yOffset + ordinalInfo.depths.indexOf(member.getDepth());
                members[y] = member;
                yOffset += ordinalInfo.getWidth();
            }
            boolean expanded = false;
            boolean same = true;
            for (int y = 0; y < members.length; ++y) {
                int y_parent;
                AxisOrdinalInfo ordinalInfo;
                int depth_i;
                MemberCell memberInfo = new MemberCell();
                Member member = members[y];
                expanded = false;
                int index = memberList.indexOf(member);
                if (index >= 0 && (depth_i = (ordinalInfo = axisInfo.ordinalInfos.get(index)).getDepths().indexOf(member.getDepth())) > 0) {
                    expanded = true;
                }
                memberInfo.setExpanded(expanded);
                boolean bl = same = same && i > 0 && Olap4jUtil.equal((Object)prevMembers[y], (Object)member);
                if (member != null) {
                    if (lvls != null && lvls.get(member.getHierarchy()) != null) {
                        memberInfo.setProperty("levelindex", "" + ((List)lvls.get(member.getHierarchy())).indexOf(member.getLevel().getDepth()));
                    }
                    if (x - 1 == offset) {
                        memberInfo.setLastRow(true);
                    }
                    matrix.setOffset(offset);
                    memberInfo.setRawValue(member.getUniqueName());
                    memberInfo.setFormattedValue(member.getCaption());
                    memberInfo.setParentDimension(member.getDimension().getName());
                    memberInfo.setHierarchy(member.getHierarchy().getUniqueName());
                    memberInfo.setLevel(member.getLevel().getUniqueName());
                    memberInfo.setUniquename(member.getUniqueName());
                } else {
                    memberInfo.setRawValue(null);
                    memberInfo.setFormattedValue(null);
                    memberInfo.setParentDimension(null);
                }
                if (isColumns) {
                    memberInfo.setRight(false);
                    memberInfo.setSameAsPrev(same);
                    if (member != null) {
                        memberInfo.setParentDimension(member.getDimension().getName());
                    }
                    matrix.set(x, y, memberInfo);
                } else {
                    memberInfo.setRight(false);
                    memberInfo.setSameAsPrev(false);
                    matrix.set(y, x, memberInfo);
                }
                int x_parent = isColumns ? x : y - 1;
                int n = y_parent = isColumns ? y - 1 : x;
                if (index >= 0) {
                    AxisOrdinalInfo ordinalInfo2 = axisInfo.ordinalInfos.get(index);
                    int depth_i2 = ordinalInfo2.getDepths().indexOf(member.getDepth());
                    while (depth_i2 > 0) {
                        Member parent;
                        int parentDepth = ordinalInfo2.getDepths().get(--depth_i2);
                        for (parent = member.getParentMember(); parent != null && parent.getDepth() > parentDepth; parent = parent.getParentMember()) {
                        }
                        MemberCell pInfo = new MemberCell();
                        if (parent != null) {
                            pInfo.setRawValue(parent.getUniqueName());
                            pInfo.setFormattedValue(parent.getCaption());
                            pInfo.setParentDimension(parent.getDimension().getName());
                            pInfo.setHierarchy(parent.getHierarchy().getUniqueName());
                            pInfo.setUniquename(parent.getUniqueName());
                            pInfo.setLevel(parent.getLevel().getUniqueName());
                        } else {
                            pInfo.setRawValue("");
                            pInfo.setFormattedValue("");
                            pInfo.setParentDimension(member.getDimension().getName());
                            pInfo.setHierarchy(member.getHierarchy().getUniqueName());
                            pInfo.setLevel(member.getLevel().getUniqueName());
                            pInfo.setUniquename("");
                        }
                        matrix.set(x_parent, y_parent, pInfo);
                        if (isColumns) {
                            --y_parent;
                            continue;
                        }
                        --x_parent;
                    }
                }
                prevMembers[y] = member;
                prevMemberInfo[y] = memberInfo;
                members[y] = null;
            }
        }
    }

    private static class AxisOrdinalInfo {
        private final List<Integer> depths = new ArrayList<Integer>();
        private final Map<Integer, Level> depthLevel = new HashMap<Integer, Level>();

        private AxisOrdinalInfo() {
        }

        public int getWidth() {
            return this.depths.size();
        }

        public List<Integer> getDepths() {
            return this.depths;
        }

        public Level getLevel(Integer depth) {
            return this.depthLevel.get(depth);
        }

        public void addLevel(Integer depth, Level level) {
            this.depthLevel.put(depth, level);
        }
    }

    private static class AxisInfo {
        final List<AxisOrdinalInfo> ordinalInfos;

        AxisInfo(int ordinalCount) {
            this.ordinalInfos = new ArrayList<AxisOrdinalInfo>(ordinalCount);
            for (int i = 0; i < ordinalCount; ++i) {
                this.ordinalInfos.add(new AxisOrdinalInfo());
            }
        }

        public int getWidth() {
            int width = 0;
            for (AxisOrdinalInfo info : this.ordinalInfos) {
                width += info.getWidth();
            }
            return width;
        }
    }
}

