/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query2.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.query2.ThinAxis;
import org.saiku.olap.query2.ThinCalculatedMeasure;
import org.saiku.olap.query2.ThinCalculatedMember;
import org.saiku.olap.query2.ThinDetails;
import org.saiku.olap.query2.ThinHierarchy;
import org.saiku.olap.query2.ThinLevel;
import org.saiku.olap.query2.ThinMeasure;
import org.saiku.olap.query2.ThinMember;
import org.saiku.olap.query2.ThinQuery;
import org.saiku.olap.query2.ThinQueryModel;
import org.saiku.olap.query2.ThinSelection;
import org.saiku.olap.query2.common.ThinQuerySet;
import org.saiku.olap.query2.common.ThinSortableQuerySet;
import org.saiku.olap.query2.filter.ThinFilter;
import org.saiku.query.IQuerySet;
import org.saiku.query.ISortableQuerySet;
import org.saiku.query.Query;
import org.saiku.query.QueryAxis;
import org.saiku.query.QueryDetails;
import org.saiku.query.QueryHierarchy;
import org.saiku.query.QueryLevel;
import org.saiku.query.mdx.GenericFilter;
import org.saiku.query.mdx.IFilterFunction;
import org.saiku.query.mdx.NFilter;
import org.saiku.query.mdx.NameFilter;
import org.saiku.query.mdx.NameLikeFilter;
import org.saiku.query.metadata.CalculatedMeasure;
import org.saiku.query.metadata.CalculatedMember;

public class Thin {
    public static ThinQuery convert(Query query, SaikuCube cube) throws Exception {
        ThinQuery tq = new ThinQuery(query.getName(), cube);
        ThinQueryModel tqm = Thin.convert(query, tq);
        tq.setQueryModel(tqm);
        if (query.getParameters() != null) {
            query.retrieveParameters();
            tq.setParameters(query.getParameters());
        }
        tq.setMdx(query.getMdx());
        return tq;
    }

    private static ThinQueryModel convert(Query query, ThinQuery tq) {
        ThinQueryModel tqm = new ThinQueryModel();
        tqm.setAxes(Thin.convertAxes(query.getAxes(), tq));
        ThinDetails td = Thin.convert(query.getDetails());
        tqm.setDetails(td);
        List<ThinCalculatedMeasure> cms = Thin.convert((List<CalculatedMeasure>)query.getCalculatedMeasures());
        List<ThinCalculatedMember> cmem = Thin.convertCM((List<CalculatedMember>)query.getCalculatedMembers());
        tqm.setCalculatedMeasures(cms);
        tqm.setCalculatedMembers(cmem);
        tqm.setVisualTotals(query.isVisualTotals());
        tqm.setVisualTotalsPattern(query.getVisualTotalsPattern());
        return tqm;
    }

    private static List<ThinCalculatedMeasure> convert(List<CalculatedMeasure> qcms) {
        ArrayList<ThinCalculatedMeasure> tcms = new ArrayList<ThinCalculatedMeasure>();
        if (qcms != null && qcms.size() > 0) {
            for (CalculatedMeasure qcm : qcms) {
                ThinCalculatedMeasure tcm = new ThinCalculatedMeasure(qcm.getHierarchy().getUniqueName(), qcm.getName(), qcm.getUniqueName(), qcm.getCaption(), qcm.getFormula(), qcm.getFormatProperties());
                tcms.add(tcm);
            }
        }
        return tcms;
    }

    private static List<ThinCalculatedMember> convertCM(List<CalculatedMember> qcms) {
        ArrayList<ThinCalculatedMember> tcms = new ArrayList<ThinCalculatedMember>();
        if (qcms != null && qcms.size() > 0) {
            for (CalculatedMember qcm : qcms) {
                String pplevel = null;
                if (qcm.getParentMember() != null && qcm.getParentMember().getParentMember() != null) {
                    pplevel = qcm.getParentMember().getParentMember().getLevel().getName();
                }
                String plevel = null;
                if (qcm.getParentMember() != null) {
                    plevel = qcm.getParentMember().getLevel().getName();
                }
                ThinCalculatedMember tcm = new ThinCalculatedMember(qcm.getHierarchy().getDimension().getName(), qcm.getHierarchy().getUniqueName(), qcm.getName(), qcm.getUniqueName(), qcm.getCaption(), qcm.getFormula(), qcm.getFormatProperties(), qcm.getParentMember() != null ? qcm.getParentMember().toString() : null, plevel, pplevel);
                tcms.add(tcm);
            }
        }
        return tcms;
    }

    private static ThinDetails convert(QueryDetails details) {
        ThinDetails.Location location = ThinDetails.Location.valueOf(details.getLocation().toString());
        ThinQueryModel.AxisLocation axis = ThinQueryModel.AxisLocation.valueOf(details.getAxis().toString());
        ArrayList<ThinMeasure> measures = new ArrayList<ThinMeasure>();
        if (details.getMeasures().size() > 0) {
            for (Measure m : details.getMeasures()) {
                ThinMeasure.Type type = ThinMeasure.Type.EXACT;
                if (m instanceof CalculatedMeasure) {
                    type = ThinMeasure.Type.CALCULATED;
                }
                ThinMeasure tm = new ThinMeasure(m.getName(), m.getUniqueName(), m.getCaption(), type);
                measures.add(tm);
            }
        }
        return new ThinDetails(axis, location, measures);
    }

    private static Map<ThinQueryModel.AxisLocation, ThinAxis> convertAxes(Map<Axis, QueryAxis> axes, ThinQuery tq) {
        TreeMap<ThinQueryModel.AxisLocation, ThinAxis> thinAxes = new TreeMap<ThinQueryModel.AxisLocation, ThinAxis>();
        if (axes != null) {
            for (Axis axis : Thin.sortAxes(axes.keySet())) {
                if (axis == null) continue;
                ThinAxis ta = Thin.convertAxis(axes.get(axis), tq);
                thinAxes.put(ta.getLocation(), ta);
            }
        }
        return thinAxes;
    }

    private static List<Axis> sortAxes(Set<Axis> axes) {
        ArrayList<Axis> ax = new ArrayList<Axis>();
        for (Axis.Standard a : Axis.Standard.values()) {
            if (!axes.contains(a)) continue;
            ax.add((Axis)a);
        }
        return ax;
    }

    private static ThinAxis convertAxis(QueryAxis queryAxis, ThinQuery tq) {
        ThinQueryModel.AxisLocation loc = Thin.getLocation(queryAxis);
        List aggs = queryAxis.getQuery().getAggregators(queryAxis.getLocation().toString());
        ThinAxis ta = new ThinAxis(loc, Thin.convertHierarchies(queryAxis.getQueryHierarchies(), tq), queryAxis.isNonEmpty(), aggs);
        Thin.extendSortableQuerySet(ta, (ISortableQuerySet)queryAxis);
        return ta;
    }

    private static NamedList<ThinHierarchy> convertHierarchies(List<QueryHierarchy> queryHierarchies, ThinQuery tq) {
        NamedListImpl hs = new NamedListImpl();
        if (queryHierarchies != null) {
            for (QueryHierarchy qh : queryHierarchies) {
                ThinHierarchy th = Thin.convertHierarchy(qh, tq);
                hs.add((Object)th);
            }
        }
        return hs;
    }

    private static ThinHierarchy convertHierarchy(QueryHierarchy qh, ThinQuery tq) {
        ArrayList<String> s = new ArrayList<String>();
        for (CalculatedMember cmember : qh.getCalculatedMembers()) {
            s.add(cmember.getUniqueName());
        }
        ThinHierarchy th = new ThinHierarchy(qh.getUniqueName(), qh.getCaption(), qh.getHierarchy().getDimension().getName(), Thin.convertLevels(qh.getActiveQueryLevels(), tq), s);
        Thin.extendSortableQuerySet(th, (ISortableQuerySet)qh);
        return th;
    }

    private static Map<String, ThinLevel> convertLevels(List<QueryLevel> levels, ThinQuery tq) {
        HashMap<String, ThinLevel> tl = new HashMap<String, ThinLevel>();
        if (levels != null) {
            for (QueryLevel ql : levels) {
                ThinLevel l = Thin.convertLevel(ql, tq);
                tl.put(ql.getName(), l);
            }
        }
        return tl;
    }

    private static ThinLevel convertLevel(QueryLevel ql, ThinQuery tq) {
        List<ThinMember> inclusions = Thin.convertMembers(ql.getInclusions(), tq);
        List<ThinMember> exclusions = Thin.convertMembers(ql.getExclusions(), tq);
        ThinMember rangeStart = Thin.convertMember(ql.getRangeStart(), tq);
        ThinMember rangeEnd = Thin.convertMember(ql.getRangeEnd(), tq);
        ThinSelection ts = new ThinSelection(ThinSelection.Type.INCLUSION, null);
        if (inclusions.size() > 0) {
            ts = new ThinSelection(ThinSelection.Type.INCLUSION, inclusions);
        } else if (exclusions.size() > 0) {
            ts = new ThinSelection(ThinSelection.Type.EXCLUSION, exclusions);
        } else if (rangeStart != null && rangeEnd != null) {
            ArrayList<ThinMember> range = new ArrayList<ThinMember>();
            range.add(rangeStart);
            range.add(rangeEnd);
            ts = new ThinSelection(ThinSelection.Type.RANGE, range);
        }
        if (ql.hasParameter()) {
            ts.setParameterName(ql.getParameterName());
            tq.addParameter(ql.getParameterName());
        }
        List aggs = ql.getQueryHierarchy().getQuery().getAggregators(ql.getUniqueName());
        ThinLevel l = new ThinLevel(ql.getName(), ql.getCaption(), ts, aggs);
        Thin.extendQuerySet(l, (IQuerySet)ql);
        return l;
    }

    private static List<ThinMember> convertMembers(List<Member> members, ThinQuery tq) {
        ArrayList<ThinMember> ms = new ArrayList<ThinMember>();
        if (members != null) {
            for (Member m : members) {
                ms.add(Thin.convertMember(m, tq));
            }
        }
        return ms;
    }

    private static ThinMember convertMember(Member m, ThinQuery tq) {
        if (m != null) {
            String type = null;
            if (m instanceof CalculatedMember) {
                type = "calculatedmember";
            }
            ThinMember tm = new ThinMember(m.getName(), m.getUniqueName(), m.getCaption());
            tm.setType(type);
            return tm;
        }
        return null;
    }

    private static ThinQueryModel.AxisLocation getLocation(QueryAxis axis) {
        Axis ax = axis.getLocation();
        if (Axis.ROWS.equals((Object)ax)) {
            return ThinQueryModel.AxisLocation.ROWS;
        }
        if (Axis.COLUMNS.equals((Object)ax)) {
            return ThinQueryModel.AxisLocation.COLUMNS;
        }
        if (Axis.FILTER.equals((Object)ax)) {
            return ThinQueryModel.AxisLocation.FILTER;
        }
        if (Axis.PAGES.equals((Object)ax)) {
            return ThinQueryModel.AxisLocation.PAGES;
        }
        return null;
    }

    private static void extendQuerySet(ThinQuerySet ts, IQuerySet qs) {
        if (StringUtils.isNotBlank((String)qs.getMdxSetExpression())) {
            ts.setMdx(qs.getMdxSetExpression());
        }
        if (qs.getFilters() != null && qs.getFilters().size() > 0) {
            List<ThinFilter> filters = Thin.convertFilters(qs.getFilters());
            ts.getFilters().addAll(filters);
        }
    }

    private static List<ThinFilter> convertFilters(List<IFilterFunction> filters) {
        ArrayList<ThinFilter> tfs = new ArrayList<ThinFilter>();
        for (IFilterFunction f : filters) {
            ThinFilter tf;
            Enum type;
            ArrayList<String> expressions;
            NameFilter nf;
            if (f instanceof NameFilter) {
                nf = (NameFilter)f;
                expressions = nf.getFilterExpression();
                expressions.add(0, nf.getHierarchy().getUniqueName());
                type = ThinFilter.FilterOperator.LIKE;
                if (nf.getOp() != null && nf.getOp().equals("NOTEQUAL")) {
                    type = ThinFilter.FilterOperator.NOTEQUAL;
                }
                tf = new ThinFilter(ThinFilter.FilterFlavour.Name, (ThinFilter.FilterOperator)type, ThinFilter.FilterFunction.Filter, expressions);
                tfs.add(tf);
            }
            if (f instanceof NameLikeFilter) {
                nf = (NameLikeFilter)f;
                expressions = nf.getFilterExpression();
                expressions.add(0, nf.getHierarchy().getUniqueName());
                type = ThinFilter.FilterOperator.LIKE;
                if (nf.getOp() != null && nf.getOp().equals("NOTEQUAL")) {
                    type = ThinFilter.FilterOperator.NOTEQUAL;
                }
                tf = new ThinFilter(ThinFilter.FilterFlavour.NameLike, (ThinFilter.FilterOperator)type, ThinFilter.FilterFunction.Filter, expressions);
                tfs.add(tf);
            }
            if (f instanceof GenericFilter) {
                nf = (GenericFilter)f;
                expressions = new ArrayList<String>();
                expressions.add(nf.getFilterExpression());
                ThinFilter tf2 = new ThinFilter(ThinFilter.FilterFlavour.Generic, null, ThinFilter.FilterFunction.Filter, expressions);
                tfs.add(tf2);
            }
            if (!(f instanceof NFilter)) continue;
            nf = (NFilter)f;
            expressions = new ArrayList();
            expressions.add(Integer.toString(nf.getN()));
            if (nf.getFilterExpression() != null) {
                expressions.add(nf.getFilterExpression());
            }
            type = ThinFilter.FilterFunction.valueOf(nf.getFunctionType().toString());
            tf = new ThinFilter(ThinFilter.FilterFlavour.N, null, (ThinFilter.FilterFunction)type, expressions);
            tfs.add(tf);
        }
        return tfs;
    }

    private static void extendSortableQuerySet(ThinSortableQuerySet ts, ISortableQuerySet qs) {
        Thin.extendQuerySet(ts, (IQuerySet)qs);
        if (qs.getHierarchizeMode() != null) {
            ts.setHierarchizeMode(ThinSortableQuerySet.HierarchizeMode.valueOf(qs.getHierarchizeMode().toString()));
        }
        if (qs.getSortOrder() != null) {
            ts.sort(ThinSortableQuerySet.SortOrder.valueOf(qs.getSortOrder().toString()), qs.getSortEvaluationLiteral());
        }
    }
}

