/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.olap4j.Axis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Database;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Schema;
import org.olap4j.query.LimitFunction;
import org.olap4j.query.Query;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.olap4j.query.SortOrder;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.query.IQuery;
import org.saiku.olap.query.MdxQuery;
import org.saiku.olap.query.OlapQuery;
import org.saiku.olap.util.exception.QueryParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class QueryDeserializer {
    private static final Logger log = LoggerFactory.getLogger(QueryDeserializer.class);
    private static final String QUERY = "Query";
    private static final String CUBE = "cube";
    private static final String CONNECTION = "connection";
    private static final String CATALOG = "catalog";
    private static final String SCHEMA = "schema";
    private static final String SELECTION = "Selection";
    private Document dom;
    private Query qm;
    private OlapConnection connection;
    private InputSource source;

    public IQuery unparse(String xml, OlapConnection connection) throws Exception {
        this.connection = connection;
        SAXBuilder parser = new SAXBuilder();
        this.source = new InputSource(new ByteArrayInputStream(xml.getBytes("UTF8")));
        this.dom = parser.build(this.source);
        Element child = this.dom.getRootElement();
        Element qmElement = child.getChild("QueryModel");
        Element mdxElement = child.getChild("MDX");
        if (qmElement != null) {
            IQuery returnQuery = this.createQmQuery();
            return returnQuery;
        }
        if (mdxElement != null) {
            IQuery returnQuery = this.createMdxQuery();
            return returnQuery;
        }
        throw new Exception("Cant find <QueryModel> nor <MDX> Query");
    }

    public SaikuCube getFakeCube(String xml) throws Exception {
        SAXBuilder parser = new SAXBuilder();
        InputSource source = new InputSource(new ByteArrayInputStream(xml.getBytes()));
        Document dom = parser.build(source);
        Element queryElement = dom.getRootElement();
        if (queryElement != null && queryElement.getName().equals(QUERY)) {
            String cubeName = queryElement.getAttributeValue(CUBE);
            String connectionName = queryElement.getAttributeValue(CONNECTION);
            String catalogName = queryElement.getAttributeValue(CATALOG);
            String schemaName = queryElement.getAttributeValue(SCHEMA);
            return new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
        }
        throw new Exception("Cant find <QueryModel> nor <MDX> Query");
    }

    public SaikuCube getCube(String xml, OlapConnection con) throws Exception {
        this.connection = con;
        SAXBuilder parser = new SAXBuilder();
        this.source = new InputSource(new ByteArrayInputStream(xml.getBytes()));
        this.dom = parser.build(this.source);
        Element queryElement = this.dom.getRootElement();
        if (queryElement != null && queryElement.getName().equals(QUERY)) {
            String cubeName = queryElement.getAttributeValue(CUBE);
            if (!StringUtils.isNotBlank((String)cubeName)) {
                throw new QueryParseException("Cube for query not defined");
            }
            String connectionName = queryElement.getAttributeValue(CONNECTION);
            String catalogName = queryElement.getAttributeValue(CATALOG);
            String schemaName = queryElement.getAttributeValue(SCHEMA);
            Query tmpQuery = this.createEmptyQuery("tmp-1234", catalogName, schemaName, cubeName);
            Cube cub = tmpQuery.getCube();
            return new SaikuCube(connectionName, cub.getUniqueName(), cub.getName(), cub.getCaption(), catalogName, schemaName);
        }
        throw new Exception("Cant find <QueryModel> nor <MDX> Query");
    }

    private IQuery createQmQuery() throws QueryParseException, SQLException {
        Element queryElement = this.dom.getRootElement();
        if (queryElement != null && queryElement.getName().equals(QUERY)) {
            String queryName = queryElement.getAttributeValue("name");
            String cubeName = queryElement.getAttributeValue(CUBE);
            if (!StringUtils.isNotBlank((String)cubeName)) {
                throw new QueryParseException("Cube for query not defined");
            }
            String connectionName = queryElement.getAttributeValue(CONNECTION);
            String catalogName = queryElement.getAttributeValue(CATALOG);
            String schemaName = queryElement.getAttributeValue(SCHEMA);
            try {
                Element qmElement = queryElement.getChild("QueryModel");
                if (qmElement != null) {
                    this.qm = this.createEmptyQuery(queryName, catalogName, schemaName, cubeName);
                    this.manipulateQuery(qmElement);
                    SaikuCube cube = new SaikuCube(connectionName, cubeName, this.qm.getCube().getName(), this.qm.getCube().getCaption(), catalogName, schemaName);
                    OlapQuery q = new OlapQuery(this.qm, this.connection, cube, false);
                    this.setTotals(q, queryElement);
                    Properties p = this.getProperties(queryElement);
                    q.setProperties(p);
                    return q;
                }
                throw new OlapException("Can't find child <QueryModel>");
            }
            catch (OlapException e) {
                throw new QueryParseException(e.getMessage(), e);
            }
        }
        throw new QueryParseException("Cannot parse Query Model: Query node not found and/or more than 1 Query node found");
    }

    private IQuery createMdxQuery() throws QueryParseException {
        Element queryElement = this.dom.getRootElement();
        if (queryElement != null && queryElement.getName().equals(QUERY)) {
            String queryName = queryElement.getAttributeValue("name");
            String cubeName = queryElement.getAttributeValue(CUBE);
            String connectionName = queryElement.getAttributeValue(CONNECTION);
            String catalogName = queryElement.getAttributeValue(CATALOG);
            String schemaName = queryElement.getAttributeValue(SCHEMA);
            Properties props = this.getProperties(queryElement);
            try {
                Element mdxElement = queryElement.getChild("MDX");
                if (mdxElement != null) {
                    SaikuCube cube = new SaikuCube(connectionName, cubeName, cubeName, cubeName, catalogName, schemaName);
                    MdxQuery q = new MdxQuery(this.connection, cube, queryName, mdxElement.getText());
                    q.setProperties(props);
                    return q;
                }
                throw new OlapException("Can't find child <MDX>");
            }
            catch (OlapException e) {
                throw new QueryParseException(e.getMessage(), e);
            }
        }
        throw new QueryParseException("Cannot parse Query Model: Query node not found and/or more than 1 Query node found");
    }

    private void setTotals(IQuery q, Element queryElement) {
        Element totals = queryElement.getChild("Totals");
        if (null != totals) {
            List totalList = totals.getChildren("Total");
            for (Element function : totalList) {
                String uniqueLevelName = function.getAttributeValue("uniqueLevelName");
                String functionName = function.getAttributeValue("functionName");
                q.setTotalFunction(uniqueLevelName, functionName);
            }
        }
    }

    private Properties getProperties(Element queryElement) {
        Properties props = new Properties();
        try {
            Element propertiesElement = queryElement.getChild("Properties");
            if (propertiesElement != null) {
                for (int i = 0; i < propertiesElement.getChildren("Property").size(); ++i) {
                    Element p = (Element)propertiesElement.getChildren("Property").get(i);
                    String k = p.getAttributeValue("name");
                    String v = p.getAttributeValue("value");
                    props.put(k, v);
                }
            }
        }
        catch (Exception e) {
            log.error("Exception", e.getCause());
        }
        return props;
    }

    private void manipulateQuery(Element qmElement) throws OlapException {
        this.moveDims2Axis(qmElement);
    }

    private void moveDims2Axis(Element qmElement) throws OlapException {
        Element axesElement = qmElement.getChild("Axes");
        if (axesElement != null) {
            for (int i = 0; i < axesElement.getChildren("Axis").size(); ++i) {
                Element axisElement = (Element)axesElement.getChildren("Axis").get(i);
                String location = axisElement.getAttributeValue("location");
                if (!StringUtils.isNotBlank((String)location)) {
                    throw new OlapException("Location for Axis Element can't be null");
                }
                QueryAxis qAxis = (QueryAxis)this.qm.getAxes().get(this.getAxisName(location));
                String nonEmpty = axisElement.getAttributeValue("nonEmpty");
                if (StringUtils.isNotBlank((String)nonEmpty)) {
                    qAxis.setNonEmpty(Boolean.parseBoolean(nonEmpty));
                }
                String sortOrder = axisElement.getAttributeValue("sortOrder");
                String sortEvaluationLiteral = axisElement.getAttributeValue("sortEvaluationLiteral");
                if (StringUtils.isNotBlank((String)sortOrder)) {
                    if (StringUtils.isNotBlank((String)sortEvaluationLiteral)) {
                        qAxis.sort(SortOrder.valueOf((String)sortOrder), sortEvaluationLiteral);
                    } else {
                        qAxis.sort(SortOrder.valueOf((String)sortOrder));
                    }
                }
                String limitFunction = axisElement.getAttributeValue("limitFunction");
                String limitFunctionN = axisElement.getAttributeValue("limitFunctionN");
                String limitFunctionSortLiteral = axisElement.getAttributeValue("limitFunctionSortLiteral");
                String filterCondition = axisElement.getAttributeValue("filterCondition");
                try {
                    if (StringUtils.isNotBlank((String)limitFunction)) {
                        LimitFunction func = LimitFunction.valueOf((String)limitFunction);
                        BigDecimal n = new BigDecimal(limitFunctionN);
                        qAxis.limit(func, n, limitFunctionSortLiteral);
                    }
                    if (StringUtils.isNotBlank((String)filterCondition)) {
                        qAxis.filter(filterCondition);
                    }
                }
                catch (Error e) {
                    log.error("ERROR", (Throwable)e);
                }
                Element dimensions = axisElement.getChild("Dimensions");
                if (dimensions == null) continue;
                for (int z = 0; z < dimensions.getChildren("Dimension").size(); ++z) {
                    Element dimensionElement = (Element)dimensions.getChildren("Dimension").get(z);
                    this.processDimension(dimensionElement, location);
                }
            }
        }
    }

    private void processDimension(Element dimension, String location) throws OlapException {
        String dimName = dimension.getAttributeValue("name");
        if (StringUtils.isNotBlank((String)dimName)) {
            String hierarchyConsistent;
            String hierarchizeMode;
            QueryDimension dim = this.qm.getDimension(dimName);
            if (dim == null) {
                throw new OlapException("Dimension not found:" + dimName);
            }
            String sortOrder = dimension.getAttributeValue("sortOrder");
            if (StringUtils.isNotBlank((String)sortOrder)) {
                dim.sort(SortOrder.valueOf((String)sortOrder));
            }
            if (StringUtils.isNotBlank((String)(hierarchizeMode = dimension.getAttributeValue("hierarchizeMode")))) {
                dim.setHierarchizeMode(QueryDimension.HierarchizeMode.valueOf((String)hierarchizeMode));
            }
            if (StringUtils.isNotBlank((String)(hierarchyConsistent = dimension.getAttributeValue("hierarchyConsistent")))) {
                dim.setHierarchyConsistent(Boolean.parseBoolean(hierarchyConsistent));
            }
            ((QueryAxis)this.qm.getAxes().get(Axis.Standard.valueOf((String)location))).getDimensions().add(dim);
            Element inclusions = dimension.getChild("Inclusions");
            if (inclusions != null) {
                for (int z = 0; z < inclusions.getChildren(SELECTION).size(); ++z) {
                    Element selectionElement = (Element)inclusions.getChildren(SELECTION).get(z);
                    String name = selectionElement.getAttributeValue("node");
                    String operator = selectionElement.getAttributeValue("operator");
                    String type = selectionElement.getAttributeValue("type");
                    Selection sel = null;
                    if ("level".equals(type)) {
                        for (Hierarchy hierarchy : dim.getDimension().getHierarchies()) {
                            for (Level level : hierarchy.getLevels()) {
                                if (!level.getUniqueName().equals(name)) continue;
                                sel = dim.include(level);
                            }
                        }
                    } else if ("member".equals(type)) {
                        sel = dim.include(Selection.Operator.valueOf((String)operator), IdentifierNode.parseIdentifier((String)name).getSegmentList());
                    }
                    Element contextElement = selectionElement.getChild("Context");
                    if (sel == null || contextElement == null) continue;
                    for (int h = 0; h < contextElement.getChildren(SELECTION).size(); ++h) {
                        Selection contextSelection;
                        Element context = (Element)contextElement.getChildren(SELECTION).get(h);
                        String contextname = context.getAttributeValue("node");
                        String contextoperator = context.getAttributeValue("operator");
                        String contextDimension = context.getAttributeValue("dimension");
                        QueryDimension contextDim = this.qm.getDimension(contextDimension);
                        if (contextDim != null) {
                            contextSelection = contextDim.createSelection(Selection.Operator.valueOf((String)contextoperator), IdentifierNode.parseIdentifier((String)contextname).getSegmentList());
                            if (contextSelection == null) {
                                throw new OlapException("Cannot create selection for node: " + contextname + " operator:" + contextoperator + " on dimension: " + dim.getName());
                            }
                        } else {
                            throw new OlapException("Context dimension is null");
                        }
                        sel.addContext(contextSelection);
                    }
                }
            }
            Element exclusions = dimension.getChild("Exclusions");
            if (inclusions != null) {
                for (int z = 0; z < exclusions.getChildren(SELECTION).size(); ++z) {
                    Element selectionElement = (Element)exclusions.getChildren(SELECTION).get(z);
                    String name = selectionElement.getAttributeValue("node");
                    String operator = selectionElement.getAttributeValue("operator");
                    dim.exclude(Selection.Operator.valueOf((String)operator), IdentifierNode.parseIdentifier((String)name).getSegmentList());
                }
            }
        } else {
            throw new OlapException("No Dimension name defined");
        }
    }

    private Query createEmptyQuery(String queryName, String catalogName, String schemaName, String cubeName) throws SQLException {
        if (!StringUtils.isNotBlank((String)catalogName)) {
            try {
                this.connection.setCatalog(catalogName);
            }
            catch (SQLException e) {
                throw new OlapException(e.getMessage(), (Throwable)e);
            }
        }
        Cube cube = null;
        if (this.connection != null) {
            for (Database db : this.connection.getOlapDatabases()) {
                Catalog cat = (Catalog)db.getCatalogs().get(catalogName);
                if (cat == null) continue;
                for (Schema schema : cat.getSchemas()) {
                    if (!schema.getName().equals(schemaName) && (!schema.getName().equals("") || schemaName != null)) continue;
                    for (Cube cub : schema.getCubes()) {
                        if (!cub.getName().equals(cubeName) && !cub.getUniqueName().equals(cubeName)) continue;
                        cube = cub;
                    }
                }
            }
        }
        if (cube != null) {
            try {
                return new Query(queryName, cube);
            }
            catch (SQLException e) {
                throw new OlapException("Error creating query :" + queryName, (Throwable)e);
            }
        }
        throw new OlapException("No Cube with name: " + cubeName + " found");
    }

    private Axis.Standard getAxisName(String location) {
        if (location != null) {
            return Axis.Standard.valueOf((String)location);
        }
        return null;
    }
}

