/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.datasources.connection.encrypt;

public final class Des {
    private static final int DES_BITS_IN_KEY = 56;
    private static final int DES_ROUNDS = 16;
    public static final int DES_BLOCK_BYTES = 8;
    private static final int DF_KEYSET = 1;
    private static final int DF_3DES = 2;
    private static final int[] s_IP = new int[]{0, 1, 0, 1, 256, 257, 256, 257, 0, 1, 0, 1, 256, 257, 256, 257, 65536, 65537, 65536, 65537, 65792, 65793, 65792, 65793, 65536, 65537, 65536, 65537, 65792, 65793, 65792, 65793, 0, 1, 0, 1, 256, 257, 256, 257, 0, 1, 0, 1, 256, 257, 256, 257, 65536, 65537, 65536, 65537, 65792, 65793, 65792, 65793, 65536, 65537, 65536, 65537, 65792, 65793, 65792, 65793, 0x1000000, 0x1000001, 0x1000000, 0x1000001, 0x1000100, 0x1000101, 0x1000100, 0x1000101, 0x1000000, 0x1000001, 0x1000000, 0x1000001, 0x1000100, 0x1000101, 0x1000100, 0x1000101, 0x1010000, 0x1010001, 0x1010000, 0x1010001, 0x1010100, 0x1010101, 0x1010100, 0x1010101, 0x1010000, 0x1010001, 0x1010000, 0x1010001, 0x1010100, 0x1010101, 0x1010100, 0x1010101, 0x1000000, 0x1000001, 0x1000000, 0x1000001, 0x1000100, 0x1000101, 0x1000100, 0x1000101, 0x1000000, 0x1000001, 0x1000000, 0x1000001, 0x1000100, 0x1000101, 0x1000100, 0x1000101, 0x1010000, 0x1010001, 0x1010000, 0x1010001, 0x1010100, 0x1010101, 0x1010100, 0x1010101, 0x1010000, 0x1010001, 0x1010000, 0x1010001, 0x1010100, 0x1010101, 0x1010100, 0x1010101};
    private static final byte[] s_KP = new byte[]{4, 12, 20, 28, 3, 11, 19, 27, 35, 43, 51, 59, 2, 10, 18, 26, 34, 42, 50, 58, 1, 9, 17, 25, 33, 41, 49, 57, 36, 44, 52, 60, 5, 13, 21, 29, 37, 45, 53, 61, 6, 14, 22, 30, 38, 46, 54, 62, 7, 15, 23, 31, 39, 47, 55, 63};
    private static final int DES_NUM_WEAK_KEYS = 64;
    private static final int[][] s_KeyWeak = new int[][]{{0, 0}, {0xFFFFFFF, 0}, {0, 0xFFFFFFF}, {0xFFFFFFF, 0xFFFFFFF}, {0xAAAAAAA, 0xAAAAAAA}, {0x5555555, 0x5555555}, {0x5555555, 0xAAAAAAA}, {0xAAAAAAA, 0x5555555}, {0, 0xAAAAAAA}, {0, 0x5555555}, {0xFFFFFFF, 0xAAAAAAA}, {0xFFFFFFF, 0x5555555}, {0xAAAAAAA, 0}, {0x5555555, 0}, {0xAAAAAAA, 0xFFFFFFF}, {0x5555555, 0xFFFFFFF}, {0x3333333, 0}, {0x6666666, 0}, {0x9999999, 0}, {0xCCCCCCC, 0}, {0, 0x3333333}, {0x3333333, 0x3333333}, {0x5555555, 0x3333333}, {0x6666666, 0x3333333}, {0x9999999, 0x3333333}, {0xAAAAAAA, 0x3333333}, {0xCCCCCCC, 0x3333333}, {0xFFFFFFF, 0x3333333}, {0x3333333, 0x5555555}, {0x6666666, 0x5555555}, {0x9999999, 0x5555555}, {0xCCCCCCC, 0x5555555}, {0, 0x6666666}, {0x3333333, 0x6666666}, {0x5555555, 0x6666666}, {0x6666666, 0x6666666}, {0x9999999, 0x6666666}, {0xAAAAAAA, 0x6666666}, {0xCCCCCCC, 0x6666666}, {0xFFFFFFF, 0x6666666}, {0, 0x9999999}, {0x3333333, 0x9999999}, {0x5555555, 0x9999999}, {0x6666666, 0x9999999}, {0x9999999, 0x9999999}, {0xAAAAAAA, 0x9999999}, {0xCCCCCCC, 0x9999999}, {0xFFFFFFF, 0x9999999}, {0x3333333, 0xAAAAAAA}, {0x6666666, 0xAAAAAAA}, {0x9999999, 0xAAAAAAA}, {0xCCCCCCC, 0xAAAAAAA}, {0, 0xCCCCCCC}, {0x3333333, 0xCCCCCCC}, {0x5555555, 0xCCCCCCC}, {0x6666666, 0xCCCCCCC}, {0x9999999, 0xCCCCCCC}, {0xAAAAAAA, 0xCCCCCCC}, {0xCCCCCCC, 0xCCCCCCC}, {0xFFFFFFF, 0xCCCCCCC}, {0x3333333, 0xFFFFFFF}, {0x6666666, 0xFFFFFFF}, {0x9999999, 0xFFFFFFF}, {0xCCCCCCC, 0xFFFFFFF}};
    private static final short s_KRot = 32508;
    private static final byte[] s_KPerm = new byte[]{28, 19, 49, 6, 58, 53, 6, 25, 18, 52, 6, 60, 21, 27, 61, 17, 51, 59, 24, 6, 48, 20, 26, 56, 50, 29, 16, 57, 34, 40, 6, 32, 44, 11, 3, 36, 8, 41, 5, 10, 37, 6, 4, 45, 12, 35, 6, 42, 2, 6, 33, 9, 0, 43, 13, 1};
    private static final int[][] s_SB = new int[][]{{0x1010400, 0, 65536, 0x1010404, 0x1010004, 66564, 4, 65536, 1024, 0x1010400, 0x1010404, 1024, 0x1000404, 0x1010004, 0x1000000, 4, 1028, 0x1000400, 0x1000400, 66560, 66560, 0x1010000, 0x1010000, 0x1000404, 65540, 0x1000004, 0x1000004, 65540, 0, 1028, 66564, 0x1000000, 65536, 0x1010404, 4, 0x1010000, 0x1010400, 0x1000000, 0x1000000, 1024, 0x1010004, 65536, 66560, 0x1000004, 1024, 4, 0x1000404, 66564, 0x1010404, 65540, 0x1010000, 0x1000404, 0x1000004, 1028, 66564, 0x1010400, 1028, 0x1000400, 0x1000400, 0, 65540, 66560, 0, 0x1010004}, {-2146402272, -2147450880, 32768, 1081376, 0x100000, 32, -2146435040, -2147450848, -2147483616, -2146402272, -2146402304, Integer.MIN_VALUE, -2147450880, 0x100000, 32, -2146435040, 0x108000, 0x100020, -2147450848, 0, Integer.MIN_VALUE, 32768, 1081376, -2146435072, 0x100020, -2147483616, 0, 0x108000, 32800, -2146402304, -2146435072, 32800, 0, 1081376, -2146435040, 0x100000, -2147450848, -2146435072, -2146402304, 32768, -2146435072, -2147450880, 32, -2146402272, 1081376, 32, 32768, Integer.MIN_VALUE, 32800, -2146402304, 0x100000, -2147483616, 0x100020, -2147450848, -2147483616, 0x100020, 0x108000, 0, -2147450880, 32800, Integer.MIN_VALUE, -2146435040, -2146402272, 0x108000}, {520, 0x8020200, 0, 0x8020008, 0x8000200, 0, 131592, 0x8000200, 131080, 0x8000008, 0x8000008, 131072, 0x8020208, 131080, 0x8020000, 520, 0x8000000, 8, 0x8020200, 512, 131584, 0x8020000, 0x8020008, 131592, 0x8000208, 131584, 131072, 0x8000208, 8, 0x8020208, 512, 0x8000000, 0x8020200, 0x8000000, 131080, 520, 131072, 0x8020200, 0x8000200, 0, 512, 131080, 0x8020208, 0x8000200, 0x8000008, 512, 0, 0x8020008, 0x8000208, 131072, 0x8000000, 0x8020208, 8, 131592, 131584, 0x8000008, 0x8020000, 0x8000208, 520, 0x8020000, 131592, 8, 0x8020008, 131584}, {8396801, 8321, 8321, 128, 0x802080, 0x800081, 0x800001, 8193, 0, 0x802000, 0x802000, 8396929, 129, 0, 0x800080, 0x800001, 1, 8192, 0x800000, 8396801, 128, 0x800000, 8193, 8320, 0x800081, 1, 8320, 0x800080, 8192, 0x802080, 8396929, 129, 0x800080, 0x800001, 0x802000, 8396929, 129, 0, 0, 0x802000, 8320, 0x800080, 0x800081, 1, 8396801, 8321, 8321, 128, 8396929, 129, 1, 8192, 0x800001, 8193, 0x802080, 0x800081, 8193, 8320, 0x800000, 8396801, 128, 0x800000, 8192, 0x802080}, {256, 34078976, 0x2080000, 1107296512, 524288, 256, 0x40000000, 0x2080000, 1074266368, 524288, 0x2000100, 1074266368, 1107296512, 1107820544, 524544, 0x40000000, 0x2000000, 0x40080000, 0x40080000, 0, 0x40000100, 1107820800, 1107820800, 0x2000100, 1107820544, 0x40000100, 0, 0x42000000, 34078976, 0x2000000, 0x42000000, 524544, 524288, 1107296512, 256, 0x2000000, 0x40000000, 0x2080000, 1107296512, 1074266368, 0x2000100, 0x40000000, 1107820544, 34078976, 1074266368, 256, 0x2000000, 1107820544, 1107820800, 524544, 0x42000000, 1107820800, 0x2080000, 0, 0x40080000, 0x42000000, 524544, 0x2000100, 0x40000100, 524288, 0, 0x40080000, 34078976, 0x40000100}, {0x20000010, 0x20400000, 16384, 541081616, 0x20400000, 16, 541081616, 0x400000, 0x20004000, 0x404010, 0x400000, 0x20000010, 0x400010, 0x20004000, 0x20000000, 16400, 0, 0x400010, 536887312, 16384, 0x404000, 536887312, 16, 541065232, 541065232, 0, 0x404010, 0x20404000, 16400, 0x404000, 0x20404000, 0x20000000, 0x20004000, 16, 541065232, 0x404000, 541081616, 0x400000, 16400, 0x20000010, 0x400000, 0x20004000, 0x20000000, 16400, 0x20000010, 541081616, 0x404000, 0x20400000, 0x404010, 0x20404000, 0, 541065232, 16, 16384, 0x20400000, 0x404010, 16384, 0x400010, 536887312, 0, 0x20404000, 0x20000000, 0x400010, 536887312}, {0x200000, 0x4200002, 67110914, 0, 2048, 67110914, 0x200802, 69208064, 69208066, 0x200000, 0, 0x4000002, 2, 0x4000000, 0x4200002, 2050, 0x4000800, 0x200802, 0x200002, 0x4000800, 0x4000002, 0x4200000, 69208064, 0x200002, 0x4200000, 2048, 2050, 69208066, 0x200800, 2, 0x4000000, 0x200800, 0x4000000, 0x200800, 0x200000, 67110914, 67110914, 0x4200002, 0x4200002, 2, 0x200002, 0x4000000, 0x4000800, 0x200000, 69208064, 2050, 0x200802, 69208064, 2050, 0x4000002, 69208066, 0x4200000, 0x200800, 0, 2, 69208066, 0, 0x200802, 0x4200000, 2048, 0x4000002, 0x4000800, 2048, 0x200002}, {0x10001040, 4096, 262144, 0x10041040, 0x10000000, 0x10001040, 64, 0x10000000, 262208, 0x10040000, 0x10041040, 266240, 0x10041000, 266304, 4096, 64, 0x10040000, 0x10000040, 0x10001000, 4160, 266240, 262208, 0x10040040, 0x10041000, 4160, 0, 0, 0x10040040, 0x10000040, 0x10001000, 266304, 262144, 266304, 262144, 0x10041000, 4096, 64, 0x10040040, 4096, 266304, 0x10001000, 64, 0x10000040, 0x10040000, 0x10040040, 0x10000000, 262144, 0x10001040, 0, 0x10041040, 262208, 0x10000040, 0x10040000, 0x10001000, 0x10001040, 0, 0x10041040, 266240, 266240, 4160, 4160, 262208, 0x10000000, 0x10041000}};
    private static final int[] s_OP = new int[]{0, 0x1000000, 65536, 0x1010000, 256, 0x1000100, 65792, 0x1010100, 1, 0x1000001, 65537, 0x1010001, 257, 0x1000101, 65793, 0x1010101};
    private final int[][] m_keyRoundCrypt0 = new int[16][2];
    private final int[][] m_keyRoundCrypt1 = new int[16][2];
    private int m_Flags = 0;

    public int SetKey(boolean encrypt, byte[] key) {
        this.m_Flags &= 0xFFFFFFFC;
        int[] keyPermuted = new int[2];
        if (!this.KeyPermute(keyPermuted, key)) {
            return 0;
        }
        this.RoundGen(this.m_keyRoundCrypt0, keyPermuted, encrypt);
        this.m_Flags |= 1;
        return 1;
    }

    public int SetKey(boolean encrypt, byte[] key1, byte[] key2) {
        this.m_Flags ^= 0xFFFFFFFC;
        int[] keyPermuted = new int[2];
        if (!this.KeyPermute(keyPermuted, key1)) {
            return 0;
        }
        this.RoundGen(this.m_keyRoundCrypt0, keyPermuted, encrypt);
        if (!this.KeyPermute(keyPermuted, key2)) {
            return 0;
        }
        this.RoundGen(this.m_keyRoundCrypt1, keyPermuted, !encrypt);
        this.m_Flags |= 3;
        return 1;
    }

    void EraseKey() {
        for (int i = 0; i < 16; ++i) {
            this.m_keyRoundCrypt0[i][1] = 0;
            this.m_keyRoundCrypt0[i][0] = 0;
            this.m_keyRoundCrypt1[i][1] = 0;
            this.m_keyRoundCrypt1[i][0] = 0;
        }
        this.m_Flags &= 0xFFFFFFFE;
    }

    private int Crypt(byte[] pvTo, byte[] pvFrom) {
        if (pvFrom.length % 8 != 0) {
            return 0;
        }
        if ((this.m_Flags & 1) == 0) {
            return 0;
        }
        byte[] To = new byte[8];
        byte[] From = new byte[8];
        for (int index = 0; index < pvFrom.length; index += 8) {
            System.arraycopy(pvFrom, 0 + index, From, 0, 8);
            this.Munge64(To, From);
            System.arraycopy(To, 0, pvTo, 0 + index, 8);
        }
        return 1;
    }

    public int Crypt(byte[] pv) {
        return this.Crypt(pv, pv);
    }

    private void Munge64(byte[] pOut, byte[] pIn) {
        int[] Halves = new int[2];
        int i = 0;
        Halves[1] = s_IP[pIn[i] & 0x7F];
        Halves[0] = s_IP[pIn[i++] >> 1 & 0x7F];
        Halves[1] = Halves[1] | s_IP[pIn[i] & 0x7F] << 1;
        Halves[0] = Halves[0] | s_IP[pIn[i++] >> 1 & 0x7F] << 1;
        Halves[1] = Halves[1] | s_IP[pIn[i] & 0x7F] << 2;
        Halves[0] = Halves[0] | s_IP[pIn[i++] >> 1 & 0x7F] << 2;
        Halves[1] = Halves[1] | s_IP[pIn[i] & 0x7F] << 3;
        Halves[0] = Halves[0] | s_IP[pIn[i++] >> 1 & 0x7F] << 3;
        Halves[1] = Halves[1] | s_IP[pIn[i] & 0x7F] << 4;
        Halves[0] = Halves[0] | s_IP[pIn[i++] >> 1 & 0x7F] << 4;
        Halves[1] = Halves[1] | s_IP[pIn[i] & 0x7F] << 5;
        Halves[0] = Halves[0] | s_IP[pIn[i++] >> 1 & 0x7F] << 5;
        Halves[1] = Halves[1] | s_IP[pIn[i] & 0x7F] << 6;
        Halves[0] = Halves[0] | s_IP[pIn[i++] >> 1 & 0x7F] << 6;
        Halves[1] = Halves[1] | s_IP[pIn[i] & 0x7F] << 7;
        Halves[0] = Halves[0] | s_IP[pIn[i] >> 1 & 0x7F] << 7;
        Halves[1] = Halves[1] << 1 & 0xFFFFFFFE | Halves[1] >> 31 & 1;
        Halves[0] = Halves[0] << 1 & 0xFFFFFFFE | Halves[0] >> 31 & 1;
        this.DoDes(Halves, this.m_keyRoundCrypt0);
        if ((this.m_Flags & 2) != 0) {
            this.DoDes(Halves, this.m_keyRoundCrypt1);
            this.DoDes(Halves, this.m_keyRoundCrypt0);
        }
        Halves[1] = Halves[1] >> 1 & Integer.MAX_VALUE | Halves[1] << 31 & Integer.MIN_VALUE;
        Halves[0] = Halves[0] >> 1 & Integer.MAX_VALUE | Halves[0] << 31 & Integer.MIN_VALUE;
        int ulL = s_OP[Halves[1] & 0xF];
        int ulR = s_OP[Halves[1] >> 4 & 0xF];
        ulL |= s_OP[Halves[1] >> 8 & 0xF] << 2;
        ulR |= s_OP[Halves[1] >> 12 & 0xF] << 2;
        ulL |= s_OP[Halves[1] >> 16 & 0xF] << 4;
        ulR |= s_OP[Halves[1] >> 20 & 0xF] << 4;
        ulL |= s_OP[Halves[1] >> 24 & 0xF] << 6;
        ulR |= s_OP[Halves[1] >> 28 & 0xF] << 6;
        ulL |= s_OP[Halves[0] & 0xF] << 1;
        ulR |= s_OP[Halves[0] >> 4 & 0xF] << 1;
        ulL |= s_OP[Halves[0] >> 8 & 0xF] << 3;
        ulR |= s_OP[Halves[0] >> 12 & 0xF] << 3;
        ulL |= s_OP[Halves[0] >> 16 & 0xF] << 5;
        ulR |= s_OP[Halves[0] >> 20 & 0xF] << 5;
        ulR |= s_OP[Halves[0] >> 28 & 0xF] << 7;
        i = 0;
        pOut[i++] = (byte)((ulL |= s_OP[Halves[0] >> 24 & 0xF] << 7) >> 24);
        pOut[i++] = (byte)(ulL >> 16);
        pOut[i++] = (byte)(ulL >> 8);
        pOut[i++] = (byte)ulL;
        pOut[i++] = (byte)(ulR >> 24);
        pOut[i++] = (byte)(ulR >> 16);
        pOut[i++] = (byte)(ulR >> 8);
        pOut[i] = (byte)ulR;
    }

    protected int IsKeySet() {
        return this.m_Flags & 1;
    }

    private void DoDes(int[] Halves, int[][] pKey) {
        int Left = Halves[1];
        int Right = Halves[0];
        int index = 0;
        for (int ii = 0; ii < 8; ++ii) {
            int temp = Right ^ pKey[index][0];
            int NewVal = s_SB[7][temp & 0x3F];
            NewVal |= s_SB[5][temp >> 8 & 0x3F];
            NewVal |= s_SB[3][temp >> 16 & 0x3F];
            NewVal |= s_SB[1][temp >> 24 & 0x3F];
            temp = (Right << 28 | Right >> 4 & 0xFFFFFFF) ^ pKey[index][1];
            NewVal |= s_SB[6][temp & 0x3F];
            NewVal |= s_SB[4][temp >> 8 & 0x3F];
            NewVal |= s_SB[2][temp >> 16 & 0x3F];
            Left ^= (NewVal |= s_SB[0][temp >> 24 & 0x3F]);
            temp = Left ^ pKey[++index][0];
            NewVal = s_SB[7][temp & 0x3F];
            NewVal |= s_SB[5][temp >> 8 & 0x3F];
            NewVal |= s_SB[3][temp >> 16 & 0x3F];
            NewVal |= s_SB[1][temp >> 24 & 0x3F];
            temp = (Left << 28 | Left >> 4 & 0xFFFFFFF) ^ pKey[index][1];
            NewVal |= s_SB[6][temp & 0x3F];
            NewVal |= s_SB[4][temp >> 8 & 0x3F];
            NewVal |= s_SB[2][temp >> 16 & 0x3F];
            Right ^= (NewVal |= s_SB[0][temp >> 24 & 0x3F]);
            ++index;
        }
        Halves[1] = Right;
        Halves[0] = Left;
    }

    private boolean KeyPermute(int[] pKey, byte[] achKeyIn) {
        int ii;
        pKey[1] = 0;
        pKey[0] = 0;
        for (ii = 0; ii < 56; ++ii) {
            if ((achKeyIn[s_KP[ii] / 8] & 1 << (s_KP[ii] & 7)) == 0) continue;
            int iIndex = ii >= 28 ? ii + 4 : ii;
            int n = iIndex / 32;
            pKey[n] = pKey[n] | 1 << iIndex % 32;
        }
        for (ii = 0; ii < 64; ++ii) {
            if (s_KeyWeak[ii][0] != pKey[0] || s_KeyWeak[ii][1] != pKey[1]) continue;
            return false;
        }
        return true;
    }

    private void RoundGen(int[][] pRound, int[] pKey, boolean encrypt) {
        for (int ii = 0; ii < 16; ++ii) {
            int jj;
            int iRound;
            int n = iRound = encrypt ? ii : 15 - ii;
            if ((0x7EFC & 1 << ii) != 0) {
                pKey[1] = pKey[1] << 2 | pKey[1] >> 26 & 3;
                pKey[0] = pKey[0] << 2 | pKey[0] >> 26 & 3;
            } else {
                pKey[1] = pKey[1] << 1 | pKey[1] >> 27 & 1;
                pKey[0] = pKey[0] << 1 | pKey[0] >> 27 & 1;
            }
            pRound[iRound][0] = 0;
            pRound[iRound][1] = 0;
            for (jj = 0; jj < 28; ++jj) {
                if ((pKey[1] & 1 << jj) == 0) continue;
                int[] nArray = pRound[iRound];
                int n2 = s_KPerm[jj] / 32;
                nArray[n2] = nArray[n2] | 1 << s_KPerm[jj] % 32;
            }
            while (jj < 56) {
                if ((pKey[0] & 1 << jj - 28) != 0) {
                    int[] nArray = pRound[iRound];
                    int n3 = s_KPerm[jj] / 32;
                    nArray[n3] = nArray[n3] | 1 << s_KPerm[jj] % 32;
                }
                ++jj;
            }
        }
    }
}

