/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.interpreter.FieldDescriptorFactory;
import de.statspez.pleditor.generator.interpreter.GenericFieldDescriptor;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptor;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.regex.Pattern;

public class TBFieldDescriptorFactory
extends AbstractElementVisitor
implements FieldDescriptorFactory {
    private static final Hashtable MAPPINGS = new Hashtable();
    private HashMap typeDescriptors;
    private Stack hierarchy = new Stack();
    private MetaTBFeld currentTBFeld;
    private String indexPrefix = "#";
    private String indexSuffix = "";
    private int indexBase = 0;

    public TBFieldDescriptorFactory(MetaPlausibilisierung plausi) {
        this(((MetaCustomPlausibilisierung)plausi).rootThemenbereich());
    }

    public TBFieldDescriptorFactory(MetaThemenbereich tb) {
        this.typeDescriptors = new HashMap();
        this.hierarchy = new Stack();
        if (tb != null) {
            tb.accept(this);
        }
    }

    public void setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public void setIndexSuffix(String indexSuffix) {
        this.indexSuffix = indexSuffix;
    }

    public String getIndexSuffix() {
        return this.indexSuffix;
    }

    public void setIndexBase(int indexBase) {
        this.indexBase = indexBase;
    }

    public int getIndexBase() {
        return this.indexBase;
    }

    public FeldDeskriptorImpl getFieldDescriptor(String fieldName) throws NoSuchFieldException {
        FeldDeskriptorImpl fieldDescriptor = null;
        if (fieldName != null && fieldName.length() > 0) {
            String[] paths = fieldName.split("\\.");
            for (int i = 0; i < paths.length; ++i) {
                int[] indices;
                String name;
                int indexOf = paths[i].indexOf(this.indexPrefix);
                if (indexOf > 0) {
                    name = paths[i].substring(0, indexOf);
                    indices = this.parseIndices(paths[i].substring(indexOf + this.indexPrefix.length(), paths[i].length() - this.indexSuffix.length()));
                } else {
                    name = paths[i];
                    indices = null;
                }
                fieldDescriptor = this.getFieldDecriptor(name, indices, fieldDescriptor);
            }
        }
        return fieldDescriptor;
    }

    public String getFieldName(FeldDeskriptorInterface fieldDescriptor) {
        StringBuffer buffer = new StringBuffer();
        for (FeldDeskriptorInterface currentFieldDescriptor = fieldDescriptor; currentFieldDescriptor != null; currentFieldDescriptor = currentFieldDescriptor.getVorgaenger()) {
            if (buffer.length() > 0) {
                buffer.insert(0, '.');
            }
            if (currentFieldDescriptor.getIndizes() != null && currentFieldDescriptor.getIndizes().length > 0) {
                for (int i = currentFieldDescriptor.getIndizes().length - 1; i >= 0; --i) {
                    buffer.insert(0, this.indexSuffix);
                    buffer.insert(0, currentFieldDescriptor.getIndizes()[i] + this.indexBase);
                    buffer.insert(0, this.indexPrefix);
                }
            }
            buffer.insert(0, currentFieldDescriptor.getFeldNameTB());
        }
        return buffer.toString();
    }

    private String getHierarchy() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.hierarchy.size(); ++i) {
            buffer.append(this.hierarchy.get(i));
            buffer.append(".");
        }
        return buffer.toString();
    }

    private FeldDeskriptor getParentFieldDescriptor() {
        FeldDeskriptor parent;
        if (this.hierarchy.isEmpty()) {
            parent = null;
        } else {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.hierarchy.size(); ++i) {
                buffer.append(this.hierarchy.get(i));
                if (i >= this.hierarchy.size() - 1) continue;
                buffer.append(".");
            }
            parent = (FeldDeskriptor)this.typeDescriptors.get(buffer.toString());
        }
        return parent;
    }

    private int[] parseIndices(String indicesAsString) {
        String[] indices = indicesAsString.split(Pattern.quote(this.indexSuffix + this.indexPrefix));
        int[] indicesAsInt = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            indicesAsInt[i] = Integer.parseInt(indices[i]) - this.indexBase;
        }
        return indicesAsInt;
    }

    private FeldDeskriptor getTypeDescriptor(String name, String structure) throws NoSuchFieldException {
        String key = structure != null && structure.length() > 0 ? structure + name : name;
        if (!this.typeDescriptors.containsKey(key)) {
            throw new NoSuchFieldException(name);
        }
        FeldDeskriptor typeDescriptor = (FeldDeskriptor)this.typeDescriptors.get(key);
        return typeDescriptor;
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich aTb) {
        MetaCustomThemenbereich tb = (MetaCustomThemenbereich)aTb;
        if (this.currentTBFeld == null) {
            this.visitElements(tb.getFelder());
            this.visitElements(tb.getVariablen());
            this.visitElements(tb.getInitialisierungswerte());
        } else {
            this.typeDescriptors.put(this.getHierarchy() + this.currentTBFeld.getName(), new FeldDeskriptorExt(MAPPINGS, this.currentTBFeld.getName(), this.getParentFieldDescriptor(), 7, ((MetaCustomTBFeld)this.currentTBFeld).dimensions(), TBFieldDescriptorFactory.getDisplayName((MetaCustomTBFeld)this.currentTBFeld)));
            this.enterSubNamespace(this.currentTBFeld.getName());
            this.visitElements(tb.getFelder());
            this.visitElements(tb.getVariablen());
            this.visitElements(tb.getInitialisierungswerte());
            this.leaveSubNamespace();
        }
    }

    @Override
    public void visitTBFeld(MetaTBFeld aFeld) {
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        this.currentTBFeld = aFeld;
        if (aFeld.getKlasse() != null) {
            feld.getKlasse().accept(this);
        }
    }

    @Override
    public void visitMerkmal(MetaMerkmal merkmal) {
        int type;
        switch (merkmal.getTyp()) {
            case 5: {
                type = 0;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            case 7: {
                type = 4;
                break;
            }
            case 3: 
            case 4: {
                type = 5;
                break;
            }
            case 6: {
                type = 8;
                break;
            }
            default: {
                type = 7;
            }
        }
        int[] dimensions = this.currentTBFeld.getMehrfachantworten() ? new int[]{CodegenUtil.getMehrfachantwortTbFieldDimension(this.currentTBFeld)} : ((MetaCustomTBFeld)this.currentTBFeld).dimensions();
        FeldDeskriptorExt typeDescriptor = new FeldDeskriptorExt(MAPPINGS, this.currentTBFeld.getName(), this.getParentFieldDescriptor(), type, merkmal.getMaske(), dimensions, TBFieldDescriptorFactory.getDisplayName((MetaCustomTBFeld)this.currentTBFeld));
        typeDescriptor.setMehrfachantwort(this.currentTBFeld.getMehrfachantworten());
        this.typeDescriptors.put(this.getHierarchy() + this.currentTBFeld.getName(), typeDescriptor);
    }

    @Override
    public void visitPLVariable(MetaPLVariable variable) {
        int type;
        String mask = null;
        switch (variable.getTyp()) {
            case 5: {
                type = 0;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            case 7: {
                type = 4;
                break;
            }
            case 3: 
            case 4: {
                type = 5;
                mask = "TT.MM.JJJJ";
                break;
            }
            default: {
                type = 7;
            }
        }
        this.typeDescriptors.put(this.getHierarchy() + variable.getName(), new FeldDeskriptorExt(MAPPINGS, variable.getName(), this.getParentFieldDescriptor(), type, mask, ((MetaCustomVariable)variable).dimensions(), "###PL-VARIABLE###"));
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        int type;
        String mask = null;
        switch (initwert.getTyp()) {
            case 5: {
                type = 0;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            case 7: {
                type = 4;
                break;
            }
            case 3: 
            case 4: {
                type = 5;
                mask = "TT.MM.JJJJ";
                break;
            }
            default: {
                type = 7;
            }
        }
        this.typeDescriptors.put(this.getHierarchy() + initwert.getName(), new FeldDeskriptorExt(MAPPINGS, initwert.getName(), this.getParentFieldDescriptor(), type, mask, ((MetaCustomInitwert)initwert).dimensions(), "###PL-VARIABLE###"));
    }

    public static String getDisplayName(MetaCustomTBFeld feld) {
        String displayName = feld.getBezeichnung();
        if ((displayName == null || displayName.length() == 0) && feld.getKlasse() instanceof MetaCustomMerkmal) {
            displayName = ((MetaCustomMerkmal)feld.getKlasse()).getBezeichnung();
        }
        if (displayName == null || displayName.length() == 0) {
            displayName = feld.getName();
        }
        return displayName;
    }

    private void enterSubNamespace(String namespace) {
        this.hierarchy.push(namespace);
    }

    private String leaveSubNamespace() {
        return (String)this.hierarchy.pop();
    }

    @Override
    public FeldDeskriptorImpl getFieldDecriptor(String name, int[] indices, FeldDeskriptorImpl parent) throws NoSuchFieldException {
        StringBuffer typeKey = new StringBuffer();
        FeldDeskriptorImpl aktParent = parent;
        if (aktParent != null) {
            Stack<FeldDeskriptorImpl> parents = new Stack<FeldDeskriptorImpl>();
            while (aktParent.getVorgaenger() != null) {
                parents.push(aktParent);
                aktParent = (FeldDeskriptorImpl)aktParent.getVorgaenger();
            }
            while (!parents.isEmpty()) {
                typeKey.append(aktParent.getFeldNameTB());
                typeKey.append('.');
                aktParent = (FeldDeskriptorImpl)parents.pop();
            }
            typeKey.append(aktParent.getFeldNameTB());
            typeKey.append('.');
        }
        return new GenericFieldDescriptor(this.getTypeDescriptor(name, typeKey.toString()), indices, parent);
    }
}

