/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2;

import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.compare2.Comparator;
import de.statspez.pleditor.generator.compare2.ComparedCell;
import de.statspez.pleditor.generator.compare2.ComparedNode;
import de.statspez.pleditor.generator.compare2.MultipleComparedCell;
import de.statspez.pleditor.generator.compare2.ui.ComboBoxValue;
import de.statspez.pleditor.generator.compare2.ui.MultipleFieldUtil;
import de.statspez.pleditor.generator.compare2.ui.TreeTable;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.ArrayList;
import java.util.List;

public class MultipleComparedNode
extends ComparedNode {
    private Integer dimension = null;
    private final List<ComboBoxValue> valueItems;
    private final List<ComboBoxValue> missingValueItems;
    private String[] hauptsatzFeldwert;

    public MultipleComparedNode(ComparedNode parent, MetaCustomTBFeld feld, FeldDeskriptorImpl feldDeskriptor, SatzInterface hauptsatz, List<SatzInterface> vergleichssaetze, Comparator comparator) {
        super(parent, feld, feldDeskriptor, false, hauptsatz, vergleichssaetze, comparator);
        MetaAuspraegungsgruppe apg = this.getClassifications();
        this.valueItems = apg != null ? TreeTable.getComboBoxValues(apg, false) : null;
        apg = this.getMissingValueClassifications();
        this.missingValueItems = apg != null ? TreeTable.getComboBoxValues(apg, false) : null;
    }

    @Override
    public boolean hasHauptsatzValue() {
        boolean result = false;
        if (this.hauptsatzFeldwert != null && this.hauptsatzFeldwert.length > 0) {
            for (String tmp : this.hauptsatzFeldwert) {
                if (tmp == null || tmp.length() <= 0) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean setHauptsatzValue(Object value, boolean markAsChanged) {
        if (!(value instanceof String[])) {
            throw new IllegalArgumentException("Typ des Wertes ist unbekannt");
        }
        boolean changed = MultipleFieldUtil.setValues((String[])value, this.hauptsatzFeldwert, this.hauptsatz, this.valueItems, this.missingValueItems, this.getFeldDeskriptor(), this.dimension());
        if (changed) {
            if (markAsChanged) {
                this.setChanged(true);
            }
            this.readValueOfHauptsatz();
        }
        return changed;
    }

    public String[] getHauptsatzFeldwert() {
        return this.hauptsatzFeldwert;
    }

    public String[] getVergleichssatzFeldwert(int indexOfVergleichssatz) {
        String[] result;
        ComparedCell cell = this.getComparedCell(indexOfVergleichssatz - 1);
        if (cell instanceof MultipleComparedCell) {
            MultipleComparedCell comparedCell = (MultipleComparedCell)cell;
            result = comparedCell.getMultipleValue();
        } else {
            result = null;
        }
        return result;
    }

    public MetaAuspraegungsgruppe getMissingValueClassifications() {
        MetaCustomMerkmal feature = this.getFeature();
        MetaAuspraegungsgruppe classifications = feature != null ? feature.getKlasseFehlwerte() : null;
        return classifications;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        MetaCustomTBFeld field = this.getMetaTBFeld();
        if (field.getBezeichnung() != null && field.getBezeichnung().length() > 0) {
            buffer.append(field.getBezeichnung());
        } else {
            buffer.append(field.getName());
        }
        buffer.append("*");
        String text = buffer.toString();
        return text;
    }

    @Override
    protected ComparedCell createComparedCell(SatzInterface satz) {
        return new MultipleComparedCell(satz, this.dimension());
    }

    @Override
    protected void readValueOfHauptsatz() {
        if (this.hasHauptsatz()) {
            this.hauptsatzFeldwert = MultipleFieldUtil.getSavedValues(this.getFeldDeskriptor(), this.dimension(), this.hauptsatz);
            this.hauptsatzAnzeigewert = MultipleFieldUtil.getSavedValuesAsString(this.hauptsatzFeldwert);
        } else {
            this.hauptsatzFeldwert = null;
            this.hauptsatzAnzeigewert = null;
            this.setChanged(false);
        }
    }

    @Override
    protected void readValue(int indexOfVergleichssatz) {
        if (this.hasSatzByVergleichssatzIndex(indexOfVergleichssatz)) {
            MetaAuspraegungsgruppe classifications = this.getClassifications();
            ComparedCell comparedCell = this.getComparedCell(indexOfVergleichssatz);
            comparedCell.readValue(this.getFeldDeskriptor(), classifications);
        }
    }

    @Override
    protected boolean isDifferentValue(int indexOfVergleichssatz) {
        boolean isDifferent;
        MultipleComparedCell comparedCell = (MultipleComparedCell)this.getComparedCell(indexOfVergleichssatz);
        String[] values1 = this.hauptsatzFeldwert;
        String[] values2 = comparedCell.getMultipleValue();
        if (values1 != null && values2 != null) {
            isDifferent = false;
            ArrayList<String> notEmptyValues1 = this.getNotEmptyValuesAsList(values1);
            ArrayList<String> notEmptyValues2 = this.getNotEmptyValuesAsList(values2);
            for (String tmp : notEmptyValues1) {
                if (notEmptyValues2.contains(tmp)) continue;
                isDifferent = true;
                break;
            }
            if (!isDifferent) {
                for (String tmp : notEmptyValues2) {
                    if (notEmptyValues1.contains(tmp)) continue;
                    isDifferent = true;
                    break;
                }
            }
        } else {
            isDifferent = values1 != null || values2 != null;
        }
        return isDifferent;
    }

    @Override
    protected void setVergleichssatzValueInHauptsatz(ComparedNode quellNode, int indexOfVergleichssatz) {
        MultipleComparedNode multipleComparedNode = (MultipleComparedNode)quellNode;
        MultipleComparedCell comparedCell = (MultipleComparedCell)multipleComparedNode.getComparedCell(indexOfVergleichssatz);
        String[] valueToSet = comparedCell.getMultipleValue();
        MultipleFieldUtil.setValues(valueToSet, this.hauptsatzFeldwert, this.hauptsatz, this.valueItems, this.missingValueItems, this.getFeldDeskriptor(), this.dimension());
    }

    private Integer dimension() {
        if (this.dimension == null) {
            MetaCustomTBFeld field = this.getMetaTBFeld();
            this.dimension = CodegenUtil.getMehrfachantwortTbFieldDimension(field);
        }
        return this.dimension;
    }

    private ArrayList<String> getNotEmptyValuesAsList(String[] values) {
        ArrayList<String> result = new ArrayList<String>();
        for (String tmp : values) {
            if (tmp == null || tmp.length() <= 0 || result.contains(tmp)) continue;
            result.add(tmp);
        }
        return result;
    }
}

