/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.MaterialConstructorGenerator;
import de.statspez.pleditor.generator.codegen.java.PlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import java.util.Vector;

public class MaterialCodeGenerator
extends PlausiElementCodeGenerator {
    private CodegenContext context;
    private int numOfFields;
    private Stack segments;
    private Vector fields;

    public synchronized void generate(CodegenContext aContext, MetaThemenbereich aTb) {
        if (!((MetaCustomThemenbereich)aTb).describesMaterial() && !((MetaCustomThemenbereich)aTb).referencedByMaterial()) {
            throw new CodegenException("Fatal Fehler: der Themenbereich " + aTb.getName() + " beschreibt kein Material.");
        }
        this.context = aContext;
        this.numOfFields = 0;
        this.segments = new Stack();
        this.fields = new Vector();
        aTb.accept(this);
        this.checkForErrors();
        this.out.flush();
    }

    public synchronized void generate(MetaPlausibilisierung aPlausi) {
        aPlausi.accept(this);
        this.checkForErrors();
        this.out.flush();
    }

    private void createMaterialTbConstructor(MetaThemenbereich aTb, String className, boolean superIsNotBaseClass, Vector fieldsToInit) {
        MaterialConstructorGenerator codeGen = new MaterialConstructorGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context, aTb, className, superIsNotBaseClass, this.withinSegment(), fieldsToInit.iterator());
    }

    private void createGetInstanceMethod(MetaThemenbereich aTb) {
        this.defineMethod("public", "MaterialThemenbereich", "getInstance", "int[] indizes");
        this.indentNewLine();
        this.out.print("return new ");
        this.out.print(this.getTbClass(aTb));
        this.out.print("(");
        this.out.print("getVorgaenger");
        this.out.print("(), ");
        this.out.print("getFeldDeskriptor");
        this.out.print("(), indizes, ");
        this.out.print("getMaterialName");
        this.out.print("(), ");
        this.out.print("getMaterialDSBName");
        this.out.print("(), true);");
        this.endMethodDefinition();
    }

    private void declareMaterialTbInstance(MetaPLMaterial material) {
        MetaCustomThemenbereich tb = (MetaCustomThemenbereich)material.getThemenbereich();
        this.indentNewLine();
        this.out.print("__material_");
        this.out.print(StringHelper.getEscapedName(material.getName()));
        this.out.print(" = new ");
        this.out.print(this.getTbClass(tb));
        this.out.print("(null, new ");
        this.out.print("FeldDeskriptor");
        this.out.print("(mappingsForMaterial(\"");
        this.out.print(material.getName());
        this.out.print("\"), \"");
        this.out.print(material.getMapping().getThemenbereich().getName());
        this.out.print("\", null, RuntimeSettings.RT_TYPE_CUSTOM), null, \"");
        this.out.print(material.getName());
        this.out.print("\", \"");
        this.out.print(material.getDSB().getName());
        this.out.print("\", false);");
    }

    private void startNewSegment() {
        String baseClassName = "MaterialThemenbereich";
        if (this.withinSegment()) {
            baseClassName = ((SegmentInfo)this.segments.peek()).className;
        }
        String className = this.context.getNextPlausiSegmentClassName();
        String filename = className + ".java";
        Writer writer = this.context.createWriter(filename);
        this.segments.push(new SegmentInfo(className, filename, writer, this.out, this.indentLevel()));
        this.setOutput(writer);
        this.setIndentLevel(0);
        this.out.print("package ");
        this.out.print(this.context.getPlausiPackage());
        this.out.print(";");
        this.indentNewLine();
        this.indentNewLine();
        this.out.print("import ");
        this.out.print("de.statspez.pleditor.generator.runtime.");
        this.out.print("*;");
        this.indentNewLine();
        this.out.print("import ");
        this.out.print("de.statspez.pleditor.generator.runtime.plausi.");
        this.out.print("*;");
        this.indentNewLine();
        this.defineClass(className, "public abstract", baseClassName);
    }

    private void startNewSegmentIfNecessary(MetaElement element) {
        if (this.numOfFields >= this.context.getMaxElementsInSegment(5)) {
            this.numOfFields = 1;
            this.startNewSegment();
        } else {
            ++this.numOfFields;
        }
        if (this.withinSegment()) {
            ((SegmentInfo)this.segments.peek()).fields.add(element);
        } else {
            this.fields.add(element);
        }
    }

    private void closeCurrentSegment(MetaThemenbereich tb) {
        if (this.withinSegment()) {
            SegmentInfo segment = (SegmentInfo)this.segments.peek();
            this.indentNewLine();
            this.createMaterialTbConstructor(tb, segment.className, this.segments.size() > 1, segment.fields);
            this.endClassDefinition();
            this.out.flush();
            this.segments.pop();
            this.context.destroyWriter(segment.filename, segment.writer);
            this.out = segment.previousOut;
            this.setIndentLevel(segment.previousIndentLevel);
        }
    }

    private boolean withinSegment() {
        return !this.segments.isEmpty();
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        boolean extend;
        if (tb.sizeOfFelder() > this.context.getMaxElementsInSegment(5)) {
            extend = true;
            this.startNewSegment();
        } else {
            extend = false;
            this.defineClass(this.getTbClass(tb), "public", "MaterialThemenbereich");
        }
        this.visitElements(tb.getFelder());
        if (extend) {
            String className = ((SegmentInfo)this.segments.peek()).className;
            while (this.withinSegment()) {
                this.closeCurrentSegment(tb);
            }
            this.defineClass(this.getTbClass(tb), "public", className);
        }
        this.createMaterialTbConstructor(tb, this.getTbClass(tb), extend, this.fields);
        this.indentNewLine();
        this.createGetInstanceMethod(tb);
        this.endClassDefinition();
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        MetaPLMaterial[] usedMaterials = CodegenUtil.getUsedMaterials(plausi);
        if (usedMaterials != null && usedMaterials.length > 0) {
            for (int i = 0; i < usedMaterials.length; ++i) {
                usedMaterials[i].accept(this);
            }
        }
    }

    @Override
    public void visitPLMaterial(MetaPLMaterial material) {
        this.declareMaterialTbInstance(material);
    }

    @Override
    public void visitTBFeld(MetaTBFeld aFeld) {
        this.startNewSegmentIfNecessary(aFeld);
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        String type = null;
        if (feld.getKlasse() instanceof MetaMerkmal) {
            type = aFeld.getListe() ? "MaterialArray" : "MaterialVariable";
        } else if (feld.getKlasse() instanceof MetaThemenbereich) {
            if (aFeld.getListe()) {
                type = "TopicMaterialArray";
            } else {
                type = this.getTbClass((MetaThemenbereich)feld.getKlasse());
                if (this.withinSegment()) {
                    type = this.context.getPlausiClassName() + "." + type;
                }
            }
        } else {
            this.error(aFeld, "Das Feld " + feld.getName() + " hat eine ungueltige Feld-Klasse (" + aFeld.getKlasse() + ")");
        }
        this.indentNewLine();
        this.out.print("public ");
        this.out.print(type);
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(aFeld.getName()));
        this.out.print(";");
    }

    @Override
    protected String getTbClass(MetaThemenbereich aTb) {
        return "Material" + super.getTbClass(aTb);
    }

    private class SegmentInfo {
        public String className;
        public String filename;
        public Writer writer;
        public PrintWriter previousOut;
        private int previousIndentLevel;
        private Vector fields;

        public SegmentInfo(String className, String filename, Writer writer, PrintWriter previousOut, int previousIndentLevel) {
            this.className = className;
            this.filename = filename;
            this.writer = writer;
            this.previousOut = previousOut;
            this.previousIndentLevel = previousIndentLevel;
            this.fields = new Vector();
        }
    }
}

