/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.html;

import de.statspez.pleditor.generator.parser.speclanguage.ui.HighlightScanner;
import de.statspez.pleditor.generator.parser.speclanguage.ui.SyntaxSegment;
import de.werum.prosi.common.xml.XmlWriter;
import java.io.IOException;
import java.io.StringReader;

public class HtmlProgramCodeGenerator {
    public void generateHtml(String code, XmlWriter out) throws IOException {
        if (code != null && code.length() > 0) {
            SyntaxSegment segment;
            HighlightScanner scanner = new HighlightScanner(new StringReader(code));
            int offset = 0;
            while ((segment = scanner.next_segment()) != null) {
                if (segment.getOffsetStart() > offset) {
                    out.write(code.substring(offset, segment.getOffsetStart()));
                }
                out.startTag("span");
                switch (segment.getType()) {
                    case 7: {
                        out.writeAttribute("class", "kw");
                        break;
                    }
                    case 3: {
                        out.writeAttribute("class", "str");
                        break;
                    }
                    case 1: {
                        out.writeAttribute("class", "cmt");
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 4: {
                        out.writeAttribute("class", "ms");
                        break;
                    }
                    case 2: {
                        out.writeAttribute("class", "num");
                        break;
                    }
                    case 6: {
                        out.writeAttribute("class", "okw");
                        break;
                    }
                    case 5: {
                        out.writeAttribute("class", "os");
                    }
                }
                out.write(code.substring(segment.getOffsetStart(), segment.getOffsetEnd() + 1));
                out.endTag();
                offset = segment.getOffsetEnd() + 1;
            }
            if (offset < code.length()) {
                out.write(code.substring(offset, code.length()));
            }
        }
    }
}

