/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.DiffElement;
import de.statspez.pleditor.generator.codegen.diff.DiffResult;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementAdded;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementChanged;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementRemoved;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementTypeChanged;
import de.statspez.pleditor.generator.codegen.diff.DiffResultPlausiDiffers;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTree;
import de.statspez.pleditor.generator.codegen.diff.DiffUITreeNode;
import de.statspez.pleditor.generator.codegen.diff.StatusIcon;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DiffUITreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon ICON_ADDED = new ImageIcon(DiffUITreeCellRenderer.class.getResource("images/added.gif"));
    private static final Icon ICON_CHANGED = new ImageIcon(DiffUITreeCellRenderer.class.getResource("images/changed.gif"));
    private static final Icon ICON_ERROR = new ImageIcon(DiffUITreeCellRenderer.class.getResource("images/error.gif"));
    private static final Icon ICON_NO_CHANGE = new ImageIcon(DiffUITreeCellRenderer.class.getResource("images/no_change.gif"));
    private static final Icon ICON_REFERENCE_CHANGED = null;
    private static final Icon ICON_REMOVED = new ImageIcon(DiffUITreeCellRenderer.class.getResource("images/removed.gif"));
    private static final Icon ICON_WARNING = new ImageIcon(DiffUITreeCellRenderer.class.getResource("images/warning.gif"));
    private static final long serialVersionUID = -5221089452868297393L;
    private DiffConfig diffConfig = null;

    DiffUITreeCellRenderer(DiffConfig diffConfig) {
        this.diffConfig = diffConfig;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        List rootDiffResults;
        DiffResultTree resultTree;
        Icon error;
        Icon type;
        Icon status;
        List diffResults;
        DiffUITreeNode node;
        block15: {
            block16: {
                DiffResult diffResult;
                block17: {
                    super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    this.setText(null);
                    this.setIcon(null);
                    if (!(value instanceof DiffUITreeNode)) return this;
                    node = (DiffUITreeNode)value;
                    diffResults = node.getDiffResultTreeNode().getDiffResults();
                    status = null;
                    type = null;
                    error = null;
                    if (!node.getDiffResultTreeNode().isHeaderNode()) {
                        MetaElement element;
                        MetaElement element1 = node.getDiffResultTreeNode().getMetaElement1();
                        MetaElement element2 = node.getDiffResultTreeNode().getMetaElement2();
                        MetaElement metaElement = element1 != null ? element1 : (element = element2 != null ? element2 : null);
                        if (element == null) {
                            throw new NullPointerException();
                        }
                        type = DiffElement.getDiffElement(element).getIcon();
                    }
                    if (node.getDiffResultTreeNode().isHeaderNode() || diffResults.size() == 0) break block15;
                    if (diffResults.size() != 1) break block16;
                    diffResult = (DiffResult)diffResults.get(0);
                    if (!(diffResult instanceof DiffResultElementAdded)) break block17;
                    status = ICON_ADDED;
                    break block15;
                }
                if (diffResult instanceof DiffResultElementRemoved) {
                    status = ICON_REMOVED;
                    break block15;
                } else if (diffResult instanceof DiffResultElementChanged) {
                    status = ICON_CHANGED;
                    break block15;
                } else if (!(diffResult instanceof DiffResultElementTypeChanged)) {
                    // empty if block
                }
                break block15;
            }
            status = ICON_CHANGED;
        }
        if (this.diffConfig != null && this.diffConfig.isShowErrorStatusIcon()) {
            for (DiffResult diffResult : diffResults) {
                int errorLevel = this.diffConfig.getErrorLevel(diffResult);
                if (errorLevel == 2) {
                    error = ICON_ERROR;
                    break;
                }
                if (errorLevel != 1) continue;
                error = ICON_WARNING;
            }
        }
        if (type != null) {
            StatusIcon icon = new StatusIcon(type);
            icon.setStatusIcon(2, status, 2, -3);
            icon.setStatusIcon(3, error, 2, -3);
            this.setIcon(icon);
        }
        if ((resultTree = node.getDiffResultTreeNode().getDiffResultTree()).getRootNode().equals(node.getDiffResultTreeNode()) && (rootDiffResults = node.getDiffResultTreeNode().getDiffResults()).size() == 1 && rootDiffResults.get(0) instanceof DiffResultPlausiDiffers) {
            this.setIcon(ICON_ERROR);
        }
        this.setText(this.generateText(node));
        if (diffResults != null && diffResults.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html>");
            if (diffResults.size() == 1) {
                buffer.append("Ein Unterschied");
            } else {
                buffer.append(diffResults.size());
                buffer.append(" Unterschiede");
            }
            buffer.append("</html>");
            this.setToolTipText(buffer.toString());
            return this;
        }
        this.setToolTipText(null);
        return this;
    }

    private String generateText(DiffUITreeNode node) {
        String text = node.toString();
        MetaElement element1 = node.getDiffResultTreeNode().getMetaElement1();
        MetaElement element2 = node.getDiffResultTreeNode().getMetaElement2();
        if (element1 != null && element1 instanceof MetaThemenbereich || element2 != null && element2 instanceof MetaThemenbereich) {
            if (element1 != null && element2 != null) {
                MetaThemenbereich tb1 = (MetaThemenbereich)element1;
                MetaThemenbereich tb2 = (MetaThemenbereich)element2;
                text = tb1.getName().equals(tb2.getName()) ? tb1.getName() : tb1.getName() + " => " + tb2.getName();
            } else {
                text = element1 != null ? ((MetaThemenbereich)element1).getName() : ((MetaThemenbereich)element2).getName();
            }
        }
        return text;
    }
}

