/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppSettings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.HelperVisitor;
import de.statspez.pleditor.generator.codegen.support.HelperVisitorAdapter;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import java.util.Iterator;

public class CppClassificationCodeGenerator
extends HelperVisitor {
    private static final String CLASSI_VAR = "classi";

    public CppClassificationCodeGenerator(HelperVisitorAdapter adapter) {
        super(adapter);
    }

    public void preGeneration() {
        this.indentNewLine();
        this.out().print("Classification* ");
        this.out().print(CLASSI_VAR);
        this.out().print(";");
        this.indentNewLine();
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe classificationGroup) {
        this.createBeginClassificationCode();
        this.out().print("&StringValue(\"");
        this.out().print(classificationGroup.getName());
        this.out().print("\")");
        this.createEndClassificationCode(classificationGroup.getName(), "#" + classificationGroup.getName(), null);
        this.indentNewLine();
        Iterator it = classificationGroup.getAuspraegungsComps().getAuspraegungen();
        while (it.hasNext()) {
            ((MetaAuspraegung)it.next()).accept(this);
        }
    }

    @Override
    public void visitPLAuspraegung(MetaPLAuspraegung classification) {
        MetaCustomAuspraegung myClassi = (MetaCustomAuspraegung)classification;
        this.createBeginClassificationCode();
        myClassi.getKodeSpezifikation().accept(this);
        this.createEndClassificationCode(myClassi.getName(), myClassi.getHierachicalCode(), myClassi.getHierachicalValue());
        String groupRegCode = myClassi.hasParent() ? ((MetaCustomAuspraegung)myClassi.getParent()).getHierachicalCode() : "#" + myClassi.getGroup().getName();
        this.indentNewLine();
        this.out().print("((Classification*)getClassificationByCode(\"");
        this.out().print(groupRegCode);
        this.out().print("\"))->addClassification(");
        this.out().print(CLASSI_VAR);
        this.out().print(");");
        this.indentNewLine();
        for (int i = 0; i < classification.sizeOfAuspraegungen(); ++i) {
            classification.getFromAuspraegungen(i).accept(this);
        }
    }

    @Override
    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        if (aRangeSeries.numberOfRanges() > 1) {
            this.out().print("&RangeSeries(");
            this.out().print(aRangeSeries.numberOfRanges());
            Iterator it = aRangeSeries.ranges();
            while (it.hasNext()) {
                this.out().print(", ");
                ((MetaElement)it.next()).accept(this);
            }
            this.out().print(")");
        } else if (aRangeSeries.numberOfRanges() == 1) {
            aRangeSeries.rangeAt(0).accept(this);
        }
    }

    @Override
    public void visitSequence(MetaSequence aRange) {
        this.out().print("&SequenceRange(");
        aRange.first().accept(this);
        this.out().print(", ");
        aRange.second().accept(this);
        this.out().print(", ");
        aRange.last().accept(this);
        this.out().print(")");
    }

    @Override
    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        this.error(aFieldAccess, "Zeichenketten m\u00fcssen in Hochkommata eingeschlossen werden.");
    }

    @Override
    public void visitInterval(MetaInterval aRange) {
        this.out().print("&IntervalRange(");
        aRange.first().accept(this);
        this.out().print(", ");
        aRange.last().accept(this);
        this.out().print(", ");
        this.out().print(CppSettings.getRuntimeIntervalType(aRange.type()));
        this.out().print(")");
    }

    @Override
    public void visitProgram(MetaProgram aProgram) {
        aProgram.statements().statementAt(0).accept(this);
    }

    @Override
    public void visitSignOperator(MetaSignOperator anOperator) {
        if (anOperator.type() == 2) {
            this.out().print("&NumberValue(");
        }
        anOperator.operand().accept(this);
        if (anOperator.type() == 2) {
            this.out().print("->asReal()");
            this.out().print(" * ");
            this.out().print("(-1))");
        }
    }

    @Override
    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        anAssignment.rightValue().accept(this);
    }

    @Override
    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        aRange.value().accept(this);
    }

    @Override
    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accessedLiteral().accept(this);
    }

    @Override
    public void visitNumber(MetaNumber aNumber) {
        this.out().print("&NumberValue(");
        this.out().print(aNumber.value().toString());
        this.out().print(")");
    }

    @Override
    public void visitString(MetaString aString) {
        this.out().print("&StringValue(\"");
        String val = aString.value();
        val = val == null ? "" : StringHelper.getEscapedStringValue(val);
        this.out().print(val);
        this.out().print("\")");
    }

    private void createBeginClassificationCode() {
        this.indentNewLine();
        this.out().print(CLASSI_VAR);
        this.out().print(" = new Classification(");
    }

    private void createEndClassificationCode(String value, String regCode, String regValue) {
        this.out().print(", \"");
        value = value == null ? "" : StringHelper.getEscapedStringValue(value);
        this.out().print(value);
        this.out().print("\");");
        this.indentNewLine();
        this.out().print("registerClassification(");
        this.out().print(CLASSI_VAR);
        this.out().print(", \"");
        this.out().print(regCode);
        this.out().print("\"");
        if (regValue != null) {
            this.out().print(", \"");
            this.out().print(StringHelper.getEscapedStringValue(regValue));
            this.out().print("\"");
        }
        this.out().print(");");
    }
}

