/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.xmla.Enumeration;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequestCallback;
import mondrian.xmla.XmlaUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlaServlet
extends HttpServlet
implements XmlaConstants {
    protected static final Logger LOGGER = Logger.getLogger(XmlaServlet.class);
    public static final String PARAM_DATASOURCES_CONFIG = "DataSourcesConfig";
    public static final String PARAM_OPTIONAL_DATASOURCE_CONFIG = "OptionalDataSourceConfig";
    public static final String PARAM_CHAR_ENCODING = "CharacterEncoding";
    public static final String PARAM_CALLBACKS = "Callbacks";
    protected XmlaHandler xmlaHandler = null;
    protected String charEncoding = null;
    private final List<XmlaRequestCallback> callbackList = new ArrayList<XmlaRequestCallback>();
    private XmlaHandler.ConnectionFactory connectionFactory;

    public static boolean getBooleanInitParameter(ServletConfig servletConfig, String paramName) {
        String paramValue = servletConfig.getInitParameter(paramName);
        return paramValue != null && Boolean.valueOf(paramValue) != false;
    }

    public static boolean getParameter(HttpServletRequest req, String paramName) {
        String paramValue = req.getParameter(paramName);
        return paramValue != null && Boolean.valueOf(paramValue) != false;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initCharEncodingHandler(servletConfig);
        this.initCallbacks(servletConfig);
        this.connectionFactory = this.createConnectionFactory(servletConfig);
    }

    protected abstract XmlaHandler.ConnectionFactory createConnectionFactory(ServletConfig var1) throws ServletException;

    protected XmlaHandler getXmlaHandler() {
        if (this.xmlaHandler == null) {
            this.xmlaHandler = new XmlaHandler(this.connectionFactory, "cxmla");
        }
        return this.xmlaHandler;
    }

    protected final void addCallback(XmlaRequestCallback callback) {
        this.callbackList.add(callback);
    }

    protected final List<XmlaRequestCallback> getCallbacks() {
        return Collections.unmodifiableList(this.callbackList);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Element[] requestSoapParts = new Element[2];
        byte[][] responseSoapParts = new byte[2][];
        Phase phase = Phase.VALIDATE_HTTP_HEAD;
        Enumeration.ResponseMimeType mimeType = Enumeration.ResponseMimeType.SOAP;
        try {
            if (this.charEncoding != null) {
                try {
                    request.setCharacterEncoding(this.charEncoding);
                    response.setCharacterEncoding(this.charEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    this.charEncoding = null;
                    LOGGER.warn((Object)("Unsupported character encoding '" + this.charEncoding + "': Use default character encoding from HTTP client " + "for now"));
                }
            }
            response.setContentType(mimeType.getMimeType());
            HashMap<String, Object> context = new HashMap<String, Object>();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking validate http header callbacks");
                }
                for (XmlaRequestCallback callback : this.getCallbacks()) {
                    if (callback.processHttpHeader(request, response, context)) continue;
                    return;
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks validateHttpHeader", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks validateHttpHeader", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CHHA01", "Error in Callback processHttpHeader", ex));
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.INITIAL_PARSE;
            try {
                String contentType;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Unmarshalling SOAP message");
                }
                if ((contentType = request.getContentType()) == null || !contentType.contains("text/xml")) {
                    throw new IllegalArgumentException("Only accepts content type 'text/xml', not '" + contentType + "'");
                }
                String accept = request.getHeader("Accept");
                if (accept != null) {
                    mimeType = XmlaUtil.chooseResponseMimeType(accept);
                    if (mimeType == null) {
                        throw new IllegalArgumentException("Accept header '" + accept + "' is not a supported" + " response content type. Allowed values:" + " text/xml, application/xml, application/json.");
                    }
                    if (mimeType != Enumeration.ResponseMimeType.SOAP) {
                        response.setContentType(mimeType.getMimeType());
                    }
                }
                context.put("language", (Object)mimeType);
                this.unmarshallSoapMessage(request, requestSoapParts);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Unable to unmarshall SOAP message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.PROCESS_HEADER;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Handling XML/A message header");
                }
                this.handleSoapHeader(response, requestSoapParts, responseSoapParts, context);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.CALLBACK_PRE_ACTION;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking callbacks preAction");
                }
                for (XmlaRequestCallback callback : this.getCallbacks()) {
                    callback.preAction(request, requestSoapParts, context);
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks preaction", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks preaction", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CPREA01", "Error in Callback PreAction", ex));
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.PROCESS_BODY;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Handling XML/A message body");
                }
                this.handleSoapBody(response, requestSoapParts, responseSoapParts, context);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            mimeType = (Enumeration.ResponseMimeType)((Object)context.get("language"));
            phase = Phase.CALLBACK_POST_ACTION;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Invoking callbacks postAction");
                }
                for (XmlaRequestCallback callback : this.getCallbacks()) {
                    callback.postAction(request, response, responseSoapParts, context);
                }
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when invoking callbacks postaction", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Errors when invoking callbacks postaction", (Throwable)ex);
                this.handleFault(response, responseSoapParts, phase, new XmlaException("Server", "00CPOSTA01", "Error in Callback PostAction", ex));
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
                return;
            }
            phase = Phase.SEND_RESPONSE;
            try {
                response.setStatus(200);
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
            }
            catch (XmlaException xex) {
                LOGGER.error((Object)"Errors when handling XML/A message", (Throwable)xex);
                this.handleFault(response, responseSoapParts, phase, xex);
                phase = Phase.SEND_ERROR;
                this.marshallSoapMessage(response, responseSoapParts, mimeType);
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Unknown Error when handling XML/A message", t);
            this.handleFault(response, responseSoapParts, phase, t);
            this.marshallSoapMessage(response, responseSoapParts, mimeType);
        }
    }

    protected abstract void unmarshallSoapMessage(HttpServletRequest var1, Element[] var2) throws XmlaException;

    protected abstract void handleSoapHeader(HttpServletResponse var1, Element[] var2, byte[][] var3, Map<String, Object> var4) throws XmlaException;

    protected abstract void handleSoapBody(HttpServletResponse var1, Element[] var2, byte[][] var3, Map<String, Object> var4) throws XmlaException;

    protected abstract void marshallSoapMessage(HttpServletResponse var1, byte[][] var2, Enumeration.ResponseMimeType var3) throws XmlaException;

    protected abstract void handleFault(HttpServletResponse var1, byte[][] var2, Phase var3, Throwable var4);

    protected void initCharEncodingHandler(ServletConfig servletConfig) {
        String paramValue = servletConfig.getInitParameter(PARAM_CHAR_ENCODING);
        if (paramValue != null) {
            this.charEncoding = paramValue;
        } else {
            this.charEncoding = null;
            LOGGER.warn((Object)"Use default character encoding from HTTP client");
        }
    }

    protected void initCallbacks(ServletConfig servletConfig) {
        String callbacksValue = servletConfig.getInitParameter(PARAM_CALLBACKS);
        if (callbacksValue != null) {
            String[] classNames = callbacksValue.split(";");
            int count = 0;
            for (String className1 : classNames) {
                String className = className1.trim();
                try {
                    Class<?> cls = Class.forName(className);
                    if (XmlaRequestCallback.class.isAssignableFrom(cls)) {
                        XmlaRequestCallback callback = (XmlaRequestCallback)cls.newInstance();
                        try {
                            callback.init(servletConfig);
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)("Failed to initialize callback '" + className + "'"), (Throwable)e);
                            continue;
                        }
                        this.addCallback(callback);
                        ++count;
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug((Object)("Register callback '" + className + "'"));
                        continue;
                    }
                    LOGGER.warn((Object)("'" + className + "' is not an implementation of '" + XmlaRequestCallback.class + "'"));
                }
                catch (ClassNotFoundException cnfe) {
                    LOGGER.warn((Object)("Callback class '" + className + "' not found"), (Throwable)cnfe);
                }
                catch (InstantiationException ie) {
                    LOGGER.warn((Object)("Can't instantiate class '" + className + "'"), (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    LOGGER.warn((Object)("Can't instantiate class '" + className + "'"), (Throwable)iae);
                }
            }
            LOGGER.debug((Object)("Registered " + count + " callback" + (count > 1 ? "s" : "")));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        VALIDATE_HTTP_HEAD,
        INITIAL_PARSE,
        CALLBACK_PRE_ACTION,
        PROCESS_HEADER,
        PROCESS_BODY,
        CALLBACK_POST_ACTION,
        SEND_RESPONSE,
        SEND_ERROR;

    }
}

