/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.server.Execution;
import mondrian.spi.Dialect;
import mondrian.spi.StatisticsProvider;
import org.apache.log4j.Logger;

public class JdbcStatisticsProvider
implements StatisticsProvider {
    private static final Logger LOG = Logger.getLogger(JdbcStatisticsProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTableCardinality(Dialect dialect, DataSource dataSource, String catalog, String schema, String table, Execution execution) {
        int n;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            resultSet = connection.getMetaData().getIndexInfo(dialect.rectifyCase(catalog), dialect.rectifyCase(schema), dialect.rectifyCase(table), false, true);
            int maxNonUnique = -1;
            while (resultSet.next()) {
                int type = resultSet.getInt(7);
                int cardinality = resultSet.getInt(11);
                boolean unique = !resultSet.getBoolean(4);
                switch (type) {
                    case 0: {
                        int n2 = cardinality;
                        Util.close(resultSet, null, connection);
                        return n2;
                    }
                    default: {
                        if (unique) break;
                        maxNonUnique = Math.max(maxNonUnique, cardinality);
                        break;
                    }
                }
            }
            n = maxNonUnique;
            Util.close(resultSet, null, connection);
            return n;
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("JdbcStatisticsProvider failed to get the cardinality of the table " + table), (Throwable)e);
            }
            n = -1;
            return n;
        }
        finally {
            Util.close(resultSet, null, connection);
        }
    }

    public int getQueryCardinality(Dialect dialect, DataSource dataSource, String sql, Execution execution) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getColumnCardinality(Dialect dialect, DataSource dataSource, String catalog, String schema, String table, String column, Execution execution) {
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            int type;
            connection = dataSource.getConnection();
            resultSet = connection.getMetaData().getIndexInfo(dialect.rectifyCase(catalog), dialect.rectifyCase(schema), dialect.rectifyCase(table), false, true);
            block9: while (resultSet.next()) {
                type = resultSet.getInt(7);
                switch (type) {
                    case 0: {
                        continue block9;
                    }
                }
                String columnName = resultSet.getString(9);
                if (columnName == null || !columnName.equals(column)) continue;
                int n = resultSet.getInt(11);
                Util.close(resultSet, null, connection);
                return n;
            }
            type = -1;
            Util.close(resultSet, null, connection);
            return type;
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("JdbcStatisticsProvider failed to get the cardinality of the table " + table), (Throwable)e);
            }
            int n = -1;
            return n;
        }
        finally {
            Util.close(resultSet, null, connection);
        }
    }
}

