/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunInfo
implements Comparable<FunInfo> {
    private final Syntax syntax;
    private final String name;
    private final String description;
    private final int[] returnTypes;
    private final int[][] parameterTypes;
    private String[] sigs;

    static FunInfo make(Resolver resolver) {
        FunDef funDef = resolver.getFunDef();
        if (funDef != null) {
            return new FunInfo(funDef);
        }
        if (resolver instanceof MultiResolver) {
            return new FunInfo((MultiResolver)resolver);
        }
        return new FunInfo(resolver);
    }

    FunInfo(FunDef funDef) {
        String[] stringArray;
        this.syntax = funDef.getSyntax();
        this.name = funDef.getName();
        assert (this.name != null);
        assert (this.syntax != null);
        this.returnTypes = new int[]{funDef.getReturnCategory()};
        this.parameterTypes = new int[][]{funDef.getParameterCategories()};
        if (funDef instanceof FunDefBase && ((FunDefBase)funDef).signature != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ((FunDefBase)funDef).signature;
        } else {
            stringArray = FunInfo.makeSigs(this.syntax, this.name, this.returnTypes, this.parameterTypes);
        }
        this.sigs = stringArray;
        this.description = funDef.getDescription();
    }

    FunInfo(MultiResolver multiResolver) {
        this.syntax = multiResolver.getSyntax();
        this.name = multiResolver.getName();
        assert (this.name != null);
        assert (this.syntax != null);
        this.description = multiResolver.getDescription();
        String[] signatures = multiResolver.getSignatures();
        this.returnTypes = new int[signatures.length];
        this.parameterTypes = new int[signatures.length][];
        for (int i = 0; i < signatures.length; ++i) {
            this.returnTypes[i] = FunUtil.decodeReturnCategory(signatures[i]);
            this.parameterTypes[i] = FunUtil.decodeParameterCategories(signatures[i]);
        }
        this.sigs = FunInfo.makeSigs(this.syntax, this.name, this.returnTypes, this.parameterTypes);
    }

    FunInfo(Resolver resolver) {
        String[] stringArray;
        this.syntax = resolver.getSyntax();
        this.name = resolver.getName();
        assert (this.name != null);
        assert (this.syntax != null);
        this.description = resolver.getDescription();
        this.returnTypes = null;
        this.parameterTypes = null;
        String signature = resolver.getSignature();
        if (signature == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = signature;
        }
        this.sigs = stringArray;
    }

    FunInfo(String name, String description, String flags) {
        this.name = name;
        this.description = description;
        this.syntax = FunUtil.decodeSyntacticType(flags);
        this.returnTypes = new int[]{FunUtil.decodeReturnCategory(flags)};
        this.parameterTypes = new int[][]{FunUtil.decodeParameterCategories(flags)};
    }

    public String[] getSignatures() {
        return this.sigs;
    }

    private static String[] makeSigs(Syntax syntax, String name, int[] returnTypes, int[][] parameterTypes) {
        if (parameterTypes == null) {
            return null;
        }
        String[] sigs = new String[parameterTypes.length];
        for (int i = 0; i < sigs.length; ++i) {
            sigs[i] = syntax.getSignature(name, returnTypes[i], parameterTypes[i]);
        }
        return sigs;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int[] getReturnCategories() {
        return this.returnTypes;
    }

    public int[][] getParameterCategories() {
        return this.parameterTypes;
    }

    @Override
    public int compareTo(FunInfo fi) {
        int c = this.name.compareTo(fi.name);
        if (c != 0) {
            return c;
        }
        List<Object> pcList = FunInfo.toList(this.getParameterCategories());
        String pc = pcList.toString();
        List<Object> otherPcList = FunInfo.toList(fi.getParameterCategories());
        String otherPc = otherPcList.toString();
        return pc.compareTo(otherPc);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FunInfo) {
            FunInfo that = (FunInfo)obj;
            if (!this.name.equals(that.name)) {
                return false;
            }
            List<Object> pcList = FunInfo.toList(this.getParameterCategories());
            List<Object> pcList2 = FunInfo.toList(that.getParameterCategories());
            return pcList.equals(pcList2);
        }
        return false;
    }

    public int hashCode() {
        int h = this.name.hashCode();
        List<Object> pcList = FunInfo.toList(this.getParameterCategories());
        return Util.hash(h, pcList);
    }

    private static List<Object> toList(Object a) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (a == null) {
            return list;
        }
        int length = Array.getLength(a);
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(a, i);
            if (o.getClass().isArray()) {
                list.add(FunInfo.toList(o));
                continue;
            }
            list.add(o);
        }
        return list;
    }
}

