/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.DistinctFunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtractFunDef
extends FunDefBase {
    static final ResolverBase Resolver = new ResolverBase("Extract", "Extract(<Set>, <Hierarchy>[, <Hierarchy>...])", "Returns a set of tuples from extracted hierarchy elements. The opposite of Crossjoin.", Syntax.Function){

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (args.length < 2) {
                return null;
            }
            if (!validator.canConvert(0, args[0], 8, conversions)) {
                return null;
            }
            for (int i = 1; i < args.length; ++i) {
                if (validator.canConvert(0, args[i], 3, conversions)) continue;
                return null;
            }
            ArrayList extractedOrdinals = new ArrayList();
            ArrayList extractedHierarchies = new ArrayList();
            ExtractFunDef.findExtractedHierarchies(args, extractedHierarchies, extractedOrdinals);
            int[] parameterTypes = new int[args.length];
            parameterTypes[0] = 8;
            Arrays.fill(parameterTypes, 1, parameterTypes.length, 3);
            return new ExtractFunDef(this, 8, parameterTypes);
        }
    };

    private ExtractFunDef(Resolver resolver, int returnType, int[] parameterTypes) {
        super(resolver, returnType, parameterTypes);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        ArrayList<Hierarchy> extractedHierarchies = new ArrayList<Hierarchy>();
        ArrayList<Integer> extractedOrdinals = new ArrayList<Integer>();
        ExtractFunDef.findExtractedHierarchies(args, extractedHierarchies, extractedOrdinals);
        if (extractedHierarchies.size() == 1) {
            return new SetType(MemberType.forHierarchy((Hierarchy)extractedHierarchies.get(0)));
        }
        ArrayList<MemberType> typeList = new ArrayList<MemberType>();
        for (Hierarchy extractedHierarchy : extractedHierarchies) {
            typeList.add(MemberType.forHierarchy(extractedHierarchy));
        }
        return new SetType(new TupleType(typeList.toArray(new Type[typeList.size()])));
    }

    private static void findExtractedHierarchies(Exp[] args, List<Hierarchy> extractedHierarchies, List<Integer> extractedOrdinals) {
        SetType type = (SetType)args[0].getType();
        List<Hierarchy> hierarchies = type.getElementType() instanceof TupleType ? ((TupleType)type.getElementType()).getHierarchies() : Collections.singletonList(type.getHierarchy());
        for (Hierarchy hierarchy : hierarchies) {
            if (hierarchy != null) continue;
            throw new RuntimeException("hierarchy of argument not known");
        }
        for (int i = 1; i < args.length; ++i) {
            Exp arg = args[i];
            Hierarchy extractedHierarchy = null;
            if (arg instanceof HierarchyExpr) {
                HierarchyExpr hierarchyExpr = (HierarchyExpr)arg;
                extractedHierarchy = hierarchyExpr.getHierarchy();
            } else if (arg instanceof DimensionExpr) {
                DimensionExpr dimensionExpr = (DimensionExpr)arg;
                extractedHierarchy = dimensionExpr.getDimension().getHierarchy();
            }
            if (extractedHierarchy == null) {
                throw new RuntimeException("not a constant hierarchy: " + arg);
            }
            int ordinal = hierarchies.indexOf(extractedHierarchy);
            if (ordinal == -1) {
                throw new RuntimeException("hierarchy " + extractedHierarchy.getUniqueName() + " is not a hierarchy of the expression " + args[0]);
            }
            if (extractedOrdinals.indexOf(ordinal) >= 0) {
                throw new RuntimeException("hierarchy " + extractedHierarchy.getUniqueName() + " is extracted more than once");
            }
            extractedOrdinals.add(ordinal);
            extractedHierarchies.add(extractedHierarchy);
        }
    }

    private static int[] toIntArray(List<Integer> integerList) {
        int[] ints = new int[integerList.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = integerList.get(i);
        }
        return ints;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ArrayList<Hierarchy> extractedHierarchyList = new ArrayList<Hierarchy>();
        ArrayList<Integer> extractedOrdinalList = new ArrayList<Integer>();
        ExtractFunDef.findExtractedHierarchies(call.getArgs(), extractedHierarchyList, extractedOrdinalList);
        Util.assertTrue(extractedOrdinalList.size() == extractedHierarchyList.size());
        Exp arg = call.getArg(0);
        final ListCalc listCalc = compiler.compileList(arg, false);
        int inArity = arg.getType().getArity();
        final int outArity = extractedOrdinalList.size();
        if (inArity == 1) {
            Util.assertTrue(outArity == 1);
            return new DistinctFunDef.CalcImpl(call, listCalc);
        }
        final int[] extractedOrdinals = ExtractFunDef.toIntArray(extractedOrdinalList);
        return new AbstractListCalc(call, new Calc[]{listCalc}){

            public TupleList evaluateList(Evaluator evaluator) {
                TupleList result = TupleCollections.createList(outArity);
                TupleList list = listCalc.evaluateList(evaluator);
                HashSet<List> emittedTuples = new HashSet<List>();
                for (List members : list.project(extractedOrdinals)) {
                    if (!emittedTuples.add(members)) continue;
                    result.add(members);
                }
                return result;
            }
        };
    }
}

