/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.SlaveServerDetection;

public class GetSlavesServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = GetSlavesServlet.class;
    public static final String XML_TAG_SLAVESERVER_DETECTIONS = "SlaveServerDetections";
    private static final long serialVersionUID = -5472184538138241050L;
    public static final String CONTEXT_PATH = "/kettle/getSlaves";

    public GetSlavesServlet() {
    }

    public GetSlavesServlet(List<SlaveServerDetection> slaveServers) {
        super(slaveServers);
    }

    public GetSlavesServlet(List<SlaveServerDetection> slaveServers, boolean isJetty) {
        super(slaveServers, isJetty);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetStatusServlet.StatusRequested", (String[])new String[0]));
        }
        response.setStatus(200);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
        out.println(XMLHandler.openTag((String)XML_TAG_SLAVESERVER_DETECTIONS));
        if (this.getDetections() != null) {
            for (SlaveServerDetection slaveServer : this.getDetections()) {
                try {
                    slaveServer.getSlaveServer().getStatus();
                }
                catch (Exception e) {
                    slaveServer.setActive(false);
                    slaveServer.setLastInactiveDate(new Date());
                }
                out.println(slaveServer.getXML());
            }
        }
        out.println(XMLHandler.closeTag((String)XML_TAG_SLAVESERVER_DETECTIONS));
    }

    public String toString() {
        return "Get list of slave servers";
    }

    @Override
    public String getService() {
        return "/kettle/getSlaves (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

