/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices.wsdl;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.pentaho.di.trans.steps.webservices.wsdl.DomUtils;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOpReturnType;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlTypes;
import org.w3c.dom.Element;

public final class WsdlOpParameter
extends WsdlOpReturnType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private QName _name;
    private ParameterMode _mode;
    private boolean _isHeader;
    private boolean _elementFormQualified;

    WsdlOpParameter(String name, QName xmlType, Element schemaTypeElement, WsdlTypes wsdlTypes) {
        this.setName(name, wsdlTypes);
        this._xmlType = xmlType;
        this._itemXmlType = this.getArrayItemType(schemaTypeElement, wsdlTypes);
        this._isArray = this._itemXmlType != null;
        this._isHeader = false;
        this._mode = ParameterMode.UNDEFINED;
    }

    WsdlOpParameter(String name, Element e, WsdlTypes wsdlTypes) {
        this(e, wsdlTypes);
        this.setName(name, wsdlTypes);
    }

    WsdlOpParameter(Element e, WsdlTypes wsdlTypes) {
        this._mode = ParameterMode.UNDEFINED;
        this._isArray = this.isArray(e);
        this._isHeader = false;
        if (e.hasAttribute("name") && e.hasAttribute("type")) {
            this.setName(e.getAttribute("name"), wsdlTypes);
            this._xmlType = wsdlTypes.getTypeQName(e.getAttribute("type"));
        } else if (e.hasAttribute("ref")) {
            this._xmlType = wsdlTypes.getTypeQName(e.getAttribute("ref"));
            this._name = new QName("", this._xmlType.getLocalPart());
        } else if (e.hasAttribute("name")) {
            this.setName(e.getAttribute("name"), wsdlTypes);
            this._xmlType = this.getElementType(e, wsdlTypes);
        } else {
            throw new RuntimeException("invalid element: " + e.getNodeName());
        }
        Element t = wsdlTypes.findNamedType(this._xmlType);
        if (t != null && "complexType".equals(t.getLocalName())) {
            this._itemXmlType = this.getArrayItemType(t, wsdlTypes);
            boolean bl = this._isArray = this._itemXmlType != null;
            if (this._itemXmlType != null) {
                this._itemComplexType = wsdlTypes.getNamedComplexTypes().getComplexType(this._itemXmlType.getLocalPart());
            }
        }
    }

    public QName getName() {
        return this._name;
    }

    public ParameterMode getMode() {
        return this._mode;
    }

    public boolean isNameElementFormQualified() {
        return this._elementFormQualified;
    }

    public boolean isHeader() {
        return this._isHeader;
    }

    protected void setHeader() {
        this._isHeader = true;
    }

    protected void setMode(ParameterMode mode) {
        this._mode = mode;
    }

    protected void setName(String name, WsdlTypes wsdlTypes) {
        this._name = wsdlTypes.getTypeQName(name);
        this._elementFormQualified = wsdlTypes.isElementFormQualified(this._name.getNamespaceURI());
    }

    private boolean isArray(Element e) {
        if (e.hasAttribute("maxOccurs") && !"1".equals(e.getAttribute("maxOccurs"))) {
            return true;
        }
        if (e.hasAttribute("minOccurs")) {
            String minOccurs = e.getAttribute("minOccurs");
            try {
                int i = Integer.parseInt(minOccurs);
                if (i > 1) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private QName getElementType(Element element, WsdlTypes wsdlTypes) {
        Element child = DomUtils.getChildElementByName(element, "complexType");
        if (child != null) {
            if ((child = DomUtils.getChildElementByName(child, "sequence")) != null) {
                Element childElement = DomUtils.getChildElementByName(child, "element");
                if (childElement != null) {
                    if (child.hasAttribute("ref")) {
                        return wsdlTypes.getTypeQName(child.getAttribute("ref"));
                    }
                    if (child.hasAttribute("type")) {
                        return wsdlTypes.getTypeQName(child.getAttribute("type"));
                    }
                } else {
                    childElement = DomUtils.getChildElementByName(child, "any");
                    if (childElement != null) {
                        return new QName(childElement.getNamespaceURI(), childElement.getLocalName());
                    }
                }
            }
        } else {
            return new QName("http://www.w3.org/2001/XMLSchema", "any");
        }
        return new QName("http://www.w3.org/2001/XMLSchema", "String");
    }

    private QName getArrayItemType(Element type, WsdlTypes wsdlTypes) {
        if (type == null || "simpleElement".equals(type.getLocalName())) {
            return null;
        }
        Element sequence = DomUtils.getChildElementByName(type, "sequence");
        if (sequence != null) {
            return this.getArrayItemTypeFromSequence(sequence, wsdlTypes);
        }
        Element complexContent = DomUtils.getChildElementByName(type, "complexContent");
        if (complexContent != null) {
            return this.getArrayItemTypeFromComplexContent(complexContent, wsdlTypes);
        }
        return null;
    }

    private QName getArrayItemTypeFromSequence(Element sequenceElement, WsdlTypes wsdlTypes) {
        Element element = DomUtils.getChildElementByName(sequenceElement, "element");
        if (element == null) {
            return null;
        }
        if (!this.isArray(element)) {
            return null;
        }
        return wsdlTypes.getTypeQName(element.getAttribute("type"));
    }

    private QName getArrayItemTypeFromComplexContent(Element ccElement, WsdlTypes wsdlTypes) {
        Element restriction = DomUtils.getChildElementByName(ccElement, "restriction");
        if (restriction == null) {
            return null;
        }
        String base = restriction.getAttribute("base");
        if (!"soapenc:Array".equals(base)) {
            return null;
        }
        Element attribute = DomUtils.getChildElementByName(restriction, "attribute");
        if (attribute == null) {
            return null;
        }
        String arrayType = attribute.getAttribute("wsdl:arrayType");
        if (arrayType == null) {
            return null;
        }
        return wsdlTypes.getTypeQName(arrayType);
    }

    public boolean equals(Object o) {
        if (o instanceof WsdlOpParameter) {
            return this._name.equals(((WsdlOpParameter)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this._name);
    }

    public static class ParameterMode {
        private String mode;
        public static final ParameterMode IN = new ParameterMode("IN");
        public static final ParameterMode OUT = new ParameterMode("OUT");
        public static final ParameterMode INOUT = new ParameterMode("INOUT");
        public static final ParameterMode UNDEFINED = new ParameterMode("UNDEFINED");

        private ParameterMode(String mode) {
            this.mode = mode;
        }

        public String toString() {
            return this.mode;
        }
    }
}

