/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.cluster;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.crypto.IllegalBlockSizeException;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.encryption.CertificateGenEncryptUtil;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.SlaveStepCopyPartitionDistribution;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransMetaFactory;
import org.pentaho.di.trans.TransMetaFactoryImpl;
import org.pentaho.di.trans.step.RemoteStep;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.socketreader.SocketReaderMeta;
import org.pentaho.di.trans.steps.socketwriter.SocketWriterMeta;
import org.w3c.dom.Node;

public class TransSplitter {
    private static Class<?> PKG = TransMeta.class;
    private static final int FANOUT = 30;
    private static final int SPLIT = 120;
    private TransMeta originalTransformation;
    private Map<SlaveServer, TransMeta> slaveTransMap;
    private TransMeta masterTransMeta;
    private StepMeta[] referenceSteps;
    private Map<SlaveServer, Map<PartitionSchema, List<String>>> slaveServerPartitionsMap;
    private Map<TransMeta, Map<StepMeta, String>> slaveStepPartitionFlag;
    private SlaveStepCopyPartitionDistribution slaveStepCopyPartitionDistribution = new SlaveStepCopyPartitionDistribution();
    private int socketsBufferSize;
    private boolean compressingSocketStreams;
    private Map<String, Integer> portCache;
    private Map<TransMeta, String> carteObjectMap;
    private String clusteredRunId;
    private static final String STRING_TARGET_PARTITION_NAME_SUFFIX = " (target)";

    public TransSplitter() {
        this.clear();
    }

    private void clear() {
        this.slaveTransMap = new Hashtable<SlaveServer, TransMeta>();
        this.slaveStepPartitionFlag = new Hashtable<TransMeta, Map<StepMeta, String>>();
        this.portCache = new Hashtable<String, Integer>();
        this.carteObjectMap = new Hashtable<TransMeta, String>();
        this.clusteredRunId = UUID.randomUUID().toString();
    }

    public TransSplitter(TransMeta transMeta) throws KettleException {
        this(transMeta, new TransMetaFactoryImpl());
    }

    protected TransSplitter(TransMeta transMeta, TransMetaFactory transMetaFactory) throws KettleException {
        this();
        String transXML = transMeta.getXML();
        this.originalTransformation = transMetaFactory.create(XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)transXML), (String)"transformation"), null);
        this.originalTransformation.shareVariablesWith(transMeta);
        this.originalTransformation.copyParametersFrom(transMeta);
        this.originalTransformation.setRepository(transMeta.getRepository());
        this.originalTransformation.setRepositoryDirectory(transMeta.getRepositoryDirectory());
        Repository rep = transMeta.getRepository();
        if (rep != null) {
            rep.readTransSharedObjects(this.originalTransformation);
        }
        this.checkClusterConfiguration();
        ClusterSchema clusterSchema = this.originalTransformation.findFirstUsedClusterSchema();
        if (clusterSchema == null) {
            throw new KettleException("No clustering is used in this transformation.");
        }
        if (clusterSchema.isDynamic()) {
            List<SlaveServer> slaveServers = clusterSchema.getSlaveServersFromMasterOrLocal();
            SlaveServer masterSlaveServer = clusterSchema.findMaster();
            if (masterSlaveServer == null) {
                throw new KettleException("You always need at least one master in a cluster schema.");
            }
            slaveServers.add(0, masterSlaveServer);
            clusterSchema.setDynamic(false);
            clusterSchema.setSlaveServers(slaveServers);
        }
    }

    public TransMeta getOriginalTransformation() {
        return this.originalTransformation;
    }

    public void setOriginalTransformation(TransMeta originalTransformation) {
        this.originalTransformation = originalTransformation;
    }

    private void checkClusterConfiguration() throws KettleException {
        Hashtable<String, ClusterSchema> map = new Hashtable<String, ClusterSchema>();
        List<StepMeta> steps = this.originalTransformation.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            StepMeta step = steps.get(i);
            ClusterSchema clusterSchema = step.getClusterSchema();
            if (clusterSchema == null) continue;
            map.put(clusterSchema.getName(), clusterSchema);
            if (clusterSchema.findMaster() == null) {
                throw new KettleException("No master server was specified in cluster schema [" + clusterSchema + "]");
            }
            this.socketsBufferSize = Const.toInt((String)this.originalTransformation.environmentSubstitute(clusterSchema.getSocketsBufferSize()), (int)50000);
            this.compressingSocketStreams = clusterSchema.isSocketsCompressed();
            List<SlaveServer> slaves = clusterSchema.getSlaveServersFromMasterOrLocal();
            int count = 0;
            for (int s = 0; s < slaves.size(); ++s) {
                if (slaves.get(s).isMaster()) continue;
                ++count;
            }
            if (count > 0) continue;
            throw new KettleException("At least one slave server is required to be present in cluster schema [" + clusterSchema + "]");
        }
        if (map.size() == 0) {
            throw new KettleException("No cluster schemas are being used.  As such it is not possible to split and cluster this transformation.");
        }
        if (map.size() > 1) {
            throw new KettleException("At this time we don't support the use of multiple cluster schemas in one and the same transformation.");
        }
    }

    private String getWriterName(ClusterSchema clusterSchema, SlaveServer sourceSlaveServer, String sourceStepname, int sourceStepCopy, SlaveServer targetSlaveServer, String targetStepName, int targetStepCopy) throws Exception {
        return "Writer : " + this.getPort(clusterSchema, sourceSlaveServer, sourceStepname, sourceStepCopy, targetSlaveServer, targetStepName, targetStepCopy);
    }

    private String getReaderName(ClusterSchema clusterSchema, SlaveServer sourceSlaveServer, String sourceStepname, int sourceStepCopy, SlaveServer targetSlaveServer, String targetStepName, int targetStepCopy) throws Exception {
        return "Reader : " + this.getPort(clusterSchema, sourceSlaveServer, sourceStepname, sourceStepCopy, targetSlaveServer, targetStepName, targetStepCopy);
    }

    private String getSlaveTransName(String transName, ClusterSchema clusterSchema, SlaveServer slaveServer) {
        return transName + " (" + clusterSchema + ":" + slaveServer.getName() + ")";
    }

    private int getPort(ClusterSchema clusterSchema, SlaveServer sourceSlave, String sourceStepName, int sourceStepCopy, SlaveServer targetSlave, String targetStepName, int targetStepCopy) throws Exception {
        SlaveServer masterSlave = clusterSchema.findMaster();
        String portCacheKey = this.createPortCacheKey(sourceSlave, sourceStepName, sourceStepCopy, targetSlave, targetStepName, targetStepCopy);
        Integer portNumber = this.portCache.get(portCacheKey);
        if (portNumber != null) {
            return portNumber;
        }
        String realHostname = sourceSlave.environmentSubstitute(sourceSlave.getHostname());
        int port = masterSlave.allocateServerSocket(this.clusteredRunId, Const.toInt((String)clusterSchema.getBasePort(), (int)40000), realHostname, this.originalTransformation.getName(), sourceSlave.getName(), sourceStepName, Integer.toString(sourceStepCopy), targetSlave.getName(), targetStepName, Integer.toString(targetStepCopy));
        this.portCache.put(portCacheKey, port);
        return port;
    }

    public String createPortCacheKey(SlaveServer sourceSlave, String sourceStepName, int sourceStepCopy, SlaveServer targetSlave, String targetStepName, int targetStepCopy) {
        return this.clusteredRunId + "/" + sourceSlave.getHostname() + sourceSlave.getName() + "/" + sourceStepName + "." + sourceStepCopy + " - " + targetSlave.getName() + "/" + targetStepName + "." + targetStepCopy;
    }

    private TransMeta getSlaveTransformation(ClusterSchema clusterSchema, SlaveServer slaveServer) throws KettleException {
        TransMeta slave = this.slaveTransMap.get(slaveServer);
        if (slave == null) {
            slave = this.getOriginalCopy(true, clusterSchema, slaveServer);
            this.slaveTransMap.put(slaveServer, slave);
        }
        return slave;
    }

    private TransMeta getOriginalCopy(boolean isSlaveTrans, ClusterSchema clusterSchema, SlaveServer slaveServer) throws KettleException {
        TransMeta transMeta = new TransMeta();
        transMeta.setSlaveTransformation(true);
        if (isSlaveTrans) {
            transMeta.setName(this.getSlaveTransName(this.originalTransformation.getName(), clusterSchema, slaveServer));
            NotePadMeta slaveNote = new NotePadMeta("This is a generated slave transformation.\nIt will be run on slave server: " + slaveServer, 0, 0, -1, -1);
            transMeta.addNote(slaveNote);
            for (int i = 0; i < this.referenceSteps.length; ++i) {
                StepMeta stepMeta = this.referenceSteps[i];
                this.verifySlavePartitioningConfiguration(transMeta, stepMeta, clusterSchema, slaveServer);
            }
        } else {
            transMeta.setName(this.originalTransformation.getName() + " (master)");
            NotePadMeta masterNote = new NotePadMeta("This is a generated master transformation.\nIt will be run on server: " + this.getMasterServer(), 0, 0, -1, -1);
            transMeta.addNote(masterNote);
        }
        for (ClusterSchema schema : this.originalTransformation.getClusterSchemas()) {
            transMeta.getClusterSchemas().add(schema.clone());
        }
        transMeta.setDatabases(this.originalTransformation.getDatabases());
        transMeta.setFeedbackShown(this.originalTransformation.isFeedbackShown());
        transMeta.setFeedbackSize(this.originalTransformation.getFeedbackSize());
        transMeta.setUsingThreadPriorityManagment(this.originalTransformation.isUsingThreadPriorityManagment());
        transMeta.setUsingUniqueConnections(this.originalTransformation.isUsingUniqueConnections());
        transMeta.setRepository(this.originalTransformation.getRepository());
        transMeta.setRepositoryDirectory(this.originalTransformation.getRepositoryDirectory());
        transMeta.setTransLogTable((TransLogTable)this.originalTransformation.getTransLogTable().clone());
        transMeta.setSizeRowset(this.originalTransformation.getSizeRowset());
        return transMeta;
    }

    private void verifySlavePartitioningConfiguration(TransMeta slave, StepMeta stepMeta, ClusterSchema clusterSchema, SlaveServer slaveServer) {
        String targetSchemaName;
        PartitionSchema targetSchema;
        PartitionSchema partitionSchema;
        List<String> partitionsList;
        Map<PartitionSchema, List<String>> schemaPartitionsMap;
        Map<StepMeta, String> stepPartitionFlag = this.slaveStepPartitionFlag.get(slave);
        if (stepPartitionFlag == null) {
            stepPartitionFlag = new Hashtable<StepMeta, String>();
            this.slaveStepPartitionFlag.put(slave, stepPartitionFlag);
        }
        if (stepPartitionFlag.get(stepMeta) != null) {
            return;
        }
        StepPartitioningMeta partitioningMeta = stepMeta.getStepPartitioningMeta();
        if (partitioningMeta != null && partitioningMeta.getMethodType() != 0 && partitioningMeta.getPartitionSchema() != null && (schemaPartitionsMap = this.slaveServerPartitionsMap.get(slaveServer)) != null && (partitionsList = schemaPartitionsMap.get(partitionSchema = partitioningMeta.getPartitionSchema())) != null && (targetSchema = slave.findPartitionSchema(targetSchemaName = TransSplitter.createSlavePartitionSchemaName(partitionSchema.getName()))) == null) {
            targetSchema = new PartitionSchema(targetSchemaName, partitionsList);
            slave.getPartitionSchemas().add(targetSchema);
        }
        stepPartitionFlag.put(stepMeta, "Y");
    }

    public static String createSlavePartitionSchemaName(String name) {
        return name;
    }

    public static String createTargetPartitionSchemaName(String name) {
        return name + STRING_TARGET_PARTITION_NAME_SUFFIX;
    }

    public static String createPartitionSchemaNameFromTarget(String targetName) {
        if (targetName.endsWith(STRING_TARGET_PARTITION_NAME_SUFFIX)) {
            return targetName.substring(0, targetName.length() - STRING_TARGET_PARTITION_NAME_SUFFIX.length());
        }
        return targetName;
    }

    public TransMeta getMaster() {
        return this.masterTransMeta;
    }

    public Map<SlaveServer, TransMeta> getSlaveTransMap() {
        return this.slaveTransMap;
    }

    public TransMeta[] getSlaves() {
        Collection<TransMeta> collection = this.slaveTransMap.values();
        return collection.toArray(new TransMeta[collection.size()]);
    }

    public SlaveServer[] getSlaveTargets() {
        Set<SlaveServer> set = this.slaveTransMap.keySet();
        return set.toArray(new SlaveServer[set.size()]);
    }

    public SlaveServer getMasterServer() throws KettleException {
        StepMeta[] steps = this.originalTransformation.getStepsArray();
        for (int i = 0; i < steps.length; ++i) {
            ClusterSchema clusterSchema = steps[i].getClusterSchema();
            if (clusterSchema == null) continue;
            return clusterSchema.findMaster();
        }
        throw new KettleException("No master server could be found in the original transformation");
    }

    public void splitOriginalTransformation() throws KettleException {
        this.clear();
        this.findUsedOriginalSteps();
        this.checkClusterConfiguration();
        this.generateSlavePartitionSchemas();
        try {
            SlaveServer masterSlaveServer = this.getMasterServer();
            this.masterTransMeta = this.getOriginalCopy(false, null, null);
            ClusterSchema clusterSchema = this.originalTransformation.findFirstUsedClusterSchema();
            List<SlaveServer> slaveServers = clusterSchema.getSlaveServers();
            int nrSlavesNodes = clusterSchema.findNrSlaves();
            boolean encrypt = false;
            byte[] transformationKey = null;
            PublicKey pubK = null;
            if (encrypt) {
                KeyPair pair = CertificateGenEncryptUtil.generateKeyPair();
                pubK = pair.getPublic();
                PrivateKey privK = pair.getPrivate();
                Key key1 = CertificateGenEncryptUtil.generateSingleKey();
                try {
                    transformationKey = CertificateGenEncryptUtil.encodeKeyForTransmission((Key)privK, (Key)key1);
                }
                catch (InvalidKeyException ex) {
                    this.masterTransMeta.getLogChannel().logError("Invalid key was used for encoding", (Throwable)ex);
                }
                catch (IllegalBlockSizeException ex) {
                    this.masterTransMeta.getLogChannel().logError("Error happenned during key encoding", (Throwable)ex);
                }
                catch (Exception ex) {
                    this.masterTransMeta.getLogChannel().logError("Error happenned during encryption initialization", (Throwable)ex);
                }
            }
            for (int r = 0; r < this.referenceSteps.length; ++r) {
                StepMeta referenceStep = this.referenceSteps[r];
                List<StepMeta> prevSteps = this.originalTransformation.findPreviousSteps(referenceStep);
                int nrPreviousSteps = prevSteps.size();
                for (int p = 0; p < nrPreviousSteps; ++p) {
                    RemoteStep remoteMasterStep;
                    LinkedList<Integer> masterStepCopyNumbers;
                    StepMeta previousStep = prevSteps.get(p);
                    if (!referenceStep.isClustered()) {
                        if (!previousStep.isClustered()) {
                            StepMeta source;
                            StepMeta target = this.masterTransMeta.findStep(referenceStep.getName());
                            if (target == null) {
                                target = (StepMeta)referenceStep.clone();
                                this.masterTransMeta.addStep(target);
                            }
                            if ((source = this.masterTransMeta.findStep(previousStep.getName())) == null) {
                                source = (StepMeta)previousStep.clone();
                                this.masterTransMeta.addStep(source);
                            }
                            TransHopMeta masterHop = new TransHopMeta(source, target);
                            this.masterTransMeta.addTransHop(masterHop);
                            continue;
                        }
                        StepMeta masterStep = this.masterTransMeta.findStep(referenceStep.getName());
                        if (masterStep == null) {
                            masterStep = (StepMeta)referenceStep.clone();
                            masterStep.setLocation(masterStep.getLocation().x, masterStep.getLocation().y);
                            this.masterTransMeta.addStep(masterStep);
                        }
                        masterStepCopyNumbers = new LinkedList<Integer>();
                        for (int i = 0; i < masterStep.getCopies(); ++i) {
                            masterStepCopyNumbers.add(i);
                        }
                        for (int slaveNr = 0; slaveNr < slaveServers.size(); ++slaveNr) {
                            SlaveServer sourceSlaveServer = slaveServers.get(slaveNr);
                            if (sourceSlaveServer.isMaster()) continue;
                            TransMeta slave = this.getSlaveTransformation(clusterSchema, sourceSlaveServer);
                            StepMeta slaveStep = slave.findStep(previousStep.getName());
                            if (slaveStep == null) {
                                slaveStep = this.addSlaveCopy(slave, previousStep, sourceSlaveServer);
                            }
                            StepPartitioningMeta previousStepPartitioningMeta = previousStep.getStepPartitioningMeta();
                            PartitionSchema previousPartitionSchema = previousStepPartitioningMeta.getPartitionSchema();
                            int nrOfSourceCopies = this.determineNrOfStepCopies(sourceSlaveServer, previousStep);
                            if (masterStep.getCopies() != 1 && masterStep.getCopies() != nrOfSourceCopies) {
                                String message = BaseMessages.getString(PKG, (String)"TransSplitter.Clustering.CopyNumberStep", (Object[])new Object[]{nrSlavesNodes, previousStep.getName(), masterStep.getName()});
                                throw new KettleException(message);
                            }
                            for (int sourceCopyNr = 0; sourceCopyNr < nrOfSourceCopies; ++sourceCopyNr) {
                                Integer masterStepCopyNr = (Integer)masterStepCopyNumbers.poll();
                                if (masterStepCopyNr == null) {
                                    masterStepCopyNr = 0;
                                }
                                int port = this.getPort(clusterSchema, sourceSlaveServer, slaveStep.getName(), sourceCopyNr, masterSlaveServer, masterStep.getName(), masterStepCopyNr);
                                remoteMasterStep = new RemoteStep(sourceSlaveServer.getHostname(), masterSlaveServer.getHostname(), Integer.toString(port), slaveStep.getName(), sourceCopyNr, masterStep.getName(), masterStepCopyNr, sourceSlaveServer.getName(), masterSlaveServer.getName(), this.socketsBufferSize, this.compressingSocketStreams, this.originalTransformation.getStepFields(previousStep));
                                remoteMasterStep.setEncryptingStreams(encrypt);
                                remoteMasterStep.setKey(transformationKey);
                                masterStep.getRemoteInputSteps().add(remoteMasterStep);
                                RemoteStep remoteSlaveStep = new RemoteStep(sourceSlaveServer.getHostname(), masterSlaveServer.getHostname(), Integer.toString(port), slaveStep.getName(), sourceCopyNr, masterStep.getName(), masterStepCopyNr, sourceSlaveServer.getName(), masterSlaveServer.getName(), this.socketsBufferSize, this.compressingSocketStreams, this.originalTransformation.getStepFields(previousStep));
                                remoteSlaveStep.setEncryptingStreams(encrypt);
                                remoteSlaveStep.setKey(transformationKey);
                                slaveStep.getRemoteOutputSteps().add(remoteSlaveStep);
                                if (!slaveStep.isPartitioned()) continue;
                                this.slaveStepCopyPartitionDistribution.addPartition(sourceSlaveServer.getName(), previousPartitionSchema.getName(), sourceCopyNr);
                            }
                            if (!referenceStep.isPartitioned()) continue;
                            StepPartitioningMeta stepPartitioningMeta = previousStepPartitioningMeta.clone();
                            PartitionSchema partitionSchema = stepPartitioningMeta.getPartitionSchema();
                            partitionSchema.setName(TransSplitter.createTargetPartitionSchemaName(partitionSchema.getName()));
                            if (partitionSchema.isDynamicallyDefined()) {
                                partitionSchema.expandPartitionsDynamically(clusterSchema.findNrSlaves(), this.originalTransformation);
                            }
                            masterStep.setTargetStepPartitioningMeta(stepPartitioningMeta);
                            this.masterTransMeta.addOrReplacePartitionSchema(partitionSchema);
                            stepPartitioningMeta = previousStepPartitioningMeta.clone();
                            partitionSchema = stepPartitioningMeta.getPartitionSchema();
                            partitionSchema.setName(TransSplitter.createSlavePartitionSchemaName(partitionSchema.getName()));
                            if (partitionSchema.isDynamicallyDefined()) {
                                partitionSchema.expandPartitionsDynamically(clusterSchema.findNrSlaves(), this.originalTransformation);
                            }
                            partitionSchema.retainPartitionsForSlaveServer(clusterSchema.findNrSlaves(), this.getSlaveServerNumber(clusterSchema, sourceSlaveServer));
                            slave.addOrReplacePartitionSchema(partitionSchema);
                        }
                        continue;
                    }
                    if (!previousStep.isClustered()) {
                        StepMeta sourceStep = this.masterTransMeta.findStep(previousStep.getName());
                        if (sourceStep == null) {
                            sourceStep = (StepMeta)previousStep.clone();
                            sourceStep.setLocation(previousStep.getLocation().x, previousStep.getLocation().y);
                            this.masterTransMeta.addStep(sourceStep);
                        }
                        masterStepCopyNumbers = new LinkedList();
                        for (int i = 0; i < sourceStep.getCopies(); ++i) {
                            masterStepCopyNumbers.add(i);
                        }
                        for (int s = 0; s < slaveServers.size(); ++s) {
                            SlaveServer targetSlaveServer = slaveServers.get(s);
                            if (targetSlaveServer.isMaster()) continue;
                            TransMeta slaveTransMeta = this.getSlaveTransformation(clusterSchema, targetSlaveServer);
                            StepMeta targetStep = slaveTransMeta.findStep(referenceStep.getName());
                            if (targetStep == null) {
                                targetStep = this.addSlaveCopy(slaveTransMeta, referenceStep, targetSlaveServer);
                            }
                            StepPartitioningMeta targetStepPartitioningMeta = referenceStep.getStepPartitioningMeta();
                            PartitionSchema targetPartitionSchema = targetStepPartitioningMeta.getPartitionSchema();
                            int nrOfTargetCopies = this.determineNrOfStepCopies(targetSlaveServer, referenceStep);
                            for (int targetCopyNr = 0; targetCopyNr < nrOfTargetCopies; ++targetCopyNr) {
                                Integer masterStepCopyNr = (Integer)masterStepCopyNumbers.poll();
                                if (masterStepCopyNr == null) {
                                    masterStepCopyNr = 0;
                                }
                                int port = this.getPort(clusterSchema, masterSlaveServer, sourceStep.getName(), masterStepCopyNr, targetSlaveServer, referenceStep.getName(), targetCopyNr);
                                remoteMasterStep = new RemoteStep(masterSlaveServer.getHostname(), targetSlaveServer.getHostname(), Integer.toString(port), sourceStep.getName(), masterStepCopyNr, referenceStep.getName(), targetCopyNr, masterSlaveServer.getName(), targetSlaveServer.getName(), this.socketsBufferSize, this.compressingSocketStreams, this.originalTransformation.getStepFields(previousStep));
                                remoteMasterStep.setEncryptingStreams(encrypt);
                                remoteMasterStep.setKey(transformationKey);
                                sourceStep.getRemoteOutputSteps().add(remoteMasterStep);
                                RemoteStep remoteSlaveStep = new RemoteStep(masterSlaveServer.getHostname(), targetSlaveServer.getHostname(), Integer.toString(port), sourceStep.getName(), masterStepCopyNr, referenceStep.getName(), targetCopyNr, masterSlaveServer.getName(), targetSlaveServer.getName(), this.socketsBufferSize, this.compressingSocketStreams, this.originalTransformation.getStepFields(previousStep));
                                remoteSlaveStep.setEncryptingStreams(encrypt);
                                remoteSlaveStep.setKey(transformationKey);
                                targetStep.getRemoteInputSteps().add(remoteSlaveStep);
                                if (!targetStep.isPartitioned()) continue;
                                this.slaveStepCopyPartitionDistribution.addPartition(targetSlaveServer.getName(), targetPartitionSchema.getName(), targetCopyNr);
                            }
                            if (!targetStepPartitioningMeta.isPartitioned()) continue;
                            StepPartitioningMeta stepPartitioningMeta = targetStepPartitioningMeta.clone();
                            PartitionSchema partitionSchema = stepPartitioningMeta.getPartitionSchema();
                            partitionSchema.setName(TransSplitter.createTargetPartitionSchemaName(partitionSchema.getName()));
                            if (partitionSchema.isDynamicallyDefined()) {
                                partitionSchema.expandPartitionsDynamically(clusterSchema.findNrSlaves(), this.originalTransformation);
                            }
                            sourceStep.setTargetStepPartitioningMeta(stepPartitioningMeta);
                            this.masterTransMeta.addOrReplacePartitionSchema(partitionSchema);
                            stepPartitioningMeta = targetStepPartitioningMeta.clone();
                            partitionSchema = stepPartitioningMeta.getPartitionSchema();
                            partitionSchema.setName(TransSplitter.createSlavePartitionSchemaName(partitionSchema.getName()));
                            if (partitionSchema.isDynamicallyDefined()) {
                                partitionSchema.expandPartitionsDynamically(clusterSchema.findNrSlaves(), this.originalTransformation);
                            }
                            partitionSchema.retainPartitionsForSlaveServer(clusterSchema.findNrSlaves(), this.getSlaveServerNumber(clusterSchema, targetSlaveServer));
                            slaveTransMeta.addOrReplacePartitionSchema(partitionSchema);
                        }
                        continue;
                    }
                    for (int slaveNr = 0; slaveNr < slaveServers.size(); ++slaveNr) {
                        StepMeta sourceStep;
                        SlaveServer targetSlaveServer = slaveServers.get(slaveNr);
                        if (targetSlaveServer.isMaster()) continue;
                        TransMeta slaveTransMeta = this.getSlaveTransformation(clusterSchema, targetSlaveServer);
                        StepMeta targetStep = slaveTransMeta.findStep(referenceStep.getName());
                        if (targetStep == null) {
                            targetStep = this.addSlaveCopy(slaveTransMeta, referenceStep, targetSlaveServer);
                        }
                        if ((sourceStep = slaveTransMeta.findStep(previousStep.getName())) == null) {
                            sourceStep = this.addSlaveCopy(slaveTransMeta, previousStep, targetSlaveServer);
                        }
                        TransHopMeta slaveHop = new TransHopMeta(sourceStep, targetStep);
                        slaveTransMeta.addTransHop(slaveHop);
                        StepPartitioningMeta sourceStepPartitioningMeta = previousStep.getStepPartitioningMeta();
                        StepPartitioningMeta targetStepPartitioningMeta = referenceStep.getStepPartitioningMeta();
                        if (previousStep.isPartitioned() && referenceStep.isPartitioned() && sourceStepPartitioningMeta.equals(targetStepPartitioningMeta)) {
                            StepPartitioningMeta stepPartitioningMeta = sourceStepPartitioningMeta.clone();
                            PartitionSchema partitionSchema = stepPartitioningMeta.getPartitionSchema();
                            partitionSchema.setName(TransSplitter.createSlavePartitionSchemaName(partitionSchema.getName()));
                            if (partitionSchema.isDynamicallyDefined()) {
                                partitionSchema.expandPartitionsDynamically(clusterSchema.findNrSlaves(), this.originalTransformation);
                            }
                            partitionSchema.retainPartitionsForSlaveServer(clusterSchema.findNrSlaves(), this.getSlaveServerNumber(clusterSchema, targetSlaveServer));
                            sourceStep.setStepPartitioningMeta(stepPartitioningMeta);
                            targetStep.setStepPartitioningMeta(stepPartitioningMeta);
                            slaveTransMeta.addOrReplacePartitionSchema(partitionSchema);
                            continue;
                        }
                        if ((previousStep.isPartitioned() || !referenceStep.isPartitioned()) && (!previousStep.isPartitioned() || !referenceStep.isPartitioned() || sourceStepPartitioningMeta.equals(targetStep.getStepPartitioningMeta()))) continue;
                        PartitionSchema targetPartitionSchema = targetStepPartitioningMeta.getPartitionSchema();
                        PartitionSchema sourcePartitionSchema = sourceStepPartitioningMeta.getPartitionSchema();
                        for (int partSlaveNr = 0; partSlaveNr < slaveServers.size(); ++partSlaveNr) {
                            SlaveServer sourceSlaveServer = slaveServers.get(partSlaveNr);
                            if (sourceSlaveServer.isMaster()) continue;
                            Map<PartitionSchema, List<String>> partitionsMap = this.slaveServerPartitionsMap.get(sourceSlaveServer);
                            int nrOfTargetPartitions = 1;
                            if (targetStep.isPartitioned() && targetPartitionSchema != null) {
                                List<String> targetPartitionsList = partitionsMap.get(targetPartitionSchema);
                                nrOfTargetPartitions = targetPartitionsList.size();
                            } else if (targetStep.getCopies() > 1) {
                                nrOfTargetPartitions = targetStep.getCopies();
                            }
                            int nrOfSourcePartitions = 1;
                            if (sourceStep.isPartitioned() && sourcePartitionSchema != null) {
                                List<String> sourcePartitionsList = partitionsMap.get(sourcePartitionSchema);
                                nrOfSourcePartitions = sourcePartitionsList.size();
                            } else if (sourceStep.getCopies() > 1) {
                                nrOfSourcePartitions = sourceStep.getCopies();
                            }
                            for (int sourceCopyNr = 0; sourceCopyNr < nrOfSourcePartitions; ++sourceCopyNr) {
                                for (int targetCopyNr = 0; targetCopyNr < nrOfTargetPartitions; ++targetCopyNr) {
                                    if (!targetSlaveServer.equals(sourceSlaveServer)) {
                                        int outPort = this.getPort(clusterSchema, targetSlaveServer, sourceStep.getName(), sourceCopyNr, sourceSlaveServer, targetStep.getName(), targetCopyNr);
                                        RemoteStep remoteOutputStep = new RemoteStep(targetSlaveServer.getHostname(), sourceSlaveServer.getHostname(), Integer.toString(outPort), sourceStep.getName(), sourceCopyNr, targetStep.getName(), targetCopyNr, targetSlaveServer.getName(), sourceSlaveServer.getName(), this.socketsBufferSize, this.compressingSocketStreams, this.originalTransformation.getStepFields(previousStep));
                                        remoteOutputStep.setEncryptingStreams(encrypt);
                                        remoteOutputStep.setKey(transformationKey);
                                        sourceStep.getRemoteOutputSteps().add(remoteOutputStep);
                                        int inPort = this.getPort(clusterSchema, sourceSlaveServer, sourceStep.getName(), sourceCopyNr, targetSlaveServer, targetStep.getName(), targetCopyNr);
                                        RemoteStep remoteInputStep = new RemoteStep(sourceSlaveServer.getHostname(), targetSlaveServer.getHostname(), Integer.toString(inPort), sourceStep.getName(), sourceCopyNr, targetStep.getName(), targetCopyNr, sourceSlaveServer.getName(), targetSlaveServer.getName(), this.socketsBufferSize, this.compressingSocketStreams, this.originalTransformation.getStepFields(previousStep));
                                        remoteInputStep.setEncryptingStreams(encrypt);
                                        remoteInputStep.setKey(transformationKey);
                                        targetStep.getRemoteInputSteps().add(remoteInputStep);
                                    }
                                    this.slaveStepCopyPartitionDistribution.addPartition(sourceSlaveServer.getName(), targetPartitionSchema.getName(), targetCopyNr);
                                }
                            }
                            if (sourceStepPartitioningMeta.isPartitioned()) {
                                StepPartitioningMeta stepPartitioningMeta = sourceStepPartitioningMeta.clone();
                                PartitionSchema partitionSchema = stepPartitioningMeta.getPartitionSchema();
                                partitionSchema.setName(TransSplitter.createSlavePartitionSchemaName(partitionSchema.getName()));
                                if (partitionSchema.isDynamicallyDefined()) {
                                    partitionSchema.expandPartitionsDynamically(clusterSchema.findNrSlaves(), this.originalTransformation);
                                }
                                partitionSchema.retainPartitionsForSlaveServer(clusterSchema.findNrSlaves(), this.getSlaveServerNumber(clusterSchema, targetSlaveServer));
                                sourceStep.setStepPartitioningMeta(stepPartitioningMeta);
                                slaveTransMeta.addOrReplacePartitionSchema(partitionSchema);
                            }
                            if (targetStepPartitioningMeta.isPartitioned()) {
                                StepPartitioningMeta stepPartitioningMeta = targetStepPartitioningMeta.clone();
                                PartitionSchema partitionSchema = stepPartitioningMeta.getPartitionSchema();
                                partitionSchema.setName(TransSplitter.createSlavePartitionSchemaName(partitionSchema.getName()));
                                if (partitionSchema.isDynamicallyDefined()) {
                                    partitionSchema.expandPartitionsDynamically(clusterSchema.findNrSlaves(), this.originalTransformation);
                                }
                                partitionSchema.retainPartitionsForSlaveServer(clusterSchema.findNrSlaves(), this.getSlaveServerNumber(clusterSchema, targetSlaveServer));
                                targetStep.setStepPartitioningMeta(stepPartitioningMeta);
                                slaveTransMeta.addOrReplacePartitionSchema(partitionSchema);
                            }
                            if (sourceStepPartitioningMeta.isPartitioned() && sourceStepPartitioningMeta.equals(targetStepPartitioningMeta)) continue;
                            StepPartitioningMeta stepPartitioningMeta = targetStepPartitioningMeta.clone();
                            PartitionSchema partitionSchema = stepPartitioningMeta.getPartitionSchema();
                            partitionSchema.setName(TransSplitter.createTargetPartitionSchemaName(partitionSchema.getName()));
                            if (partitionSchema.isDynamicallyDefined()) {
                                partitionSchema.expandPartitionsDynamically(clusterSchema.findNrSlaves(), this.originalTransformation);
                            }
                            sourceStep.setTargetStepPartitioningMeta(stepPartitioningMeta);
                            slaveTransMeta.addOrReplacePartitionSchema(partitionSchema);
                        }
                    }
                }
                if (nrPreviousSteps != 0) continue;
                if (!referenceStep.isClustered()) {
                    if (this.masterTransMeta.findStep(referenceStep.getName()) != null) continue;
                    this.masterTransMeta.addStep((StepMeta)referenceStep.clone());
                    continue;
                }
                for (int s = 0; s < slaveServers.size(); ++s) {
                    TransMeta slave;
                    SlaveServer slaveServer = slaveServers.get(s);
                    if (slaveServer.isMaster() || (slave = this.getSlaveTransformation(clusterSchema, slaveServer)).findStep(referenceStep.getName()) != null) continue;
                    this.addSlaveCopy(slave, referenceStep, slaveServer);
                }
            }
            for (int i = 0; i < this.referenceSteps.length; ++i) {
                StepMeta originalStep = this.referenceSteps[i];
                StepMeta[] infoSteps = this.originalTransformation.getInfoStep(originalStep);
                for (int p = 0; infoSteps != null && p < infoSteps.length; ++p) {
                    StepMeta infoStep = infoSteps[p];
                    if (infoStep == null) continue;
                    if (!originalStep.isClustered()) {
                        if (!infoStep.isClustered()) {
                            StepMeta target = this.masterTransMeta.findStep(originalStep.getName());
                            StepMeta source = this.masterTransMeta.findStep(infoStep.getName());
                            TransHopMeta masterHop = new TransHopMeta(source, target);
                            this.masterTransMeta.addTransHop(masterHop);
                            continue;
                        }
                        int nrSlaves = clusterSchema.getSlaveServers().size();
                        for (int s = 0; s < nrSlaves; ++s) {
                            TransHopMeta mergeHop;
                            SlaveServer sourceSlaveServer = clusterSchema.getSlaveServers().get(s);
                            if (sourceSlaveServer.isMaster()) continue;
                            TransMeta slave = this.getSlaveTransformation(clusterSchema, sourceSlaveServer);
                            SocketWriterMeta socketWriterMeta = new SocketWriterMeta();
                            int port = this.getPort(clusterSchema, sourceSlaveServer, infoStep.getName(), 0, masterSlaveServer, originalStep.getName(), 0);
                            socketWriterMeta.setPort("" + port);
                            socketWriterMeta.setBufferSize(clusterSchema.getSocketsBufferSize());
                            socketWriterMeta.setFlushInterval(clusterSchema.getSocketsFlushInterval());
                            socketWriterMeta.setCompressed(clusterSchema.isSocketsCompressed());
                            StepMeta writerStep = new StepMeta(this.getWriterName(clusterSchema, sourceSlaveServer, infoStep.getName(), 0, masterSlaveServer, originalStep.getName(), 0), socketWriterMeta);
                            writerStep.setLocation(infoStep.getLocation().x + 50, infoStep.getLocation().y + 50);
                            writerStep.setDraw(true);
                            slave.addStep(writerStep);
                            TransHopMeta slaveHop = new TransHopMeta(infoStep, writerStep);
                            if (slave.findTransHop(slaveHop) == null) {
                                slave.addTransHop(slaveHop);
                            }
                            SocketReaderMeta socketReaderMeta = new SocketReaderMeta();
                            socketReaderMeta.setPort("" + port);
                            socketReaderMeta.setBufferSize(clusterSchema.getSocketsBufferSize());
                            socketReaderMeta.setCompressed(clusterSchema.isSocketsCompressed());
                            StepMeta readerStep = new StepMeta(this.getReaderName(clusterSchema, sourceSlaveServer, infoStep.getName(), 0, masterSlaveServer, originalStep.getName(), 0), socketReaderMeta);
                            readerStep.setLocation(infoStep.getLocation().x, infoStep.getLocation().y + s * 30 * 2 - nrSlaves * 30 / 2);
                            readerStep.setDraw(true);
                            this.masterTransMeta.addStep(readerStep);
                            String dummyName = infoStep.getName();
                            StepMeta dummyStep = this.masterTransMeta.findStep(dummyName);
                            if (dummyStep == null) {
                                DummyTransMeta dummy = new DummyTransMeta();
                                dummyStep = new StepMeta(dummyName, dummy);
                                dummyStep.setLocation(infoStep.getLocation().x + 60, infoStep.getLocation().y);
                                dummyStep.setDraw(true);
                                dummyStep.setDescription("This step merges the data from the various data streams coming from the slave transformations.\nIt does that right before it hits the step that reads from a specific (info) step.");
                                this.masterTransMeta.addStep(dummyStep);
                                StepMeta masterTargetStep = this.masterTransMeta.findStep(originalStep.getName());
                                TransHopMeta targetHop = new TransHopMeta(dummyStep, masterTargetStep);
                                this.masterTransMeta.addTransHop(targetHop);
                                String[] infoStepNames = masterTargetStep.getStepMetaInterface().getStepIOMeta().getInfoStepnames();
                                if (infoStepNames != null) {
                                    StepMeta[] is = new StepMeta[infoStepNames.length];
                                    for (int n = 0; n < infoStepNames.length; ++n) {
                                        is[n] = slave.findStep(infoStepNames[n]);
                                        if (!infoStepNames[n].equals(infoStep.getName())) continue;
                                        infoSteps[n] = readerStep;
                                    }
                                    masterTargetStep.getStepMetaInterface().getStepIOMeta().setInfoSteps(infoSteps);
                                }
                            }
                            if (this.masterTransMeta.findTransHop(mergeHop = new TransHopMeta(readerStep, dummyStep)) != null) continue;
                            this.masterTransMeta.addTransHop(mergeHop);
                        }
                        continue;
                    }
                    if (!infoStep.isClustered()) {
                        for (int s = 0; s < slaveServers.size(); ++s) {
                            SlaveServer targetSlaveServer = slaveServers.get(s);
                            if (targetSlaveServer.isMaster()) continue;
                            SocketWriterMeta socketWriterMeta = new SocketWriterMeta();
                            socketWriterMeta.setPort("" + this.getPort(clusterSchema, masterSlaveServer, infoStep.getName(), 0, targetSlaveServer, originalStep.getName(), 0));
                            socketWriterMeta.setBufferSize(clusterSchema.getSocketsBufferSize());
                            socketWriterMeta.setFlushInterval(clusterSchema.getSocketsFlushInterval());
                            socketWriterMeta.setCompressed(clusterSchema.isSocketsCompressed());
                            StepMeta writerStep = new StepMeta(this.getWriterName(clusterSchema, masterSlaveServer, infoStep.getName(), 0, targetSlaveServer, originalStep.getName(), 0), socketWriterMeta);
                            writerStep.setLocation(originalStep.getLocation().x, originalStep.getLocation().y + s * 30 * 2 - nrSlavesNodes * 30 / 2);
                            writerStep.setDraw(originalStep.isDrawn());
                            this.masterTransMeta.addStep(writerStep);
                            StepMeta previous = this.masterTransMeta.findStep(infoStep.getName());
                            if (previous == null) {
                                previous = (StepMeta)infoStep.clone();
                                this.masterTransMeta.addStep(previous);
                            }
                            TransHopMeta masterHop = new TransHopMeta(previous, writerStep);
                            this.masterTransMeta.addTransHop(masterHop);
                            TransMeta slave = this.getSlaveTransformation(clusterSchema, targetSlaveServer);
                            SocketReaderMeta socketReaderMeta = new SocketReaderMeta();
                            socketReaderMeta.setHostname(masterSlaveServer.getHostname());
                            socketReaderMeta.setPort("" + this.getPort(clusterSchema, masterSlaveServer, infoStep.getName(), 0, targetSlaveServer, originalStep.getName(), 0));
                            socketReaderMeta.setBufferSize(clusterSchema.getSocketsBufferSize());
                            socketReaderMeta.setCompressed(clusterSchema.isSocketsCompressed());
                            StepMeta readerStep = new StepMeta(this.getReaderName(clusterSchema, masterSlaveServer, infoStep.getName(), 0, targetSlaveServer, originalStep.getName(), 0), socketReaderMeta);
                            readerStep.setLocation(originalStep.getLocation().x - 60, originalStep.getLocation().y);
                            readerStep.setDraw(originalStep.isDrawn());
                            slave.addStep(readerStep);
                            StepMeta slaveStep = slave.findStep(originalStep.getName());
                            if (slaveStep == null) {
                                slaveStep = this.addSlaveCopy(slave, originalStep, targetSlaveServer);
                            }
                            TransHopMeta slaveHop = new TransHopMeta(readerStep, slaveStep);
                            slave.addTransHop(slaveHop);
                            String[] infoStepNames = slaveStep.getStepMetaInterface().getStepIOMeta().getInfoStepnames();
                            if (infoStepNames == null) continue;
                            StepMeta[] is = new StepMeta[infoStepNames.length];
                            for (int n = 0; n < infoStepNames.length; ++n) {
                                is[n] = slave.findStep(infoStepNames[n]);
                                if (!infoStepNames[n].equals(infoStep.getName())) continue;
                                infoSteps[n] = readerStep;
                            }
                            slaveStep.getStepMetaInterface().getStepIOMeta().setInfoSteps(infoSteps);
                        }
                        continue;
                    }
                    for (int s = 0; s < slaveServers.size(); ++s) {
                        TransMeta slave;
                        StepMeta slaveStep;
                        String[] infoStepNames;
                        SlaveServer slaveServer = slaveServers.get(s);
                        if (slaveServer.isMaster() || (infoStepNames = (slaveStep = (slave = this.getSlaveTransformation(clusterSchema, slaveServer)).findStep(originalStep.getName())).getStepMetaInterface().getStepIOMeta().getInfoStepnames()) == null) continue;
                        StepMeta[] is = new StepMeta[infoStepNames.length];
                        for (int n = 0; n < infoStepNames.length; ++n) {
                            is[n] = slave.findStep(infoStepNames[n]);
                            if (slave.findTransHop(is[n], slaveStep) != null) continue;
                            TransHopMeta infoHop = new TransHopMeta(is[n], slaveStep);
                            slave.addTransHop(infoHop);
                        }
                        slaveStep.getStepMetaInterface().getStepIOMeta().setInfoSteps(infoSteps);
                    }
                }
            }
            this.slaveStepCopyPartitionDistribution.setOriginalPartitionSchemas(this.originalTransformation.getPartitionSchemas());
            for (TransMeta transMeta : this.slaveTransMap.values()) {
                transMeta.setSlaveStepCopyPartitionDistribution(this.slaveStepCopyPartitionDistribution);
                if (encrypt) {
                    transMeta.setKey(pubK.getEncoded());
                    transMeta.setPrivateKey(false);
                }
                transMeta.clearChanged();
            }
            this.masterTransMeta.addOrReplacePartitionSchema(this.originalTransformation.getPartitionSchemas());
            this.masterTransMeta.setSlaveStepCopyPartitionDistribution(this.slaveStepCopyPartitionDistribution);
            if (encrypt) {
                this.masterTransMeta.setKey(pubK.getEncoded());
                this.masterTransMeta.setPrivateKey(true);
            }
            this.masterTransMeta.clearChanged();
        }
        catch (Exception e) {
            throw new KettleException("Unexpected problem while generating master transformation", (Throwable)e);
        }
    }

    private int determineNrOfStepCopies(SlaveServer slaveServer, StepMeta step) {
        if (!step.isClustered()) {
            return step.getCopies();
        }
        if (!step.isPartitioned()) {
            return step.getCopies();
        }
        if (slaveServer.isMaster()) {
            return step.getCopies();
        }
        StepPartitioningMeta stepPartitioningMeta = step.getStepPartitioningMeta();
        PartitionSchema partitionSchema = stepPartitioningMeta.getPartitionSchema();
        Map<PartitionSchema, List<String>> partitionMap = this.slaveServerPartitionsMap.get(slaveServer);
        List<String> partitionList = partitionMap.get(partitionSchema);
        return partitionList.size();
    }

    private int getSlaveServerNumber(ClusterSchema clusterSchema, SlaveServer slaveServer) throws KettleException {
        int index = 0;
        for (SlaveServer check : clusterSchema.getSlaveServers()) {
            if (check.isMaster()) continue;
            if (check.equals(slaveServer)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private StepMeta addSlaveCopy(TransMeta transMeta, StepMeta stepMeta, SlaveServer slaveServer) {
        StepMeta copy = (StepMeta)stepMeta.clone();
        if (copy.isPartitioned()) {
            StepPartitioningMeta stepPartitioningMeta = copy.getStepPartitioningMeta();
            PartitionSchema partitionSchema = stepPartitioningMeta.getPartitionSchema();
            String slavePartitionSchemaName = TransSplitter.createSlavePartitionSchemaName(partitionSchema.getName());
            PartitionSchema slaveSchema = transMeta.findPartitionSchema(slavePartitionSchemaName);
            if (slaveSchema != null) {
                stepPartitioningMeta.setPartitionSchema(slaveSchema);
            }
            copy.setCopies(1);
        }
        copy.setClusterSchema(null);
        transMeta.addStep(copy);
        return copy;
    }

    private void findUsedOriginalSteps() {
        List<StepMeta> transHopSteps = this.originalTransformation.getTransHopSteps(false);
        this.referenceSteps = transHopSteps.toArray(new StepMeta[transHopSteps.size()]);
    }

    private void generateSlavePartitionSchemas() throws KettleException {
        this.slaveServerPartitionsMap = new Hashtable<SlaveServer, Map<PartitionSchema, List<String>>>();
        for (int i = 0; i < this.referenceSteps.length; ++i) {
            int nrPartitions;
            ClusterSchema clusterSchema;
            StepMeta stepMeta = this.referenceSteps[i];
            StepPartitioningMeta stepPartitioningMeta = stepMeta.getStepPartitioningMeta();
            if (stepPartitioningMeta == null || stepPartitioningMeta.getMethodType() == 0 || (clusterSchema = stepMeta.getClusterSchema()) == null) continue;
            PartitionSchema partitionSchema = (PartitionSchema)stepPartitioningMeta.getPartitionSchema().clone();
            int nrSlaves = clusterSchema.findNrSlaves();
            if (nrSlaves == 0) continue;
            if (partitionSchema.isDynamicallyDefined()) {
                partitionSchema.expandPartitionsDynamically(nrSlaves, this.originalTransformation);
            }
            if ((nrPartitions = partitionSchema.getPartitionIDs().size()) < nrSlaves) {
                throw new KettleException("It doesn't make sense to have a partitioned, clustered step with less partitions (" + nrPartitions + ") than that there are slave servers (" + nrSlaves + ")");
            }
            int slaveServerNr = 0;
            List<SlaveServer> slaveServers = clusterSchema.getSlaveServers();
            for (int p = 0; p < nrPartitions; ++p) {
                List<String> partitions;
                Map<PartitionSchema, List<String>> schemaPartitionsMap;
                String partitionId = partitionSchema.getPartitionIDs().get(p);
                SlaveServer slaveServer = slaveServers.get(slaveServerNr);
                if (slaveServer.isMaster()) {
                    if (++slaveServerNr >= slaveServers.size()) {
                        slaveServerNr = 0;
                    }
                    slaveServer = slaveServers.get(slaveServerNr);
                }
                if ((schemaPartitionsMap = this.slaveServerPartitionsMap.get(slaveServer)) == null) {
                    schemaPartitionsMap = new HashMap<PartitionSchema, List<String>>();
                    this.slaveServerPartitionsMap.put(slaveServer, schemaPartitionsMap);
                }
                if ((partitions = schemaPartitionsMap.get(partitionSchema)) == null) {
                    partitions = new ArrayList<String>();
                    schemaPartitionsMap.put(partitionSchema, partitions);
                }
                if (partitions.indexOf(partitionId) < 0) {
                    partitions.add(partitionId);
                }
                if (++slaveServerNr < clusterSchema.getSlaveServers().size()) continue;
                slaveServerNr = 0;
            }
        }
    }

    public Map<TransMeta, String> getCarteObjectMap() {
        return this.carteObjectMap;
    }

    public String getClusteredRunId() {
        return this.clusteredRunId;
    }
}

