/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sendnagiospassivecheck;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.builders.MessagePayloadBuilder;
import com.googlecode.jsendnsca.builders.NagiosSettingsBuilder;
import com.googlecode.jsendnsca.encryption.Encryption;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntrySendNagiosPassiveCheck
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySendNagiosPassiveCheck.class;
    private String serverName = null;
    private String port = "" + DEFAULT_PORT;
    private String responseTimeOut;
    private String connectionTimeOut = String.valueOf(DEFAULT_CONNECTION_TIME_OUT);
    private String message = null;
    private String senderServerName = null;
    private String senderServiceName = null;
    private int encryptionMode = 0;
    private int level = 0;
    private String password = null;
    private static int DEFAULT_RESPONSE_TIME_OUT = 10000;
    public static int DEFAULT_CONNECTION_TIME_OUT = 5000;
    public static int DEFAULT_PORT = 5667;
    public static final String[] encryption_mode_Desc = new String[]{BaseMessages.getString(PKG, (String)"JobSendNagiosPassiveCheck.EncryptionMode.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSendNagiosPassiveCheck.EncryptionMode.TripleDES", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSendNagiosPassiveCheck.EncryptionMode.XOR", (String[])new String[0])};
    public static final String[] encryption_mode_Code = new String[]{"none", "tripledes", "xor"};
    public static final int ENCRYPTION_MODE_NONE = 0;
    public static final int ENCRYPTION_MODE_TRIPLEDES = 1;
    public static final int ENCRYPTION_MODE_XOR = 2;
    public static final String[] level_type_Desc = new String[]{BaseMessages.getString(PKG, (String)"JobSendNagiosPassiveCheck.LevelType.Unknown", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSendNagiosPassiveCheck.EncryptionMode.OK", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSendNagiosPassiveCheck.EncryptionMode.Warning", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSendNagiosPassiveCheck.EncryptionMode.Critical", (String[])new String[0])};
    public static final String[] level_type_Code = new String[]{"unknown", "ok", "warning", "critical"};
    public static final int LEVEL_TYPE_UNKNOWN = 0;
    public static final int LEVEL_TYPE_OK = 1;
    public static final int LEVEL_TYPE_WARNING = 2;
    public static final int LEVEL_TYPE_CRITICAL = 3;

    public JobEntrySendNagiosPassiveCheck(String n) {
        super(n, "");
        this.responseTimeOut = String.valueOf(DEFAULT_RESPONSE_TIME_OUT);
    }

    public JobEntrySendNagiosPassiveCheck() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySendNagiosPassiveCheck je = (JobEntrySendNagiosPassiveCheck)super.clone();
        return je;
    }

    public static int getEncryptionModeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < encryption_mode_Desc.length; ++i) {
            if (!encryption_mode_Desc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySendNagiosPassiveCheck.getEncryptionModeByCode(tt);
    }

    public static String getEncryptionModeDesc(int i) {
        if (i < 0 || i >= encryption_mode_Desc.length) {
            return encryption_mode_Desc[0];
        }
        return encryption_mode_Desc[i];
    }

    public static String getLevelDesc(int i) {
        if (i < 0 || i >= level_type_Desc.length) {
            return level_type_Desc[0];
        }
        return level_type_Desc[i];
    }

    public static int getLevelByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < level_type_Desc.length; ++i) {
            if (!level_type_Desc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntrySendNagiosPassiveCheck.getEncryptionModeByCode(tt);
    }

    private static String getEncryptionModeCode(int i) {
        if (i < 0 || i >= encryption_mode_Code.length) {
            return encryption_mode_Code[0];
        }
        return encryption_mode_Code[i];
    }

    private String getLevelCode(int i) {
        if (i < 0 || i >= level_type_Code.length) {
            return level_type_Code[0];
        }
        return level_type_Code[i];
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)this.password));
        retval.append("      ").append(XMLHandler.addTagValue((String)"responseTimeOut", (String)this.responseTimeOut));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connectionTimeOut", (String)this.connectionTimeOut));
        retval.append("      ").append(XMLHandler.addTagValue((String)"senderServerName", (String)this.senderServerName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"senderServiceName", (String)this.senderServiceName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"message", (String)this.message));
        retval.append("      ").append(XMLHandler.addTagValue((String)"encryptionMode", (String)JobEntrySendNagiosPassiveCheck.getEncryptionModeCode(this.encryptionMode)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"level", (String)this.getLevelCode(this.level)));
        return retval.toString();
    }

    private static int getEncryptionModeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < encryption_mode_Code.length; ++i) {
            if (!encryption_mode_Code[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getLevelByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < level_type_Code.length; ++i) {
            if (!level_type_Code[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.responseTimeOut = XMLHandler.getTagValue((Node)entrynode, (String)"responseTimeOut");
            this.connectionTimeOut = XMLHandler.getTagValue((Node)entrynode, (String)"connectionTimeOut");
            this.password = XMLHandler.getTagValue((Node)entrynode, (String)"password");
            this.senderServerName = XMLHandler.getTagValue((Node)entrynode, (String)"senderServerName");
            this.senderServiceName = XMLHandler.getTagValue((Node)entrynode, (String)"senderServiceName");
            this.message = XMLHandler.getTagValue((Node)entrynode, (String)"message");
            this.encryptionMode = JobEntrySendNagiosPassiveCheck.getEncryptionModeByCode(XMLHandler.getTagValue((Node)entrynode, (String)"encryptionMode"));
            this.level = JobEntrySendNagiosPassiveCheck.getLevelByCode(XMLHandler.getTagValue((Node)entrynode, (String)"level"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'SendNagiosPassiveCheck' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.password = rep.getJobEntryAttributeString(id_jobentry, "password");
            this.responseTimeOut = rep.getJobEntryAttributeString(id_jobentry, "responseTimeOut");
            this.connectionTimeOut = rep.getJobEntryAttributeString(id_jobentry, "connectionTimeOut");
            this.senderServerName = rep.getJobEntryAttributeString(id_jobentry, "senderServerName");
            this.senderServiceName = rep.getJobEntryAttributeString(id_jobentry, "senderServiceName");
            this.message = rep.getJobEntryAttributeString(id_jobentry, "message");
            this.encryptionMode = JobEntrySendNagiosPassiveCheck.getEncryptionModeByCode(rep.getJobEntryAttributeString(id_jobentry, "encryptionMode"));
            this.level = JobEntrySendNagiosPassiveCheck.getLevelByCode(rep.getJobEntryAttributeString(id_jobentry, "level"));
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'SendNagiosPassiveCheck' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", this.password);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "responseTimeOut", this.responseTimeOut);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "connectionTimeOut", this.connectionTimeOut);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "senderServerName", this.senderServerName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "senderServiceName", this.senderServiceName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "message", this.message);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "encryptionMode", JobEntrySendNagiosPassiveCheck.getEncryptionModeCode(this.encryptionMode));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "level", this.getLevelCode(this.level));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'SendNagiosPassiveCheck' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getSenderServerName() {
        return this.senderServerName;
    }

    public void setSenderServerName(String senderServerName) {
        this.senderServerName = senderServerName;
    }

    public String getSenderServiceName() {
        return this.senderServiceName;
    }

    public void setSenderServiceName(String senderServiceName) {
        this.senderServiceName = senderServiceName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public int getEncryptionMode() {
        return this.encryptionMode;
    }

    public void setEncryptionMode(int encryptionModein) {
        this.encryptionMode = encryptionModein;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int levelMode) {
        this.level = levelMode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setResponseTimeOut(String responseTimeOut) {
        this.responseTimeOut = responseTimeOut;
    }

    public String getResponseTimeOut() {
        return this.responseTimeOut;
    }

    public void setConnectionTimeOut(String connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public String getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        this.log.logBasic(BaseMessages.getString(PKG, (String)"JobEntrySendNagiosPassiveCheck.Started", (String[])new String[]{this.serverName}));
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String realServername = this.environmentSubstitute(this.serverName);
        String realPassword = Utils.resolvePassword((VariableSpace)this.variables, (String)this.password);
        int realPort = Const.toInt((String)this.environmentSubstitute(this.port), (int)DEFAULT_PORT);
        int realResponseTimeOut = Const.toInt((String)this.environmentSubstitute(this.responseTimeOut), (int)DEFAULT_RESPONSE_TIME_OUT);
        int realConnectionTimeOut = Const.toInt((String)this.environmentSubstitute(this.connectionTimeOut), (int)DEFAULT_CONNECTION_TIME_OUT);
        String realSenderServerName = this.environmentSubstitute(this.senderServerName);
        String realSenderServiceName = this.environmentSubstitute(this.senderServiceName);
        try {
            if (Utils.isEmpty((CharSequence)realServername)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobSendNagiosPassiveCheck.Error.TargetServerMissing", (String[])new String[0]));
            }
            String realMessageString = this.environmentSubstitute(this.message);
            if (Utils.isEmpty((CharSequence)realMessageString)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobSendNagiosPassiveCheck.Error.MessageMissing", (String[])new String[0]));
            }
            Level level = Level.UNKNOWN;
            switch (this.getLevel()) {
                case 1: {
                    level = Level.OK;
                    break;
                }
                case 3: {
                    level = Level.CRITICAL;
                    break;
                }
                case 2: {
                    level = Level.WARNING;
                    break;
                }
            }
            Encryption encr = Encryption.NONE;
            switch (this.getEncryptionMode()) {
                case 1: {
                    encr = Encryption.TRIPLE_DES;
                    break;
                }
                case 2: {
                    encr = Encryption.XOR;
                    break;
                }
            }
            NagiosSettingsBuilder ns = new NagiosSettingsBuilder();
            ns.withNagiosHost(realServername);
            ns.withPort(realPort);
            ns.withConnectionTimeout(realConnectionTimeOut);
            ns.withResponseTimeout(realResponseTimeOut);
            ns.withEncryption(encr);
            if (!Utils.isEmpty((CharSequence)realPassword)) {
                ns.withPassword(realPassword);
            } else {
                ns.withNoPassword();
            }
            NagiosSettings settings = ns.create();
            MessagePayloadBuilder pb = new MessagePayloadBuilder();
            if (!Utils.isEmpty((CharSequence)realSenderServerName)) {
                pb.withHostname(realSenderServerName);
            }
            pb.withLevel(level);
            if (!Utils.isEmpty((CharSequence)realSenderServiceName)) {
                pb.withServiceName(realSenderServiceName);
            }
            pb.withMessage(realMessageString);
            MessagePayload payload = pb.create();
            NagiosPassiveCheckSender sender = new NagiosPassiveCheckSender(settings);
            sender.send(payload);
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"JobEntrySendNagiosPassiveCheck.ErrorGetting", (String[])new String[]{e.toString()}));
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Utils.isEmpty((CharSequence)this.serverName)) {
            String realServername = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

