/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeCategoriesOrder;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginTypeCategoriesOrder(getNaturalCategoriesOrder={"BaseStep.Category.Input", "BaseStep.Category.Output", "BaseStep.Category.Streaming", "BaseStep.Category.Transform", "BaseStep.Category.Utility", "BaseStep.Category.Flow", "BaseStep.Category.Scripting", "BaseStep.Category.BAServer", "BaseStep.Category.Lookup", "BaseStep.Category.Joins", "BaseStep.Category.DataWarehouse", "BaseStep.Category.Validation", "BaseStep.Category.Statistics", "BaseStep.Category.DataMining", "BaseStep.Category.BigData", "BaseStep.Category.Agile", "BaseStep.Category.DataQuality", "BaseStep.Category.Cryptography", "BaseStep.Category.Palo", "BaseStep.Category.OpenERP", "BaseStep.Category.Job", "BaseStep.Category.Mapping", "BaseStep.Category.Bulk", "BaseStep.Category.Inline", "BaseStep.Category.Experimental", "BaseStep.Category.Deprecated"}, i18nPackageClass=StepInterface.class)
@PluginMainClassType(value=StepMetaInterface.class)
@PluginAnnotationType(value=Step.class)
public class StepPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static StepPluginType stepPluginType;

    protected StepPluginType() {
        super(Step.class, "STEP", "Step");
        this.populateFolders("steps");
    }

    public static StepPluginType getInstance() {
        if (stepPluginType == null) {
            stepPluginType = new StepPluginType();
        }
        return stepPluginType;
    }

    protected String getXmlPluginFile() {
        return "kettle-steps.xml";
    }

    protected String getAlternativePluginFile() {
        return "KETTLE_CORE_STEPS_FILE";
    }

    protected String getMainTag() {
        return "steps";
    }

    protected String getSubTag() {
        return "step";
    }

    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile((FileObject)file);
                    Node pluginNode = XMLHandler.getSubNode((Node)document, (String)"plugin");
                    if (pluginNode == null) continue;
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename((FileObject)file.getParent()), ((Object)((Object)this)).getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading step plugin.xml file: " + file.getName().toString(), (Throwable)e);
                }
            }
        }
    }

    protected String extractCategory(Annotation annotation) {
        return ((Step)annotation).categoryDescription();
    }

    protected String extractDesc(Annotation annotation) {
        return ((Step)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((Step)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((Step)annotation).name();
    }

    protected String extractImageFile(Annotation annotation) {
        return ((Step)annotation).image();
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return ((Step)annotation).isSeparateClassLoaderNeeded();
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return ((Step)annotation).i18nPackageName();
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    protected String extractDocumentationUrl(Annotation annotation) {
        return Const.getDocUrl((String)((Step)annotation).documentationUrl());
    }

    protected String extractCasesUrl(Annotation annotation) {
        return ((Step)annotation).casesUrl();
    }

    protected String extractForumUrl(Annotation annotation) {
        return ((Step)annotation).forumUrl();
    }

    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((Step)annotation).classLoaderGroup();
    }

    protected String extractSuggestion(Annotation annotation) {
        return ((Step)annotation).suggestion();
    }
}

