/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.pentaho.di.core.SwingUniversalImage;
import org.pentaho.di.core.SwingUniversalImageBitmap;
import org.pentaho.di.core.SwingUniversalImageSvg;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.svg.SvgImage;
import org.pentaho.di.core.svg.SvgSupport;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;

public class SwingGUIResource {
    private static LogChannelInterface log = new LogChannel((Object)"SwingGUIResource");
    private static SwingGUIResource instance;
    private Map<String, SwingUniversalImage> stepImages = this.loadStepImages();
    private Map<String, SwingUniversalImage> entryImages = this.loadEntryImages();

    private SwingGUIResource() {
    }

    public static SwingGUIResource getInstance() {
        if (instance == null) {
            instance = new SwingGUIResource();
        }
        return instance;
    }

    private Map<String, SwingUniversalImage> loadStepImages() {
        HashMap<String, SwingUniversalImage> map = new HashMap<String, SwingUniversalImage>();
        for (PluginInterface plugin : PluginRegistry.getInstance().getPlugins(StepPluginType.class)) {
            try {
                SwingUniversalImage image = this.getUniversalImageIcon(plugin);
                for (String id : plugin.getIds()) {
                    map.put(id, image);
                }
            }
            catch (Exception e) {
                log.logError("Unable to load step icon image for plugin: " + plugin.getName() + " (id=" + plugin.getIds()[0] + ")", (Throwable)e);
            }
        }
        return map;
    }

    private Map<String, SwingUniversalImage> loadEntryImages() {
        HashMap<String, SwingUniversalImage> map = new HashMap<String, SwingUniversalImage>();
        for (PluginInterface plugin : PluginRegistry.getInstance().getPlugins(JobEntryPluginType.class)) {
            try {
                if ("SPECIAL".equals(plugin.getIds()[0])) continue;
                SwingUniversalImage image = this.getUniversalImageIcon(plugin);
                if (image == null) {
                    throw new KettleException("Unable to find image file: " + plugin.getImageFile() + " for plugin: " + plugin);
                }
                map.put(plugin.getIds()[0], image);
            }
            catch (Exception e) {
                log.logError("Unable to load job entry icon image for plugin: " + plugin.getName() + " (id=" + plugin.getIds()[0] + ")", (Throwable)e);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwingUniversalImage getUniversalImageIcon(PluginInterface plugin) throws KettleException {
        try {
            InputStream inputStream;
            PluginRegistry registry = PluginRegistry.getInstance();
            String filename = plugin.getImageFile();
            ClassLoader classLoader = registry.getClassLoader(plugin);
            SwingUniversalImageSvg image = null;
            if (SvgSupport.isSvgEnabled() && SvgSupport.isSvgName((String)filename)) {
                inputStream = classLoader.getResourceAsStream(filename);
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream("/" + filename);
                }
                if (inputStream == null) {
                    inputStream = registry.getClass().getResourceAsStream(filename);
                }
                if (inputStream == null) {
                    inputStream = registry.getClass().getResourceAsStream("/" + filename);
                }
                if (inputStream == null) {
                    try {
                        inputStream = new FileInputStream(filename);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        SvgImage svg = SvgSupport.loadSvgImage((InputStream)inputStream);
                        image = new SwingUniversalImageSvg(svg);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                }
            }
            if (image == null) {
                inputStream = classLoader.getResourceAsStream(filename = SvgSupport.toPngName((String)filename));
                if (inputStream == null) {
                    inputStream = classLoader.getResourceAsStream("/" + filename);
                }
                if (inputStream == null) {
                    inputStream = registry.getClass().getResourceAsStream(filename);
                }
                if (inputStream == null) {
                    inputStream = registry.getClass().getResourceAsStream("/" + filename);
                }
                if (inputStream == null) {
                    try {
                        inputStream = new FileInputStream(filename);
                    }
                    catch (FileNotFoundException svg) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        BufferedImage bitmap = ImageIO.read(inputStream);
                        WaitingImageObserver wia = new WaitingImageObserver((Image)bitmap);
                        wia.waitImageLoaded();
                        image = new SwingUniversalImageBitmap(bitmap);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                }
            }
            if (image == null) {
                throw new KettleException("Unable to find file: " + plugin.getImageFile() + " for plugin: " + plugin);
            }
            return image;
        }
        catch (Throwable e) {
            throw new KettleException("Unable to load image from file : '" + plugin.getImageFile() + "' for plugin: " + plugin, e);
        }
    }

    public Map<String, SwingUniversalImage> getEntryImages() {
        return this.entryImages;
    }

    public Map<String, SwingUniversalImage> getStepImages() {
        return this.stepImages;
    }
}

