/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.util.List;
import org.pentaho.di.core.AddUndoPositionInterface;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.Redrawable;
import org.pentaho.di.core.gui.UndoInterface;

public class SnapAllignDistribute {
    private List<? extends GUIPositionInterface> elements;
    private AddUndoPositionInterface addUndoPositionInterface;
    private int[] indices;
    private Redrawable redrawable;
    private UndoInterface undoInterface;

    public SnapAllignDistribute(UndoInterface undoInterface, List<? extends GUIPositionInterface> elements, int[] indices, AddUndoPositionInterface addUndoPositionInterface, Redrawable redrawable) {
        this.undoInterface = undoInterface;
        this.elements = elements;
        this.indices = indices;
        this.addUndoPositionInterface = addUndoPositionInterface;
        this.redrawable = redrawable;
    }

    public void snaptogrid(int size) {
        if (this.elements.isEmpty()) {
            return;
        }
        Object[] elemArray = new GUIPositionInterface[this.elements.size()];
        Point[] before = new Point[this.elements.size()];
        Point[] after = new Point[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            GUIPositionInterface positionInterface;
            elemArray[i] = positionInterface = this.elements.get(i);
            Point p = positionInterface.getLocation();
            before[i] = new Point(p.x, p.y);
            int dx = p.x % size;
            int dy = p.y % size;
            p.x = dx > size / 2 ? (p.x += size - dx) : (p.x -= dx);
            p.y = dy > size / 2 ? (p.y += size - dy) : (p.y -= dy);
            after[i] = new Point(p.x, p.y);
        }
        if (this.addUndoPositionInterface != null) {
            this.addUndoPositionInterface.addUndoPosition(this.undoInterface, elemArray, this.indices, before, after);
        }
        this.redrawable.redraw();
    }

    public void allignleft() {
        Point p;
        GUIPositionInterface element;
        int i;
        if (this.elements.isEmpty()) {
            return;
        }
        Object[] elemArray = this.elements.toArray(new GUIPositionInterface[this.elements.size()]);
        Point[] before = new Point[this.elements.size()];
        Point[] after = new Point[this.elements.size()];
        int min = 99999;
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            p = element.getLocation();
            if (p.x >= min) continue;
            min = p.x;
        }
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            p = element.getLocation();
            before[i] = new Point(p.x, p.y);
            element.setLocation(min, p.y);
            after[i] = new Point(min, p.y);
        }
        if (this.addUndoPositionInterface != null) {
            this.addUndoPositionInterface.addUndoPosition(this.undoInterface, elemArray, this.indices, before, after);
        }
        this.redrawable.redraw();
    }

    public void allignright() {
        Point p;
        int i;
        if (this.elements.isEmpty()) {
            return;
        }
        Object[] elemArray = this.elements.toArray(new GUIPositionInterface[this.elements.size()]);
        Point[] before = new Point[this.elements.size()];
        Point[] after = new Point[this.elements.size()];
        int max = -99999;
        for (i = 0; i < this.elements.size(); ++i) {
            GUIPositionInterface element = this.elements.get(i);
            p = element.getLocation();
            if (p.x <= max) continue;
            max = p.x;
        }
        for (i = 0; i < this.elements.size(); ++i) {
            GUIPositionInterface stepMeta = this.elements.get(i);
            p = stepMeta.getLocation();
            before[i] = new Point(p.x, p.y);
            stepMeta.setLocation(max, p.y);
            after[i] = new Point(max, p.y);
        }
        if (this.addUndoPositionInterface != null) {
            this.addUndoPositionInterface.addUndoPosition(this.undoInterface, elemArray, this.indices, before, after);
        }
        this.redrawable.redraw();
    }

    public void alligntop() {
        Point p;
        GUIPositionInterface element;
        int i;
        if (this.elements.isEmpty()) {
            return;
        }
        Object[] elemArray = this.elements.toArray(new GUIPositionInterface[this.elements.size()]);
        Point[] before = new Point[this.elements.size()];
        Point[] after = new Point[this.elements.size()];
        int min = 99999;
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            p = element.getLocation();
            if (p.y >= min) continue;
            min = p.y;
        }
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            p = element.getLocation();
            before[i] = new Point(p.x, p.y);
            element.setLocation(p.x, min);
            after[i] = new Point(p.x, min);
        }
        if (this.addUndoPositionInterface != null) {
            this.addUndoPositionInterface.addUndoPosition(this.undoInterface, elemArray, this.indices, before, after);
        }
        this.redrawable.redraw();
    }

    public void allignbottom() {
        Point p;
        GUIPositionInterface element;
        int i;
        if (this.elements.isEmpty()) {
            return;
        }
        Object[] elemArray = this.elements.toArray(new GUIPositionInterface[this.elements.size()]);
        Point[] before = new Point[this.elements.size()];
        Point[] after = new Point[this.elements.size()];
        int max = -99999;
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            p = element.getLocation();
            if (p.y <= max) continue;
            max = p.y;
        }
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            p = element.getLocation();
            before[i] = new Point(p.x, p.y);
            element.setLocation(p.x, max);
            after[i] = new Point(p.x, max);
        }
        if (this.addUndoPositionInterface != null) {
            this.addUndoPositionInterface.addUndoPosition(this.undoInterface, elemArray, this.indices, before, after);
        }
        this.redrawable.redraw();
    }

    public void distributehorizontal() {
        int i;
        if (this.elements.size() <= 1) {
            return;
        }
        Object[] elemArray = this.elements.toArray(new GUIPositionInterface[this.elements.size()]);
        Point[] before = new Point[this.elements.size()];
        Point[] after = new Point[this.elements.size()];
        int min = 99999;
        int max = -99999;
        int[] order = new int[this.elements.size()];
        for (i = 0; i < this.elements.size(); ++i) {
            GUIPositionInterface element = this.elements.get(i);
            Point p = element.getLocation();
            if (p.x < min) {
                min = p.x;
            }
            if (p.x > max) {
                max = p.x;
            }
            order[i] = i;
        }
        for (i = 0; i < this.elements.size(); ++i) {
            for (int j = 0; j < this.elements.size() - 1; ++j) {
                Point p1 = this.elements.get(order[j]).getLocation();
                Point p2 = this.elements.get(order[j + 1]).getLocation();
                if (p1.x <= p2.x) continue;
                int dummy = order[j];
                order[j] = order[j + 1];
                order[j + 1] = dummy;
                dummy = this.indices[j];
                this.indices[j] = this.indices[j + 1];
                this.indices[j + 1] = dummy;
            }
        }
        int distance = (max - min) / (this.elements.size() - 1);
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            GUIPositionInterface element = this.elements.get(order[i2]);
            Point p = element.getLocation();
            before[i2] = new Point(p.x, p.y);
            p.x = min + i2 * distance;
            after[i2] = new Point(p.x, p.y);
            elemArray[i2] = element;
        }
        if (this.addUndoPositionInterface != null) {
            this.addUndoPositionInterface.addUndoPosition(this.undoInterface, elemArray, this.indices, before, after);
        }
        this.redrawable.redraw();
    }

    public void distributevertical() {
        int i;
        if (this.elements.size() <= 1) {
            return;
        }
        Object[] elemArray = this.elements.toArray(new GUIPositionInterface[this.elements.size()]);
        Point[] before = new Point[this.elements.size()];
        Point[] after = new Point[this.elements.size()];
        int min = 99999;
        int max = -99999;
        int[] order = new int[this.elements.size()];
        for (i = 0; i < this.elements.size(); ++i) {
            GUIPositionInterface element = this.elements.get(i);
            Point p = element.getLocation();
            if (p.y < min) {
                min = p.y;
            }
            if (p.y > max) {
                max = p.y;
            }
            order[i] = i;
        }
        for (i = 0; i < this.elements.size(); ++i) {
            for (int j = 0; j < this.elements.size() - 1; ++j) {
                Point p1 = this.elements.get(order[j]).getLocation();
                Point p2 = this.elements.get(order[j + 1]).getLocation();
                if (p1.y <= p2.y) continue;
                int dummy = order[j];
                order[j] = order[j + 1];
                order[j + 1] = dummy;
                dummy = this.indices[j];
                this.indices[j] = this.indices[j + 1];
                this.indices[j + 1] = dummy;
            }
        }
        int distance = (max - min) / (this.elements.size() - 1);
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            GUIPositionInterface element = this.elements.get(order[i2]);
            Point p = element.getLocation();
            before[i2] = new Point(p.x, p.y);
            p.y = min + i2 * distance;
            after[i2] = new Point(p.x, p.y);
            elemArray[i2] = element;
        }
        if (this.addUndoPositionInterface != null) {
            this.addUndoPositionInterface.addUndoPosition(this.undoInterface, elemArray, this.indices, before, after);
        }
        this.redrawable.redraw();
    }
}

