/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.math.NumberUtils;
import org.pentaho.di.base.IParams;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;

public class Params
implements IParams {
    private String uuid;
    private String repoName;
    private String blockRepoConns;
    private String repoUsername;
    private String trustRepoUser;
    private String repoPassword;
    private String inputDir;
    private String inputFile;
    private String listRepoFiles;
    private String listRepoDirs;
    private String exportRepo;
    private String localFile;
    private String localJarFile;
    private String localInitialDir;
    private String listRepos;
    private String safeMode;
    private String metrics;
    private String listFileParams;
    private String logLevel;
    private String maxLogLines;
    private String maxLogTimeout;
    private String logFile;
    private String oldLogFile;
    private String version;
    private String resultSetStepName;
    private String resultSetCopyNumber;
    private String base64Zip;
    private NamedParams namedParams;
    private NamedParams customNamedParams;

    private Params() {
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    @Override
    public String getBlockRepoConns() {
        return this.blockRepoConns;
    }

    public void setBlockRepoConns(String blockRepoConns) {
        this.blockRepoConns = blockRepoConns;
    }

    @Override
    public String getRepoUsername() {
        return this.repoUsername;
    }

    public void setRepoUsername(String repoUsername) {
        this.repoUsername = repoUsername;
    }

    @Override
    public String getTrustRepoUser() {
        return this.trustRepoUser;
    }

    public void setTrustRepoUser(String trustRepoUser) {
        this.trustRepoUser = trustRepoUser;
    }

    @Override
    public String getRepoPassword() {
        return this.repoPassword;
    }

    public void setRepoPassword(String repoPassword) {
        this.repoPassword = repoPassword;
    }

    @Override
    public String getInputDir() {
        return this.inputDir;
    }

    public void setInputDir(String inputDir) {
        this.inputDir = inputDir;
    }

    @Override
    public String getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(String localFile) {
        this.localFile = localFile;
    }

    @Override
    public String getLocalJarFile() {
        return this.localJarFile;
    }

    public void setLocalJarFile(String localJarFile) {
        this.localJarFile = localJarFile;
    }

    @Override
    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    @Override
    public String getListRepoFiles() {
        return this.listRepoFiles;
    }

    public void setListRepoFiles(String listRepoFiles) {
        this.listRepoFiles = listRepoFiles;
    }

    @Override
    public String getListRepoDirs() {
        return this.listRepoDirs;
    }

    public void setListRepoDirs(String listRepoDirs) {
        this.listRepoDirs = listRepoDirs;
    }

    @Override
    public String getExportRepo() {
        return this.exportRepo;
    }

    public void setExportRepo(String exportRepo) {
        this.exportRepo = exportRepo;
    }

    @Override
    public String getLocalInitialDir() {
        return this.localInitialDir;
    }

    public void setLocalInitialDir(String localInitialDir) {
        this.localInitialDir = localInitialDir;
    }

    @Override
    public String getListRepos() {
        return this.listRepos;
    }

    public void setListRepos(String listRepos) {
        this.listRepos = listRepos;
    }

    @Override
    public String getSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(String safeMode) {
        this.safeMode = safeMode;
    }

    @Override
    public String getMetrics() {
        return this.metrics;
    }

    public void setMetrics(String metrics) {
        this.metrics = metrics;
    }

    @Override
    public String getListFileParams() {
        return this.listFileParams;
    }

    public void setListFileParams(String listFileParams) {
        this.listFileParams = listFileParams;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String getMaxLogLines() {
        return this.maxLogLines;
    }

    public void setMaxLogLines(String maxLogLines) {
        this.maxLogLines = maxLogLines;
    }

    @Override
    public String getMaxLogTimeout() {
        return this.maxLogTimeout;
    }

    public void setMaxLogTimeout(String maxLogTimeout) {
        this.maxLogTimeout = maxLogTimeout;
    }

    @Override
    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    @Override
    public String getOldLogFile() {
        return this.oldLogFile;
    }

    public void setOldLogFile(String oldLogFile) {
        this.oldLogFile = oldLogFile;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getResultSetStepName() {
        return this.resultSetStepName;
    }

    public void setResultSetStepName(String resultSetStepName) {
        this.resultSetStepName = resultSetStepName;
    }

    @Override
    public String getResultSetCopyNumber() {
        return this.resultSetCopyNumber;
    }

    public void setResultSetCopyNumber(String resultSetCopyNumber) {
        this.resultSetCopyNumber = resultSetCopyNumber;
    }

    @Override
    public String getBase64Zip() {
        return this.base64Zip;
    }

    public void setBase64Zip(String base64Zip) {
        this.base64Zip = base64Zip;
    }

    @Override
    public NamedParams getNamedParams() {
        return this.namedParams;
    }

    public void setNamedParams(NamedParams params) {
        this.namedParams = params;
    }

    @Override
    public Map<String, String> getParams() {
        if (this.namedParams == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : this.namedParams.listParameters()) {
            try {
                params.put(key, this.namedParams.getParameterValue(key));
            }
            catch (UnknownParamException unknownParamException) {
                // empty catch block
            }
        }
        return params;
    }

    @Override
    public NamedParams getCustomNamedParams() {
        return this.customNamedParams;
    }

    public void setCustomNamedParams(NamedParams customNamedParams) {
        this.customNamedParams = customNamedParams;
    }

    @Override
    public Map<String, String> getCustomParams() {
        if (this.customNamedParams == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        for (String key : this.customNamedParams.listParameters()) {
            try {
                customParams.put(key, this.customNamedParams.getParameterValue(key));
            }
            catch (UnknownParamException unknownParamException) {
                // empty catch block
            }
        }
        return customParams;
    }

    public static class Builder {
        private String uuid;
        private String repoName;
        private String blockRepoConns;
        private String repoUsername;
        private String trustRepoUser;
        private String repoPassword;
        private String inputDir;
        private String inputFile;
        private String listRepoFiles;
        private String listRepoDirs;
        private String exportRepo;
        private String localFile;
        private String localJarFile;
        private String localInitialDir;
        private String listRepos;
        private String safeMode;
        private String metrics;
        private String listFileParams;
        private String logLevel;
        private String maxLogLines;
        private String maxLogTimeout;
        private String logFile;
        private String oldLogFile;
        private String version;
        private String resultSetStepName;
        private String resultSetCopyNumber;
        private String base64Zip;
        private NamedParams namedParams;
        private NamedParams customNamedParams;

        public Builder() {
            this(UUID.randomUUID().toString());
        }

        public Builder(String uuid) {
            this.uuid = uuid;
        }

        public Builder blockRepoConns(String blockRepoConns) {
            this.blockRepoConns = blockRepoConns;
            return this;
        }

        public Builder repoName(String repoName) {
            this.repoName = repoName;
            return this;
        }

        public Builder repoUsername(String repoUsername) {
            this.repoUsername = repoUsername;
            return this;
        }

        public Builder trustRepoUser(String trustRepoUser) {
            this.trustRepoUser = trustRepoUser;
            return this;
        }

        public Builder repoPassword(String repoPassword) {
            this.repoPassword = repoPassword;
            return this;
        }

        public Builder inputDir(String inputDir) {
            this.inputDir = inputDir;
            return this;
        }

        public Builder inputFile(String inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        public Builder listRepoFiles(String listRepoFiles) {
            this.listRepoFiles = listRepoFiles;
            return this;
        }

        public Builder listRepoDirs(String listRepoDirs) {
            this.listRepoDirs = listRepoDirs;
            return this;
        }

        public Builder exportRepo(String exportRepo) {
            this.exportRepo = exportRepo;
            return this;
        }

        public Builder localFile(String localFile) {
            this.localFile = localFile;
            return this;
        }

        public Builder localJarFile(String localJarFile) {
            this.localJarFile = localJarFile;
            return this;
        }

        public Builder localInitialDir(String localInitialDir) {
            this.localInitialDir = localInitialDir;
            return this;
        }

        public Builder listRepos(String listRepos) {
            this.listRepos = listRepos;
            return this;
        }

        public Builder safeMode(String safeMode) {
            this.safeMode = safeMode;
            return this;
        }

        public Builder metrics(String metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder listFileParams(String listFileParams) {
            this.listFileParams = listFileParams;
            return this;
        }

        public Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder maxLogLines(String maxLogLines) {
            this.maxLogLines = maxLogLines;
            return this;
        }

        public Builder maxLogTimeout(String maxLogTimeout) {
            this.maxLogTimeout = maxLogTimeout;
            return this;
        }

        public Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder oldLogFile(String oldLogFile) {
            this.oldLogFile = oldLogFile;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder resultSetStepName(String resultSetStepName) {
            this.resultSetStepName = resultSetStepName;
            return this;
        }

        public Builder resultSetCopyNumber(String resultSetCopyNumber) {
            this.resultSetCopyNumber = resultSetCopyNumber;
            return this;
        }

        public Builder base64Zip(String base64Zip) {
            this.base64Zip = base64Zip;
            return this;
        }

        public Builder namedParams(NamedParams namedParams) {
            this.namedParams = namedParams;
            return this;
        }

        public Builder customNamedParams(NamedParams customNamedParams) {
            this.customNamedParams = customNamedParams;
            return this;
        }

        public Params build() {
            Params params = new Params();
            params.uuid = this.uuid;
            params.blockRepoConns = this.blockRepoConns;
            params.repoName = this.repoName;
            params.repoUsername = this.repoUsername;
            params.trustRepoUser = this.trustRepoUser;
            params.repoPassword = this.repoPassword;
            params.inputDir = this.inputDir;
            params.inputFile = this.inputFile;
            params.listRepoFiles = this.listRepoFiles;
            params.listRepoDirs = this.listRepoDirs;
            params.exportRepo = this.exportRepo;
            params.localFile = this.localFile;
            params.localJarFile = this.localJarFile;
            params.localInitialDir = this.localInitialDir;
            params.listRepos = this.listRepos;
            params.safeMode = this.safeMode;
            params.metrics = this.metrics;
            params.listFileParams = this.listFileParams;
            params.logLevel = this.logLevel;
            params.maxLogLines = this.maxLogLines;
            params.maxLogTimeout = this.maxLogTimeout;
            params.logFile = this.logFile;
            params.oldLogFile = this.oldLogFile;
            params.version = this.version;
            params.resultSetStepName = this.resultSetStepName;
            params.resultSetCopyNumber = NumberUtils.isNumber((String)this.resultSetCopyNumber) ? this.resultSetCopyNumber : "0";
            params.base64Zip = this.base64Zip;
            params.namedParams = this.namedParams;
            params.customNamedParams = this.customNamedParams;
            return params;
        }
    }
}

