/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.tools;

import java.io.IOException;
import org.jfor.jfor.tools.ElementVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DomToSaxAdapter
extends ElementVisitor {
    private ContentHandler m_handler;
    private final Document m_doc;

    public DomToSaxAdapter(Document document) {
        this.m_doc = document;
    }

    public void simulateParsing(ContentHandler contentHandler) throws IOException, SAXException {
        this.m_handler = contentHandler;
        this.visit(this.m_doc.getDocumentElement());
        this.m_handler.endDocument();
    }

    protected void startElement(Element element) throws IOException, SAXException {
        this.m_handler.startElement(null, null, element.getTagName(), DomToSaxAdapter.saxAttributes(element.getAttributes()));
    }

    protected void endElement(Element element) throws IOException, SAXException {
        this.m_handler.endElement(null, null, element.getTagName());
    }

    protected void visitText(Text text) throws IOException, SAXException {
        String string = text.getNodeValue();
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        this.m_handler.characters(cArray, 0, n);
    }

    protected void visitCDATA(CDATASection cDATASection) throws IOException {
    }

    protected void visitComment(Comment comment) throws IOException {
    }

    protected void visitNode(Node node) throws IOException {
    }

    private static Attributes saxAttributes(NamedNodeMap namedNodeMap) {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            attributesImpl.addAttribute(null, null, attr.getName(), "CDATA", attr.getValue());
            ++n;
        }
        return attributesImpl;
    }
}

