/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFCharset;
import org.apache.fontbox.cff.CFFDataInput;
import org.apache.fontbox.cff.CFFEncoding;
import org.apache.fontbox.cff.CFFExpertCharset;
import org.apache.fontbox.cff.CFFExpertEncoding;
import org.apache.fontbox.cff.CFFExpertSubsetCharset;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFISOAdobeCharset;
import org.apache.fontbox.cff.CFFOperator;
import org.apache.fontbox.cff.CFFStandardEncoding;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.cff.DataInput;
import org.apache.fontbox.cff.FDSelect;
import org.apache.fontbox.cff.IndexData;

public class CFFParser {
    private static final String TAG_OTTO = "OTTO";
    private static final String TAG_TTCF = "ttcf";
    private static final String TAG_TTFONLY = "\u0000\u0001\u0000\u0000";
    private CFFDataInput input = null;
    private Header header = null;
    private IndexData nameIndex = null;
    private IndexData topDictIndex = null;
    private IndexData stringIndex = null;
    private String debugFontName;

    public List<CFFFont> parse(byte[] bytes) throws IOException {
        this.input = new CFFDataInput(bytes);
        String firstTag = CFFParser.readTagName(this.input);
        if (TAG_OTTO.equals(firstTag)) {
            int numTables = this.input.readShort();
            short searchRange = this.input.readShort();
            short entrySelector = this.input.readShort();
            short rangeShift = this.input.readShort();
            boolean cffFound = false;
            for (int q = 0; q < numTables; ++q) {
                String tagName = CFFParser.readTagName(this.input);
                long checksum = CFFParser.readLong(this.input);
                long offset = CFFParser.readLong(this.input);
                long length = CFFParser.readLong(this.input);
                if (!tagName.equals("CFF ")) continue;
                cffFound = true;
                byte[] bytes2 = new byte[(int)length];
                System.arraycopy(bytes, (int)offset, bytes2, 0, bytes2.length);
                this.input = new CFFDataInput(bytes2);
                break;
            }
            if (!cffFound) {
                throw new IOException("CFF tag not found in this OpenType font.");
            }
        } else {
            if (TAG_TTCF.equals(firstTag)) {
                throw new IOException("True Type Collection fonts are not supported.");
            }
            if (TAG_TTFONLY.equals(firstTag)) {
                throw new IOException("OpenType fonts containing a true type font are not supported.");
            }
            this.input.setPosition(0);
        }
        this.header = CFFParser.readHeader(this.input);
        this.nameIndex = CFFParser.readIndexData(this.input);
        this.topDictIndex = CFFParser.readIndexData(this.input);
        this.stringIndex = CFFParser.readIndexData(this.input);
        IndexData globalSubrIndex = CFFParser.readIndexData(this.input);
        ArrayList<CFFFont> fonts = new ArrayList<CFFFont>();
        for (int i = 0; i < this.nameIndex.getCount(); ++i) {
            CFFFont font = this.parseFont(i);
            font.setGlobalSubrIndex(globalSubrIndex);
            fonts.add(font);
        }
        return fonts;
    }

    private static String readTagName(CFFDataInput input) throws IOException {
        byte[] b = input.readBytes(4);
        return new String(b, "ISO-8859-1");
    }

    private static long readLong(CFFDataInput input) throws IOException {
        return input.readCard16() << 16 | input.readCard16();
    }

    private static Header readHeader(CFFDataInput input) throws IOException {
        Header cffHeader = new Header();
        cffHeader.major = input.readCard8();
        cffHeader.minor = input.readCard8();
        cffHeader.hdrSize = input.readCard8();
        cffHeader.offSize = input.readOffSize();
        return cffHeader;
    }

    private static IndexData readIndexData(CFFDataInput input) throws IOException {
        int count = input.readCard16();
        IndexData index = new IndexData(count);
        if (count == 0) {
            return index;
        }
        int offSize = input.readOffSize();
        for (int i = 0; i <= count; ++i) {
            index.setOffset(i, input.readOffset(offSize));
        }
        int dataSize = index.getOffset(count) - index.getOffset(0);
        index.initData(dataSize);
        for (int i = 0; i < dataSize; ++i) {
            index.setData(i, input.readCard8());
        }
        return index;
    }

    private static DictData readDictData(CFFDataInput input) throws IOException {
        DictData dict = new DictData();
        dict.entries = new ArrayList();
        while (input.hasRemaining()) {
            DictData.Entry entry = CFFParser.readEntry(input);
            dict.entries.add(entry);
        }
        return dict;
    }

    private static DictData.Entry readEntry(CFFDataInput input) throws IOException {
        int b0;
        DictData.Entry entry;
        block3: {
            entry = new DictData.Entry();
            while (true) {
                if ((b0 = input.readUnsignedByte()) >= 0 && b0 <= 21) break block3;
                if (b0 == 28 || b0 == 29) {
                    entry.operands.add(CFFParser.readIntegerNumber(input, b0));
                    continue;
                }
                if (b0 == 30) {
                    entry.operands.add(CFFParser.readRealNumber(input, b0));
                    continue;
                }
                if (b0 < 32 || b0 > 254) break;
                entry.operands.add(CFFParser.readIntegerNumber(input, b0));
            }
            throw new IllegalArgumentException();
        }
        entry.operator = CFFParser.readOperator(input, b0);
        return entry;
    }

    private static CFFOperator readOperator(CFFDataInput input, int b0) throws IOException {
        CFFOperator.Key key = CFFParser.readOperatorKey(input, b0);
        return CFFOperator.getOperator(key);
    }

    private static CFFOperator.Key readOperatorKey(CFFDataInput input, int b0) throws IOException {
        if (b0 == 12) {
            int b1 = input.readUnsignedByte();
            return new CFFOperator.Key(b0, b1);
        }
        return new CFFOperator.Key(b0);
    }

    private static Integer readIntegerNumber(CFFDataInput input, int b0) throws IOException {
        if (b0 == 28) {
            int b1 = input.readUnsignedByte();
            int b2 = input.readUnsignedByte();
            return (short)(b1 << 8 | b2);
        }
        if (b0 == 29) {
            int b1 = input.readUnsignedByte();
            int b2 = input.readUnsignedByte();
            int b3 = input.readUnsignedByte();
            int b4 = input.readUnsignedByte();
            return b1 << 24 | b2 << 16 | b3 << 8 | b4;
        }
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = input.readUnsignedByte();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = input.readUnsignedByte();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        throw new IllegalArgumentException();
    }

    private static Double readRealNumber(CFFDataInput input, int b0) throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean done = false;
        boolean exponentMissing = false;
        while (!done) {
            int[] nibbles;
            int b = input.readUnsignedByte();
            block10: for (int nibble : nibbles = new int[]{b / 16, b % 16}) {
                switch (nibble) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        sb.append(nibble);
                        exponentMissing = false;
                        continue block10;
                    }
                    case 10: {
                        sb.append(".");
                        continue block10;
                    }
                    case 11: {
                        sb.append("E");
                        exponentMissing = true;
                        continue block10;
                    }
                    case 12: {
                        sb.append("E-");
                        exponentMissing = true;
                        continue block10;
                    }
                    case 13: {
                        continue block10;
                    }
                    case 14: {
                        sb.append("-");
                        continue block10;
                    }
                    case 15: {
                        done = true;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        if (exponentMissing) {
            sb.append("0");
        }
        return Double.valueOf(sb.toString());
    }

    private CFFFont parseFont(int index) throws IOException {
        CFFCharset charset;
        CFFFont font;
        boolean isCIDFont;
        DataInput nameInput = new DataInput(this.nameIndex.getBytes(index));
        String name = nameInput.getString();
        CFFDataInput topDictInput = new CFFDataInput(this.topDictIndex.getBytes(index));
        DictData topDict = CFFParser.readDictData(topDictInput);
        DictData.Entry syntheticBaseEntry = topDict.getEntry("SyntheticBase");
        if (syntheticBaseEntry != null) {
            throw new IOException("Synthetic Fonts are not supported");
        }
        boolean bl = isCIDFont = topDict.getEntry("ROS") != null;
        if (isCIDFont) {
            font = new CFFCIDFont();
            DictData.Entry rosEntry = topDict.getEntry("ROS");
            ((CFFCIDFont)font).setRegistry(this.readString(rosEntry.getNumber(0).intValue()));
            ((CFFCIDFont)font).setOrdering(this.readString(rosEntry.getNumber(1).intValue()));
            ((CFFCIDFont)font).setSupplement(rosEntry.getNumber(2).intValue());
        } else {
            font = new CFFType1Font();
        }
        this.debugFontName = name;
        font.setName(name);
        font.addValueToTopDict("version", this.getString(topDict, "version"));
        font.addValueToTopDict("Notice", this.getString(topDict, "Notice"));
        font.addValueToTopDict("Copyright", this.getString(topDict, "Copyright"));
        font.addValueToTopDict("FullName", this.getString(topDict, "FullName"));
        font.addValueToTopDict("FamilyName", this.getString(topDict, "FamilyName"));
        font.addValueToTopDict("Weight", this.getString(topDict, "Weight"));
        font.addValueToTopDict("isFixedPitch", this.getBoolean(topDict, "isFixedPitch", false));
        font.addValueToTopDict("ItalicAngle", this.getNumber(topDict, "ItalicAngle", 0));
        font.addValueToTopDict("UnderlinePosition", this.getNumber(topDict, "UnderlinePosition", -100));
        font.addValueToTopDict("UnderlineThickness", this.getNumber(topDict, "UnderlineThickness", 50));
        font.addValueToTopDict("PaintType", this.getNumber(topDict, "PaintType", 0));
        font.addValueToTopDict("CharstringType", this.getNumber(topDict, "CharstringType", 2));
        font.addValueToTopDict("FontMatrix", this.getArray(topDict, "FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
        font.addValueToTopDict("UniqueID", this.getNumber(topDict, "UniqueID", null));
        font.addValueToTopDict("FontBBox", this.getArray(topDict, "FontBBox", Arrays.asList(0, 0, 0, 0)));
        font.addValueToTopDict("StrokeWidth", this.getNumber(topDict, "StrokeWidth", 0));
        font.addValueToTopDict("XUID", this.getArray(topDict, "XUID", null));
        DictData.Entry charStringsEntry = topDict.getEntry("CharStrings");
        int charStringsOffset = charStringsEntry.getNumber(0).intValue();
        this.input.setPosition(charStringsOffset);
        IndexData charStringsIndex = CFFParser.readIndexData(this.input);
        DictData.Entry charsetEntry = topDict.getEntry("charset");
        if (charsetEntry != null) {
            int charsetId = charsetEntry.getNumber(0).intValue();
            if (!isCIDFont && charsetId == 0) {
                charset = CFFISOAdobeCharset.getInstance();
            } else if (!isCIDFont && charsetId == 1) {
                charset = CFFExpertCharset.getInstance();
            } else if (!isCIDFont && charsetId == 2) {
                charset = CFFExpertSubsetCharset.getInstance();
            } else {
                this.input.setPosition(charsetId);
                charset = this.readCharset(this.input, charStringsIndex.getCount(), isCIDFont);
            }
        } else {
            charset = isCIDFont ? new EmptyCharset(charStringsIndex.getCount()) : CFFISOAdobeCharset.getInstance();
        }
        font.setCharset(charset);
        font.getCharStringBytes().add(charStringsIndex.getBytes(0));
        for (int i = 1; i < charStringsIndex.getCount(); ++i) {
            byte[] bytes = charStringsIndex.getBytes(i);
            font.getCharStringBytes().add(bytes);
        }
        if (isCIDFont) {
            this.parseCIDFontDicts(topDict, (CFFCIDFont)font, charStringsIndex);
            if (topDict.getEntry("FontMatrix") == null) {
                List<Map<String, Object>> fontDicts = ((CFFCIDFont)font).getFontDicts();
                if (fontDicts.size() > 0 && fontDicts.get(0).containsKey("FontMatrix")) {
                    List matrix = (List)fontDicts.get(0).get("FontMatrix");
                    font.addValueToTopDict("FontMatrix", matrix);
                } else {
                    font.addValueToTopDict("FontMatrix", this.getArray(topDict, "FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
                }
            }
        } else {
            this.parseType1Dicts(topDict, (CFFType1Font)font, charset);
        }
        return font;
    }

    private void parseCIDFontDicts(DictData topDict, CFFCIDFont font, IndexData charStringsIndex) throws IOException {
        DictData.Entry fdArrayEntry = topDict.getEntry("FDArray");
        if (fdArrayEntry == null) {
            throw new IOException("FDArray is missing for a CIDKeyed Font.");
        }
        int fontDictOffset = fdArrayEntry.getNumber(0).intValue();
        this.input.setPosition(fontDictOffset);
        IndexData fdIndex = CFFParser.readIndexData(this.input);
        LinkedList<Map<String, Object>> privateDictionaries = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> fontDictionaries = new LinkedList<Map<String, Object>>();
        for (int i = 0; i < fdIndex.getCount(); ++i) {
            byte[] bytes = fdIndex.getBytes(i);
            CFFDataInput fontDictInput = new CFFDataInput(bytes);
            DictData fontDict = CFFParser.readDictData(fontDictInput);
            LinkedHashMap<String, Object> fontDictMap = new LinkedHashMap<String, Object>();
            fontDictMap.put("FontName", this.getString(fontDict, "FontName"));
            fontDictMap.put("FontType", this.getNumber(fontDict, "FontType", 0));
            fontDictMap.put("FontBBox", this.getDelta(fontDict, "FontBBox", null));
            fontDictMap.put("FontMatrix", this.getDelta(fontDict, "FontMatrix", null));
            fontDictionaries.add(fontDictMap);
            DictData.Entry privateEntry = fontDict.getEntry("Private");
            if (privateEntry == null) {
                throw new IOException("Font DICT invalid without \"Private\" entry");
            }
            int privateOffset = privateEntry.getNumber(1).intValue();
            this.input.setPosition(privateOffset);
            int privateSize = privateEntry.getNumber(0).intValue();
            CFFDataInput privateDictData = new CFFDataInput(this.input.readBytes(privateSize));
            DictData privateDict = CFFParser.readDictData(privateDictData);
            LinkedHashMap<String, Object> privDict = new LinkedHashMap<String, Object>();
            privDict.put("BlueValues", this.getDelta(privateDict, "BlueValues", null));
            privDict.put("OtherBlues", this.getDelta(privateDict, "OtherBlues", null));
            privDict.put("FamilyBlues", this.getDelta(privateDict, "FamilyBlues", null));
            privDict.put("FamilyOtherBlues", this.getDelta(privateDict, "FamilyOtherBlues", null));
            privDict.put("BlueScale", this.getNumber(privateDict, "BlueScale", 0.039625));
            privDict.put("BlueShift", this.getNumber(privateDict, "BlueShift", 7));
            privDict.put("BlueFuzz", this.getNumber(privateDict, "BlueFuzz", 1));
            privDict.put("StdHW", this.getNumber(privateDict, "StdHW", null));
            privDict.put("StdVW", this.getNumber(privateDict, "StdVW", null));
            privDict.put("StemSnapH", this.getDelta(privateDict, "StemSnapH", null));
            privDict.put("StemSnapV", this.getDelta(privateDict, "StemSnapV", null));
            privDict.put("ForceBold", this.getBoolean(privateDict, "ForceBold", false));
            privDict.put("LanguageGroup", this.getNumber(privateDict, "LanguageGroup", 0));
            privDict.put("ExpansionFactor", this.getNumber(privateDict, "ExpansionFactor", 0.06));
            privDict.put("initialRandomSeed", this.getNumber(privateDict, "initialRandomSeed", 0));
            privDict.put("defaultWidthX", this.getNumber(privateDict, "defaultWidthX", 0));
            privDict.put("nominalWidthX", this.getNumber(privateDict, "nominalWidthX", 0));
            privateDictionaries.add(privDict);
            int localSubrOffset = (Integer)this.getNumber(privateDict, "Subrs", 0);
            if (localSubrOffset == 0) {
                privDict.put("Subrs", new IndexData(0));
                continue;
            }
            this.input.setPosition(privateOffset + localSubrOffset);
            IndexData idx = CFFParser.readIndexData(this.input);
            privDict.put("Subrs", idx);
        }
        DictData.Entry fdSelectEntry = topDict.getEntry("FDSelect");
        int fdSelectPos = fdSelectEntry.getNumber(0).intValue();
        this.input.setPosition(fdSelectPos);
        FDSelect fdSelect = this.readFDSelect(this.input, charStringsIndex.getCount(), font);
        font.setFontDict(fontDictionaries);
        font.setPrivDict(privateDictionaries);
        font.setFdSelect(fdSelect);
    }

    private void parseType1Dicts(DictData topDict, CFFType1Font font, CFFCharset charset) throws IOException {
        CFFEncoding encoding;
        int encodingId;
        DictData.Entry encodingEntry = topDict.getEntry("Encoding");
        int n = encodingId = encodingEntry != null ? encodingEntry.getNumber(0).intValue() : 0;
        if (encodingId == 0) {
            encoding = CFFStandardEncoding.getInstance();
        } else if (encodingId == 1) {
            encoding = CFFExpertEncoding.getInstance();
        } else {
            this.input.setPosition(encodingId);
            encoding = this.readEncoding(this.input, charset);
        }
        font.setEncoding(encoding);
        DictData.Entry privateEntry = topDict.getEntry("Private");
        int privateOffset = privateEntry.getNumber(1).intValue();
        this.input.setPosition(privateOffset);
        int privateSize = privateEntry.getNumber(0).intValue();
        CFFDataInput privateDictData = new CFFDataInput(this.input.readBytes(privateSize));
        DictData privateDict = CFFParser.readDictData(privateDictData);
        font.addToPrivateDict("BlueValues", this.getDelta(privateDict, "BlueValues", null));
        font.addToPrivateDict("OtherBlues", this.getDelta(privateDict, "OtherBlues", null));
        font.addToPrivateDict("FamilyBlues", this.getDelta(privateDict, "FamilyBlues", null));
        font.addToPrivateDict("FamilyOtherBlues", this.getDelta(privateDict, "FamilyOtherBlues", null));
        font.addToPrivateDict("BlueScale", this.getNumber(privateDict, "BlueScale", 0.039625));
        font.addToPrivateDict("BlueShift", this.getNumber(privateDict, "BlueShift", 7));
        font.addToPrivateDict("BlueFuzz", this.getNumber(privateDict, "BlueFuzz", 1));
        font.addToPrivateDict("StdHW", this.getNumber(privateDict, "StdHW", null));
        font.addToPrivateDict("StdVW", this.getNumber(privateDict, "StdVW", null));
        font.addToPrivateDict("StemSnapH", this.getDelta(privateDict, "StemSnapH", null));
        font.addToPrivateDict("StemSnapV", this.getDelta(privateDict, "StemSnapV", null));
        font.addToPrivateDict("ForceBold", this.getBoolean(privateDict, "ForceBold", false));
        font.addToPrivateDict("LanguageGroup", this.getNumber(privateDict, "LanguageGroup", 0));
        font.addToPrivateDict("ExpansionFactor", this.getNumber(privateDict, "ExpansionFactor", 0.06));
        font.addToPrivateDict("initialRandomSeed", this.getNumber(privateDict, "initialRandomSeed", 0));
        font.addToPrivateDict("defaultWidthX", this.getNumber(privateDict, "defaultWidthX", 0));
        font.addToPrivateDict("nominalWidthX", this.getNumber(privateDict, "nominalWidthX", 0));
        int localSubrOffset = (Integer)this.getNumber(privateDict, "Subrs", 0);
        if (localSubrOffset == 0) {
            font.addToPrivateDict("Subrs", new IndexData(0));
        } else {
            this.input.setPosition(privateOffset + localSubrOffset);
            font.addToPrivateDict("Subrs", CFFParser.readIndexData(this.input));
        }
    }

    private String readString(int index) throws IOException {
        if (index >= 0 && index <= 390) {
            return CFFStandardString.getName(index);
        }
        if (index - 391 < this.stringIndex.getCount()) {
            DataInput dataInput = new DataInput(this.stringIndex.getBytes(index - 391));
            return dataInput.getString();
        }
        return "SID" + index;
    }

    private String getString(DictData dict, String name) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? this.readString(entry.getNumber(0).intValue()) : null;
    }

    private Boolean getBoolean(DictData dict, String name, boolean defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? entry.getBoolean(0) : defaultValue;
    }

    private Number getNumber(DictData dict, String name, Number defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? (Number)entry.getNumber(0) : (Number)defaultValue;
    }

    private List<Number> getArray(DictData dict, String name, List<Number> defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? entry.getArray() : defaultValue;
    }

    private List<Number> getDelta(DictData dict, String name, List<Number> defaultValue) throws IOException {
        DictData.Entry entry = dict.getEntry(name);
        return entry != null ? entry.getArray() : defaultValue;
    }

    private CFFEncoding readEncoding(CFFDataInput dataInput, CFFCharset charset) throws IOException {
        int format = dataInput.readCard8();
        int baseFormat = format & 0x7F;
        if (baseFormat == 0) {
            return this.readFormat0Encoding(dataInput, charset, format);
        }
        if (baseFormat == 1) {
            return this.readFormat1Encoding(dataInput, charset, format);
        }
        throw new IllegalArgumentException();
    }

    private Format0Encoding readFormat0Encoding(CFFDataInput dataInput, CFFCharset charset, int format) throws IOException {
        Format0Encoding encoding = new Format0Encoding();
        encoding.format = format;
        encoding.nCodes = dataInput.readCard8();
        Format0Encoding.access$1302(encoding, new int[encoding.nCodes]);
        encoding.add(0, 0, ".notdef");
        for (int gid = 1; gid <= encoding.nCodes; ++gid) {
            int code;
            ((Format0Encoding)encoding).code[gid - 1] = code = dataInput.readCard8();
            int sid = charset.getSIDForGID(gid);
            encoding.add(code, sid, this.readString(sid));
        }
        if ((format & 0x80) != 0) {
            this.readSupplement(dataInput, encoding);
        }
        return encoding;
    }

    private Format1Encoding readFormat1Encoding(CFFDataInput dataInput, CFFCharset charset, int format) throws IOException {
        Format1Encoding encoding = new Format1Encoding();
        encoding.format = format;
        encoding.nRanges = dataInput.readCard8();
        Format1Encoding.access$1702(encoding, new Format1Encoding.Range1[encoding.nRanges]);
        encoding.add(0, 0, ".notdef");
        int gid = 1;
        for (int i = 0; i < encoding.range.length; ++i) {
            Format1Encoding.Range1 range = new Format1Encoding.Range1();
            range.first = dataInput.readCard8();
            range.nLeft = dataInput.readCard8();
            ((Format1Encoding)encoding).range[i] = range;
            for (int j = 0; j < 1 + range.nLeft; ++j) {
                int sid = charset.getSIDForGID(gid);
                int code = range.first + j;
                encoding.add(code, sid, this.readString(sid));
                ++gid;
            }
        }
        if ((format & 0x80) != 0) {
            this.readSupplement(dataInput, encoding);
        }
        return encoding;
    }

    private void readSupplement(CFFDataInput dataInput, EmbeddedEncoding encoding) throws IOException {
        encoding.nSups = dataInput.readCard8();
        EmbeddedEncoding.access$2202(encoding, new EmbeddedEncoding.Supplement[encoding.nSups]);
        for (int i = 0; i < encoding.supplement.length; ++i) {
            EmbeddedEncoding.Supplement supplement = new EmbeddedEncoding.Supplement();
            supplement.code = dataInput.readCard8();
            supplement.sid = dataInput.readSID();
            supplement.name = this.readString(supplement.sid);
            ((EmbeddedEncoding)encoding).supplement[i] = supplement;
            encoding.add(supplement.code, supplement.sid, this.readString(supplement.sid));
        }
    }

    private FDSelect readFDSelect(CFFDataInput dataInput, int nGlyphs, CFFCIDFont ros) throws IOException {
        int format = dataInput.readCard8();
        if (format == 0) {
            return this.readFormat0FDSelect(dataInput, format, nGlyphs, ros);
        }
        if (format == 3) {
            return this.readFormat3FDSelect(dataInput, format, nGlyphs, ros);
        }
        throw new IllegalArgumentException();
    }

    private Format0FDSelect readFormat0FDSelect(CFFDataInput dataInput, int format, int nGlyphs, CFFCIDFont ros) throws IOException {
        Format0FDSelect fdselect = new Format0FDSelect(ros);
        fdselect.format = format;
        Format0FDSelect.access$2802(fdselect, new int[nGlyphs]);
        for (int i = 0; i < fdselect.fds.length; ++i) {
            ((Format0FDSelect)fdselect).fds[i] = dataInput.readCard8();
        }
        return fdselect;
    }

    private Format3FDSelect readFormat3FDSelect(CFFDataInput dataInput, int format, int nGlyphs, CFFCIDFont ros) throws IOException {
        Format3FDSelect fdselect = new Format3FDSelect(ros);
        fdselect.format = format;
        fdselect.nbRanges = dataInput.readCard16();
        Format3FDSelect.access$3202(fdselect, new Range3[fdselect.nbRanges]);
        for (int i = 0; i < fdselect.nbRanges; ++i) {
            Range3 r3 = new Range3();
            r3.first = dataInput.readCard16();
            r3.fd = dataInput.readCard8();
            ((Format3FDSelect)fdselect).range3[i] = r3;
        }
        fdselect.sentinel = dataInput.readCard16();
        return fdselect;
    }

    private CFFCharset readCharset(CFFDataInput dataInput, int nGlyphs, boolean isCIDFont) throws IOException {
        int format = dataInput.readCard8();
        if (format == 0) {
            return this.readFormat0Charset(dataInput, format, nGlyphs, isCIDFont);
        }
        if (format == 1) {
            return this.readFormat1Charset(dataInput, format, nGlyphs, isCIDFont);
        }
        if (format == 2) {
            return this.readFormat2Charset(dataInput, format, nGlyphs, isCIDFont);
        }
        throw new IllegalArgumentException();
    }

    private Format0Charset readFormat0Charset(CFFDataInput dataInput, int format, int nGlyphs, boolean isCIDFont) throws IOException {
        Format0Charset charset = new Format0Charset(isCIDFont);
        charset.format = format;
        Format0Charset.access$3802(charset, new int[nGlyphs]);
        ((Format0Charset)charset).glyph[0] = 0;
        if (isCIDFont) {
            charset.addCID(0, 0);
        } else {
            charset.addSID(0, 0, ".notdef");
        }
        for (int gid = 1; gid < charset.glyph.length; ++gid) {
            int sid;
            ((Format0Charset)charset).glyph[gid] = sid = dataInput.readSID();
            if (isCIDFont) {
                charset.addCID(gid, sid);
                continue;
            }
            charset.addSID(gid, sid, this.readString(sid));
        }
        return charset;
    }

    private Format1Charset readFormat1Charset(CFFDataInput dataInput, int format, int nGlyphs, boolean isCIDFont) throws IOException {
        Format1Charset charset = new Format1Charset(isCIDFont);
        charset.format = format;
        ArrayList<Format1Charset.Range1> ranges = new ArrayList<Format1Charset.Range1>();
        if (isCIDFont) {
            charset.addCID(0, 0);
        } else {
            charset.addSID(0, 0, ".notdef");
        }
        for (int gid = 1; gid < nGlyphs; ++gid) {
            Format1Charset.Range1 range = new Format1Charset.Range1();
            range.first = dataInput.readSID();
            range.nLeft = dataInput.readCard8();
            ranges.add(range);
            for (int j = 0; j < 1 + range.nLeft; ++j) {
                int sid = range.first + j;
                if (isCIDFont) {
                    charset.addCID(gid + j, sid);
                    continue;
                }
                charset.addSID(gid + j, sid, this.readString(sid));
            }
            gid += range.nLeft;
        }
        Format1Charset.access$4302(charset, ranges.toArray(new Format1Charset.Range1[0]));
        return charset;
    }

    private Format2Charset readFormat2Charset(CFFDataInput dataInput, int format, int nGlyphs, boolean isCIDFont) throws IOException {
        Format2Charset charset = new Format2Charset(isCIDFont);
        charset.format = format;
        Format2Charset.access$4502(charset, new Format2Charset.Range2[0]);
        if (isCIDFont) {
            charset.addCID(0, 0);
        } else {
            charset.addSID(0, 0, ".notdef");
        }
        for (int gid = 1; gid < nGlyphs; ++gid) {
            Format2Charset.Range2[] newRange = new Format2Charset.Range2[charset.range.length + 1];
            System.arraycopy(charset.range, 0, newRange, 0, charset.range.length);
            Format2Charset.access$4502(charset, newRange);
            Format2Charset.Range2 range = new Format2Charset.Range2();
            range.first = dataInput.readSID();
            range.nLeft = dataInput.readCard16();
            ((Format2Charset)charset).range[((Format2Charset)charset).range.length - 1] = range;
            for (int j = 0; j < 1 + range.nLeft; ++j) {
                int sid = range.first + j;
                if (isCIDFont) {
                    charset.addCID(gid + j, sid);
                    continue;
                }
                charset.addSID(gid + j, sid, this.readString(sid));
            }
            gid += range.nLeft;
        }
        return charset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.debugFontName + "]";
    }

    private static class Format2Charset
    extends EmbeddedCharset {
        private int format;
        private Range2[] range;

        protected Format2Charset(boolean isCIDFont) {
            super(isCIDFont);
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", range=" + Arrays.toString(this.range) + "]";
        }

        static /* synthetic */ Range2[] access$4502(Format2Charset x0, Range2[] x1) {
            x0.range = x1;
            return x1;
        }

        private static class Range2 {
            private int first;
            private int nLeft;

            private Range2() {
            }

            public String toString() {
                return this.getClass().getName() + "[first=" + this.first + ", nLeft=" + this.nLeft + "]";
            }
        }
    }

    private static class Format1Charset
    extends EmbeddedCharset {
        private int format;
        private Range1[] range;

        protected Format1Charset(boolean isCIDFont) {
            super(isCIDFont);
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", range=" + Arrays.toString(this.range) + "]";
        }

        static /* synthetic */ Range1[] access$4302(Format1Charset x0, Range1[] x1) {
            x0.range = x1;
            return x1;
        }

        private static class Range1 {
            private int first;
            private int nLeft;

            private Range1() {
            }

            public String toString() {
                return this.getClass().getName() + "[first=" + this.first + ", nLeft=" + this.nLeft + "]";
            }
        }
    }

    private static class Format0Charset
    extends EmbeddedCharset {
        private int format;
        private int[] glyph;

        protected Format0Charset(boolean isCIDFont) {
            super(isCIDFont);
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", glyph=" + Arrays.toString(this.glyph) + "]";
        }

        static /* synthetic */ int[] access$3802(Format0Charset x0, int[] x1) {
            x0.glyph = x1;
            return x1;
        }
    }

    private static class EmptyCharset
    extends EmbeddedCharset {
        protected EmptyCharset(int numCharStrings) {
            super(true);
            this.addCID(0, 0);
            for (int i = 1; i <= numCharStrings; ++i) {
                this.addCID(i, i);
            }
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    static abstract class EmbeddedCharset
    extends CFFCharset {
        protected EmbeddedCharset(boolean isCIDFont) {
            super(isCIDFont);
        }
    }

    private static class Format1Encoding
    extends EmbeddedEncoding {
        private int format;
        private int nRanges;
        private Range1[] range;

        private Format1Encoding() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", nRanges=" + this.nRanges + ", range=" + Arrays.toString(this.range) + ", supplement=" + Arrays.toString(((EmbeddedEncoding)this).supplement) + "]";
        }

        static /* synthetic */ Range1[] access$1702(Format1Encoding x0, Range1[] x1) {
            x0.range = x1;
            return x1;
        }

        private static class Range1 {
            private int first;
            private int nLeft;

            private Range1() {
            }

            public String toString() {
                return this.getClass().getName() + "[first=" + this.first + ", nLeft=" + this.nLeft + "]";
            }
        }
    }

    private static class Format0Encoding
    extends EmbeddedEncoding {
        private int format;
        private int nCodes;
        private int[] code;

        private Format0Encoding() {
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + ", nCodes=" + this.nCodes + ", code=" + Arrays.toString(this.code) + ", supplement=" + Arrays.toString(((EmbeddedEncoding)this).supplement) + "]";
        }

        static /* synthetic */ int[] access$1302(Format0Encoding x0, int[] x1) {
            x0.code = x1;
            return x1;
        }
    }

    static abstract class EmbeddedEncoding
    extends CFFEncoding {
        private int nSups;
        private Supplement[] supplement;

        EmbeddedEncoding() {
        }

        static /* synthetic */ Supplement[] access$2202(EmbeddedEncoding x0, Supplement[] x1) {
            x0.supplement = x1;
            return x1;
        }

        static class Supplement {
            private int code;
            private int sid;
            private String name;

            Supplement() {
            }

            public int getCode() {
                return this.code;
            }

            public int getSID() {
                return this.sid;
            }

            public String getName() {
                return this.name;
            }

            public String toString() {
                return this.getClass().getName() + "[code=" + this.code + ", sid=" + this.sid + "]";
            }
        }
    }

    private static class DictData {
        private List<Entry> entries = null;

        private DictData() {
        }

        public Entry getEntry(CFFOperator.Key key) {
            return this.getEntry(CFFOperator.getOperator(key));
        }

        public Entry getEntry(String name) {
            return this.getEntry(CFFOperator.getOperator(name));
        }

        private Entry getEntry(CFFOperator operator) {
            for (Entry entry : this.entries) {
                if (entry == null || entry.operator == null || !entry.operator.equals(operator)) continue;
                return entry;
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[entries=" + this.entries + "]";
        }

        private static class Entry {
            private List<Number> operands = new ArrayList<Number>();
            private CFFOperator operator = null;

            private Entry() {
            }

            public Number getNumber(int index) {
                return this.operands.get(index);
            }

            public Boolean getBoolean(int index) {
                Number operand = this.operands.get(index);
                if (operand instanceof Integer) {
                    switch (operand.intValue()) {
                        case 0: {
                            return Boolean.FALSE;
                        }
                        case 1: {
                            return Boolean.TRUE;
                        }
                    }
                }
                throw new IllegalArgumentException();
            }

            public Integer getSID(int index) {
                Number operand = this.operands.get(index);
                if (operand instanceof Integer) {
                    return (Integer)operand;
                }
                throw new IllegalArgumentException();
            }

            public List<Number> getArray() {
                return this.operands;
            }

            public List<Number> getDelta() {
                return this.operands;
            }

            public String toString() {
                return this.getClass().getName() + "[operands=" + this.operands + ", operator=" + this.operator + "]";
            }
        }
    }

    private static class Header {
        private int major;
        private int minor;
        private int hdrSize;
        private int offSize;

        private Header() {
        }

        public String toString() {
            return this.getClass().getName() + "[major=" + this.major + ", minor=" + this.minor + ", hdrSize=" + this.hdrSize + ", offSize=" + this.offSize + "]";
        }
    }

    private static class Format0FDSelect
    extends FDSelect {
        private int format;
        private int[] fds;

        private Format0FDSelect(CFFCIDFont owner) {
            super(owner);
        }

        @Override
        public int getFDIndex(int gid) {
            if (gid < this.fds.length) {
                return this.fds[gid];
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getName() + "[fds=" + Arrays.toString(this.fds) + "]";
        }

        static /* synthetic */ int[] access$2802(Format0FDSelect x0, int[] x1) {
            x0.fds = x1;
            return x1;
        }
    }

    private static final class Range3 {
        private int first;
        private int fd;

        private Range3() {
        }

        public String toString() {
            return this.getClass().getName() + "[first=" + this.first + ", fd=" + this.fd + "]";
        }
    }

    private static final class Format3FDSelect
    extends FDSelect {
        private int format;
        private int nbRanges;
        private Range3[] range3;
        private int sentinel;

        private Format3FDSelect(CFFCIDFont owner) {
            super(owner);
        }

        @Override
        public int getFDIndex(int gid) {
            for (int i = 0; i < this.nbRanges; ++i) {
                if (this.range3[i].first > gid) continue;
                if (i + 1 < this.nbRanges) {
                    if (this.range3[i + 1].first <= gid) continue;
                    return this.range3[i].fd;
                }
                if (this.sentinel > gid) {
                    return this.range3[i].fd;
                }
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getName() + "[format=" + this.format + " nbRanges=" + this.nbRanges + ", range3=" + Arrays.toString(this.range3) + " sentinel=" + this.sentinel + "]";
        }

        static /* synthetic */ Range3[] access$3202(Format3FDSelect x0, Range3[] x1) {
            x0.range3 = x1;
            return x1;
        }
    }
}

