/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.taglib.StaticData;
import org.dbforms.taglib.StaticDataAddInterface;
import org.dbforms.util.KeyValuePair;
import org.dbforms.util.MessageResources;
import org.dbforms.util.Util;

public class StaticDataItem
extends DbBaseHandlerTag
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog((String)StaticDataItem.class.getName());
    private String key;
    private String value;

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        String message = null;
        if (this.value != null && this.getParent() instanceof StaticData && this.getParent().getParent() instanceof DbBaseHandlerTag && this.getParentForm().hasCaptionResourceSet()) {
            try {
                message = MessageResources.getMessage(this.value, this.getLocale());
                if (!Util.isNull(message)) {
                    this.value = message;
                }
            }
            catch (Exception e) {
                logCat.debug((Object)("getValue(" + this.value + ") Exception : " + e.getMessage()));
            }
        }
        return this.value;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        this.key = null;
        this.value = null;
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        if (this.getParent() == null || !(this.getParent() instanceof StaticDataAddInterface)) {
            throw new JspException("StaticDataItem element must be placed inside a AddStaticData element!");
        }
        ((StaticDataAddInterface)this.getParent()).addElement(new KeyValuePair(this.key, this.getValue()));
        return 1;
    }
}

