/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.dbforms.config.Table;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.MessageResources;
import org.dbforms.util.Util;

public abstract class DbBaseButtonTag
extends DbBaseHandlerTag {
    protected static final int FLAVOR_STANDARD = 0;
    protected static final int FLAVOR_IMAGE = 1;
    protected static final int FLAVOR_MODERN = 2;
    private static int uniqueID = 0;
    private String alt;
    private String border;
    private String caption;
    private String disabledBehaviour;
    private String disabledImageAlt;
    private String disabledImageHeight;
    private String disabledImageSrc;
    private String disabledImageWidth;
    private String followUp;
    private String followUpOnError;
    private String src;
    private Table table;
    private int choosenFlavor = 0;

    public void setAlt(String src) {
        this.alt = src;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    public String getBorder() {
        return this.border;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public int getChoosenFlavor() {
        return this.choosenFlavor;
    }

    public void setDisabledBehaviour(String disabledBehaviour) {
        this.disabledBehaviour = disabledBehaviour;
    }

    public String getDisabledBehaviour() {
        return this.disabledBehaviour;
    }

    public void setDisabledImageAlt(String disabledImageAlt) {
        this.disabledImageAlt = disabledImageAlt;
    }

    public String getDisabledImageAlt() {
        return this.disabledImageAlt;
    }

    public void setDisabledImageHeight(String disabledImageHeight) {
        this.disabledImageHeight = disabledImageHeight;
    }

    public String getDisabledImageHeight() {
        return this.disabledImageHeight;
    }

    public void setDisabledImageSrc(String disabledImageSrc) {
        this.disabledImageSrc = disabledImageSrc;
    }

    public String getDisabledImageSrc() {
        return this.disabledImageSrc;
    }

    public void setDisabledImageWidth(String disabledImageWidth) {
        this.disabledImageWidth = disabledImageWidth;
    }

    public String getDisabledImageWidth() {
        return this.disabledImageWidth;
    }

    public void setFlavor(String flavor) {
        this.choosenFlavor = "image".equals(flavor) ? 1 : ("modern".equals(flavor) ? 2 : 0);
    }

    public void setFollowUp(String followUp) {
        this.followUp = followUp;
    }

    public String getFollowUp() {
        return this.followUp;
    }

    public void setFollowUpOnError(String followUpOnError) {
        this.followUpOnError = followUpOnError;
    }

    public String getFollowUpOnError() {
        return this.followUpOnError;
    }

    @Override
    public void setParent(Tag parent) {
        super.setParent(parent);
        this.table = this.getParentForm().getTable();
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getSrc() {
        return this.src;
    }

    public Table getTable() {
        return this.table;
    }

    public int doEndTag() throws JspException {
        if (this.choosenFlavor == 2) {
            try {
                if (this.bodyContent != null) {
                    this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
                }
                this.pageContext.getOut().write("</button>");
            }
            catch (IOException ioe) {
                throw new JspException("IO Error: " + ioe.getMessage());
            }
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.followUp = null;
        this.followUpOnError = null;
        this.table = null;
        this.choosenFlavor = 0;
        this.caption = null;
        this.src = null;
        this.alt = null;
        this.border = null;
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        if (this.getParentForm().getFormValidatorName() != null && this.getParentForm().getFormValidatorName().length() > 0 && this.getParentForm().hasJavascriptValidationSet()) {
            String onclick;
            String string = onclick = this.getOnClick() != null ? this.getOnClick() : "";
            if (onclick.lastIndexOf(";") != onclick.length() - 1) {
                onclick = onclick + ";";
            }
            this.setOnClick(onclick + this.JsValidation());
        }
        return 0;
    }

    protected static synchronized int getUniqueID() {
        return ++uniqueID;
    }

    protected String getButtonBegin() {
        String privAlt;
        StringBuffer buf = new StringBuffer();
        Locale locale = MessageResources.getLocale((HttpServletRequest)this.pageContext.getRequest());
        String privCaption = this.getCaption();
        if (privCaption != null && this.getParentForm().hasCaptionResourceSet()) {
            privCaption = MessageResources.getMessage(privCaption, locale);
        }
        if ((privAlt = this.getAlt()) != null && this.getParentForm().hasCaptionResourceSet()) {
            privAlt = MessageResources.getMessage(privAlt, locale);
        }
        switch (this.choosenFlavor) {
            case 1: {
                buf.append("<input type=\"image\" ");
                if (this.src != null) {
                    buf.append(" src=\"");
                    buf.append(this.src);
                    buf.append("\" ");
                }
                if (privAlt == null) break;
                buf.append(" alt=\"");
                buf.append(privAlt);
                buf.append("\" ");
                break;
            }
            case 2: {
                buf.append("<button type=\"submit\" ");
                if (privCaption == null) break;
                buf.append(" value=\"");
                buf.append(privCaption);
                buf.append("\" ");
                break;
            }
            default: {
                buf.append("<input type=\"submit\" ");
                if (privCaption == null) break;
                buf.append(" value=\"");
                buf.append(privCaption);
                buf.append("\" ");
            }
        }
        buf.append(this.prepareStyles());
        buf.append(this.prepareEventHandlers());
        return buf.toString();
    }

    protected String getButtonEnd() {
        switch (this.choosenFlavor) {
            case 1: {
                return "\"/>";
            }
            case 2: {
                return "\">";
            }
        }
        return "\"/>";
    }

    protected String getDataTag(String primaryTagName, String dataKey, String dataValue) {
        String s = "";
        if (!Util.isNull(dataValue)) {
            StringBuffer tagBuf = new StringBuffer();
            tagBuf.append("<input type=\"hidden\" name=\"data");
            tagBuf.append(primaryTagName);
            tagBuf.append("_");
            tagBuf.append(dataKey);
            tagBuf.append("\" value =\"");
            tagBuf.append(dataValue);
            tagBuf.append("\"/>");
            s = tagBuf.toString();
        }
        return s;
    }

    protected String getDisabledImage() {
        StringBuffer imgBuf = new StringBuffer();
        imgBuf.append("<img src=\"");
        imgBuf.append(this.getDisabledImageSrc());
        imgBuf.append("\"");
        imgBuf.append(" alt=\"");
        imgBuf.append(this.getDisabledImageAlt());
        imgBuf.append("\"");
        imgBuf.append(this.prepareStyles());
        if (!Util.isNull(this.getDisabledImageWidth())) {
            imgBuf.append(" width=\"");
            imgBuf.append(this.getDisabledImageWidth());
            imgBuf.append("\"");
        }
        if (!Util.isNull(this.getDisabledImageHeight())) {
            imgBuf.append(" height=\"");
            imgBuf.append(this.getDisabledImageHeight());
            imgBuf.append("\"");
        }
        imgBuf.append(" />");
        return imgBuf.toString();
    }

    protected String JsValidation() {
        return "bValidateForm=false;";
    }

    @Override
    protected String prepareStyles() {
        StringBuffer styles = new StringBuffer(super.prepareStyles());
        if (this.border != null) {
            styles.append(" border=\"");
            styles.append(this.border);
            styles.append("\"");
        }
        return styles.toString();
    }
}

