/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import jakarta.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.managed.TransactionRegistry;
import org.apache.commons.dbcp.managed.XAConnectionFactory;

public class LocalXAConnectionFactory
implements XAConnectionFactory {
    protected TransactionRegistry transactionRegistry;
    protected ConnectionFactory connectionFactory;

    public LocalXAConnectionFactory(TransactionManager transactionManager, ConnectionFactory connectionFactory) {
        if (transactionManager == null) {
            throw new NullPointerException("transactionManager is null");
        }
        if (connectionFactory == null) {
            throw new NullPointerException("connectionFactory is null");
        }
        this.transactionRegistry = new TransactionRegistry(transactionManager);
        this.connectionFactory = connectionFactory;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Override
    public Connection createConnection() throws SQLException {
        Connection connection = this.connectionFactory.createConnection();
        LocalXAResource xaResource = new LocalXAResource(connection);
        this.transactionRegistry.registerConnection(connection, xaResource);
        return connection;
    }

    protected static class LocalXAResource
    implements XAResource {
        private final Connection connection;
        private Xid currentXid;
        private boolean originalAutoCommit;

        public LocalXAResource(Connection localTransaction) {
            this.connection = localTransaction;
        }

        public synchronized Xid getXid() {
            return this.currentXid;
        }

        @Override
        public synchronized void start(Xid xid, int flag) throws XAException {
            if (flag == 0) {
                if (this.currentXid != null) {
                    throw new XAException("Already enlisted in another transaction with xid " + xid);
                }
                try {
                    this.originalAutoCommit = this.connection.getAutoCommit();
                }
                catch (SQLException ignored) {
                    this.originalAutoCommit = true;
                }
                try {
                    this.connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw (XAException)new XAException("Count not turn off auto commit for a XA transaction").initCause(e);
                }
                this.currentXid = xid;
            } else if (flag == 0x8000000) {
                if (xid != this.currentXid) {
                    throw new XAException("Attempting to resume in different transaction: expected " + this.currentXid + ", but was " + xid);
                }
            } else {
                throw new XAException("Unknown start flag " + flag);
            }
        }

        @Override
        public synchronized void end(Xid xid, int flag) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
        }

        @Override
        public synchronized int prepare(Xid xid) {
            try {
                if (this.connection.isReadOnly()) {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                    return 3;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return 0;
        }

        @Override
        public synchronized void commit(Xid xid, boolean flag) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
            try {
                if (this.connection.isClosed()) {
                    throw new XAException("Conection is closed");
                }
                if (!this.connection.isReadOnly()) {
                    this.connection.commit();
                }
            }
            catch (SQLException e) {
                throw (XAException)new XAException().initCause(e);
            }
            finally {
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                }
                catch (SQLException e) {}
                this.currentXid = null;
            }
        }

        @Override
        public synchronized void rollback(Xid xid) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                throw (XAException)new XAException().initCause(e);
            }
            finally {
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                }
                catch (SQLException e) {}
                this.currentXid = null;
            }
        }

        @Override
        public boolean isSameRM(XAResource xaResource) {
            return this == xaResource;
        }

        @Override
        public synchronized void forget(Xid xid) {
            if (xid != null && this.currentXid.equals(xid)) {
                this.currentXid = null;
            }
        }

        @Override
        public Xid[] recover(int flag) {
            return new Xid[0];
        }

        @Override
        public int getTransactionTimeout() {
            return 0;
        }

        @Override
        public boolean setTransactionTimeout(int transactionTimeout) {
            return false;
        }
    }
}

