/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Switch
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Switch();

    @Override
    public String parseFunction(List<String> list, IWikiModel model, char[] src, int beginIndex, int endIndex) {
        if (list.size() > 2) {
            String defaultResult = null;
            String conditionString = this.parse(list.get(0), model);
            boolean valueFound = false;
            for (int i = 1; i < list.size(); ++i) {
                String leftHandSide;
                String temp = this.parse(list.get(i), model);
                int index = temp.indexOf(61);
                if (index >= 0) {
                    if (valueFound) {
                        return temp.substring(index + 1).trim();
                    }
                    leftHandSide = temp.substring(0, index).trim();
                } else {
                    leftHandSide = temp.trim();
                }
                String parsedLHS = this.parse(leftHandSide, model);
                if (index >= 0 && "#default".equals(parsedLHS)) {
                    defaultResult = temp.substring(index + 1).trim();
                    continue;
                }
                if (index < 0 && i == list.size() - 1) {
                    return parsedLHS;
                }
                if (!this.equalsTypes(conditionString, parsedLHS)) continue;
                if (index >= 0) {
                    return temp.substring(index + 1).trim();
                }
                valueFound = true;
            }
            return defaultResult;
        }
        return null;
    }

    private boolean equalsTypes(String first, String second) {
        boolean result = false;
        if (first.length() == 0) {
            return second.length() == 0;
        }
        if (second.length() == 0) {
            return first.length() == 0;
        }
        if (first.charAt(0) == '+') {
            first = first.substring(1);
        }
        if (second.charAt(0) == '+') {
            second = second.substring(1);
        }
        try {
            double d1 = Double.parseDouble(first);
            double d2 = Double.parseDouble(second);
            if (d1 == d2) {
                result = true;
            }
        }
        catch (NumberFormatException e) {
            result = first.equals(second);
        }
        return result;
    }
}

