/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.util.DateUtils;
import de.memtext.util.HsqlUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;

public class Field
implements Cloneable,
Serializable {
    private String name;
    private Object value;
    private int type;

    public Field(String name, int type) {
        if (name == null) {
            throw new NullPointerException("Field name must not be null");
        }
        this.setName(name);
        this.setType(type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Field name must not be null");
        }
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getValueString() {
        String result = this.value == null ? "" : this.value.toString();
        if (this.value != null && this.getType() == 91) {
            result = DateUtils.format((java.sql.Date)this.value);
        }
        return result;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value == null) {
            this.value = null;
        } else {
            switch (this.getType()) {
                case -6: 
                case 2: 
                case 4: 
                case 5: {
                    try {
                        this.value = new BigInteger(value.toString());
                        break;
                    }
                    catch (NumberFormatException e2) {
                        throw new IllegalArgumentException(value + " not OK for field: " + this.getName());
                    }
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    try {
                        this.value = new BigDecimal(value.toString());
                        break;
                    }
                    catch (NumberFormatException e3) {
                        throw new IllegalArgumentException(value + " not OK for field: " + this.getName());
                    }
                }
                case -1: 
                case 1: 
                case 12: {
                    this.value = value.toString();
                    break;
                }
                case 91: {
                    if (value instanceof Date) {
                        this.value = value;
                        break;
                    }
                    try {
                        this.value = DateUtils.parse(value.toString());
                        break;
                    }
                    catch (ParseException e4) {
                        throw new IllegalArgumentException(value + " not OK for field: " + this.getName());
                    }
                }
                default: {
                    throw new RuntimeException("SQL-Type " + this.getType() + " not supported!");
                }
            }
        }
    }

    public boolean isStringType() {
        boolean result = false;
        switch (this.getType()) {
            case -1: 
            case 1: 
            case 12: {
                result = true;
            }
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Field result = (Field)super.clone();
        result.setName(this.getName());
        result.setType(this.getType());
        Object value = this.getValue();
        Object newval = null;
        if (value != null) {
            if (value instanceof String) {
                newval = new String(value.toString());
            }
            if (value instanceof BigInteger) {
                newval = new BigInteger(value.toString());
            }
            if (value instanceof BigDecimal) {
                newval = new BigDecimal(value.toString());
            }
            if (value instanceof Date) {
                newval = ((Date)value).clone();
            }
            if (newval == null) {
                throw new CloneNotSupportedException("can't clone datatype" + value.getClass());
            }
        }
        result.setValue(newval);
        return result;
    }

    public String toString() {
        return "Field name:" + this.getName() + " type:" + this.getType() + " value:" + this.getValueString();
    }

    public String getInsertCommandValue() {
        StringBuffer result = new StringBuffer();
        if (this.getValue() == null) {
            result.append("null");
        } else if (this.getType() != 91) {
            if (this.isStringType()) {
                result.append("'");
            }
            result.append(this.getValueString());
            if (this.isStringType()) {
                result.append("'");
            }
        } else {
            result.append(HsqlUtils.getDateForHsql((Date)this.getValue()));
        }
        return result.toString();
    }
}

