/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;

public class TrailingDelimiterRemovingReader
extends FilterReader {
    private final String delimiter;
    private StringBuffer currentLine = null;
    private int currentIdx = 0;
    private final int columnCount;
    private int lineNr = 0;
    private final boolean trailingDelimiter;
    private final String filename;
    public static StrTokenizer csvTokenizer = new StrTokenizer().setDelimiterMatcher(new StrMatcher(){

        public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            int result = 0;
            if (buffer[pos] == '^') {
                int countBackSlashesBefore = 0;
                for (int index = pos - 1; index >= 0 && buffer[index] == '\\'; --index) {
                    ++countBackSlashesBefore;
                }
                if (countBackSlashesBefore % 2 == 0) {
                    result = 1;
                }
            }
            return result;
        }
    }).setIgnoreEmptyTokens(false);

    public TrailingDelimiterRemovingReader(Reader in, String delimiter, int columnCount, boolean trailingDelimiter, String filename) {
        super(in);
        this.delimiter = delimiter;
        this.columnCount = columnCount;
        this.trailingDelimiter = trailingDelimiter;
        this.filename = filename;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.currentLine == null) {
            this.readNextLine();
        }
        if (this.currentLine != null) {
            int num = Math.min(len, Math.min(cbuf.length - off, this.currentLine.length() - this.currentIdx));
            for (int i = 0; i < num; ++i) {
                cbuf[off++] = this.currentLine.charAt(this.currentIdx++);
            }
            if (this.currentIdx == this.currentLine.length()) {
                this.currentLine = null;
                this.currentIdx = 0;
            }
            return num;
        }
        if (len > 0) {
            return -1;
        }
        return 0;
    }

    private void readNextLine() {
        StringBuffer result = new StringBuffer();
        try {
            String line = ((BufferedReader)this.in).readLine();
            while (line != null) {
                result.append(line);
                if (result.length() > 0 && result.charAt(result.length() - 1) == '\\') {
                    result.append('\n');
                    line = ((BufferedReader)this.in).readLine();
                    continue;
                }
                line = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (result.length() > 0) {
            ++this.lineNr;
            this.currentLine = result;
            int idx = this.currentLine.lastIndexOf(this.delimiter);
            if (this.trailingDelimiter && idx > -1) {
                this.currentLine.deleteCharAt(idx);
            }
            csvTokenizer.reset(this.currentLine.toString());
            int delimiterCount = csvTokenizer.size();
            if (delimiterCount != this.columnCount) {
                throw new RuntimeException("Wrong column count in input line " + this.lineNr + ". Expected " + this.columnCount + " found " + delimiterCount + " in file " + this.filename);
            }
            this.currentLine.append('\n');
        } else {
            this.currentLine = null;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.currentLine != null || this.in.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

