/*
 * Decompiled with CFR 0.152.
 */
package de.superx.transfer;

import de.memtext.icons.MBStandardIcons;
import de.memtext.util.IconUtils;
import de.memtext.util.WindowUtils;
import de.memtext.widgets.FileOrDirSelectionPanel;
import de.memtext.widgets.InfoMessage;
import de.memtext.widgets.MBFrame;
import de.memtext.widgets.VerticalBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class ActionPanel
extends VerticalBox
implements ActionListener {
    private FileOrDirSelectionPanel unloadPathPanel;
    private Vector files = new Vector();
    private DefaultListModel fileListModel = new DefaultListModel();
    private JLabel lblDir = new JLabel("Dateiliste");
    private Font btnFont = new Font("Serif", 1, 14);

    public ActionPanel() {
        this.addStrut(40);
        JLabel lblTitle = new JLabel("Lokal");
        lblTitle.setFont(new Font("SansSerif", 1, 16));
        this.addWithCenterAlignment(lblTitle);
        this.unloadPathPanel = new FileOrDirSelectionPanel("Unload Pfad");
        this.unloadPathPanel.setFileSelectionMode(1);
        this.addWithCenterAlignment(this.unloadPathPanel);
        this.addStrut(40);
        JButton btnUnload = new JButton("entladen", IconUtils.get("de/superx/transfer/unload.gif"));
        btnUnload.setFont(this.btnFont);
        btnUnload.addActionListener(this);
        JPanel pUnload = new JPanel(new FlowLayout(0));
        pUnload.setBackground(null);
        pUnload.add(new JLabel(IconUtils.get("de/superx/transfer/pfeil-gruen.gif")));
        pUnload.add(btnUnload);
        this.add(pUnload);
        JLabel lblArrowDown = new JLabel(IconUtils.get("de/superx/transfer/pfeil-down-gruen.gif"));
        lblArrowDown.setBackground(null);
        this.addStrut(20);
        this.add(this.lblDir);
        JList fileList = new JList(this.fileListModel);
        fileList.setVisibleRowCount(7);
        this.add(new JScrollPane(fileList));
        JButton btnPreview = new JButton("Vorschau", MBStandardIcons.getViewingGlass());
        this.addWithCenterAlignment(btnPreview);
        btnPreview.addActionListener(this);
        this.addStrut(20);
        JButton btnUpload = new JButton("abschicken", IconUtils.get("de/superx/transfer/upload.gif"));
        btnUpload.setFont(this.btnFont);
        this.addStrut(20);
        JPanel p2 = new JPanel(new FlowLayout(2));
        p2.add(btnUpload);
        btnUpload.addActionListener(this);
        p2.add(new JLabel(IconUtils.get("de/superx/transfer/pfeil-blau.gif")));
        this.add(p2);
        Border border = BorderFactory.createEtchedBorder();
        this.addGlue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("entladen")) {
            this.unload();
        }
        if (e.getActionCommand().equals("Vorschau")) {
            this.preview();
        }
        if (e.getActionCommand().equals("abschicken")) {
            this.upload();
        }
    }

    private void upload() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        InfoMessage.show((Component)this, "\u00dcbertragung erfolgreich", "SuperX Transfer Tool");
    }

    private void unload() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.fileListModel.removeAllElements();
        this.fileListModel.addElement("k_abint.xml");
        this.fileListModel.addElement("k_abext.xml");
        this.fileListModel.addElement("k_stg.xml");
        this.fileListModel.addElement("k_pvers.xml");
        this.fileListModel.addElement("k_vert.xml");
        this.fileListModel.addElement("k_schwp.xml");
        this.fileListModel.addElement("k_nc.xml");
        this.fileListModel.addElement("k_abstgv.xml");
    }

    private void preview() {
        try {
            File startFile = new File("index.htm");
            JEditorPane pane = new JEditorPane("file://" + startFile.getAbsolutePath());
            pane.setEditable(false);
            MBFrame f = new MBFrame("Vorschau");
            f.setIconImage(IconUtils.get("de/superx/transfer/transferIcon.gif").getImage());
            pane.addHyperlinkListener(new Hyperactive(f));
            f.setSystemExitOnClose(false);
            f.setCenter(new JScrollPane(pane));
            WindowUtils.maximize(f);
            f.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addObserver(Observer observer) {
        this.unloadPathPanel.addObserver(observer);
    }

    class Hyperactive
    implements HyperlinkListener {
        private JFrame parentFrame;

        Hyperactive(JFrame parentFrame) {
            this.parentFrame = parentFrame;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        WindowUtils.setWaitCursor(this.parentFrame, true);
                        pane.setPage(e.getURL());
                        WindowUtils.setWaitCursor(this.parentFrame, false);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

