/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.service;

import de.superx.common.AccessDeniedException;
import de.superx.common.SxUser;
import de.superx.rest.model.job.Component;
import de.superx.spring.service.UserService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class UserServiceImpl
implements UserService {
    @Override
    public UserDetails currentUserDetails() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            Object principal = authentication.getPrincipal();
            return principal instanceof UserDetails ? (UserDetails)principal : null;
        }
        return null;
    }

    @Override
    public void checkRights(int report_tid, SxUser user) {
        if (user != null && !user.hasRightsOnReport(report_tid)) {
            throw new AccessDeniedException("No right to access report " + report_tid);
        }
    }

    @Override
    public void checkAdminRights() {
        SxUser user = (SxUser)this.currentUserDetails();
        if (user != null && !user.isAdmin()) {
            throw new AccessDeniedException("No right to access administrative functions");
        }
    }

    @Override
    public void checkViewRights() {
        SxUser user = (SxUser)this.currentUserDetails();
        if (user != null && !user.getHis1Rights().contains("RIGHT_CS_BIA_ANALYSIS_VIEW_ANALYSIS_TABLE")) {
            throw new AccessDeniedException("No right to access View functions");
        }
    }

    @Override
    public void checkEtlJobRights() {
        SxUser user = (SxUser)this.currentUserDetails();
        if (user != null && !user.getHis1Rights().contains("RIGHT_CS_BIA_STANDARDREPORTS_ADMIN") && !user.getHis1Rights().contains("RIGHT_CS_BIA_STANDARDREPORTS_START_CONNECTOR")) {
            throw new AccessDeniedException("No right to execute etl jobs");
        }
    }

    @Override
    public void checkLieferfreigabeRights() {
        SxUser user = (SxUser)this.currentUserDetails();
        if (user != null && !user.getHis1Rights().contains("RIGHT_CS_BIA_STANDARDREPORTS_MANAGE_REPORTDELIVERY")) {
            throw new AccessDeniedException("No right to access to save or delete Lieferfreigaben");
        }
    }

    @Override
    public void checkStichtageRights() {
        SxUser user = (SxUser)this.currentUserDetails();
        if (user != null && !user.getHis1Rights().contains("RIGHT_CS_BIA_STANDARDREPORTS_ADMIN")) {
            throw new AccessDeniedException("No right to access to save or delete Stichtage");
        }
    }

    @Override
    public void checkReportDeliveryRights() {
        SxUser user = (SxUser)this.currentUserDetails();
        if (user != null && !user.getHis1Rights().contains("RIGHT_CS_BIA_STANDARDREPORTS_MANAGE_REPORTDELIVERY") && !user.getHis1Rights().contains("RIGHT_CS_BIA_STANDARDREPORTS_ADMIN")) {
            throw new AccessDeniedException("No right of access");
        }
    }

    @Override
    public List<Component> filterComponents(List<Component> components) {
        String allowedComponentsList;
        SxUser user = (SxUser)this.currentUserDetails();
        Map<String, Map<String, String>> rightsMap = null;
        Map<String, String> startConnectorMap = null;
        if (user != null) {
            rightsMap = user.getRightsMap();
            startConnectorMap = rightsMap.get("RIGHT_CS_BIA_STANDARDREPORTS_START_CONNECTOR");
        }
        if (startConnectorMap != null && !startConnectorMap.isEmpty() && (allowedComponentsList = startConnectorMap.get("bi_component")) != null) {
            List<String> allowedComponents = Arrays.asList(StringUtils.split((String)allowedComponentsList, (char)','));
            return components.stream().filter(component -> allowedComponents.contains(component.getAbbreviation())).collect(Collectors.toList());
        }
        return components;
    }
}

