/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import java.util.HashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.jdbc.core.JdbcTemplate;

public class UnloadParamReaderTasklet
implements Tasklet,
StepExecutionListener {
    private JdbcTemplate jdbcTemplate;
    private Integer systeminfoId;
    private StepExecution stepExecution;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public UnloadParamReaderTasklet(int systeminfoId, DataSource dataSource) {
        this.systeminfoId = systeminfoId;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return ExitStatus.COMPLETED;
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        assert (this.systeminfoId != null);
        HashMap unloadParams = new HashMap();
        ExecutionContext executionContext = this.stepExecution.getJobExecution().getExecutionContext();
        this.jdbcTemplate.query("select param_id, param_val from unload_params where systeminfo_id = ?", new Object[]{this.systeminfoId}, resultSet -> {
            this.logger.info("PUT PARAM " + resultSet.getString("param_id") + "->" + resultSet.getString("param_val"));
            unloadParams.put(resultSet.getString("param_id"), resultSet.getString("param_val"));
        });
        executionContext.put("UNLOAD_PARAMS", unloadParams);
        return RepeatStatus.FINISHED;
    }
}

