/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.DateUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.TimeUtils;
import de.memtext.util.TransletUtils;
import de.memtext.util.XmlFlatFileMerger;
import de.superx.common.DBServletException;
import de.superx.common.SxUser;
import de.superx.common.TransletCache;
import de.superx.conf.InitStatus;
import de.superx.job.ContainerNode;
import de.superx.rest.EtlJobApi;
import de.superx.saiku.SuperxRepositoryDataSourceManager;
import de.superx.sec.HttpGetAccessGuard;
import de.superx.sec.HttpGetAccessListParser;
import de.superx.sec.InputCheckRegistry;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.LdapPasswordChecker;
import de.superx.servlet.MaskenContainer;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SessionAttribute;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.servlet.UserInitializer;
import de.superx.servlet.XUpdaterServlet;
import de.superx.spring.batch.job.BiQuartzBatchJob;
import de.superx.spring.service.BeanUtil;
import de.superx.spring.service.DbJobDescriptionAdapter;
import de.superx.spring.service.EntityJobDescriptionSource;
import de.superx.spring.service.JobAdapter;
import de.superx.util.JasperUtils;
import de.superx.util.PathAndFileUtils;
import de.superx.util.SqlStringUtils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.core.fs.local.FileUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DataSourceProviderFactory;
import org.pentaho.di.core.database.DataSourceProviderInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;

@Component
public class SuperXManager
extends HttpServlet
implements ApplicationContextAware {
    private static final String INSTALLED_COMPONENTS_LOOKUP_SQL = "SELECT trim(his_system) FROM db_version";
    private static final String PLATTFORM_LOOKUP_SQL = "SELECT apnr AS plattform_id FROM konstanten WHERE beschreibung = 'PLATTFORM'";
    private static Logger logger = Logger.getLogger(SuperXManager.class);
    private static ApplicationContext applicationContext;
    public static final String QIS_CONTEXT = "QIS_CONTEXT";
    public static final String PARAM_SUPERX_STANDALONE = "superxStandalone";
    private static final String PROP_DB_SET = "SuperX-DB-PROPERTIES-SET";
    private static final String PROP_DB_SET_NEW_SPELLING = "superxDbPropertiesSet";
    private static final long serialVersionUID = 2L;
    public static final long maxMillisWaitingTime = 1800000L;
    public static String his1_refapp;
    private SuperXInitThread initThread;
    public static HttpGetAccessGuard httpGetAccessGuard;
    public static final String SUPER_X_HISINONE_VERSION = "SuperX-HISinOne-VERSION";
    public static boolean isZukuenftigerStandErlaubt;
    public static int maxRows;
    public static String defaultMaskXsl;
    public static String defaultTableHtmlXsl;
    public static String defaultTableXlsXsl;
    public static String defaultTablePdfXsl;
    public static String sharedSecret;
    private static String xmenu;
    private static String xmask;
    private static String xtablehtml;
    private static String xtablexsl;
    private static String xtablepdf;
    public static boolean isSichtenCachingWanted;
    public static boolean canWriteUserHomeDir;
    public static boolean canWriteUserKettleDir;
    private static final String ADMIN_ONLY;
    private static final int PLATTFORM_ID_HISINONE = 1;
    private static String pageBeginning;
    private static String pageEnd;
    public static StringBuffer activityLog;
    private static String lastFMMaskenSql;
    private static String lastMaskenSql;
    private static String lastXml;
    private static String lastXmlMandantid;
    private static String lastMaskenSqlMandantid;
    public static boolean isDevelopmentMode;
    private static boolean isLastSqlExtraPageWanted;
    public static boolean isXMLReturnLinkWanted;
    static String refererstart;
    public static String field1Cache;
    private static CacheUpdater cashUpdater;
    public static boolean isHis1;
    private static String webinfPfad;
    private static String moduleDir;
    public static boolean isResponseCompressionWanted;
    private static String noSessionFieldDefaults;
    private static Date start;
    private static boolean isStandaloneLdapActive;
    public static String sxversion;
    public static String builddatum;

    public static String getMaxRowsHinweis() {
        return " Die Datenbank lieferte eine gro\u00dfe Menge an Datens\u00e4tzen. Es werden generell nur die ersten " + maxRows + " dargestellt, in Datenblatt-Abfragen ggf. sogar weniger. Schr\u00e4nken Sie Ihre Abfrage ggfs. weiter ein oder nutzen den Excelexport";
    }

    public static boolean isSessionFieldDefaultsWanted(String mandantenID) {
        if (noSessionFieldDefaults == null) {
            noSessionFieldDefaults = "";
        }
        return noSessionFieldDefaults.indexOf("," + mandantenID + ",") == -1;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.debug((Object)"SuperXManager start.");
        start = new Date();
        webinfPfad = this.getServletConfig().getServletContext().getRealPath("/WEB-INF");
        canWriteUserHomeDir = SuperXManager.checkCanWriteUserHomeDir();
        canWriteUserKettleDir = SuperXManager.checkCanWriteUserKettleDir();
        this.checkHis1OrStandalone();
        if (!SuperXManager.isHis1()) {
            this.initLdapPasswordCheckingIfConfigured();
        }
        try {
            this.initThread = new SuperXInitThread(config);
            this.initThread.start();
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    private void initLdapPasswordCheckingIfConfigured() {
        File superxStandaloneLdapConfigFile = new File(webinfPfad + File.separator + "superx_standalone_ldap.properties");
        if (superxStandaloneLdapConfigFile.exists()) {
            System.out.println(" Passwortkontrolle via LDAP wird aktiviert");
            isStandaloneLdapActive = true;
            try {
                LdapPasswordChecker.setup(superxStandaloneLdapConfigFile);
            }
            catch (Exception e) {
                System.out.println(" Konfiguration Passwordkontrolle via LDAP fehlgeschlagen " + String.valueOf(e));
                e.printStackTrace();
            }
        }
    }

    private void checkHis1OrStandalone() {
        String param = this.getServletContext().getInitParameter(PARAM_SUPERX_STANDALONE);
        if (param == null) {
            logger.info((Object)"Kein Init-Parameter superxStandalone (true/false) in web.xml f\u00fcr SuperXManager gefunden. Setze auf HisInOne-Umgebung");
            isHis1 = true;
        } else if (param.toLowerCase().equals("false")) {
            isHis1 = true;
            logger.info((Object)"Setze Umgebung HisInOneaufgrund von Init-Parameter superxStandalone in web.xml f\u00fcr SuperXManager.");
        } else {
            isHis1 = false;
            String msg = "Setze Umgebung SuperX (Standalone)aufgrund von Init-Parameter superxStandalone in web.xml f\u00fcr SuperXManager.";
            logger.info((Object)msg);
            System.out.println(msg);
        }
    }

    public static String getWEB_INFPfad() {
        return webinfPfad;
    }

    public static void setWEB_INFPfad(String p) {
        webinfPfad = p;
    }

    private void initXSLFilenames() {
        xmenu = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/menue_html.xsl");
        xmask = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/" + defaultMaskXsl);
        xtablehtml = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/" + defaultTableHtmlXsl);
        xtablexsl = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/" + defaultTableXlsXsl);
        xtablepdf = "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/" + defaultTablePdfXsl);
    }

    public static void initStandardXsl() throws TransformerConfigurationException, DBServletException {
        TransletCache.getTransformer(null, xmenu);
        TransletCache.getTransformer(null, xmask);
        TransletCache.getTransformer(null, xtablehtml);
        TransletCache.getTransformer(null, xtablexsl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        super.destroy();
        try {
            if (this.initThread != null) {
                this.initThread.destroy();
            }
            SxPools.closeAll();
            cashUpdater.setActive(false);
            cashUpdater.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Enumeration<Driver> en = DriverManager.getDrivers();
            while (en.hasMoreElements()) {
                Driver d = en.nextElement();
                try {
                    DriverManager.deregisterDriver(d);
                    logger.info((Object)(String.valueOf(new Date()) + "{} deregister {}" + String.valueOf(d)));
                }
                catch (Exception e) {
                    logger.error((Object)"Couldn't deregister driver", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (KettleEnvironment.isInitialized()) {
                KettleEnvironment.shutdown();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AbstractSuperXServlet.setEncoding(request);
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        if (ServletHelper.getParameter(request, RequestParameter.kennung) != null && ServletHelper.getParameter(request, RequestParameter.passwort) != null) {
            UserInitializer ui = new UserInitializer(request);
            try {
                ui.perform(null, null);
            }
            catch (Exception e) {
                throw new ServletException("Authentifizierung f\u00fcr " + ServletHelper.getParameter(request, RequestParameter.kennung) + " fehlgeschlagen");
            }
        }
        if (request.getParameter(RequestParameter.xupdater.toString()) != null) {
            XUpdaterServlet xu = new XUpdaterServlet();
            xu.doPost(request, response);
        } else {
            SxUser user = (SxUser)request.getSession().getAttribute(SessionAttribute.user.toString());
            if (user == null || !user.isAdmin()) {
                PrintWriter output = response.getWriter();
                output.write(ADMIN_ONLY);
                output.flush();
            } else {
                SxManager m = new SxManager(request, response);
                m.run(false);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        SxUser user = (SxUser)request.getSession().getAttribute(SessionAttribute.user.toString());
        if (user == null || !user.isAdmin()) {
            PrintWriter output = response.getWriter();
            output.write(ADMIN_ONLY);
            output.flush();
            output.close();
        } else if (request.getParameter(RequestParameter.xupdater.toString()) != null) {
            XUpdaterServlet xu = new XUpdaterServlet();
            xu.doGet(request, response);
        } else {
            boolean isLastSqlXmlWantend;
            PrintWriter output = response.getWriter();
            String showLastSqlXml = ServletHelper.getParameter(request, RequestParameter.showlastsqlxml);
            boolean bl = isLastSqlXmlWantend = showLastSqlXml != null && showLastSqlXml.equals("true");
            if (isLastSqlXmlWantend) {
                output.write(pageBeginning + this.getLastSqlXml() + pageEnd);
            } else {
                CsrfToken token = SuperXServletHelper.getCsRfToken(request);
                output.write(this.getStandardPage(request, "", token.getParameterName(), token.getToken()) + pageEnd);
            }
            output.flush();
            output.close();
        }
    }

    private String getLastSqlXml() {
        StringBuffer result = new StringBuffer("<br>");
        result.append("<center><table><tr>");
        result.append("<td><p align=center><b>letzter Masken sql (vom XML-Frontend)<br>vor FreeMarker-Transformation</b></p><textarea name=\"sql\" rows=20 cols=50>" + lastFMMaskenSql + "</textarea></td>");
        result.append("<td><p align=center><b>letzter Masken sql (vom XML-Frontend)</b></p><textarea name=\"sql\" rows=20 cols=50>" + lastMaskenSql + "</textarea></td><td><p align=center><b>letztes XML</b></p><textarea name=\"xml\" rows=20 cols=50>" + lastXml + "</textarea></td></tr></table></center>");
        return result.toString();
    }

    public String getStandardPage(HttpServletRequest request, String comment, String tokenParamName, String token) {
        String m = ServletUtils.getMandantenID(request);
        StringBuffer result = new StringBuffer(pageBeginning + (String)(m.equals(SxSQL_Server.DEFAULT_MANDANTEN_ID) ? "" : "<center>(Mandant: " + m + ")<br>\n") + "\n<br><center><form action=\"SuperXManager\" method=post>" + comment + "\n<br><br><input type=submit name=\"cache\" value=\"Server-Cache aktualisieren\">&nbsp;<input type=submit name=\"clearStylesheets\" value=\"nur Stylesheet-Cache leeren\"></font><br><font>Es werden Erl&auml;uterungen und &Uuml;bersetzungen (captions) gecacht.<br>F&uuml;rs XML-Frontend auch: User,Userrechte und Sichten,<br> und auch Abfragen wenn in der db.properties eingetragen</font> <br><br><font size=+1>Entwicklungsmodus ist " + (isDevelopmentMode ? "AN" : "AUS") + " <input type=radio name=\"Entwicklungsmodus\" value=\"an\"" + (isDevelopmentMode ? "checked" : "") + ">an\n<input type=radio name=\"Entwicklungsmodus\" value=\"aus\"" + (!isDevelopmentMode ? "checked" : "") + ">aus\n\n</font><input type=submit value=\"&Uuml;bernehmen\"><br>(Im Entwicklungsmodus werden alle SQL-Befehle von Abfragen einzeln an die Datenbank geschickt.<br>Das dauert l&auml;nger, erm&ouml;glicht aber bessere Fehlermeldungen.)<br><br>Achtung: bei Informix sollten Sie den Entwicklungsmodus nicht ausschalten, der JDBC-Treiber arbeitet dann instabil.<br><br><input type=\"hidden\" name=\"" + tokenParamName + "\" value=\"" + token + "\">\n<br><br><input type=submit name=\"clearlogfiles\" value=\"Log-Dateien leeren\"><br>\n");
        result.append("</form>");
        result.append("</form></center>");
        result.append(SuperXManager.htmlSubsystemsInitStatus(m));
        if (isLastSqlExtraPageWanted) {
            result.append(this.getLastSqlXml());
        } else {
            result.append("<a href=\"SuperXManager?showlastsqlxml=true\" target=\"_blank\">letzter SQL / XML</a><br><br><hr>");
        }
        result.append("<center><h2>LOG  <a href=\"SuperXManager\">aktualisieren<a/></h2><br>" + String.valueOf(activityLog) + "<br><hr><a href=\"SuperXManager\">LOG aktualisieren<a/>");
        result.append("<br><br>" + SxPools.getPoolFinRechteInfos());
        result.append(pageEnd);
        return result.toString();
    }

    public static void setLastMaskenSql(String sql) {
        lastMaskenSql = sql;
    }

    public static String getLastMaskenSql() {
        return lastMaskenSql;
    }

    public static void setLastXml(String xml) {
        lastXml = xml;
    }

    public static String getLastXml() {
        return lastXml;
    }

    public static String getLastMaskenSqlMandantid() {
        return lastMaskenSqlMandantid;
    }

    public static void setLastMaskenSqlMandantid(String lastMaskenSqlMandantid) {
        SuperXManager.lastMaskenSqlMandantid = lastMaskenSqlMandantid;
    }

    public static String getLastXmlMandantid() {
        return lastXmlMandantid;
    }

    public static void setLastXmlMandantid(String lastXmlMandantid) {
        SuperXManager.lastXmlMandantid = lastXmlMandantid;
    }

    static synchronized void initAll() throws KeyParentEqualException, NichtAngemeldetException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException, DBServletException, TransformerException {
        SxPools.resetAllPools();
        logger.debug((Object)(" using encoding: " + SqlStringUtils.getEncoding()));
        SuperXManager.clearTransletStylesheets();
    }

    public static void initPool(HttpServletRequest request, String mandantenID) throws TransformerConfigurationException, SQLException, DBServletException, IOException {
        logger.debug((Object)(DateUtils.getNowString() + " Server Cache wird neu geladen f\u00fcr :" + mandantenID));
        MaskenContainer mc = MaskenContainer.getFromRequest(request);
        mc.clear();
        if (mandantenID.equals(SxSQL_Server.DEFAULT_MANDANTEN_ID)) {
            SxPools.resetAllPools();
        } else {
            SxPools.get(mandantenID).init();
        }
        logger.debug((Object)(" using encoding: " + SqlStringUtils.getEncoding()));
        SuperXManager.clearTransletStylesheets();
        SuperXManager.initStandardXsl();
    }

    public static void clearTransletStylesheets() throws TransformerConfigurationException, DBServletException {
        JasperUtils.compileAllJRXMLFiles(webinfPfad + File.separator + "reports" + File.separator);
        logger.debug((Object)(DateUtils.getNowString() + " Stylesheet-Cache geleert"));
        TransletCache.clear();
    }

    public String getServletInfo() {
        return "SuperXManager";
    }

    public static void clearLog() {
        activityLog.setLength(0);
    }

    public static void logActivity(Level level, String log) {
        if (level == null) {
            level = Level.INFO;
        }
        activityLog.append(TimeUtils.getNowString() + " " + log + "<br>");
    }

    public static boolean isHis1() {
        return isHis1;
    }

    public static void setHis1TrueForTesting() {
        isHis1 = true;
    }

    public static boolean isDBPropsSet() {
        boolean result = false;
        if ("true".equalsIgnoreCase(System.getProperty(PROP_DB_SET))) {
            result = true;
        }
        if ("true".equalsIgnoreCase(System.getProperty(PROP_DB_SET_NEW_SPELLING))) {
            result = true;
        }
        return result;
    }

    public static void initMondrianSchema(DataSource dataSource, SuperxRepositoryDataSourceManager srdm) throws Exception {
        DataSource ds = dataSource == null ? (DataSource)applicationContext.getBean("dataSource") : dataSource;
        try {
            if (!SuperXManager.isHISinOneConfigured(ds)) {
                return;
            }
            List<String> installed_components = SuperXManager.lookupInstalledComponents(ds);
            ClassPathResource cp_rec = new ClassPathResource("./edustore/");
            String schemaDir = cp_rec.getURL().getPath();
            String comp_list = StringUtils.join(installed_components, (char)'|');
            XmlFlatFileMerger.flatMergeXmlFiles(schemaDir, "edustore_(" + comp_list + ")\\.xml", "edustore_changed.xml", "UTF-8");
            File schemaFileChanged = new File(schemaDir + File.separator + "edustore_changed.xml");
            File schemaFile = new File(schemaDir + File.separator + "edustore.xml");
            if (!schemaFile.exists()) {
                FileUtil.copy((File)schemaFileChanged, (File)schemaFile);
                SuperxRepositoryDataSourceManager srm = srdm == null ? (SuperxRepositoryDataSourceManager)applicationContext.getBean("repositoryDsManager") : srdm;
                srm.load();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not initialize/load mondrian schema", (Throwable)e);
            throw e;
        }
    }

    private static boolean isHISinOneConfigured(DataSource dataSource) {
        DataSource ds = dataSource == null ? (DataSource)applicationContext.getBean("dataSource") : dataSource;
        JdbcTemplate jtl = new JdbcTemplate(ds);
        SqlRowSet result = jtl.queryForRowSet(PLATTFORM_LOOKUP_SQL);
        return result.first() && result.getInt("plattform_id") == 1;
    }

    private static List<String> lookupInstalledComponents(DataSource dataSource) {
        DataSource ds = dataSource == null ? (DataSource)applicationContext.getBean("dataSource") : dataSource;
        JdbcTemplate jtl = new JdbcTemplate(ds);
        List installed_components = jtl.queryForList(INSTALLED_COMPONENTS_LOOKUP_SQL, String.class);
        for (String component : installed_components) {
            logger.debug((Object)("Installed: " + component));
        }
        return installed_components;
    }

    public static String getLastFMMaskenSql() {
        return lastFMMaskenSql;
    }

    public static void setLastFMMaskenSql(String lastFMMaskenSql) {
        SuperXManager.lastFMMaskenSql = lastFMMaskenSql;
    }

    public static void main(String[] args) {
        System.out.println("SuperX @version@ (build:@sxtimestamp@)");
        System.out.println(SqlStringUtils.getEncoding());
    }

    public static final void initKettleEnv(ApplicationContext externalApplicationContext) {
        if (KettleEnvironment.isInitialized()) {
            logger.info((Object)"KettleEnvironment already initialized.");
            return;
        }
        try {
            ApplicationContext validContext;
            String kettlePluginDir = PathAndFileUtils.getWebinfPath() + File.separator + "kettle-plugins";
            System.setProperty("BI_KETTLE_PLUGIN_BASE_FOLDERS", kettlePluginDir);
            System.setProperty("KETTLE_DISABLE_CONSOLE_LOGGING", "Y");
            KettleEnvironment.init();
            ApplicationContext applicationContext = validContext = SuperXManager.applicationContext != null ? SuperXManager.applicationContext : externalApplicationContext;
            if (validContext != null) {
                DataSourceProviderInterface dsp = (DataSourceProviderInterface)validContext.getBean("dataSources");
                DataSourceProviderFactory.setDataSourceProviderInterface((DataSourceProviderInterface)dsp);
            } else {
                logger.error((Object)"Couldn't get DataSourceProviders");
            }
            KettleLogStore.init();
            logger.info((Object)("Kettle plugin dir: " + kettlePluginDir));
            logger.info((Object)"Kettle environment sucessfully initialized.");
        }
        catch (KettleException e) {
            logger.error((Object)"Couldn't initialize KettleEnvironment!", (Throwable)e);
        }
    }

    public static void initQuartz() {
        Scheduler scheduler = SuperXManager.getBean("scheduler", Scheduler.class);
        JobLocator jobLocator = SuperXManager.getBean("jobLocator", JobLocator.class);
        JobLauncher jobLauncher = SuperXManager.getBean("jobLauncher", JobLauncher.class);
        DataSource dataSource = SuperXManager.getBean("dataSource", DataSource.class);
        EtlJobApi api = SuperXManager.getBean("etlJobApi", EtlJobApi.class);
        try {
            scheduler.getContext().put("jobLocator", (Object)jobLocator);
            scheduler.getContext().put("jobLauncher", (Object)jobLauncher);
            scheduler.getContext().put("api", (Object)api);
            scheduler.getContext().put("dataSource", (Object)dataSource);
            logger.info((Object)"Successfully initialzed quartz scheduler.");
        }
        catch (SchedulerException e) {
            logger.error((Object)"Couldn't set scheduler context vars!", (Throwable)e);
        }
        JobKey jobKey = new JobKey("Remove Job History", "ETL");
        SimpleScheduleBuilder sb = SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(24).repeatForever();
        BiQuartzBatchJob.scheduleJob(scheduler, "removeSpringBatchHistoryJob", jobKey, new JobDataMap(), sb, true);
    }

    public static String htmlPageHead(String title) {
        String ret = "<html><head><title>" + title + "</title><link rel=\"stylesheet\" type=\"text/css\" href=\"../style/superx.css\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"/superx/xml/his1/css/HISinOneErrorMessages.css\" /><META HTTP-EQUIV=\"CACHE-CONTROL\" CONTENT=\"NO-CACHE\" /> <META HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\" /> <META HTTP-EQUIV=\"EXPIRES\" CONTENT=\"0\"/><link rel=\"stylesheet\" type=\"text/css\" href=\"../xml/superxml_html.css\" /></head>\n<body>\n";
        if (isHis1) {
            ret = ret + "<link rel='stylesheet' type='text/css' href='/superx/xml/his1/css/HISinOne.css'>\n<a href='/superx/servlet/SuperXmlAnmeldung' target='_parent' style='cursor:pointer; font-weight: bold;' class='ui-link'>Zur\u00fcck zu Standardberichte</a> | <a href='/superx/servlet/SuperXmlAbmeldung' target='_parent' style='cursor:pointer; font-weight: bold;' class='ui-link'>Abmelden von Standardberichte</a>";
        }
        return ret;
    }

    private static String htmlSubsystemsInitStatus(String mandant) {
        Map<InitStatus.SubSystem, Boolean> subSystemStatus = InitStatus.getSubSystemStatus();
        String initSubsystems = "<div style=\"float: left; border: 3px dashed red\">\n<h3>Status Initialisierung Pool " + mandant + "</h3>\n<ul>\n";
        for (Map.Entry<InitStatus.SubSystem, Boolean> subSystemEntry : subSystemStatus.entrySet()) {
            initSubsystems = initSubsystems + "<li>" + subSystemEntry.getKey().toString() + ": <strong>" + (subSystemEntry.getValue() != false ? "FEHLER" : "OK") + "</strong></li>\n";
        }
        initSubsystems = initSubsystems + "</ul></div>\n";
        return initSubsystems;
    }

    public static void setModuleDir(String md) {
        moduleDir = md;
        logger.debug((Object)("SuperXManager: MODULE_PFAD: " + moduleDir + " isHisInOne:" + isHis1));
    }

    public static String getModuleDir() {
        return moduleDir;
    }

    public void setApplicationContext(ApplicationContext context) {
        applicationContext = context;
        DataSource eduetlDataSource = null;
        try {
            eduetlDataSource = (DataSource)context.getBean("dataSource", DataSource.class);
        }
        catch (Exception ex) {
            logger.error((Object)"There seems to be no eduetl DataSource, but it is required!", (Throwable)ex);
            return;
        }
        SuperXManager.setWebInfFilePath(eduetlDataSource);
    }

    public static void setWebInfFilePath(DataSource eduetlDataSource) {
        JdbcTemplate jt = new JdbcTemplate(eduetlDataSource);
        String myWEBINFFilePath = System.getProperty("user.dir");
        try {
            myWEBINFFilePath = PathAndFileUtils.getWebinfDirectory();
        }
        catch (URISyntaxException e1) {
            logger.warn((Object)"Setting WEBINFDIR to user.dir because couldn't get WEB-INF dir!");
        }
        String query = "select count(*) from information_schema.tables where table_name = ?";
        Integer result = (Integer)jt.queryForObject(query, Integer.class, new Object[]{"sx_repository"});
        if (result > 0) {
            Integer count = (Integer)jt.queryForObject("select count(*) from sx_repository where id='WEBINFDIR'", Integer.class);
            if (count == 0) {
                try {
                    jt.update("insert into sx_repository  (id,content,caption,aktiv,gueltig_seit,gueltig_bis) values ('WEBINFDIR',?,'WEB-INF Directory',1,date_val('1.1.1900'),date_val('1.1.3000'))", new Object[]{myWEBINFFilePath});
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not set webinfpath " + e.getMessage()));
                }
            } else {
                jt.update("update sx_repository set content=? where id='WEBINFDIR'", new Object[]{myWEBINFFilePath});
            }
        }
    }

    public static <T> T getBean(String beanName, Class<T> requiredType) {
        if (applicationContext != null) {
            if (beanName != null && !beanName.isEmpty()) {
                return (T)applicationContext.getBean(beanName, requiredType);
            }
            return (T)applicationContext.getBean(requiredType);
        }
        return null;
    }

    public static boolean isStandaloneLdapActive() {
        return isStandaloneLdapActive;
    }

    private static boolean checkCanWriteUserHomeDir() {
        File homeDir = new File(System.getProperty("user.home"));
        return homeDir.canWrite();
    }

    private static boolean checkCanWriteUserKettleDir() {
        File kettleDir = new File(System.getProperty("user.home") + File.separator + ".kettle");
        return kettleDir.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runEtlFromFileSystem(String propertyFileName) {
        String moduleDirectory = PathAndFileUtils.getWebinfPath() + File.separator + PathAndFileUtils.MODULE_PATH;
        File propertyFile = new File(moduleDirectory + File.separator + propertyFileName);
        if (!propertyFile.exists()) {
            return;
        }
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(propertyFile);){
            props.load(fis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String execute = props.getProperty("start").toLowerCase();
        if (execute.equals("true")) {
            EntityJobDescriptionSource ejds = BeanUtil.getBean(EntityJobDescriptionSource.class);
            EtlJobApi etlJob = BeanUtil.getBean(EtlJobApi.class);
            etlJob.setJobDescriptionSource(ejds);
            String installs = props.getProperty("modul.installieren");
            String[] installComp = installs != null ? installs.split(",") : new String[]{};
            String updates = props.getProperty("konnektor.starten");
            String[] updateComp = updates != null ? updates.split(",") : new String[]{};
            String updatesNoUnload = props.getProperty("konnektor.starten.kein.unload");
            String[] updateNoUnloadComp = updatesNoUnload != null ? updatesNoUnload.split(",") : new String[]{};
            etlJob.setSyncExecution();
            try {
                logger.info((Object)"Start executing install and update routines.");
                for (String comp : installComp) {
                    logger.info((Object)("Start installing: " + comp));
                    try {
                        etlJob.executeInstall(comp);
                    }
                    catch (Exception e) {
                        logger.error((Object)("ERROR installing component " + comp), (Throwable)e);
                    }
                }
                for (String comp : updateComp) {
                    logger.info((Object)("Start updating: " + comp));
                    try {
                        etlJob.complete(comp);
                    }
                    catch (Exception e) {
                        logger.error((Object)("ERROR running connector " + comp), (Throwable)e);
                    }
                }
                for (String comp : updateNoUnloadComp) {
                    logger.info((Object)("Start load_and_transform job for component: " + comp));
                    String jobId = comp + ContainerNode.JobType.load_transform.getNamePattern();
                    try {
                        etlJob.executeJob(null, jobId);
                    }
                    catch (Exception e) {
                        logger.error((Object)("ERROR running connector " + jobId));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                etlJob.unsetSyncExecution();
            }
            JobAdapter jobAdapter = BeanUtil.getBean(JobAdapter.class);
            etlJob.setJobDescriptionSource(jobAdapter);
        }
    }

    public static void initEtl(boolean eduetlDbEmpty) {
        if (eduetlDbEmpty) {
            logger.info((Object)"Installing initial Components");
            SuperXManager.runEtlFromFileSystem("module_filesystem_initial.properties");
        }
        logger.info((Object)"DELETING ALL NON CUSTOM JOBS FROM DB");
        DbJobDescriptionAdapter djda = SuperXManager.getBean("dbJobDescriptionAdapter", DbJobDescriptionAdapter.class);
        djda.deleteAllNonCustomJobs();
        try {
            SuperXManager.runEtlFromFileSystem("module_filesystem.properties");
        }
        catch (Exception e) {
            logger.error((Object)"Could not run ETL from filesystem", (Throwable)e);
        }
    }

    public static boolean checkDatabaseEmpty(DataSource eduetlDataSource) {
        JdbcTemplate jt = new JdbcTemplate(eduetlDataSource);
        return (Boolean)jt.queryForObject("SELECT COUNT(*) = 0 FROM information_schema.tables WHERE table_schema='public' AND table_name='systeminfo'", Boolean.class);
    }

    static {
        his1_refapp = "";
        isZukuenftigerStandErlaubt = true;
        maxRows = 20000;
        defaultMaskXsl = "maske_html.xsl";
        defaultTableHtmlXsl = "tabelle_html.xsl";
        defaultTableXlsXsl = "tabelle_xls.xsl";
        defaultTablePdfXsl = "tabelle_fo_pdf.xsl";
        sharedSecret = "";
        isSichtenCachingWanted = true;
        canWriteUserHomeDir = false;
        canWriteUserKettleDir = false;
        ADMIN_ONLY = SuperXManager.htmlPageHead("Admin-Bereich") + "<center><h3>Hier ist ein Login nur f\u00fcr Administratoren m&ouml;glich.</h3>(Cookies m&uuml;ssen aktiviert sein)<FORM ACTION=\"SuperXManager\" METHOD=\"post\"><p><p>Kennung: <br /><INPUT TYPE=\"Text\" NAME=\"kennung\" VALUE=\"superx\"></p><p><p>Passwort: <br /><INPUT TYPE=\"Password\" NAME=\"passwort\" value=\"\"></p><p>MandantenID<br><input type=\"text\" name=\"MandantenID\" value=\"" + SxSQL_Server.DEFAULT_MANDANTEN_ID + "\"></p><br><INPUT TYPE=\"Submit\" NAME=\"Abschicken\" VALUE=\"Anmelden\"></FORM></center></body></html>";
        pageBeginning = SuperXManager.htmlPageHead("Webanwendung Manager") + "<h1 align=center>SuperX Manager</h1><center>SuperX @version@ (build:@sxtimestamp@)</center>";
        pageEnd = "</body></html>";
        activityLog = new StringBuffer();
        lastMaskenSql = "--";
        lastXml = "--";
        lastXmlMandantid = "--";
        lastMaskenSqlMandantid = "";
        isDevelopmentMode = true;
        isLastSqlExtraPageWanted = true;
        isXMLReturnLinkWanted = true;
        refererstart = null;
        cashUpdater = new CacheUpdater();
        isHis1 = false;
        webinfPfad = ".";
        moduleDir = "";
        isResponseCompressionWanted = true;
        start = null;
        isStandaloneLdapActive = false;
        sxversion = "@version@";
        builddatum = "@sxtimestamp@";
    }

    class SuperXInitThread
    extends Thread {
        private ServletConfig config;
        private boolean isDestroyWanted = false;

        public SuperXInitThread(ServletConfig config) throws SecurityException, IOException {
            this.config = config;
        }

        public void destroy() {
            this.isDestroyWanted = true;
        }

        @Override
        public void run() {
            logger.debug((Object)"SuperXInit thread start.");
            if (isHis1) {
                while (!this.isDestroyWanted && !SuperXManager.isDBPropsSet()) {
                    this.waitForHis1Webapp();
                }
            }
            try {
                logger.debug((Object)"Webanwendung Manager startet");
                if (SuperXManager.isDBPropsSet()) {
                    logger.debug((Object)"Param SuperX-DB-PROPERTIES-SEToder superxDbPropertiesSet =true gefunden");
                }
                this.doInit();
            }
            catch (ServletException e) {
                e.printStackTrace();
                throw new IllegalStateException("SuperX Init fehlgeschlagen " + e.getMessage());
            }
        }

        private void waitForHis1Webapp() {
            long totalTimeWaiting = System.currentTimeMillis() - start.getTime();
            try {
                Thread.sleep(4000L);
                logger.info((Object)("SuperXInit waiting. Total: " + Long.valueOf(totalTimeWaiting) + "millis"));
                if (totalTimeWaiting > 1800000L) {
                    throw new InterruptedException("*** SuperXManager timeout!\nJava System-Property SuperX-DB-PROPERTIES-SETor superxDbPropertiesSet not set!\nHISinOne Business Intelligence may not be usable!\nPlease check if Module EDUSTORE in modules.xml is active\nand EdustoreManager has run correctly on HISinOne startup! ***");
                }
            }
            catch (InterruptedException e) {
                logger.warn((Object)"SuperXinit interrupted!", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        private void doInit() throws ServletException {
            String sichtcache;
            String rc;
            String f1;
            String mxr;
            String xsl_parser;
            String last_sql_extra_page;
            String xmlReturnLink;
            String zukuenftigerStandErlaubt;
            DataSource ds = (DataSource)applicationContext.getBean("dataSource");
            boolean eduetlDbEmpty = SuperXManager.checkDatabaseEmpty(ds);
            if (eduetlDbEmpty) {
                logger.info((Object)"eduetl db empty. Installing minimal db schema");
                EtlJobApi componentApi = (EtlJobApi)applicationContext.getBean(EtlJobApi.class);
                ContainerNode preInstallJob = EntityJobDescriptionSource.getPreKernInstallJob();
                try {
                    componentApi.executeJobSync("eduetl", preInstallJob);
                }
                catch (Exception e) {
                    logger.error((Object)"Couldn't install minimal eduetl db schema!", (Throwable)e);
                }
            } else {
                logger.info((Object)"eduetl db already populated");
            }
            this.initHttpGetAccessGuard();
            InputCheckRegistry.registerDefaultChecks();
            his1_refapp = System.getProperty(SuperXManager.QIS_CONTEXT);
            if (his1_refapp == null) {
                his1_refapp = "";
            } else {
                logger.debug((Object)("SuperX found HisInOne webapp: " + his1_refapp));
            }
            this.initModuleDir();
            ServletUtils.setPath(SuperXManager.this.getServletConfig().getServletContext().getRealPath("xml"));
            SuperXManager.this.initXSLFilenames();
            refererstart = this.config.getInitParameter(RequestParameter.referer_start.toString());
            if (refererstart != null && !refererstart.trim().equals("")) {
                logger.debug((Object)("Referer wird kontrolliert auf " + refererstart));
            }
            if ((zukuenftigerStandErlaubt = this.config.getInitParameter(RequestParameter.zuk\u00fcnftigerStandErlaubt.toString())) != null && zukuenftigerStandErlaubt.equals("false")) {
                isZukuenftigerStandErlaubt = false;
            }
            if ((xmlReturnLink = this.config.getInitParameter(RequestParameter.xml_return_link.toString())) != null && xmlReturnLink.equals("false")) {
                isXMLReturnLinkWanted = false;
            }
            if ((last_sql_extra_page = this.config.getInitParameter(RequestParameter.last_sql_extra_page.toString())) != null && last_sql_extra_page.equals("false")) {
                isLastSqlExtraPageWanted = false;
            }
            if ((xsl_parser = this.config.getInitParameter(RequestParameter.xsl_processor.toString())) != null) {
                TransletUtils.initFactory(xsl_parser, "org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
            } else {
                TransletUtils.initFactory("net.sf.saxon.TransformerFactoryImpl", null);
            }
            logger.debug((Object)("Using xsl processor: " + TransletUtils.getUsedProcessor()));
            sharedSecret = this.config.getInitParameter(RequestParameter.sharedSecret.toString());
            if (sharedSecret == null) {
                sharedSecret = "";
            }
            if ((mxr = this.config.getInitParameter(RequestParameter.maxRows.toString())) != null && !mxr.equals("")) {
                maxRows = Integer.parseInt(mxr);
            }
            logger.warn((Object)("SuperXManager: maxRows: " + Integer.valueOf(maxRows) + " (wenn mehr geliefert wird, werden die zusaetzlichen Datenzeilen ignoriert)"));
            String defaultXsl = this.config.getInitParameter(RequestParameter.defaultMaskXsl.toString());
            if (defaultXsl != null && !defaultXsl.trim().equals("")) {
                defaultMaskXsl = defaultXsl;
                logger.debug((Object)("SuperXManager: defaultMaskXsl: " + defaultMaskXsl));
            }
            if ((defaultXsl = this.config.getInitParameter(RequestParameter.defaultTableHtmlXsl.toString())) != null && !defaultXsl.trim().equals("")) {
                defaultTableHtmlXsl = defaultXsl;
                logger.debug((Object)("SuperXManager: defaultTableHtmlXsl: " + defaultTableHtmlXsl));
            }
            if ((defaultXsl = this.config.getInitParameter(RequestParameter.defaultTableXlsXsl.toString())) != null && !defaultXsl.trim().equals("")) {
                defaultTableXlsXsl = defaultXsl;
                logger.debug((Object)("SuperXManager: defaultTableXlsXsl: " + defaultTableXlsXsl));
            }
            if ((defaultXsl = this.config.getInitParameter(RequestParameter.defaultTablePdfXsl.toString())) != null && !defaultXsl.trim().equals("")) {
                defaultTablePdfXsl = defaultXsl;
                logger.debug((Object)("SuperXManager: defaultTablePdfXsl: " + defaultTablePdfXsl));
            }
            if ((f1 = this.config.getInitParameter(RequestParameter.field1Cache.toString())) != null && !f1.equals("")) {
                field1Cache = f1;
            }
            if ((rc = this.config.getInitParameter(RequestParameter.isResponseCompressionWanted.toString())) != null && rc.equalsIgnoreCase("false")) {
                isResponseCompressionWanted = false;
            }
            if ((sichtcache = this.config.getInitParameter(RequestParameter.sichtenCaching.toString())) != null && sichtcache.equalsIgnoreCase("false")) {
                isSichtenCachingWanted = false;
            }
            if ((noSessionFieldDefaults = "," + this.config.getInitParameter(RequestParameter.noSessionFieldDefaults.toString()) + ",") == null) {
                noSessionFieldDefaults = "";
            }
            try {
                SuperXManager.initKettleEnv(null);
                SxPools.init();
                SuperXManager.initQuartz();
                SuperXManager.initAll();
                SuperXManager.initStandardXsl();
                SuperXManager.initEtl(eduetlDbEmpty);
                cashUpdater.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServletException("SuperX konnte nicht initialisiert werden.DETAILS:" + e.getMessage());
            }
            logger.debug((Object)("SuperXInit finished after " + (new Date().getTime() - start.getTime()) + " millis"));
        }

        private void initHttpGetAccessGuard() {
            httpGetAccessGuard = new HttpGetAccessGuard();
            String blacklist_filename = SuperXManager.getWEB_INFPfad() + File.separator + "http_get_masken_blacklist.txt";
            String blacklist_custom_filename = SuperXManager.getWEB_INFPfad() + File.separator + "http_get_masken_blacklist_custom.txt";
            String whitelist_filename = SuperXManager.getWEB_INFPfad() + File.separator + "http_get_masken_whitelist.txt";
            httpGetAccessGuard.setBlacklist(this.parseWhiteBlacklistFile(blacklist_filename));
            httpGetAccessGuard.setBlacklist_custom(this.parseWhiteBlacklistFile(blacklist_custom_filename));
            httpGetAccessGuard.setWhitelist(this.parseWhiteBlacklistFile(whitelist_filename));
        }

        private Set<Integer> parseWhiteBlacklistFile(String list_filename) {
            File list_file = new File(list_filename);
            if (list_file.exists()) {
                try {
                    String content = de.memtext.util.StringUtils.readFile(list_file, StandardCharsets.UTF_8);
                    return HttpGetAccessListParser.parseList(content);
                }
                catch (IOException e) {
                    logger.error((Object)("could not read file '" + list_file.getAbsolutePath()));
                }
                catch (NumberFormatException e) {
                    logger.error((Object)("could not parse file '" + list_file.getAbsolutePath()), (Throwable)e);
                }
            }
            return null;
        }

        private void initModuleDir() {
            moduleDir = SuperXManager.isHis1() ? SuperXManager.getWEB_INFPfad() + File.separator + "conf" + File.separator + "edustore" + File.separator + "db" + File.separator + "module" : (System.getProperty("MODULE_PFAD") != null && !System.getProperty("MODULE_PFAD").toString().equals("") ? System.getProperty("MODULE_PFAD").toString() : SuperXManager.getWEB_INFPfad() + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + "db" + File.separator + "module");
            SuperXManager.setModuleDir(moduleDir);
        }
    }

    private static final class CacheUpdater
    extends Thread {
        private Date lastUpdate;
        private boolean isActive = true;

        private CacheUpdater() {
        }

        @Override
        public void run() {
            while (this.isActive) {
                Date now = new Date();
                try {
                    Thread.sleep(1800000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (now.getHours() != 7 || this.lastUpdate != null && this.lastUpdate.getDay() == now.getDay()) continue;
                try {
                    logger.info((Object)(DateUtils.getTodayString() + " " + DateUtils.getNowString() + " Server-Cache-Aktualisierung"));
                    SuperXManager.initAll();
                    this.lastUpdate = now;
                }
                catch (Exception e) {
                    logger.error((Object)"Server-Cache-Aktualisierung fehlgeschlagen:", (Throwable)e);
                }
            }
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }

    private class SxManager
    extends SuperXServletHelper {
        public SxManager(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
        }

        @Override
        protected void perform() throws IOException, IllegalArgumentException, SecurityException, KeyParentEqualException, NichtAngemeldetException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException, DBServletException, TransformerException {
            Object comment = "";
            if (this.request.getParameterMap().containsKey("cache")) {
                SuperXManager.initPool(this.request, this.getMandantenID());
                SuperXManager.initStandardXsl();
                comment = "Resources neu geladen: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            }
            if (this.request.getParameterMap().containsKey("clearStylesheets")) {
                SuperXManager.clearTransletStylesheets();
                comment = "Stylesheet-Cache geleert: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            }
            if (this.request.getParameterMap().containsKey("clearlogfiles")) {
                SxPools.clearLogFiles();
                comment = "LogDateien geleert";
            }
            if (ServletHelper.getParameter(this.request, RequestParameter.Entwicklungsmodus) != null) {
                isDevelopmentMode = ServletHelper.getParameter(this.request, RequestParameter.Entwicklungsmodus).equals("an");
            }
            PrintWriter output = this.response.getWriter();
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            CsrfToken token = SxManager.getCsRfToken(this.request);
            output.write(SuperXManager.this.getStandardPage(this.request, (String)comment, token.getParameterName(), token.getToken()));
            output.write(pageEnd);
            output.flush();
        }
    }
}

