/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.DateUtils;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.superx.common.DBServletException;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultSet;
import de.superx.common.TranslationContainer;
import de.superx.servlet.ExternalPool;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.SessionAttribute;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPool;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.util.SqlStringUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ServletUtils {
    static final boolean isExtraAuthenticationCheckWanted = false;
    private static String path;
    public static Hashtable hash;

    public static void setPath(String path) {
        ServletUtils.path = path;
    }

    public static String getPath() {
        return path;
    }

    public static String getMandantenID(HttpServletRequest request) {
        String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
        if (ServletHelper.getParameter(request, RequestParameter.MandantenID) != null) {
            mandantenID = ServletHelper.getParameter(request, RequestParameter.MandantenID);
        }
        if (request.getAttribute(SessionAttribute.MandantenID.toString()) != null) {
            mandantenID = (String)request.getAttribute("MandantenID");
        }
        if (request.getSession() != null && request.getSession().getAttribute(SessionAttribute.MandantenID.toString()) != null) {
            mandantenID = (String)request.getSession().getAttribute(SessionAttribute.MandantenID.toString());
        }
        if (mandantenID == null) {
            throw new IllegalStateException("Keine MandantenID gefunden. Muss bei einem Mandanten \"" + SxSQL_Server.DEFAULT_MANDANTEN_ID + "\" sein");
        }
        return mandantenID;
    }

    static String getLocalizedStylesheet(String stil, Locale locale) {
        String localized_stil;
        File f;
        int trunc_index;
        if (locale.getLanguage() != "de" && (trunc_index = ((String)stil).lastIndexOf(".xsl")) > 0 && (f = new File(localized_stil = ((String)stil).substring(0, trunc_index) + "_" + locale.getLanguage() + ".xsl")).exists()) {
            stil = localized_stil;
        }
        return stil;
    }

    static String getJSONErrorText(String user, Locale locale) {
        StringBuffer errorText = new StringBuffer();
        if (user != null) {
            errorText.append(ServletUtils.get("superx.denied", locale));
            errorText.append(" '");
            errorText.append(user);
            errorText.append("'.");
        } else {
            errorText.append(ServletUtils.get("superx.deniednouser", locale));
        }
        errorText.append("\n");
        errorText.append(ServletUtils.get("superx.logintext", locale));
        Object s = "";
        s = (String)s + "({error:\"" + StringUtils.jsonAdapt(errorText.toString(), true) + "\"})";
        return s;
    }

    static String getXmlErrorText(String fehler, String zs, Locale locale) {
        String s = SuperXManager.htmlPageHead("Transformation Problem") + "<h1>Ein Fehler ist bei der XML-Transformation aufgereten.</H1><p class=\"errmsg\">" + fehler + "</p>";
        s = s + "<p>Der XML-Code:<br /><TEXTAREA NAME=\"content\" ROWS=\"40\" COLS=\"80\" WRAP=\"on\" READONLY=\"true\">";
        s = s + zs + "</TEXTAREA></p></body></html>";
        return s;
    }

    public static String getLoginFailureXml(String user, String mandantenid, Locale locale) {
        StringBuffer failureXML = new StringBuffer();
        failureXML.append("<nachricht><p class=\"errmsg\">");
        if (user != null) {
            failureXML.append(ServletUtils.get("superx.denied", locale));
            failureXML.append(" ");
            failureXML.append(user);
        } else {
            failureXML.append(ServletUtils.get("superx.deniednouser", locale));
        }
        failureXML.append("</p><p>");
        failureXML.append(ServletUtils.get("superx.logintext", locale));
        if (SuperXManager.isXMLReturnLinkWanted) {
            failureXML.append("<br /><a href=\"..");
            if (mandantenid != null && !mandantenid.equalsIgnoreCase("null") && !mandantenid.equalsIgnoreCase(SxSQL_Server.DEFAULT_MANDANTEN_ID)) {
                failureXML.append("/");
                failureXML.append(mandantenid);
            }
            failureXML.append("/xml/index.htm\" target=\"_parent\">");
            failureXML.append(ServletUtils.get("superx.login", locale));
            failureXML.append("</a></p>");
        }
        failureXML.append("</nachricht>");
        return failureXML.toString();
    }

    static String get(String what, Locale locale) {
        Object r;
        if (locale == null) {
            locale = TranslationContainer.defaultLocale;
        }
        ResourceBundle bundle = null;
        if (hash != null) {
            bundle = (ResourceBundle)hash.get(locale.getLanguage());
        }
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("LocalStrings", locale);
            hash.put(bundle, locale.getLanguage());
        }
        if ((r = bundle.getString(what)) == null) {
            r = "Unknown Local String: " + what;
        }
        return r;
    }

    public static String escapeTimeFeld(String feldwert) throws ParseException {
        String charcode1 = "'";
        String charcode2 = "'";
        if (((String)feldwert).startsWith(charcode1) && ((String)feldwert).endsWith(charcode1)) {
            feldwert = ((String)feldwert).substring(2, ((String)feldwert).length() - 1);
        }
        SimpleDateFormat in_df = new SimpleDateFormat("HH:mm:ss");
        Date feldwert_df = in_df.parse((String)feldwert);
        SimpleDateFormat out_df = new SimpleDateFormat("HH:mm:ss");
        feldwert = out_df.format(feldwert_df);
        feldwert = charcode1 + (String)feldwert + charcode2;
        return feldwert;
    }

    public static String escapeTimestampFeld(String feldwert) throws ParseException {
        SimpleDateFormat in_df;
        Date feldwert_df;
        SimpleDateFormat out_df;
        String charcode1 = "'";
        String charcode2 = "'";
        if (((String)feldwert).startsWith(charcode1) && ((String)feldwert).endsWith(charcode1)) {
            feldwert = ((String)feldwert).substring(2, ((String)feldwert).length() - 1);
        }
        if (((String)(feldwert = (out_df = new SimpleDateFormat("d.M.yyyy HH:mm:ss")).format(feldwert_df = (in_df = new SimpleDateFormat("d.M.yyyy HH:mm:ss")).parse((String)feldwert)))).length() > 0) {
            feldwert = charcode1 + (String)feldwert + charcode2;
        }
        return feldwert;
    }

    public static String escapeDateFeld(String feldwert) throws ParseException {
        String charcode1 = "'";
        String charcode2 = "'";
        if (((String)feldwert).startsWith(charcode1) && ((String)feldwert).endsWith(charcode1)) {
            feldwert = ((String)feldwert).substring(1, ((String)feldwert).length() - 1);
        }
        if (((String)feldwert).length() > 0) {
            feldwert = ((String)feldwert).equals("--leer--") ? "''" : charcode1 + (String)feldwert + charcode2;
        }
        return feldwert;
    }

    public static String escapeCharFeld(String feldwert) {
        String charcode1 = "'";
        String charcode2 = "'";
        if (feldwert.startsWith(charcode1) && feldwert.endsWith(charcode1)) {
            feldwert = feldwert.substring(2, feldwert.length() - 1);
        }
        if ((feldwert = SqlStringUtils.escapeString(feldwert)).length() > 0 && SqlStringUtils.unescapeString(feldwert).equals("--leer--")) {
            feldwert = "";
        }
        return feldwert;
    }

    public static SxResultSet execute(String task, String query, String mandantenID) throws SQLException, DBServletException {
        return ServletUtils.execute_el(task, query, true, mandantenID).getResultSet();
    }

    public static boolean isExternalDbWanted(String sql) {
        return sql.indexOf("--#dbid:") > -1;
    }

    public static String getExternalDbID(String sql) {
        String result = "";
        int index1 = sql.indexOf("--#dbid:");
        int index2 = sql.indexOf("#", index1 + 8);
        result = sql.substring(index1 + 8, index2);
        return result;
    }

    public static SuperX_el execute_el(String task, String query, boolean isSingleQuery, String mandantenID) throws SQLException, DBServletException {
        SuperX_el result_el = new SuperX_el();
        Connection dbConnection = SxPools.getConnection(mandantenID);
        try {
            SxSQL_Server sxServer = new SxSQL_Server(mandantenID);
            if (isSingleQuery) {
                sxServer.executeQuery(query, dbConnection, result_el);
            } else {
                sxServer.execute(query, dbConnection, result_el);
            }
            dbConnection.close();
        }
        catch (SQLException e) {
            String msg = "Problem bei:" + task + " DETAILS:" + e.getMessage() + " sql:" + query;
            Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.ERROR, (Object)msg);
            SxPools.invalidate(mandantenID, dbConnection);
            throw new SQLException(msg);
        }
        if (result_el.getError_String() != null && !result_el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei:" + task + "\n\n  DETAILS:" + result_el.getError_String() + "\n  sql:" + query);
        }
        return result_el;
    }

    public static SuperX_el executeALL_el(ExternalPool externalPool, Connection dbCon, String task, String query, String mandantenID, boolean isStacktraceWanted) throws SQLException, DBServletException {
        if (externalPool != null) {
            task = (String)task + " DatenbankID:" + externalPool.getName();
            query = "-- DatenbankID:" + externalPool.getName() + "\n" + (String)query;
        }
        if (((String)task).startsWith("Abfrage Maske")) {
            SuperXManager.setLastMaskenSql("--" + (String)task + " " + DateUtils.getNowString() + "\n" + (String)query);
            SuperXManager.setLastMaskenSqlMandantid(mandantenID);
        }
        SuperX_el result_el = new SuperX_el();
        Connection dbConnection = null;
        dbConnection = dbCon == null ? (externalPool == null ? SxPools.getConnection(mandantenID) : externalPool.getConnection()) : dbCon;
        try {
            SxSQL_Server sxServer = new SxSQL_Server(mandantenID);
            sxServer.executeALL((String)query, dbConnection, result_el);
            if (dbCon == null) {
                dbConnection.close();
            }
        }
        catch (SQLException e) {
            if (externalPool == null) {
                SxPools.invalidate(mandantenID, dbConnection);
            } else {
                externalPool.invalidate(dbConnection);
            }
            String msg = "Problem bei:" + (String)task + "\nDETAILS:" + e.getMessage();
            Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.ERROR, (Object)msg);
            if (isStacktraceWanted) {
                e.printStackTrace();
            }
            throw new SQLException(msg);
        }
        catch (Exception e) {
            if (externalPool == null) {
                SxPools.invalidate(mandantenID, dbConnection);
            } else {
                externalPool.invalidate(dbConnection);
            }
            String msg = "Problem bei:" + (String)task + " DETAILS:" + e.getMessage() + " sql:" + (String)query;
            Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.ERROR, (Object)msg);
            if (isStacktraceWanted) {
                e.printStackTrace();
            }
            throw new DBServletException(msg);
        }
        if (result_el.getError_String() != null && !result_el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei:" + (String)task + "\n\n  DETAILS:" + result_el.getError_String() + "\n  sql:" + (String)query);
        }
        return result_el;
    }

    public static void checkParams(HttpServletRequest request) {
        StringBuffer test = new StringBuffer();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            test.append(element + " - " + request.getParameter(element) + "\n");
            if (request.getParameter(element) == null || request.getParameter(element).indexOf("'") <= -1) continue;
            boolean bl = true;
        }
    }

    public static void addParamToFormular(HttpServletRequest request, Hashtable formular, String aName) {
        String val = ServletHelper.getParameterString((ServletRequest)request, aName);
        if (val != null && val.length() > 1) {
            val = val.replace(';', '^');
        }
        if (val == null || val.equals("--leer--")) {
            val = "";
        }
        formular.put(aName, val);
    }

    public static void sendBackHtml(HttpServletResponse response, String info) throws IOException {
        PrintWriter output = response.getWriter();
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        output.write(info);
        output.flush();
        output.close();
    }

    public static ExternalPool getExternalPoolIfSpecified(String mandantenID, Integer maskennummer, String sql) throws DBServletException {
        ExternalPool ep = null;
        if (ServletUtils.isExternalDbWanted(sql)) {
            String epID = ServletUtils.getExternalDbID(sql);
            SxPool sxPool = SxPools.get(mandantenID);
            if (sxPool.hasExternalPool(mandantenID + "-" + epID + "_" + maskennummer)) {
                ep = sxPool.getExternalPool(mandantenID + "-" + epID + "_" + maskennummer);
            } else if (sxPool.hasExternalPool(mandantenID + "-" + epID)) {
                ep = sxPool.getExternalPool(mandantenID + "-" + epID);
            } else {
                throw new DBServletException("Externe Datenverbindung von Mandant :" + mandantenID + ":" + epID + " konnte nicht aufgebaut werden");
            }
        }
        if (ep != null && !ep.isOK()) {
            throw new DBServletException(ep.getExceptionMsg());
        }
        return ep;
    }

    public static String getParamValue(List<FileItem> multipartData, String paramName) {
        String result = null;
        for (FileItem item : multipartData) {
            String fieldName;
            if (!item.isFormField() || (fieldName = item.getFieldName()) == null || !fieldName.equals(paramName)) continue;
            result = item.getString();
            break;
        }
        return result;
    }

    static {
        hash = new Hashtable();
    }
}

