/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.superx.common.OrgUnit;
import de.superx.common.SxUser;
import de.superx.servlet.ImplicitOrgEinheitFillerI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class JavaRecursiveImplicitOrgEinheitFiller
implements ImplicitOrgEinheitFillerI {
    private static Logger logger = Logger.getLogger(JavaRecursiveImplicitOrgEinheitFiller.class);
    private boolean implicit_orgunit_rights_table_exists = false;
    private SxUser user;

    JavaRecursiveImplicitOrgEinheitFiller(boolean implicit_orgunit_rights_table_exists, SxUser user) {
        this.implicit_orgunit_rights_table_exists = implicit_orgunit_rights_table_exists;
        this.user = user;
    }

    @Override
    public void insertImplicitOrgUnitRights(Connection con, OrgUnit ou) throws SQLException {
        try (PreparedStatement pst_children = con.prepareStatement("select key_apnr,nvl(uniquename,key_apnr) as uniquename,lid,name,gueltig_seit,gueltig_bis from organigramm where parent_lid in (select lid from organigramm where key_apnr=? or uniquename=?) and key_apnr not in (select apnr from implicit_orgunit_rights where userinfo_id=?)");){
            pst_children.setString(1, ou.getApnr());
            pst_children.setString(2, ou.getApnr());
            pst_children.setInt(3, this.user.getUserIdAsInt());
            try (ResultSet rs = pst_children.executeQuery();
                 PreparedStatement pst_insert = con.prepareStatement("insert into implicit_orgunit_rights (userinfo_id,apnr,uniquename,lid)\nselect ?,key_apnr,nvl(uniquename,key_apnr),lid from organigramm where (key_apnr=? or uniquename=?)and (gueltig_seit<=? and gueltig_bis>=?) union\nselect ?,mapped_id,uniquename,lid from orgunit_mapping where (apnr=?  or uniquename=?) union\nselect ?,uniquename,uniquename,lid from orgunit_mapping where (apnr=? or uniquename=?)");){
                this.insertCurrentImplicitOrgunitRight(pst_insert, ou);
                while (rs.next()) {
                    OrgUnit childOrgUnit = new OrgUnit(rs.getString("key_apnr"), rs.getString("uniquename"), rs.getString("lid"), rs.getString("name"), rs.getDate("gueltig_seit"), rs.getDate("gueltig_bis"));
                    this.insertImplicitOrgUnitRights(con, childOrgUnit);
                }
            }
        }
    }

    private void insertCurrentImplicitOrgunitRight(PreparedStatement pst_insert, OrgUnit ou) throws SQLException {
        this.user.addImplicitlyAllowedOrgUnit(ou);
        if (this.implicit_orgunit_rights_table_exists) {
            pst_insert.clearParameters();
            pst_insert.setInt(1, this.user.getUserIdAsInt());
            pst_insert.setString(2, ou.getApnr());
            pst_insert.setString(3, ou.getApnr());
            pst_insert.setDate(4, ou.getGueltig_bis());
            pst_insert.setDate(5, ou.getGueltig_seit());
            pst_insert.setInt(6, this.user.getUserIdAsInt());
            pst_insert.setString(7, ou.getApnr());
            pst_insert.setString(8, ou.getApnr());
            pst_insert.setInt(9, this.user.getUserIdAsInt());
            pst_insert.setString(10, ou.getApnr());
            pst_insert.setString(11, ou.getApnr());
            pst_insert.execute();
        }
    }
}

