/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.DateUtils;
import de.superx.servlet.CSVResultReport;
import de.superx.util.HtmlUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CSVUploader {
    private static final String AUTOINC_YES = "YES";
    private static final String IS_AUTOINCREMENT = "IS_AUTOINCREMENT";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private String delim = "^";
    private StringBuffer htmlPreview = new StringBuffer("<table border='1'>");
    private String encoding = System.getProperty("file.encoding");
    private String tabelle = "";
    private boolean withHeader;
    private Connection con;
    private DatabaseMetaData databaseMetaData;
    private File sourceFile;
    private CSVResultReport resultReport = new CSVResultReport();
    private Logger logger;
    private HashMap<String, List<String>> foreignKeys = new HashMap();
    private List<String> fieldsNotNull = new LinkedList<String>();
    private CSVFormat format;
    private int db_col_count;
    private PreparedStatement pst;

    public CSVUploader(String userid, String mandantenId, String tabelle, String quelldatei, String delim, String encoding, boolean withHeader, String insertMode, boolean isXml, String modeOnError, boolean isZipped) throws IOException {
        this.logger = Logger.getLogger((String)("superx_" + mandantenId));
        this.logger.setLevel(Level.ALL);
        this.tabelle = tabelle;
        if (delim.equals("tab")) {
            this.delim = "\t";
            this.format = CSVFormat.newFormat((char)'\t').withEscape('\\');
        } else if (delim.equals("")) {
            this.delim = "^";
            this.format = CSVFormat.newFormat((char)'^').withEscape('\\');
        } else if (delim.equals("unl")) {
            this.delim = "^";
            this.format = CSVFormat.newFormat((char)'^').withEscape('\\').withTrailingDelimiter();
        } else {
            this.delim = delim;
            this.format = CSVFormat.newFormat((char)this.delim.charAt(0)).withEscape('\\');
        }
        this.encoding = encoding;
        this.withHeader = withHeader;
        if (isZipped) {
            CSVUploader.unzip(quelldatei);
        }
        this.sourceFile = new File(quelldatei);
        if (!this.sourceFile.exists()) {
            throw new IOException("Datei nicht gefunden: " + quelldatei);
        }
    }

    public CSVResultReport getResultReport() {
        return this.resultReport;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void upload(boolean isTestMode, boolean createSerial, Connection par_con) throws FileNotFoundException, IOException, SQLException {
        this.con = par_con;
        stm1 = this.con.createStatement();
        try {
            stm2 = this.con.createStatement();
            try {
                cols = stm1.executeQuery("SELECT * FROM " + this.tabelle + " WHERE 1 = 0;");
                this.db_col_count = cols.getMetaData().getColumnCount();
                insert_columns = null;
                if (this.withHeader) {
                    headerFormat = this.format.withSkipHeaderRecord(false);
                    this.format = this.format.withFirstRecordAsHeader();
                    fileinput = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), this.encoding));
                    try {
                        records = headerFormat.parse((Reader)fileinput);
                        var11_16 = records.iterator();
                        if (!var11_16.hasNext()) ** GOTO lbl32
                        line = (CSVRecord)var11_16.next();
                        insert_columns = new ArrayList<E>();
                        for (i = 0; i < line.size(); ++i) {
                            insert_columns.add(line.get(i));
                        }
                        if (insert_columns.size() <= this.db_col_count) ** GOTO lbl32
                        throw new IOException("csv file has more header columns than database table");
                    }
                    finally {
                        fileinput.close();
                    }
                } else {
                    this.format = this.format.withHeader(cols);
                    insert_columns = new ArrayList<String>();
                    insert_columns.addAll(Arrays.asList(this.format.getHeader()));
                }
lbl32:
                // 3 sources

                this.format = this.format.withRecordSeparator("\n");
                this.databaseMetaData = par_con.getMetaData();
                this.htmlPreview.append("<tr>");
                for (String header_col : insert_columns) {
                    this.htmlPreview.append("<th>" + HtmlUtils.htmlEscape(header_col) + "</th>");
                }
                this.htmlPreview.append("</tr>");
                insert_columns.replaceAll((UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$upload$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                tableMeta = this.databaseMetaData.getColumns(null, this.con.getSchema(), this.tabelle, null);
                columns_autoinc = new HashMap<String, Boolean>();
                columns_datatypes = new HashMap<String, Integer>();
                while (tableMeta.next()) {
                    db_column = tableMeta.getString("COLUMN_NAME").toLowerCase();
                    isSerial = tableMeta.getString("IS_AUTOINCREMENT").equals("YES");
                    type = tableMeta.getInt("DATA_TYPE");
                    columns_autoinc.put(db_column, isSerial);
                    columns_datatypes.put(db_column, type);
                }
                for (i = insert_columns.size() - 1; i >= 0; --i) {
                    csv_column = (String)insert_columns.get(i);
                    if (columns_autoinc.get(csv_column) == null || !((Boolean)columns_autoinc.get(csv_column)).booleanValue()) continue;
                    insert_columns.remove(i);
                    break;
                }
                if (this.withHeader) {
                    this.resultReport.setColnames(String.join((CharSequence)", ", insert_columns));
                }
                insert_placeholders = ", ?".repeat(insert_columns.size()).substring(2);
                stmt_sql = "INSERT INTO tmp_" + this.tabelle + "(" + String.join((CharSequence)", ", insert_columns) + ") VALUES (" + insert_placeholders + ");";
                timeStart = new java.util.Date().getTime();
                this.readForeignKeys();
                this.readNotNull();
                if (this.isPostgres()) {
                    try {
                        stm2.executeUpdate("drop table if exists tmp_" + this.tabelle);
                    }
                    catch (Exception e) {
                        this.logger.log((Priority)Level.WARN, (Object)("Cannot drop " + this.tabelle), (Throwable)e);
                    }
                    stm2.executeUpdate("select * into temp tmp_" + this.tabelle + " from " + this.tabelle + " where 1=0");
                } else {
                    stm2.executeUpdate("create temp table tmp_" + this.tabelle + " as select * from " + this.tabelle + " where 1=0");
                }
                prepstmt = this.con.prepareStatement(stmt_sql);
                this.logger.debug((Object)"Starting the upload.");
                this.logger.debug((Object)("Tabellenkatalog f\u00fcr " + this.tabelle));
                fileinput = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), this.encoding));
                records = this.format.parse((Reader)fileinput);
                block35: for (CSVRecord line : records) {
                    prepstmt.clearParameters();
                    if (line.size() > this.db_col_count) {
                        msg = line.toString() + "  #Error in Load-File Record " + line.getRecordNumber() + ": CSV-Datensatz hat " + line.size() + " Spalten, aber Zieltabelle hat " + this.db_col_count + " Spalten.";
                        this.resultReport.incError(msg);
                        continue;
                    }
                    for (col_index = 0; col_index < insert_columns.size(); ++col_index) {
                        col_name = (String)insert_columns.get(col_index);
                        col_type = (Integer)columns_datatypes.get(col_name);
                        if (col_type == null) continue;
                        type = col_type;
                        csv_value = line.get(col_name);
                        if (this.fieldsNotNull.contains(col_name) && (csv_value == null || csv_value.equals(""))) {
                            msg = line.toString() + "  #Error in Load-File Record " + line.getRecordNumber() + ": " + col_name + " (Spalte " + col_index + ") darf nicht null sein.";
                            this.resultReport.incError(msg);
                            continue block35;
                        }
                        fkValues = this.foreignKeys.get(col_name);
                        if (fkValues != null && !fkValues.contains(csv_value)) {
                            msg = line.toString() + "  #Error in Load-File Record " + line.getRecordNumber() + ": " + col_name + " (Spalte " + col_index + ") enth\u00e4lt Wert (" + csv_value + "), der nicht in foreign keys vorkommt.";
                            this.resultReport.incError(msg);
                            continue block35;
                        }
                        prepst_index = col_index + 1;
                        try {
                            if (csv_value == null || csv_value.equals("")) {
                                prepstmt.setNull(prepst_index, type);
                                continue;
                            }
                            switch (type) {
                                case -6: 
                                case -5: 
                                case 4: 
                                case 5: {
                                    myInt = Integer.parseInt(csv_value);
                                    prepstmt.setInt(prepst_index, myInt);
                                    break;
                                }
                                case 6: {
                                    myFloat = Float.parseFloat(csv_value);
                                    this.pst.setFloat(prepst_index, myFloat);
                                    break;
                                }
                                case 2: 
                                case 3: 
                                case 7: 
                                case 8: {
                                    myDouble = Double.parseDouble(csv_value);
                                    prepstmt.setDouble(prepst_index, myDouble);
                                    break;
                                }
                                default: {
                                    prepstmt.setString(prepst_index, csv_value);
                                    break;
                                }
                                case -1: {
                                    by = new ByteArrayInputStream(csv_value.getBytes());
                                    prepstmt.setAsciiStream(prepst_index, (InputStream)by, csv_value.length());
                                    break;
                                }
                                case 91: {
                                    datum /* !! */  = DateUtils.parse(csv_value);
                                    date_csv_value = DateUtils.formatUS(datum /* !! */ );
                                    prepstmt.setDate(prepst_index, Date.valueOf(date_csv_value));
                                    break;
                                }
                                case 92: {
                                    prepstmt.setTime(prepst_index, Time.valueOf(csv_value));
                                    break;
                                }
                                case 93: {
                                    datum /* !! */  = DateUtils.dateTimeParse(csv_value);
                                    date_csv_value = DateUtils.dateTimeFormatUS(datum /* !! */ );
                                    prepstmt.setTimestamp(prepst_index, Timestamp.valueOf(date_csv_value + ".0"));
                                    break;
                                }
                                case -7: {
                                    wf = Boolean.getBoolean(csv_value);
                                    prepstmt.setBoolean(prepst_index, wf);
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            err_msg = "Error in Row " + line.getRecordNumber() + " Column " + col_index + ": " + e.toString();
                            this.logger.info((Object)err_msg);
                            this.resultReport.incError(err_msg);
                            continue block35;
                        }
                    }
                    try {
                        prepstmt.execute();
                        if (this.resultReport.getRowCount() <= 10) {
                            this.htmlPreview.append("<tr>");
                            for (String htmlvalue : line) {
                                if (this.resultReport.getRowCount() > 10) continue;
                                this.htmlPreview.append("<td>" + HtmlUtils.htmlEscape(htmlvalue) + "</td>");
                            }
                            this.htmlPreview.append("</tr>\n");
                        }
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)("Fehler beim Ausf\u00fchren des " + this.resultReport.getRowCount() + ". Insert:\n \nFehler: " + e.toString()));
                        msg = line.toString() + "  #SQL-Error in Load-File Line " + this.resultReport.getRowCount() + ": " + String.valueOf(e);
                        this.resultReport.incError(msg);
                    }
                    this.resultReport.incRowCount();
                }
                timeFertig = new java.util.Date().getTime();
                this.logger.debug((Object)(this.resultReport.getRowCount() + " Rows inserted in " + (timeFertig - timeStart) / 1000L + " Sec."));
                if (this.resultReport.getRowCount() < 1) {
                    this.resultReport.incError("Keine Datensaetze gefunden");
                }
                if (this.resultReport.getErrorCount() > 0) {
                    System.err.println(this.resultReport.getErrorCount() + " Rows could not be inserted.");
                }
                this.htmlPreview.append("</table>");
            }
            finally {
                if (stm2 != null) {
                    stm2.close();
                }
            }
        }
        finally {
            if (stm1 != null) {
                stm1.close();
            }
        }
    }

    private void readNotNull() throws SQLException {
        try (Statement stm = this.con.createStatement();){
            ResultSet rs = stm.executeQuery("select name from sx_fields where table_name = '" + this.tabelle + "' and field_not_null=1");
            while (rs.next()) {
                String fieldname = rs.getString(1);
                this.fieldsNotNull.add(fieldname);
            }
        }
    }

    private void readForeignKeys() throws SQLException {
        try (Statement stm = this.con.createStatement();){
            ResultSet rs = stm.executeQuery("select name,foreignkey_tab,foreignkey_col from sx_fields where table_name = '" + this.tabelle + "' and foreignkey_tab is not null and check_integrity=1");
            while (rs.next()) {
                String fieldname = rs.getString(1);
                String ftabname = rs.getString(2);
                String ftabcol = rs.getString(3);
                if (ftabcol == null) {
                    throw new SQLException(this.tabelle + " foreign key feld ist null f\u00fcr Spalte " + fieldname);
                }
                ResultSet rs2 = this.con.createStatement().executeQuery("select " + ftabcol + " from " + ftabname);
                LinkedList<String> l = new LinkedList<String>();
                while (rs2.next()) {
                    l.add(rs2.getObject(1).toString().trim());
                }
                this.foreignKeys.put(fieldname, l);
            }
        }
    }

    private boolean isPostgres() throws SQLException {
        return this.databaseMetaData.getDriverName().toLowerCase().indexOf("postgres") > -1;
    }

    public String getHtmlPreview() {
        return this.htmlPreview.toString();
    }

    private static void unzip(String zipfile) throws FileNotFoundException, IOException {
        File newFile = null;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipfile));
        ZipEntry ze = zis.getNextEntry();
        int count = 0;
        byte[] buffer = new byte[1024];
        while (ze != null) {
            int len;
            ++count;
            newFile = File.createTempFile("data", ".csv");
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        File zipF = new File(zipfile);
        zipF.delete();
        if (newFile == null) {
            throw new IOException("Keine Datei gefunden");
        }
        if (count > 1) {
            throw new IOException("Zip-File darf nur eine Datei enthalten");
        }
        newFile.renameTo(zipF);
    }

    private static /* synthetic */ String lambda$upload$0(String e) {
        return e.toLowerCase();
    }
}

