/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.ServletHelper;
import de.superx.common.SxUser;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SessionAttribute;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.util.HtmlUtils;
import de.superx.util.SqlStringUtils;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.saiku.web.service.SessionService;
import org.springframework.context.ApplicationContext;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractSuperXServlet
extends HttpServlet {
    static Logger logger = Logger.getLogger(AbstractSuperXServlet.class);
    ApplicationContext springApplicationContext;
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.springApplicationContext = (ApplicationContext)config.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public String getTid(HttpServletRequest request) {
        String tidString = ServletHelper.getParameter(request, RequestParameter.tid);
        if (tidString == null || tidString.equals("")) {
            throw new IllegalArgumentException("tid Argument fehlt");
        }
        return tidString;
    }

    public boolean getShowNavigation(HttpServletRequest request) {
        String naviParam = ServletHelper.getParameter(request, RequestParameter.navi);
        String naviAttr = (String)request.getAttribute(SessionAttribute.navi.toString());
        if (naviAttr != null && !naviAttr.isEmpty()) {
            naviParam = naviAttr;
        }
        boolean showNavi = naviParam != null && naviParam.equals("true");
        return showNavi;
    }

    public void checkCacheClearing(HttpServletRequest request) throws ServletException {
        String p = ServletHelper.getParameter(request, RequestParameter.cachingcontrol);
        if (p != null) {
            if (p.equalsIgnoreCase("clearstylesheets") || p.equalsIgnoreCase("s")) {
                try {
                    SuperXManager.clearTransletStylesheets();
                }
                catch (Exception e) {
                    throw new ServletException(e.toString());
                }
            }
            if (p.equalsIgnoreCase("clearall") || p.equalsIgnoreCase("a")) {
                try {
                    SuperXManager.initPool(request, ServletUtils.getMandantenID(request));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Kann Cache nicht neu laden:" + String.valueOf(e));
                }
            }
        }
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response, String uri) throws IOException, ServletException {
        String url = response.encodeRedirectURL("/servlet/" + uri);
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(url);
        if (rd == null) {
            throw new IOException("Konnte keinen RequestDispatch aufbauen f\u00fcr /servlet/" + uri);
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void infoNeuAnmelden(HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.append("<html><body>Bitte melden Sie sich (neu) am System an</body></html>");
        writer.flush();
    }

    protected boolean hasProperSession(HttpServletRequest request) {
        boolean result = false;
        HttpSession s = request.getSession(false);
        if (s != null) {
            logger.debug((Object)("** Checking Session: ** -> " + s.getId()));
            String type = (String)s.getAttribute(SessionAttribute.sessiontype.toString());
            logger.debug((Object)("Session Type: " + type));
            SxUser user = (SxUser)s.getAttribute(SessionAttribute.user.toString());
            logger.debug((Object)("Session User: " + String.valueOf(user)));
            result = type != null && type.equals("superx") && user != null;
        }
        return result;
    }

    protected boolean isJSONRequest(HttpServletRequest request) {
        boolean result = false;
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String aName = (String)en.nextElement();
            if (!aName.startsWith("getJSON")) continue;
            result = true;
        }
        return result;
    }

    protected static void setEncoding(HttpServletRequest request) throws UnsupportedEncodingException {
        String ie = SqlStringUtils.getEncoding();
        request.setCharacterEncoding(ie);
    }

    public static String insertCsrfToken(HttpServletRequest request, String html) throws IOException {
        CsrfToken token = SuperXServletHelper.getCsRfToken(request);
        String result = HtmlUtils.insertCsrfToken(token, html);
        return result;
    }

    protected void logoutOfSaiku(HttpServletRequest request) {
        if (this.springApplicationContext != null) {
            SessionService sessionService = (SessionService)this.springApplicationContext.getBean("sessionService");
            sessionService.logout(request);
        }
    }

    protected void loginToSaiku(HttpServletRequest request, String username) {
        if (this.springApplicationContext != null) {
            SessionService sessionService = (SessionService)this.springApplicationContext.getBean("sessionService");
            sessionService.authenticate(request, username, null);
        }
    }
}

