/*
 * Decompiled with CFR 0.152.
 */
package de.superx.saiku;

import de.memtext.util.XmlFlatFileMerger;
import de.superx.conf.InitStatus;
import de.superx.saiku.schema.SuperxDynamicSchemaProcessor;
import de.superx.servlet.SuperXManager;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.core.fs.local.FileUtil;
import org.saiku.database.dto.MondrianSchema;
import org.saiku.datasources.connection.RepositoryFile;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.repository.AclEntry;
import org.saiku.repository.DataSource;
import org.saiku.repository.IRepositoryManager;
import org.saiku.repository.IRepositoryObject;
import org.saiku.repository.JackRabbitRepositoryManager;
import org.saiku.repository.ScopedRepo;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.importer.JujuSource;
import org.saiku.service.importer.LegacyImporterImpl;
import org.saiku.service.user.UserService;
import org.saiku.service.util.security.authentication.PasswordProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SuperxRepositoryDataSourceManager
implements IDatasourceManager {
    private static final String FILE_EDUSTORE_CHANGED_XML = "edustore_changed.xml";
    private static final String FILE_EDUSTORE_XML = "edustore.xml";
    private static final String CUSTOM_FILE_READ_NAME = "custom_xml_last_read";
    private final Map<String, SaikuDatasource> datasources = Collections.synchronizedMap(new HashMap());
    private UserService userService;
    private static final Logger log = LoggerFactory.getLogger(SuperxRepositoryDataSourceManager.class);
    private String configurationpath;
    private String datadir;
    private IRepositoryManager irm;
    private PasswordProvider repopasswordprovider;
    private String oldpassword;
    private String defaultRole;
    private String externalparameters;
    private javax.sql.DataSource datasource;
    private String webinfPath;
    @Autowired
    ServletContext servletContext;

    public javax.sql.DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(javax.sql.DataSource datasource) {
        this.datasource = datasource;
    }

    public void load() {
        String myConfigurationPath = this.servletContext.getRealPath(this.configurationpath);
        String myDataDir = this.servletContext.getRealPath(this.datadir);
        this.webinfPath = this.servletContext.getRealPath("/");
        log.info("path: " + this.webinfPath);
        log.info("configurationpath: " + this.configurationpath);
        log.info("configurationpath resolved: " + myConfigurationPath);
        log.info("datadir: " + myDataDir);
        log.info("repopasswordprovider: " + String.valueOf(this.repopasswordprovider));
        try {
            if (this.datasource == null) {
                throw new RuntimeException("No DataSource available!");
            }
            this.irm = JackRabbitRepositoryManager.getJackRabbitRepositoryManager((String)myConfigurationPath, (String)myDataDir, (String)this.repopasswordprovider.getPassword(), (String)this.oldpassword, (String)this.defaultRole, (ScopedRepo)new ScopedRepo(), (boolean)false);
            this.irm.start(this.userService);
            this.saveInternalFile("/etc/.repo_version", "d20f0bea-681a-11e5-9d70-feff819cdc9f", null);
            InitStatus.setStatus(InitStatus.SubSystem.SaikuJCR, Optional.empty());
        }
        catch (Exception e) {
            log.error("Could not start repo", (Throwable)e);
            if (this.irm != null) {
                this.irm.shutdown();
            }
            log.error("Could not start JackRabbit Repository Manager. Maybe db connection not configured?");
            InitStatus.setStatus(InitStatus.SubSystem.SaikuJCR, Optional.of(e));
            return;
        }
        this.datasources.clear();
        try {
            SaikuDatasource biSaikuDs;
            DataSource biDs;
            String dsId;
            boolean removalSuccessful;
            boolean schemaChanged;
            String schemaDir;
            File schemaFile;
            List<MondrianSchema> schemata = this.getMondrianSchema();
            boolean edustoreSchemaExists = false;
            for (MondrianSchema schema : schemata) {
                if (!schema.getName().equals(FILE_EDUSTORE_XML)) continue;
                edustoreSchemaExists = true;
                break;
            }
            if (!(schemaFile = new File((schemaDir = this.webinfPath + "WEB-INF" + File.separator + "classes" + File.separator + "edustore") + File.separator + FILE_EDUSTORE_XML)).exists()) {
                log.warn("No edustore.xml file found. Trying to recreate it.");
                try {
                    SuperXManager.initMondrianSchema(this.datasource, this);
                }
                catch (Exception ex) {
                    InitStatus.setStatus(InitStatus.SubSystem.SaikuSchema, Optional.of(ex));
                    log.warn("edustore.xml could not be recreated.");
                    return;
                }
                log.info("edustore.xml recreated. Continuing initialization.");
            }
            File schemaFileNew = new File(schemaDir + File.separator + FILE_EDUSTORE_CHANGED_XML);
            boolean bl = schemaChanged = edustoreSchemaExists && this.schemaFileChangedOnDisc(schemaFileNew);
            if (schemaChanged) {
                log.debug("Saiku schema changed. Reloading.");
                FileUtil.copy((File)schemaFileNew, (File)schemaFile);
                this.removeSchema(FILE_EDUSTORE_XML);
                edustoreSchemaExists = false;
            }
            File customLastReadFile = new File(this.webinfPath + "WEB-INF" + File.separator + "classes" + File.separator + "edustore" + File.separator + CUSTOM_FILE_READ_NAME);
            if (!edustoreSchemaExists || !customLastReadFile.exists()) {
                String schemaFileContents;
                File customFile = new File(this.webinfPath + "WEB-INF" + File.separator + "classes" + File.separator + "edustore" + File.separator + "custom.xml");
                String schema = schemaFileContents = FileUtils.readFileToString((File)schemaFile, (String)"UTF-8");
                if (customFile.canRead()) {
                    boolean updateCustomization = false;
                    if (customLastReadFile.canRead()) {
                        long customFileTime = customFile.lastModified();
                        long customLastReadTime = customLastReadFile.lastModified();
                        updateCustomization = customLastReadTime < customFileTime;
                    } else {
                        updateCustomization = true;
                    }
                    if (updateCustomization) {
                        SuperxDynamicSchemaProcessor sdsp = new SuperxDynamicSchemaProcessor(this.datasource);
                        String customFileContents = FileUtils.readFileToString((File)customFile, (String)"UTF-8");
                        if (customFileContents.isEmpty()) {
                            log.warn(String.valueOf(customFile) + " is empty");
                        } else {
                            schema = sdsp.customize(customFileContents, schemaFileContents);
                        }
                        this.deleteCustomFile();
                        customLastReadFile.createNewFile();
                    }
                }
                this.addSchema(schema, "/datasources/edustore.xml", "admin");
            }
            this.addAdditionalSchemaFiles(schemaDir);
            this.addAdditionalDataSourceFiles();
            if (this.datasources.containsKey("BI") && !(removalSuccessful = this.removeDatasource(dsId = (biDs = new DataSource(biSaikuDs = this.datasources.get("BI"))).getId()))) {
                log.error("Could not remove existing BI datasource!");
            }
            File datasourceFile = new File(this.webinfPath + "WEB-INF" + File.separator + "classes" + File.separator + "saiku-datasources" + File.separator + "edustore");
            Properties biProps = new Properties();
            biProps.load(new FileReader(datasourceFile));
            SaikuDatasource biDs2 = new SaikuDatasource("BI", SaikuDatasource.Type.OLAP, biProps);
            this.addDatasource(biDs2);
            InitStatus.setStatus(InitStatus.SubSystem.SaikuSchema, Optional.empty());
        }
        catch (Exception e) {
            log.error("Couldn't load Saiku Repository Manager: ", (Throwable)e);
            InitStatus.setStatus(InitStatus.SubSystem.SaikuSchema, Optional.of(e));
        }
    }

    private void createSaikuDatasourcesForExportedDatasources(Properties ext) {
        List exporteddatasources = null;
        try {
            exporteddatasources = this.irm.getAllDataSources();
        }
        catch (RepositoryException e1) {
            log.error("Could not export data sources", (Throwable)e1);
        }
        if (exporteddatasources != null) {
            for (DataSource file : exporteddatasources) {
                String p;
                if (file.getName() == null || file.getType() == null) continue;
                Properties props = new Properties();
                if (file.getDriver() != null) {
                    props.put("driver", file.getDriver());
                } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".driver")) {
                    p = ext.getProperty("datasource." + file.getPropertyKey() + ".driver");
                    props.put("driver", p);
                }
                if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".location")) {
                    p = ext.getProperty("datasource." + file.getPropertyKey() + ".location");
                    if (ext.containsKey("datasource." + file.getPropertyKey() + ".schemaoverride")) {
                        String[] spl = p.split(";");
                        spl[1] = "Catalog=mondrian://" + file.getSchema();
                        StringBuilder sb = new StringBuilder();
                        for (String str : spl) {
                            sb.append(str + ";");
                        }
                        props.put("location", sb.toString());
                    } else {
                        props.put("location", p);
                    }
                } else if (file.getLocation() != null) {
                    props.put("location", file.getLocation());
                }
                if (file.getUsername() != null && file.getPropertyKey() == null) {
                    props.put("username", file.getUsername());
                } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".username")) {
                    p = ext.getProperty("datasource." + file.getPropertyKey() + ".username");
                    props.put("username", p);
                }
                if (file.getPassword() != null && file.getPropertyKey() == null) {
                    props.put("password", file.getPassword());
                } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".password")) {
                    p = ext.getProperty("datasource." + file.getPropertyKey() + ".password");
                    props.put("password", p);
                }
                if (file.getPath() != null) {
                    props.put("path", file.getPath());
                } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".path")) {
                    p = ext.getProperty("datasource." + file.getPropertyKey() + ".path");
                    props.put("path", p);
                }
                if (file.getId() != null) {
                    props.put("id", file.getId());
                }
                if (file.getSecurityenabled() != null) {
                    props.put("security.enabled", file.getSecurityenabled());
                } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".security.enabled")) {
                    p = ext.getProperty("datasource." + file.getPropertyKey() + ".security.enabled");
                    props.put("security.enabled", p);
                }
                if (file.getSecuritytype() != null) {
                    props.put("security.type", file.getSecuritytype());
                } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".security.type")) {
                    p = ext.getProperty("datasource." + file.getPropertyKey() + ".security.type");
                    props.put("security.type", p);
                }
                if (file.getSecuritymapping() != null) {
                    props.put("security.mapping", file.getSecuritymapping());
                } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".security.mapping")) {
                    p = ext.getProperty("datasource." + file.getPropertyKey() + ".security.mapping");
                    props.put("security.mapping", p);
                }
                if (file.getAdvanced() != null) {
                    props.put("advanced", file.getAdvanced());
                }
                if (file.getPropertyKey() != null) {
                    props.put("propertykey", file.getPropertyKey());
                }
                SaikuDatasource.Type t = SaikuDatasource.Type.valueOf((String)file.getType().toUpperCase());
                SaikuDatasource ds = new SaikuDatasource(file.getName(), t, props);
                this.datasources.put(file.getName(), ds);
            }
        }
    }

    private void addAdditionalSchemaFiles(String schemaDir) throws Exception {
        File[] additionalSchemaFiles;
        for (File schemaFile : additionalSchemaFiles = new File(schemaDir).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return !fileName.startsWith("edustore") && !fileName.startsWith("custom") && fileName.endsWith(".xml");
            }
        })) {
            String schemaFileContents = FileUtils.readFileToString((File)schemaFile, (String)"UTF-8");
            this.addSchema(schemaFileContents, "/datasources/" + schemaFile.getName(), "admin");
        }
    }

    private void addAdditionalDataSourceFiles() throws Exception {
        File[] files;
        File dataSourceDir = new File(this.webinfPath + "WEB-INF" + File.separator + "classes" + File.separator + "saiku-datasources");
        for (File file : files = dataSourceDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return !"edustore".equals(fileName);
            }
        })) {
            Properties props = new Properties();
            props.load(new FileReader(file));
            SaikuDatasource ds = new SaikuDatasource(file.getName(), SaikuDatasource.Type.OLAP, props);
            this.addDatasource(ds);
        }
    }

    private boolean schemaFileChangedOnDisc(File schemaFileNew) throws IOException, RepositoryException {
        if (!schemaFileNew.exists()) {
            return false;
        }
        String internalSchemaContents = this.irm.getInternalFile("/datasources/edustore.xml");
        String schemaFileNewContents = FileUtils.readFileToString((File)schemaFileNew, (Charset)Charset.forName("utf-8"));
        Date internalDate = SuperxRepositoryDataSourceManager.getTimestampFrom(internalSchemaContents);
        Date schemaNewDate = SuperxRepositoryDataSourceManager.getTimestampFrom(schemaFileNewContents);
        return internalDate.before(schemaNewDate);
    }

    private static Date getTimestampFrom(String schemaFileContents) {
        String[] lines;
        Date result = new Date(0L);
        for (String line : lines = schemaFileContents.split("\\r?\\n", 10)) {
            String stripped = StringUtils.strip((String)line);
            if (!StringUtils.startsWith((CharSequence)stripped, (CharSequence)"<!--")) continue;
            int startIndex = stripped.indexOf(".xsl") + 4;
            Date parsedDate = XmlFlatFileMerger.MONDRIAN_SCHEMA_TIMESTAMP_FORMAT.parse(stripped, new ParsePosition(startIndex));
            if (parsedDate != null) {
                result = parsedDate;
                break;
            }
            Date parsedDateNoSeconds = XmlFlatFileMerger.MONDRIAN_SCHEMA_TIMESTAMP_FORMAT_NO_SECONDS.parse(stripped, new ParsePosition(startIndex));
            if (parsedDateNoSeconds == null) break;
            result = parsedDateNoSeconds;
            break;
        }
        return result;
    }

    public Properties checkForExternalDataSourceProperties() {
        Properties p = new Properties();
        try {
            FileInputStream input = new FileInputStream(this.externalparameters);
            p.load(input);
        }
        catch (IOException e) {
            log.debug("file did not exist");
        }
        return p;
    }

    public String[] getAvailablePropertiesKeys() {
        Properties p = new Properties();
        try {
            FileInputStream input = new FileInputStream(this.externalparameters);
            p.load(input);
        }
        catch (IOException e) {
            log.debug("file did not exist");
        }
        String[] arr = p.keySet().toArray(new String[p.keySet().size()]);
        ArrayList<String> newlist = new ArrayList<String>();
        for (String str : arr) {
            String[] s = str.split("\\.");
            newlist.add(s[1]);
        }
        HashSet unique = new HashSet(newlist);
        return unique.toArray(new String[unique.size()]);
    }

    public void unload() {
        if (this.irm != null) {
            this.irm.shutdown();
        }
    }

    public SaikuDatasource addDatasource(SaikuDatasource sds) throws Exception {
        DataSource ds = new DataSource(sds);
        String dataSourceNode = "/datasources/" + ds.getName() + ".sds";
        try {
            this.irm.removeInternalFile(dataSourceNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.irm.saveDataSource(ds, dataSourceNode, "admin");
        this.datasources.put(sds.getName(), sds);
        return sds;
    }

    public SaikuDatasource setDatasource(SaikuDatasource datasource) throws Exception {
        return this.addDatasource(datasource);
    }

    public List<SaikuDatasource> addDatasources(List<SaikuDatasource> dsources) {
        for (SaikuDatasource sds : dsources) {
            DataSource ds = new DataSource(sds);
            try {
                this.irm.saveDataSource(ds, "/datasources/" + ds.getName() + ".sds", "fixme");
                this.datasources.put(sds.getName(), sds);
            }
            catch (RepositoryException e) {
                log.error("Could not add data source" + sds.getName(), (Throwable)e);
            }
        }
        return dsources;
    }

    public boolean removeDatasource(String datasourceId) {
        List ds = null;
        if (datasourceId == null || datasourceId.isEmpty()) {
            log.error("Invalid DataSource id: " + datasourceId);
            return false;
        }
        if (this.irm == null) {
            log.error("No RepositoryManager available!");
            return false;
        }
        try {
            ds = this.irm.getAllDataSources();
        }
        catch (RepositoryException e) {
            log.error("Could not get all data sources");
        }
        if (ds != null) {
            for (DataSource data : ds) {
                if (data.getId() != null && !data.getId().equals(datasourceId)) continue;
                this.datasources.remove(data.getName());
                this.irm.deleteFile(data.getPath());
                return true;
            }
        }
        return false;
    }

    public boolean removeSchema(String schemaName) {
        List s = null;
        try {
            s = this.irm.getAllSchema();
        }
        catch (RepositoryException e) {
            log.error("Could not get All Schema", (Throwable)e);
        }
        if (s != null) {
            for (MondrianSchema data : s) {
                if (!data.getName().equals(schemaName)) continue;
                this.irm.deleteFile(data.getPath());
                if (!schemaName.equals(FILE_EDUSTORE_XML)) break;
                this.deleteCustomFile();
                break;
            }
            return true;
        }
        return false;
    }

    public Map<String, SaikuDatasource> getDatasources() {
        return this.datasources;
    }

    public SaikuDatasource getDatasource(String datasourceName) {
        return this.datasources.get(datasourceName);
    }

    public SaikuDatasource getDatasource(String datasourceName, boolean refresh) {
        if (!refresh) {
            if (this.datasources.size() > 0) {
                return this.datasources.get(datasourceName);
            }
        } else {
            return this.getDatasource(datasourceName);
        }
        return null;
    }

    public void addSchema(String fileContents, String path, String name) throws Exception {
        List schemas = this.irm.getAllSchema();
        for (MondrianSchema schema : schemas) {
            if (!schema.getPath().equals(path)) continue;
            this.irm.removeInternalFile(path);
        }
        this.irm.saveInternalFile((Object)fileContents, path, "nt:mondrianschema");
    }

    public List<MondrianSchema> getMondrianSchema() {
        try {
            return this.irm.getAllSchema();
        }
        catch (RepositoryException e) {
            log.error("Could not get all Schema", (Throwable)e);
            return new ArrayList<MondrianSchema>();
        }
    }

    public MondrianSchema getMondrianSchema(String catalog) {
        List<MondrianSchema> schemas = this.getMondrianSchema();
        for (MondrianSchema schema : schemas) {
            if (!schema.getName().equals(catalog)) continue;
            return schema;
        }
        return null;
    }

    public RepositoryFile getFile(String file) {
        return this.irm.getFile(file);
    }

    public String getFileData(String file, String username, List<String> roles) {
        try {
            return this.irm.getFile(file, username, roles);
        }
        catch (RepositoryException e) {
            log.error("Could not get file " + file, (Throwable)e);
            return null;
        }
    }

    public String getInternalFileData(String file) throws RepositoryException {
        return this.irm.getInternalFile(file);
    }

    public InputStream getBinaryInternalFileData(String file) throws RepositoryException {
        return this.irm.getBinaryInternalFile(file);
    }

    public String saveFile(String path, Object content, String user, List<String> roles) {
        try {
            this.irm.saveFile(content, path, user, "nt:saikufiles", roles);
            return "Save Okay";
        }
        catch (RepositoryException e) {
            log.error("Save Failed", (Throwable)e);
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    public String removeFile(String path, String user, List<String> roles) {
        try {
            this.irm.removeFile(path, user, roles);
            return "Remove Okay";
        }
        catch (RepositoryException e) {
            log.error("Save Failed", (Throwable)e);
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    public String moveFile(String source, String target, String user, List<String> roles) {
        try {
            this.irm.moveFile(source, target, user, roles);
            return "Move Okay";
        }
        catch (RepositoryException e) {
            log.error("Move Failed", (Throwable)e);
            return "Move Failed: " + e.getLocalizedMessage();
        }
    }

    public String saveInternalFile(String path, Object content, String type) {
        try {
            this.irm.saveInternalFile(content, path, type);
            return "Save Okay";
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    public String saveBinaryInternalFile(String path, InputStream content, String type) {
        try {
            this.irm.saveBinaryInternalFile(content, path, type);
            return "Save Okay";
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    public void removeInternalFile(String filePath) {
        try {
            this.irm.removeInternalFile(filePath);
        }
        catch (RepositoryException e) {
            log.error("Remove file failed: " + filePath);
            e.printStackTrace();
        }
    }

    public List<IRepositoryObject> getFiles(List<String> type, String username, List<String> roles) {
        return this.irm.getAllFiles(type, username, roles);
    }

    public List<IRepositoryObject> getFiles(List<String> type, String username, List<String> roles, String path) {
        try {
            return this.irm.getAllFiles(type, username, roles, path);
        }
        catch (RepositoryException e) {
            log.error("Get failed", (Throwable)e);
            return null;
        }
    }

    public void createUser(String username) {
        try {
            this.irm.createUser(username);
        }
        catch (RepositoryException e) {
            log.error("Create User Failed", (Throwable)e);
        }
    }

    public void deleteFolder(String folder) {
        try {
            this.irm.deleteFolder(folder);
        }
        catch (RepositoryException e) {
            log.error("Delete User Failed", (Throwable)e);
        }
    }

    public AclEntry getACL(String object, String username, List<String> roles) {
        return this.irm.getACL(object, username, roles);
    }

    public void setACL(String object, String acl, String username, List<String> roles) {
        try {
            this.irm.setACL(object, acl, username, roles);
        }
        catch (RepositoryException e) {
            log.error("Set ACL Failed", (Throwable)e);
        }
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public List<MondrianSchema> getInternalFilesOfFileType(String type) {
        try {
            return this.irm.getInternalFilesOfFileType(type);
        }
        catch (RepositoryException e) {
            log.error("Get internal file failed", (Throwable)e);
            return null;
        }
    }

    public void createFileMixin(String type) throws RepositoryException {
        this.irm.createFileMixin(type);
    }

    public byte[] exportRepository() {
        try {
            return this.irm.exportRepository();
        }
        catch (RepositoryException e) {
            log.error("could not export repository", (Throwable)e);
        }
        catch (IOException e) {
            log.error("could not export repository IO issue", (Throwable)e);
        }
        return null;
    }

    public void restoreRepository(byte[] data) {
        try {
            this.irm.restoreRepository(data);
        }
        catch (Exception e) {
            log.error("Could not restore export", (Throwable)e);
        }
    }

    public boolean hasHomeDirectory(String name) {
        try {
            Object eturn = this.irm.getHomeFolder(name);
            return eturn != null;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            log.error("could not get home directory");
            return false;
        }
    }

    public void restoreLegacyFiles(byte[] data) {
        LegacyImporterImpl l = new LegacyImporterImpl(null);
        l.importLegacyReports(this.irm, data);
    }

    public Object getRepository() {
        return this.irm.getRepositoryObject();
    }

    public void setConfigurationpath(String configurationpath) {
        this.configurationpath = configurationpath;
    }

    public String getConfigurationpath() {
        return this.configurationpath;
    }

    public void setDatadir(String datadir) {
        this.datadir = datadir;
    }

    public String getDatadir() {
        return this.datadir;
    }

    public void setExternalPropertiesFile(String file) {
        this.externalparameters = this.servletContext.getRealPath(file);
    }

    public void setRepoPasswordProvider(PasswordProvider passwordProvider) {
        this.repopasswordprovider = passwordProvider;
    }

    public PasswordProvider getRepopasswordprovider() {
        return this.repopasswordprovider;
    }

    public void setOldRepoPassword(String password) {
        this.oldpassword = password;
    }

    public String getOldRepopassword() {
        return this.oldpassword;
    }

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    private void deleteCustomFile() {
        File customLastReadFile = new File(this.webinfPath + "WEB-INF" + File.separator + "classes" + File.separator + "edustore" + File.separator + CUSTOM_FILE_READ_NAME);
        if (customLastReadFile.canWrite()) {
            customLastReadFile.delete();
        }
    }

    public String getEarthquakeDir() {
        return null;
    }

    public String getEarthquakeSchema() {
        return null;
    }

    public String getEarthquakeUrl() {
        return null;
    }

    public String getFoodmartdir() {
        return null;
    }

    public String getFoodmartschema() {
        return null;
    }

    public String getFoodmarturl() {
        return null;
    }

    public void setEarthquakeDir(String arg0) {
    }

    public void setEarthquakeSchema(String arg0) {
    }

    public void setEarthquakeUrl(String arg0) {
    }

    public void setFoodmartdir(String arg0) {
    }

    public void setFoodmartschema(String arg0) {
    }

    public void setFoodmarturl(String arg0) {
    }

    public Map<String, SaikuDatasource> getDatasources(String[] arg0) {
        return this.datasources;
    }

    public List<JujuSource> getJujuDatasources() {
        return null;
    }

    public String getType() {
        return null;
    }
}

