/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.config;

import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.DateUtils;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldContainer;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.Maske;
import de.superx.common.NotYetImplementedException;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.rest.config.HisDynamicFieldConfigurator;
import de.superx.rest.config.ValueFormatTool;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.HisDynamicFieldConfig;
import de.superx.rest.model.Item;
import de.superx.servlet.SichtServlet;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HisDynamicTreeSelectConfigurator
extends HisDynamicFieldConfigurator {
    private ValueFormatTool valueFormatTool = null;

    public HisDynamicTreeSelectConfigurator(Maske maske, Field field, SxUser user) throws NotYetImplementedException {
        this.maske = maske;
        this.field = field;
        this.user = user;
        this.valueFormatTool = HisDynamicTreeSelectConfigurator.createValueFormatTool(field);
    }

    @Override
    public HisDynamicFieldConfig createConfig(String currentSelection) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
        FieldContainer maskenFelder = this.maske.getIndividualFields();
        if (!this.valueFormatTool.confirmFormat(currentSelection)) {
            throw new UngueltigeEingabeException("Multiselectauswahl muss im Listenformat sein");
        }
        this.field.setInited(false);
        Hashtable formular = this.maske.getFormularCopy();
        HashMap map = new HashMap();
        map.put("UserIsAdmin", this.user.getBasicMap().get("UserIsAdmin"));
        this.field.updateDefaultValue(formular, map, maskenFelder, null, false, this.user);
        this.config = this.createTreeSelectUpdate(currentSelection);
        return this.config;
    }

    @Override
    public String escapeForFormular(String inputValue) throws UngueltigeEingabeException {
        return this.valueFormatTool.escapeForFormular(HisDynamicTreeSelectConfigurator.removeViewIdAndDate(inputValue));
    }

    @Override
    public String getUpdatedFormularValue() {
        String newSelectionValue = "";
        if (this.config.defaultValue != null) {
            if (!(this.config.defaultValue instanceof String[])) {
                throw new RuntimeException("Unexpected Type Error");
            }
            CharSequence[] newSelections = (String[])this.config.defaultValue;
            newSelectionValue = String.join((CharSequence)",", newSelections);
            try {
                newSelectionValue = this.escapeForFormular(newSelectionValue);
            }
            catch (UngueltigeEingabeException e) {
                throw new RuntimeException(e);
            }
        }
        return newSelectionValue;
    }

    private HisDynamicFieldConfig createTreeSelectUpdate(String param) {
        String[] defaultValue;
        HisDynamicFieldConfig formField = new HisDynamicFieldConfig(this.field, FieldType.TreeSelect);
        List<Item> items = HisDynamicTreeSelectConfigurator.createSelectableItems(this.field);
        formField.setItems(items);
        String[] selectedValues = HisDynamicTreeSelectConfigurator.removeViewIdAndDate(param).split("\\s*,\\s*");
        formField.defaultValue = defaultValue = this.filterValidSichtItemValues(selectedValues);
        if (defaultValue.length == 0) {
            formField.defaultValue = null;
        }
        return formField;
    }

    private String[] filterValidSichtItemValues(String[] selectedValues) {
        ArrayList<String> filteredValues = new ArrayList<String>();
        SichtServlet sicht = (SichtServlet)this.field.getSelectableItemsTree();
        for (String selectedValue : selectedValues) {
            if (!sicht.selectableItemCollection.containsItemWithId(selectedValue)) continue;
            filteredValues.add(selectedValue);
        }
        return filteredValues.toArray(new String[0]);
    }

    private static String removeViewIdAndDate(String value) {
        if (value == null) {
            return "";
        }
        int splitIndex = StringUtils.ordinalIndexOf((CharSequence)value, (CharSequence)":", (int)2);
        return value.substring(splitIndex == -1 ? 0 : splitIndex + 1);
    }

    public static String[] getSplittedViewParams(String value) {
        String[] viewParams = value.split(":", -1);
        if (viewParams[1].isEmpty()) {
            viewParams[1] = DateUtils.getTodayString();
        }
        return viewParams;
    }
}

